/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.movement.article.chargebased.details;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.DocumentScanToolkit;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.MovementDocumentScanSelectionPopup;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.CustomDocumentsPopup;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanTypeE;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.AGroupMovementAccess;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupComplete_;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupLight;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<StockMovementGroupLight>
implements InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> name;
    private TitledItem<TextLabel> number;
    private TitledItem<RDDateChooser> date;
    private TitledItem<RDComboBox> costCenter;
    private TitledItem<EditButton> customsDocuments;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TextButton scanDocument;

    public SpecificationDetailsPanel(RowEditor<StockMovementGroupLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.BASIC_DATA);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.date = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.DATE, TitledItem.TitledItemOrientation.NORTH);
        this.date.getElement().setNode(n);
        this.costCenter = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CostCenterConverter.class)), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.customsDocuments = new TitledItem<EditButton>(new EditButton(), Words.CUSTOMS_DOCUMENTS, TitledItem.TitledItemOrientation.WEST);
        this.customsDocuments.getElement().addButtonListener(this);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider, true), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.scanDocument = new TextButton(Words.DOCUMENT_SCAN);
        this.scanDocument.addButtonListener((source, x, y) -> {
            if (editor.getModel().isAddRow()) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                MovementDocumentScanSelectionPopup insert = new MovementDocumentScanSelectionPopup(DocumentScanTypeE.MOVEMENT, (Node<StockMovementGroupLight>)editor.getModel().getNode());
                popUp.setAttributes(source, true, true, Words.DOCUMENT_SCAN);
                popUp.setView(insert);
                popUp.showPopUpWithinScreenMiddle(800, 600, (source1, xargs) -> {
                    if (insert.getDocument() != null) {
                        editor.getModel().getNode().getChildNamed(StockMovementGroupComplete_.documentScan).setValue(insert.getDocument().getValue(), 0L);
                    } else {
                        editor.getModel().getNode().getChildNamed(StockMovementGroupComplete_.documentScan).setValue(null, 0L);
                    }
                }, source, PopupType.NORMAL);
            } else {
                boolean writable = provider.isWritable(AGroupMovementAccess.CHANGE_SCAN_DOCUMENT);
                InnerPopupFactory.showScanDocumentPopup(source, (Node<DocumentScanComplete>)editor.getModel().getNode().getChildNamed(StockMovementGroupComplete_.documentScan), provider, writable, "Movement Sheet");
            }
        });
        this.setCustomLayouter(new Layout());
        this.addToView(this.name);
        this.addToView(this.number);
        this.addToView(this.date);
        this.addToView(this.costCenter);
        this.addToView(this.customsDocuments);
        this.addToView(this.scanDocument);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.customsDocuments.getElement()) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, Words.CUSTOMS_DOCUMENTS);
            popUp.setView(new CustomDocumentsPopup(this.editor.getModel().getNode().getChildNamed(StockMovementGroupLight_.documents), this.provider, true));
            popUp.showPopUp(x, y, 450, 300, this, source, PopupType.FRAMELESS);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.date.setEnabled(isEnabled);
        this.costCenter.setEnabled(isEnabled);
        this.customsDocuments.setEnabled(isEnabled);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(isEnabled);
        }
        this.scanDocument.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.name.kill();
        this.number.kill();
        this.date.kill();
        this.costCenter.kill();
        this.customsDocuments.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.scanDocument.kill();
        this.name = null;
        this.number = null;
        this.date = null;
        this.costCenter = null;
        this.customsDocuments = null;
        this.locations = null;
        this.scanDocument = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = this.name.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.date);
        CheckedListAdder.addToList(focusList, this.costCenter);
        CheckedListAdder.addToList(focusList, this.customsDocuments);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.scanDocument);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow() && node != null) {
            StockMovementGroupLight dto = (StockMovementGroupLight)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.name.getElement().setNode(node.getChildNamed(StockMovementGroupLight_.name));
        this.number.getElement().setNode(node.getChildNamed(StockMovementGroupLight_.number));
        this.date.getElement().setNode(node.getChildNamed(StockMovementGroupLight_.movementDate));
        this.costCenter.getElement().setNode(node.getChildNamed(StockMovementGroupLight_.costCenter));
        this.costCenter.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(StockMovementGroupLight_.eligibleLocations));
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && (this.name.getElement().getNode().getValue() == null || this.name.getElement().getNode().getValue().equals(""))) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        } else if (this.date.getElement().isWritable() && this.date.getElement().getNode().getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DATE_IS_SET));
        }
        boolean b = false;
        Iterator it = this.editor.getModel().getNode().getChildNamed(StockMovementGroupLight_.documents).getChilds();
        while (it.hasNext()) {
            ScreenValidationObject screenValidationObject;
            Node n = (Node)it.next();
            if (n.getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue() == null || ((String)n.getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue()).equals("")) {
                b = true;
                continue;
            }
            String value = (String)n.getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue();
            try {
                Integer integer = Integer.valueOf(value);
                if (integer == 0) {
                    b = true;
                }
            }
            catch (Exception integer) {
                // empty catch block
            }
            if ((screenValidationObject = DocumentScanToolkit.validateDocumentNumber(value, null)) == null) continue;
            validationObjects.add(screenValidationObject);
        }
        if (b) {
            this.customsDocuments.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMS_DOCS_ID_IS_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() != 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EXCALTY_ONE_LOCATION_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.date.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.costCenter.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                h = (int)((double)h + SpecificationDetailsPanel.this.locations.getPreferredSize().getHeight());
                h += SpecificationDetailsPanel.this.verticalBorder;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 3 * SpecificationDetailsPanel.this.horizontalBorder;
            w /= 3;
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(w *= 2, (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.name.getX() + SpecificationDetailsPanel.this.name.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(parent.getWidth() - (SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.horizontalBorder), (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.date.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.date.setSize(SpecificationDetailsPanel.this.date.getPreferredSize());
            SpecificationDetailsPanel.this.scanDocument.setLocation(SpecificationDetailsPanel.this.date.getX() + SpecificationDetailsPanel.this.date.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, (int)((double)(SpecificationDetailsPanel.this.date.getY() + SpecificationDetailsPanel.this.date.getHeight()) - SpecificationDetailsPanel.this.scanDocument.getPreferredSize().getHeight() + 2.0));
            SpecificationDetailsPanel.this.scanDocument.setSize(SpecificationDetailsPanel.this.scanDocument.getPreferredSize());
            w = parent.getWidth() - 3 * SpecificationDetailsPanel.this.horizontalBorder;
            SpecificationDetailsPanel.this.costCenter.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.date.getY() + SpecificationDetailsPanel.this.date.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.costCenter.setSize(w /= 2, (int)SpecificationDetailsPanel.this.costCenter.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.customsDocuments.setLocation(SpecificationDetailsPanel.this.costCenter.getX() + SpecificationDetailsPanel.this.costCenter.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, (int)((double)(SpecificationDetailsPanel.this.costCenter.getY() + SpecificationDetailsPanel.this.costCenter.getHeight()) - SpecificationDetailsPanel.this.customsDocuments.getPreferredSize().getHeight() + 2.0));
            SpecificationDetailsPanel.this.customsDocuments.setSize(SpecificationDetailsPanel.this.customsDocuments.getPreferredSize());
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.locations.setLocation(SpecificationDetailsPanel.this.customsDocuments.getX() + SpecificationDetailsPanel.this.customsDocuments.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.customsDocuments.getY());
                SpecificationDetailsPanel.this.locations.setSize(SpecificationDetailsPanel.this.locations.getPreferredSize());
            }
        }
    }
}

