/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details;

import ch.icit.pegasus.client.converter.AdditionalPriceConverter;
import ch.icit.pegasus.client.gui.modules.product.details.HandlingCostsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.product.details.ProcessCostsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.product.details.utils.GroupedLoader;
import ch.icit.pegasus.client.gui.modules.product.details.utils.InternalExternalPriceFactorTable;
import ch.icit.pegasus.client.gui.modules.product.details.utils.NettoPriceConverter;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.toolkits.PriceToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductPriceFactorComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SalePriceDetailsPanel
extends StateDependantDetailsPanel<ProductComplete>
implements LafListener {
    private static final long serialVersionUID = 1L;
    private InternalExternalPriceFactorTable priceFactorTable;
    private GroupedLoader loader;
    private BackgroundFadeSkin skin2;
    private ReloadablePriceView additionalCosts;
    private ReloadablePriceView totalCosts;
    private ProcessCostsDetailsPanel processCostView;
    private boolean isDeletable;
    private Node currentNode;

    public SalePriceDetailsPanel(RowEditor<ProductComplete> editor, RDProvider provider, GroupedLoader loader, ProcessCostsDetailsPanel d2, HandlingCostsDetailsPanel handlingCosts) {
        super(editor, provider);
        this.loader = loader;
        this.isDeletable = provider.isDeletable(ProductVariantComplete_.productPriceFactors);
        this.processCostView = d2;
        this.skin2 = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.totalCosts = new ReloadablePriceView((LoadingGroup)loader, NettoPriceConverter.class);
        this.totalCosts.setNode((Node)new EmbeddedDTONode());
        this.additionalCosts = new ReloadablePriceView((LoadingGroup)loader, AdditionalPriceConverter.class);
        loader.setNettosSalesPriceView(this.totalCosts);
        loader.setAddtionalPriceView(this.additionalCosts);
        this.setTitleText(Words.ADDITIONAL_COSTS);
        this.priceFactorTable = new InternalExternalPriceFactorTable(editor, provider, this.isDeletable, loader, d2){

            @Override
            public void removeCostFactor(ReloadablePriceView costs) {
                SalePriceDetailsPanel.this.loader.removeProcessCost(costs);
            }

            @Override
            public void load(boolean b) {
                SalePriceDetailsPanel.this.additionalCosts.load(b);
            }

            @Override
            public void addCostFactor(ReloadablePriceView view) {
                SalePriceDetailsPanel.this.loader.addProcessCost(view);
            }
        };
        this.setCustomLayouter(new Layout());
        this.totalCosts.setProgress(1.0f);
        this.lafAttributeChanged("All attribues changed");
        this.setTotalCostCalcAlgorithm();
        this.setAdditionalCostCalcAlgorithm();
        this.addToView(this.priceFactorTable);
        this.addToView(this.additionalCosts);
        this.addToView(this.totalCosts);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ProductVariantLight_.state;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.currentNode = node;
        this.priceFactorTable.setNode(this.currentNode);
        this.setEnabled(this.isEnabled());
    }

    private void setAdditionalCostCalcAlgorithm() {
        if (this.additionalCosts != null) {
            CalculationRunnable run = new CalculationRunnable(){

                @Override
                public void run() {
                    try {
                        if (SalePriceDetailsPanel.this.currentNode == null || !SalePriceDetailsPanel.this.isEnabled()) {
                            return;
                        }
                        PriceComplete p2 = SalePriceDetailsPanel.this.processCostView.getProductionCost();
                        PriceComplete p3 = new PriceComplete();
                        p3.setClientOId(Long.valueOf(p3.getNextId()));
                        if (p2 != null) {
                            Boolean fix;
                            double d;
                            SalesPriceFactorComplete type;
                            Node nn;
                            double additional;
                            Iterator it;
                            p3.setCurrency(p2.getCurrency());
                            p3.setPrice(Double.valueOf(0.0));
                            ArrayList<Node> margins = new ArrayList<Node>();
                            Node list = SalePriceDetailsPanel.this.currentNode.getChildNamed(ProductVariantComplete_.productPriceFactors);
                            if (list != null) {
                                it = list.getFailSafeChildIterator();
                                additional = 0.0;
                                while (it.hasNext()) {
                                    nn = (Node)it.next();
                                    type = (SalesPriceFactorComplete)nn.getChildNamed(ProductPriceFactorComplete_.salesPriceFactor).getValue();
                                    if (type.getType() == SalesPriceFactorTypeE.Margin) {
                                        margins.add(nn);
                                        continue;
                                    }
                                    d = (Double)nn.getChildNamed(ProductPriceFactorComplete_.factor).getValue();
                                    fix = (Boolean)nn.getChildNamed(ProductPriceFactorComplete_.fixPrice).getValue();
                                    if (!Boolean.TRUE.equals(fix)) {
                                        d *= p2.getPrice().doubleValue();
                                        d /= 100.0;
                                    }
                                    additional += d;
                                }
                                p3.setPrice(Double.valueOf(p3.getPrice() + additional));
                            }
                            p3.setPrice(p3.getPrice());
                            it = margins.iterator();
                            additional = 0.0;
                            while (it.hasNext()) {
                                nn = (Node)it.next();
                                type = (SalesPriceFactorComplete)nn.getChildNamed(ProductPriceFactorComplete_.salesPriceFactor).getValue();
                                d = (Double)nn.getChildNamed(ProductPriceFactorComplete_.factor).getValue();
                                fix = (Boolean)nn.getChildNamed(ProductPriceFactorComplete_.fixPrice).getValue();
                                if (!Boolean.TRUE.equals(fix)) {
                                    d *= p3.getPrice() + p2.getPrice();
                                    d /= 100.0;
                                }
                                additional += d;
                            }
                            p3.setPrice(Double.valueOf(p3.getPrice() + additional));
                        } else {
                            p3.setPrice(Double.valueOf(0.0));
                            p3.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
                        }
                        Node pn = SalePriceDetailsPanel.this.additionalCosts.getNode();
                        if (pn == null) {
                            pn = new EmbeddedDTONode();
                            SalePriceDetailsPanel.this.additionalCosts.setNode(pn);
                        }
                        p3.setPrice(PriceToolkit.ensureDoubleFinite(p3.getPrice()));
                        pn.setValue((Object)p3, 0L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public boolean isAlive() {
                    if (SalePriceDetailsPanel.this.additionalCosts != null) {
                        return !SalePriceDetailsPanel.this.additionalCosts.isKilled();
                    }
                    return false;
                }
            };
            this.additionalCosts.setRunnable(run);
        }
    }

    private void setTotalCostCalcAlgorithm() {
        if (this.totalCosts != null) {
            CalculationRunnable run = new CalculationRunnable(){

                @Override
                public void run() {
                    Node pn;
                    PriceComplete p4;
                    if (SalePriceDetailsPanel.this.currentNode == null || !SalePriceDetailsPanel.this.isEnabled()) {
                        return;
                    }
                    PriceComplete p1 = SalePriceDetailsPanel.this.processCostView.getProductionCost();
                    if (p1 == null) {
                        return;
                    }
                    PriceComplete p3 = new PriceComplete();
                    p3.setClientOId(Long.valueOf(p3.getNextId()));
                    p3.setPrice(Double.valueOf(0.0));
                    if (p1.getPrice() == null) {
                        p1.setPrice(Double.valueOf(0.0));
                    }
                    p3.setCurrency(p1.getCurrency());
                    p3.setPrice(p1.getPrice());
                    if (SalePriceDetailsPanel.this.additionalCosts != null && SalePriceDetailsPanel.this.additionalCosts.getNode() != null && SalePriceDetailsPanel.this.additionalCosts.getNode().getValue() != null && (p4 = (PriceComplete)SalePriceDetailsPanel.this.additionalCosts.getNode().getValue()) != null) {
                        if (p3.getCurrency() == null) {
                            p3.setCurrency(p4.getCurrency());
                        }
                        p3.setPrice(Double.valueOf(p3.getPrice() + p4.getPrice()));
                    }
                    if (p3.getCurrency() == null) {
                        p3.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
                    }
                    if ((pn = SalePriceDetailsPanel.this.totalCosts.getNode()) == null) {
                        pn = new EmbeddedDTONode();
                        SalePriceDetailsPanel.this.totalCosts.setNode(pn);
                    }
                    p3.setPrice(PriceToolkit.ensureDoubleFinite(p3.getPrice()));
                    pn.setValue((Object)p3, 0L);
                }

                @Override
                public boolean isAlive() {
                    if (SalePriceDetailsPanel.this.totalCosts != null) {
                        return !SalePriceDetailsPanel.this.totalCosts.isKilled();
                    }
                    return false;
                }
            };
            this.totalCosts.setRunnable(run);
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            g2.clip(this.getClipingArea());
        }
        int skinH = this.skin2.getImage(0).getHeight();
        this.skin2.paint(g2, 0, this.getHeight() - skinH, this.getWidth(), 11);
        this.skin2.paint(g2, 0, this.getHeight() - 2 * skinH, this.getWidth(), 11);
        this.paintChildren(g2);
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
        if (this.totalCosts != null) {
            this.totalCosts.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        }
        if (this.additionalCosts != null) {
            this.additionalCosts.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.loader.setNettosSalesPriceView(null);
        this.totalCosts.kill();
        this.totalCosts = null;
        this.additionalCosts.kill();
        this.additionalCosts = null;
        this.priceFactorTable.kill();
        this.priceFactorTable = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean enabled = isEnabled && isDraft;
        super.setEnabled(enabled);
        this.priceFactorTable.setEnabled(enabled);
        this.totalCosts.setEnabled(enabled);
        this.additionalCosts.setEnabled(enabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.priceFactorTable);
        return focusList;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
    }

    public PriceComplete getNettoPrice() {
        if (this.totalCosts != null) {
            return (PriceComplete)this.totalCosts.getNode().getValue();
        }
        return new PriceComplete(null, Double.valueOf(0.0));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonSpace = SalePriceDetailsPanel.this.skin2.getImage(11).getHeight() * 2 + 1;
            int skinHeight = SalePriceDetailsPanel.this.skin2.getImage(11).getHeight();
            SalePriceDetailsPanel.this.priceFactorTable.setLocation(0, 0);
            SalePriceDetailsPanel.this.priceFactorTable.setSize(parent.getWidth(), parent.getHeight() - buttonSpace);
            SalePriceDetailsPanel.this.additionalCosts.setLocation(SalePriceDetailsPanel.this.horizontalBorder, (int)((double)(parent.getHeight() - buttonSpace) + ((double)skinHeight - SalePriceDetailsPanel.this.additionalCosts.getPreferredSize().getHeight()) / 2.0));
            SalePriceDetailsPanel.this.additionalCosts.setSize(parent.getWidth() - 2 * SalePriceDetailsPanel.this.horizontalBorder, (int)SalePriceDetailsPanel.this.additionalCosts.getPreferredSize().getHeight());
            buttonSpace = SalePriceDetailsPanel.this.skin2.getImage(11).getHeight();
            SalePriceDetailsPanel.this.totalCosts.setLocation(SalePriceDetailsPanel.this.horizontalBorder, (int)((double)(parent.getHeight() - buttonSpace) + ((double)skinHeight - SalePriceDetailsPanel.this.totalCosts.getPreferredSize().getHeight()) / 2.0));
            SalePriceDetailsPanel.this.totalCosts.setSize(parent.getWidth() - 2 * SalePriceDetailsPanel.this.horizontalBorder, (int)SalePriceDetailsPanel.this.totalCosts.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int buttonSpace = SalePriceDetailsPanel.this.skin2.getImage(11).getHeight();
            int h = (int)SalePriceDetailsPanel.this.priceFactorTable.getPreferredSize().getHeight();
            return new Dimension(0, h += buttonSpace * 2);
        }
    }
}

