/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.quality.measurement.oprp05.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserPanel;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<ReportFileComplete>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> layoutName;
    private TitledItem<FileChooserPanel> fileChooser;
    private TitledItem<ViewButton> downloadTemplate;

    public SpecificationDetailsPanel(RowEditor<ReportFileComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.setOpaque(false);
        this.setCustomLayouter(new Layout());
        this.layoutName = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), "Description", TitledItem.TitledItemOrientation.NORTH);
        this.fileChooser = new TitledItem<FileChooserPanel>(new FileChooserPanel(false), "File", TitledItem.TitledItemOrientation.NORTH);
        this.fileChooser.getElement().setFileType(".jrxml");
        this.downloadTemplate = new TitledItem<ViewButton>(new ViewButton(), "Downlaod Template", TitledItem.TitledItemOrientation.EAST);
        this.downloadTemplate.getElement().addButtonListener((source, x, y) -> {
            final File jrxml = FileChooserUtil.saveFile("jrxml");
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    PegasusFileComplete labelTemplateJRXML = (PegasusFileComplete)((ReportServiceManager)ServiceManagerRegistry.getService(ReportServiceManager.class)).getLabelTemplateJRXML().getValue();
                    File download = FileTransferUtil.download((PegasusFileComplete)labelTemplateJRXML, (FileTransferListener[])new FileTransferListener[0]);
                    FileUtils.copyFile((File)download, (File)jrxml);
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            InnerPopupFactory.showMessage("Label Template", "Template downloaed", null, SpecificationDetailsPanel.this);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog("Unable to download template " + exception.getMessage(), "Label Template", null, (Component)SpecificationDetailsPanel.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        });
        this.addToView(this.layoutName);
        this.addToView(this.fileChooser);
        this.addToView(this.downloadTemplate);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.layoutName);
        CheckedListAdder.addToList(focusList, this.fileChooser);
        CheckedListAdder.addToList(focusList, this.downloadTemplate);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.layoutName.kill();
        this.fileChooser.kill();
        this.downloadTemplate.kill();
        this.layoutName = null;
        this.fileChooser = null;
        this.downloadTemplate = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.layoutName.setEnabled(isEnabled);
        this.fileChooser.setEnabled(isEnabled);
        this.downloadTemplate.setEnabled(isEnabled);
    }

    @Override
    public void setNode(Node<?> node) {
        this.layoutName.getElement().setNode(node.getChildNamed(ReportFileComplete_.description));
        this.fileChooser.getElement().setNode(node);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.layoutName.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.layoutName.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.layoutName.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.fileChooser.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.layoutName.getY() + SpecificationDetailsPanel.this.layoutName.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.fileChooser.setSize(SpecificationDetailsPanel.this.fileChooser.getPreferredSize());
            SpecificationDetailsPanel.this.downloadTemplate.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.fileChooser.getY() + SpecificationDetailsPanel.this.fileChooser.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.downloadTemplate.setSize(SpecificationDetailsPanel.this.downloadTemplate.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.layoutName.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.fileChooser.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.downloadTemplate.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

