/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.radar.view;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.BatchList;
import ch.icit.pegasus.client.gui.hud.ConnectionToOutside;
import ch.icit.pegasus.client.gui.modules.radar.view.RadarPanel;
import ch.icit.pegasus.client.gui.screentemplates.ScreenLoader;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.smartaccess.popup.TableRowSmartScreenAccessPopupInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.prototypes.SkinButton_NEW;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class RadarToolBar
extends DefaultPanel
implements Nodable,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private ScreenLoader screenLoader = new ScreenLoader(){

        @Override
        public InnerPopUp2 getPopup() {
            return RadarToolBar.this.popUp;
        }

        public RowModel getModel() {
            return null;
        }

        @Override
        public MainFrame getMainFrame() {
            return RadarToolBar.this.panel.getMainFrame();
        }

        @Override
        public void clearPopup() {
            RadarToolBar.this.popUp = null;
        }

        public ConnectionToOutside getConnectionToOutside() {
            return RadarToolBar.this.panel.getConnection();
        }
    };
    private TitledItem<SkinButton_NEW> sheetPrint;
    private List<SubModuleAccessRightComplete> currentSmartScreens;
    private TitledItem<BatchList<?, BatchJob<?>>> batchList;
    private RadarPanel panel;
    private Node<FlightLight> selectedNode;
    private InnerPopUp2 popUp;
    private RDProvider currentProvider;

    public RadarToolBar(RadarPanel panel, RDProvider currentProvider) {
        this.panel = panel;
        this.currentProvider = currentProvider;
        this.sheetPrint = new TitledItem<SkinButton_NEW>(new SkinButton_NEW(DefaultSkins.SubModulePrintIcon), "Print", TitledItem.TitledItemOrientation.SOUTH);
        this.sheetPrint.setFocusable(false);
        this.batchList = new TitledItem(new BatchList(), "Running Jobs", TitledItem.TitledItemOrientation.NORTH);
        this.batchList.setIgnorePrefHeight(true);
        this.sheetPrint.getElement().addButtonListener(this);
        this.setLayout(new Layout());
        this.add(this.sheetPrint);
        this.add(this.batchList);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean b;
        super.setEnabled(isEnabled);
        boolean c = b = this.selectedNode != null && isEnabled;
        if (c) {
            c = c && ((FlightLight)this.selectedNode.getValue()).getId() != null;
        }
        this.sheetPrint.setEnabled(c);
        this.batchList.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.sheetPrint != null) {
            this.sheetPrint.kill();
        }
        this.sheetPrint = null;
        if (this.batchList != null) {
            this.batchList.kill();
        }
        this.batchList = null;
    }

    @Override
    public void setNode(Node<?> node) {
        this.selectedNode = node;
        this.currentSmartScreens = node != null ? this.screenLoader.fillUpSmartAccessRights() : null;
        this.setEnabled(this.getParent().isEnabled());
    }

    @Override
    public Node<?> getNode() {
        return this.selectedNode;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sheetPrint.getElement()) {
            this.showSmartPopup(source, x, y);
        }
    }

    private void showSmartPopup(Button source, int x, int y) {
        if (this.currentSmartScreens != null) {
            this.popUp = InnerPopUp2.getInnerPopUp();
            this.popUp.setAttributes(source, false, false, "");
            this.popUp.setView(new TableRowSmartScreenAccessPopupInsert(this.currentSmartScreens, this.panel.getMainFrame(), this.screenLoader, this.batchList.getElement()));
            this.popUp.showPopUp(0, source.getY() + source.getHeight(), 200, -1, null, source, PopupType.SMARTACCES);
        }
    }

    public BatchList<?, BatchJob<?>> getBatchList() {
        return this.batchList.getElement();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            RadarToolBar.this.sheetPrint.setLocation(3, 3);
            RadarToolBar.this.sheetPrint.setSize(RadarToolBar.this.sheetPrint.getPreferredSize());
            RadarToolBar.this.batchList.setLocation(0, RadarToolBar.this.sheetPrint.getY() + RadarToolBar.this.sheetPrint.getHeight() + 8);
            RadarToolBar.this.batchList.setSize(parent.getWidth(), parent.getHeight() - RadarToolBar.this.batchList.getY());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            int h = 3;
            h = (int)((double)h + RadarToolBar.this.sheetPrint.getPreferredSize().getHeight());
            return new Dimension(200, h += 15);
        }
    }
}

