/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.recipe.details;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.PreparationGroupConverter;
import ch.icit.pegasus.client.converter.RecipeProductGroupConverter;
import ch.icit.pegasus.client.converter.SingleCategoryConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDImageChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PreparationGroupComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.RecipeProductGroupComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.recipe.IngredientComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.InterpolationStepComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.recipe.StepQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.StepQuantityInterpolationComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RecipeAccess;
import ch.icit.pegasus.server.core.dtos.system.QualitySettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariantBasicDataDetailsPanel
extends StateDependantDetailsPanel<RecipeComplete>
implements NodeListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    static Logger logger = LoggerFactory.getLogger(VariantBasicDataDetailsPanel.class);
    private static boolean isNoPro;
    private TitledItem<RDComboBox> cat1;
    private TitledItem<RDComboBox> cat2;
    private TitledItem<RDComboBox> cat3;
    private TitledItem<RDComboBox> cat4;
    private TitledItem<RDTextField> name;
    private TitledItem<RDTextField> englishName;
    private TitledItem<RDInputComboBox> yield;
    private TitledItem<RDTextField> conversion;
    private TextLabel conversionUnit;
    private TextLabel equalsSign;
    private TitledItem<RDImageChooser> imagePreview;
    private TitledItem<RDComboBox> stateCombo;
    private boolean isServiceItem;
    private Node<RecipeVariantComplete> node;
    private TitledItem<RDComboBox> defaultDepartment;
    private boolean stateChangedNow;
    private TitledItem<RDCheckBox> halal;
    private TitledItem<RDSearchComboBox> customer;
    private TitledItem<RDComboBox> preparationGroup;
    private TitledItem<RDComboBox> productGroup;
    private TitledItem<RDCheckBox> useDefaultCostCenterForCCP2;
    private TitledItem<RDCheckBox> excludeFromKonterProbe;
    private TitledItem<RDCheckBox> useReserve;
    private TitledItem<RDCheckBox> alwaysShowOnOPRP05Log;
    private TitledItem<RDCheckBox> directlyInProduct;
    private TitledItem<RDInputComboBox> batchSize;
    private TitledItem<RDTextField> eanCode;

    public VariantBasicDataDetailsPanel(RowEditor<RecipeComplete> editor, RDProvider provider, boolean isServiceItem) {
        super(editor, provider);
        QualitySettingsComplete qualitySettings;
        this.isServiceItem = isServiceItem;
        isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)this.settings);
        this.setTitleText(Words.BASIC_DATA);
        this.stateCombo = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ModificationStateEConverter.class)), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        this.cat1 = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(SingleCategoryConverter.class)), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
        this.cat2 = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(SingleCategoryConverter.class)), Words.MAIN_CATEGORY, TitledItem.TitledItemOrientation.NORTH);
        this.cat3 = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(SingleCategoryConverter.class)), Words.SUB_GROUP, TitledItem.TitledItemOrientation.NORTH);
        this.cat4 = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(SingleCategoryConverter.class)), Words.SUB_GROUP, TitledItem.TitledItemOrientation.NORTH);
        this.cat1.getElement().setOverrideName(RecipeVariantLight_.category);
        this.cat2.getElement().setOverrideName(RecipeVariantLight_.category);
        this.cat3.getElement().setOverrideName(RecipeVariantLight_.category);
        this.cat4.getElement().setOverrideName(RecipeVariantLight_.category);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.englishName = new TitledItem<RDTextField>(new RDTextField(provider), Words.ENGLISH_NAME, TitledItem.TitledItemOrientation.NORTH);
        this.defaultDepartment = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.DEFAULT_DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        SystemViewSettingsComplete viewSettings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue();
        if (isServiceItem) {
            this.yield = new TitledItem<RDInputComboBox>(new RDInputComboBox(provider, InputComboBox.InputComboBoxType.PRICE_DOUBLE), Words.YIELD, TitledItem.TitledItemOrientation.NORTH);
        } else {
            this.yield = new TitledItem<RDInputComboBox>(new RDInputComboBox(provider, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE), Words.YIELD, TitledItem.TitledItemOrientation.NORTH);
            this.yield.getElement().setMaxKommaStellen(3);
        }
        this.equalsSign = new TextLabel("=");
        this.conversion = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DOUBLE), Words.CONVERSION, TitledItem.TitledItemOrientation.NORTH);
        this.conversion.getElement().setMaxKommaStellen(3);
        this.conversionUnit = new TextLabel();
        this.imagePreview = new TitledItem<RDImageChooser>(new RDImageChooser(provider), Words.IMAGE, TitledItem.TitledItemOrientation.NORTH);
        String postfix = "";
        if (Boolean.TRUE.equals(settings.getRecipeIsAutoHalal())) {
            postfix = " (calculated from ingredients)";
        }
        this.customer = new TitledItem<RDSearchComboBox>(new RDSearchComboBox(provider, RDSearchComboBox.BoxSearchTypes.CUSTOMER), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(viewSettings.getRecipeShowEanCode())) {
            this.eanCode = new TitledItem<RDTextField>(new RDTextField(provider), "EAN Code", TitledItem.TitledItemOrientation.NORTH);
        }
        if (!isNoPro) {
            this.halal = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.HALAL + postfix, TitledItem.TitledItemOrientation.EAST);
            if (Boolean.TRUE.equals(viewSettings.getShowRecipePreparationGroup())) {
                this.preparationGroup = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(PreparationGroupConverter.class), true), Words.PREPARATION_GROUP, TitledItem.TitledItemOrientation.NORTH);
            }
            this.productGroup = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(RecipeProductGroupConverter.class), true), Words.PRODUCT_GROUP, TitledItem.TitledItemOrientation.NORTH);
            this.useDefaultCostCenterForCCP2 = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Use Default Department for CCP02", TitledItem.TitledItemOrientation.EAST);
            if (Boolean.TRUE.equals(viewSettings.getShowRecipeExcludeKonterProbe())) {
                this.excludeFromKonterProbe = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Exclude from Konter Probe", TitledItem.TitledItemOrientation.EAST);
            }
            this.useReserve = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Use Reserve", TitledItem.TitledItemOrientation.EAST);
            this.alwaysShowOnOPRP05Log = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Always show on OPRP05", TitledItem.TitledItemOrientation.EAST);
            this.directlyInProduct = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Show on Recipe Forecast", TitledItem.TitledItemOrientation.EAST);
        }
        if ((qualitySettings = (QualitySettingsComplete)NodeToolkit.getAffixClass(QualitySettingsComplete.class).getValue()) != null && Boolean.TRUE.equals(qualitySettings.getUseRecipeBatchQuantity())) {
            this.batchSize = new TitledItem<RDInputComboBox>(new RDInputComboBox(provider, InputComboBox.InputComboBoxType.PRICE_DOUBLE), "Batch Size", TitledItem.TitledItemOrientation.NORTH);
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.cat1);
        this.addToView(this.cat2);
        this.addToView(this.cat3);
        this.addToView(this.cat4);
        this.addToView(this.name);
        this.addToView(this.englishName);
        this.addToView(this.yield);
        this.addToView(this.equalsSign);
        this.addToView(this.conversion);
        this.addToView(this.conversionUnit);
        this.addToView(this.stateCombo);
        this.addToView(this.imagePreview);
        this.addToView(this.customer);
        if (this.eanCode != null) {
            this.addToView(this.eanCode);
        }
        this.addToView(this.defaultDepartment);
        if (!isNoPro) {
            this.addToView(this.halal);
            if (this.preparationGroup != null) {
                this.addToView(this.preparationGroup);
            }
            this.addToView(this.productGroup);
            this.addToView(this.useDefaultCostCenterForCCP2);
            if (this.excludeFromKonterProbe != null) {
                this.addToView(this.excludeFromKonterProbe);
            }
            this.addToView(this.useReserve);
            this.addToView(this.alwaysShowOnOPRP05Log);
            this.addToView(this.directlyInProduct);
        }
        if (this.batchSize != null) {
            this.addToView(this.batchSize);
        }
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return RecipeVariantLight_.state;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean canRedraftIfInvoiced = true;
        if (!isDraft) {
            canRedraftIfInvoiced = this.stateChangedNow ? true : this.provider.isWritable(RecipeAccess.REDRAFT_ACCEPTED);
        }
        boolean b = isEnabled && isDraft;
        super.setEnabled(b);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean conversionNeeded = this.needsConversionUpdate();
        this.cat1.setEnabled(b);
        this.cat2.setEnabled(b);
        this.cat3.setEnabled(b);
        this.cat4.setEnabled(b);
        this.name.setEnabled(b);
        this.yield.setEnabled(b);
        this.imagePreview.setEnabled(b);
        this.imagePreview.getElement().enablePreviewAnyWay(isEnabled);
        this.stateCombo.setEnabled(isEnabled && canRedraftIfInvoiced);
        this.defaultDepartment.setEnabled(b);
        this.englishName.setEnabled(b);
        this.conversion.setEnabled(b && conversionNeeded);
        this.conversionUnit.setEnabled(b);
        this.equalsSign.setEnabled(b);
        this.customer.setEnabled(b);
        if (this.eanCode != null) {
            this.eanCode.setEnabled(b);
        }
        if (!isNoPro) {
            this.productGroup.setEnabled(b);
            if (this.preparationGroup != null) {
                this.preparationGroup.setEnabled(b);
            }
            this.useDefaultCostCenterForCCP2.setEnabled(b);
            if (this.excludeFromKonterProbe != null) {
                this.excludeFromKonterProbe.setEnabled(b);
            }
            this.halal.setEnabled(b && Boolean.FALSE.equals(settings.getRecipeIsAutoHalal()));
            this.useReserve.setEnabled(b);
            this.alwaysShowOnOPRP05Log.setEnabled(b);
            this.directlyInProduct.setEnabled(b);
        }
        if (this.batchSize != null) {
            this.batchSize.setEnabled(b);
        }
    }

    @Override
    public void setNode(Node<?> node) {
        Node aNode;
        if (this.node != null) {
            this.node.removeNodeListenerRecursively((NodeListener)this);
            aNode = this.node.getChildNamed(RecipeVariantLight_.yield);
            aNode.getChildNamed(QuantityComplete_.unit).removeNodeListener((NodeListener)this);
            aNode.getChildNamed(QuantityComplete_.quantity).removeNodeListener((NodeListener)this);
        }
        super.setNode(node);
        this.node = node;
        aNode = this.node.getChildNamed(RecipeVariantLight_.yield);
        aNode.getChildNamed(QuantityComplete_.unit).addNodeListener((NodeListener)this);
        aNode.getChildNamed(QuantityComplete_.quantity).addNodeListener((NodeListener)this);
        this.stateCombo.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ModificationStateE.class));
        this.stateCombo.getElement().setNode(node.getChildNamed(RecipeVariantLight_.state));
        if (this.editor.getModel().isAddRow()) {
            node.getChildNamed(RecipeVariantLight_.state).setValue((Object)ModificationStateE.DRAFT, 0L);
        }
        Node affixList = NodeToolkit.getAffixList(InternalCostCenterComplete.class);
        this.defaultDepartment.getElement().refreshPossibleValues(ComboBoxFactory.filterDepartmentsAll(affixList, node.getChildNamed(RecipeVariantLight_.defaultCostCenter), ComboBoxFactory.DepartmentType.RECIPE_PREPARATION_UNIT));
        this.defaultDepartment.getElement().setNode(node.getChildNamed(RecipeVariantLight_.defaultCostCenter));
        this.revalidateSelectableCategories();
        this.name.getElement().setNode(node.getChildNamed(RecipeVariantLight_.name));
        this.englishName.getElement().setNode(node.getChildNamed(RecipeVariantLight_.englishName));
        if (aNode.getValue() == null) {
            QuantityComplete d = new QuantityComplete();
            d.setQuantity(Double.valueOf(1.0));
            if (this.isServiceItem) {
                d.setUnit(this.settings.getPieceUnit());
            } else {
                d.setUnit(this.settings.getDefaultRecipeUnit());
            }
            aNode.setValue((Object)d, System.currentTimeMillis());
        }
        this.conversion.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.conversionToDefaultUnit));
        this.conversionUnit.setText(this.settings.getDefaultRecipeUnit().getShortName());
        this.yield.getElement().setPossibleUnits(this.createYieldUnitList());
        this.yield.getElement().setNode(aNode.getChildNamed(QuantityComplete_.quantity), aNode.getChildNamed(QuantityComplete_.unit));
        this.imagePreview.getElement().setNode(node.getChildNamed(RecipeVariantLight_.imageReference));
        this.customer.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.customer));
        if (this.eanCode != null) {
            this.eanCode.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.recipeEanCode));
        }
        if (!isNoPro) {
            this.halal.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.halal));
            if (this.preparationGroup != null) {
                this.preparationGroup.getElement().refreshPossibleValues(NodeToolkit.getAffixList(PreparationGroupComplete.class));
                this.preparationGroup.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.preparationGroup));
            }
            this.productGroup.getElement().refreshPossibleValues(NodeToolkit.getAffixList(RecipeProductGroupComplete.class));
            this.productGroup.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.productGroup));
            this.ensureConversion((Node<QuantityComplete>)node.getChildNamed(RecipeVariantComplete_.yield));
            this.useDefaultCostCenterForCCP2.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.useDefaultCostCenterForCCP2));
            if (this.excludeFromKonterProbe != null) {
                this.excludeFromKonterProbe.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.excludeFromKonterProben));
            }
            this.useReserve.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.useReserve));
            this.alwaysShowOnOPRP05Log.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.alwaysUseOnOPRP05Log));
            this.directlyInProduct.getElement().setNode(node.getChildNamed(RecipeVariantLight_.directlyInProduct));
        }
        if (this.batchSize != null) {
            this.batchSize.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.batchMaxSizeAmount), node.getChildNamed(RecipeVariantComplete_.batchMaxSizeUnit));
        }
        this.setEnabled(this.isEnabled());
    }

    private Node createYieldUnitList() {
        List value = (List)NodeToolkit.getAffixList(UnitSystemComplete.class).getValue();
        ArrayList<UnitComplete> units = new ArrayList<UnitComplete>();
        for (UnitSystemComplete unit : value) {
            for (UnitComplete maxUnit = unit.getMaxUnit(); maxUnit != null; maxUnit = maxUnit.getSubUnit()) {
                if (!Boolean.TRUE.equals(maxUnit.getRecipeYieldUnit())) continue;
                units.add(maxUnit);
            }
        }
        return INodeCreator.getDefaultImpl().createNodes(units, false);
    }

    @Override
    public void resetParagraph() {
        super.resetParagraph();
        this.name.getElement().setNode(this.node.getChildNamed(RecipeVariantLight_.name));
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.stateCombo);
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.eanCode);
        CheckedListAdder.addToList(focusList, this.englishName);
        CheckedListAdder.addToList(focusList, this.yield);
        CheckedListAdder.addToList(focusList, this.batchSize);
        CheckedListAdder.addToList(focusList, this.imagePreview);
        CheckedListAdder.addToList(focusList, this.cat1);
        CheckedListAdder.addToList(focusList, this.cat2);
        CheckedListAdder.addToList(focusList, this.cat3);
        CheckedListAdder.addToList(focusList, this.cat4);
        CheckedListAdder.addToList(focusList, this.defaultDepartment);
        CheckedListAdder.addToList(focusList, this.preparationGroup);
        CheckedListAdder.addToList(focusList, this.productGroup);
        CheckedListAdder.addToList(focusList, this.halal);
        CheckedListAdder.addToList(focusList, this.useDefaultCostCenterForCCP2);
        CheckedListAdder.addToList(focusList, this.excludeFromKonterProbe);
        CheckedListAdder.addToList(focusList, this.useReserve);
        CheckedListAdder.addToList(focusList, this.alwaysShowOnOPRP05Log);
        CheckedListAdder.addToList(focusList, this.directlyInProduct);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null && this.node.getChildNamed(RecipeVariantLight_.state) != null) {
            this.node.getChildNamed(RecipeVariantLight_.state).removeNodeListener((NodeListener)this);
        }
        if (this.node != null) {
            Node aNode = this.node.getChildNamed(RecipeVariantLight_.yield);
            aNode.getChildNamed(QuantityComplete_.unit).removeNodeListener((NodeListener)this);
            aNode.getChildNamed(QuantityComplete_.quantity).removeNodeListener((NodeListener)this);
        }
        this.cat1.kill();
        this.cat2.kill();
        this.cat3.kill();
        this.cat4.kill();
        this.name.kill();
        this.yield.kill();
        this.imagePreview.kill();
        this.stateCombo.kill();
        this.defaultDepartment.kill();
        this.englishName.kill();
        this.customer.kill();
        if (this.eanCode != null) {
            this.eanCode.kill();
        }
        this.eanCode = null;
        this.conversion.kill();
        this.conversionUnit.kill();
        this.equalsSign.kill();
        if (!isNoPro) {
            this.halal.kill();
            this.productGroup.kill();
            this.useReserve.kill();
            this.alwaysShowOnOPRP05Log.kill();
            if (this.preparationGroup != null) {
                this.preparationGroup.kill();
            }
            this.useDefaultCostCenterForCCP2.kill();
            if (this.excludeFromKonterProbe != null) {
                this.excludeFromKonterProbe.kill();
                this.excludeFromKonterProbe = null;
            }
            this.directlyInProduct.kill();
        }
        if (this.batchSize != null) {
            this.batchSize.kill();
        }
        this.cat1 = null;
        this.cat2 = null;
        this.cat3 = null;
        this.cat4 = null;
        this.name = null;
        this.yield = null;
        this.imagePreview = null;
        this.stateCombo = null;
        this.defaultDepartment = null;
        this.englishName = null;
        this.customer = null;
        this.halal = null;
        this.preparationGroup = null;
        this.conversion = null;
        this.conversionUnit = null;
        this.equalsSign = null;
        this.productGroup = null;
        this.useDefaultCostCenterForCCP2 = null;
        this.useReserve = null;
        this.alwaysShowOnOPRP05Log = null;
        this.directlyInProduct = null;
        this.batchSize = null;
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            RecipeCategoryComplete cat;
            Node newParent;
            if (e.getSource() == this.cat1.getElement().getEditor()) {
                newParent = (Node)((ComboBox)this.cat1.getElement().getEditor()).getSelectedItem();
                cat = (RecipeCategoryComplete)newParent.getValue();
                this.cat2.getElement().getNode().setValue(cat.getSubCategories().get(0), 0L);
                this.cat2.getElement().refreshPossibleValues(this.getSubCategoriesFiltered(cat));
            }
            if (e.getSource() == this.cat2.getElement().getEditor()) {
                newParent = (Node)((ComboBox)this.cat2.getElement().getEditor()).getSelectedItem();
                cat = (RecipeCategoryComplete)newParent.getValue();
                this.cat3.getElement().getNode().setValue(cat.getSubCategories().get(0), 0L);
                this.cat3.getElement().refreshPossibleValues(this.getSubCategoriesFiltered(cat));
            }
            if (e.getSource() == this.cat3.getElement().getEditor()) {
                newParent = (Node)((ComboBox)this.cat3.getElement().getEditor()).getSelectedItem();
                cat = (RecipeCategoryComplete)newParent.getValue();
                this.cat4.getElement().getNode().setValue(cat.getSubCategories().get(0), 0L);
                this.cat4.getElement().refreshPossibleValues(this.getSubCategoriesFiltered(cat));
            }
        }
    }

    private Node<List<RecipeCategoryComplete>> getFilteredCategories(List<RecipeCategoryComplete> cats) {
        ArrayList<RecipeCategoryComplete> categories = new ArrayList<RecipeCategoryComplete>();
        categories.addAll(cats);
        Node nodes = INodeCreator.getDefaultImpl().createNodes(categories, false, false);
        return nodes;
    }

    private Node<List<RecipeCategoryComplete>> getSubCategoriesFiltered(RecipeCategoryComplete parent) {
        return this.getFilteredCategories(parent.getSubCategories());
    }

    private void revalidateSelectableCategories() {
        RecipeCategoryLight cat;
        Node cat4Node;
        if (this.cat1 == null) {
            return;
        }
        this.cat1.getElement().removeItemListener(this);
        this.cat2.getElement().removeItemListener(this);
        this.cat3.getElement().removeItemListener(this);
        this.cat1.getElement().setNode((Node<?>)new DTOProxyNode());
        this.cat2.getElement().setNode((Node<?>)new DTOProxyNode());
        this.cat3.getElement().setNode((Node<?>)new DTOProxyNode());
        if (this.node != null && (cat4Node = this.node.getChildNamed(RecipeVariantLight_.category)) != null && (cat = (RecipeCategoryLight)cat4Node.getValue(RecipeCategoryLight.class)) != null) {
            RecipeCategoryComplete parent = cat.getParent();
            Node parentNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)parent, false, false);
            parentNode.updateNode();
            this.cat4.getElement().setNode(this.node.getChildNamed(RecipeVariantLight_.category));
            Node<List<RecipeCategoryComplete>> subCategoriesFiltered = this.getSubCategoriesFiltered(parent);
            this.cat4.getElement().refreshPossibleValues(subCategoriesFiltered);
            this.cat4.getElement().setSelectedItem(cat4Node);
            if (parent != null) {
                parent = parent.getParent();
                this.cat3.getElement().refreshPossibleValues(this.getSubCategoriesFiltered(parent));
                this.cat3.getElement().setSelectedItem(parentNode);
                parentNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)parent, false, false);
                parentNode.updateNode();
                if (parent != null) {
                    parent = parent.getParent();
                    this.cat2.getElement().refreshPossibleValues(this.getSubCategoriesFiltered(parent));
                    this.cat2.getElement().setSelectedItem(parentNode);
                    parentNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)parent, false, false);
                    parentNode.updateNode();
                    this.cat1.getElement().refreshPossibleValues(this.getTopLevelCategoriesFiltered());
                    this.cat1.getElement().setSelectedItem(parentNode);
                }
            }
        }
        this.cat1.getElement().addItemListener(this);
        this.cat2.getElement().addItemListener(this);
        this.cat3.getElement().addItemListener(this);
    }

    private Node<List<RecipeCategoryComplete>> getTopLevelCategoriesFiltered() {
        Node categories = NodeToolkit.getAffixList(RecipeCategoryComplete.class);
        return this.getFilteredCategories((List)categories.getValue());
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        return this.imagePreview.getElement().commitImage();
    }

    @Override
    public void childAdded(Node<?> source, Node<?> child) {
    }

    @Override
    public void childRemoved(Node<?> source, Node<?> child) {
    }

    @Override
    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    private boolean needsConversionUpdate() {
        Node n;
        int unitContaining;
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean conversionNeeded = false;
        if (this.node != null && this.node.getChildNamed(RecipeVariantComplete_.yield) != null && this.node.getChildNamed(new DtoField[]{RecipeVariantComplete_.yield, QuantityComplete_.unit}) != null && (unitContaining = UnitConversionToolkit.isUnitContaining((UnitComplete)((UnitComplete)(n = this.node.getChildNamed(new DtoField[]{RecipeVariantComplete_.yield, QuantityComplete_.unit})).getValue()), (UnitComplete)settings.getDefaultRecipeUnit(), null, (Timestamp)new Timestamp(System.currentTimeMillis()))) != 3) {
            conversionNeeded = true;
        }
        return conversionNeeded;
    }

    @Override
    public void valueChanged(Node<?> node) {
        if (node.getName().equals(QuantityComplete_.unit.getFieldName())) {
            this.setEnabled(this.isEnabled());
            Node ingredients = this.node.getChildNamed(RecipeVariantComplete_.ingredients);
            Iterator it = ingredients.getChilds();
            if (it != null) {
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    Node quant = n.getChildNamed(IngredientComplete_.quantity);
                    if (!(quant.getValue() instanceof StepQuantityInterpolationComplete)) continue;
                    Node steps = quant.getChildNamed(StepQuantityInterpolationComplete_.steps);
                    Iterator it2 = steps.getChilds();
                    while (it2.hasNext()) {
                        Node nn = (Node)it2.next();
                        Node q = nn.getChildNamed(new DtoField[]{InterpolationStepComplete_.upperBound, QuantityComplete_.unit});
                        q.setValue((Object)((UnitComplete)node.getValue()), 0L);
                    }
                }
            }
            if (!this.editor.getModel().isAddRow()) {
                InnerPopupFactory.showMessageDialog(Words.RECIPE_YIELD_UNIT_CHANGE_MESSAGE, this);
            }
            this.ensureConversion((Node<QuantityComplete>)this.node.getChildNamed(RecipeVariantComplete_.yield));
        } else if (node.getName().equals(QuantityComplete_.quantity.getFieldName())) {
            this.ensureConversion((Node<QuantityComplete>)this.node.getChildNamed(RecipeVariantComplete_.yield));
        } else if (node.getName().equals(RecipeVariantLight_.state.getFieldName())) {
            this.stateChangedNow = true;
            this.editor.setEnabled(this.editor.isEnabled());
        }
    }

    private void ensureConversion(Node<QuantityComplete> node) {
        if (!this.needsConversionUpdate()) {
            this.node.getChildNamed(RecipeVariantComplete_.conversionToDefaultUnit).setValue(node.getChildNamed(QuantityComplete_.quantity).getValue(), 0L);
            this.conversionUnit.setText(((UnitComplete)this.node.getChildNamed(new DtoField[]{RecipeVariantComplete_.yield, QuantityComplete_.unit}).getValue()).getShortName());
        } else {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            this.conversionUnit.setText(settings.getDefaultRecipeUnit().getShortName());
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        boolean isDraft;
        SystemSettingsComplete settings;
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && (this.name.getElement().getNode().getValue() == null || this.name.getElement().getNode().getValue().equals(""))) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
            this.name.getElement().setInvalid();
        }
        if (Boolean.TRUE.equals((settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getRecipeEnglishNameMandatory()) && this.englishName.getElement().isWritable() && (this.englishName.getElement().getNode().getValue() == null || this.englishName.getElement().getNode().getValue().equals(""))) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ENGLISH_NAME_IS_SET));
            this.englishName.getElement().setInvalid();
        }
        Double conversionAmount = (Double)this.node.getChildNamed(RecipeVariantLight_.conversionToDefaultUnit).getValue();
        if (this.conversion != null && this.conversion.getElement().isWritable() && conversionAmount == null) {
            this.conversion.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_YIELD_CONVERSION_IS_SET));
        }
        try {
            Double d = (Double)this.node.getChildNamed(new DtoField[]{RecipeVariantLight_.yield, QuantityComplete_.quantity}).getValue();
            if (d == null || d <= 0.0) {
                this.yield.getElement().setInvalid();
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_YIELD_IS_BIGGER_THAN_ZERO));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (Boolean.TRUE.equals(settings.getRecipeDefaultDepartmentMandatory()) && (isDraft = this.isStateDraft()) && this.defaultDepartment != null && this.defaultDepartment.getElement().isWritable() && this.defaultDepartment.getElement().getNode().getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.DEFAULT_DEPARTMENT_MUST_BE_SET));
            this.defaultDepartment.getElement().setInvalid();
        }
        return validationObjects;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.imagePreview.getElement().addFocusCycleChangeListener(listener);
    }

    @Override
    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentY = VariantBasicDataDetailsPanel.this.verticalBorder;
            VariantBasicDataDetailsPanel.this.name.setLocation(VariantBasicDataDetailsPanel.this.horizontalBorder, currentY);
            VariantBasicDataDetailsPanel.this.name.setSize(300, (int)VariantBasicDataDetailsPanel.this.name.getPreferredSize().getHeight());
            VariantBasicDataDetailsPanel.this.stateCombo.setLocation(VariantBasicDataDetailsPanel.this.name.getX() + VariantBasicDataDetailsPanel.this.name.getWidth() + VariantBasicDataDetailsPanel.this.horizontalBorder, currentY);
            VariantBasicDataDetailsPanel.this.stateCombo.setSize(100, (int)VariantBasicDataDetailsPanel.this.stateCombo.getPreferredSize().getHeight());
            VariantBasicDataDetailsPanel.this.customer.setLocation(VariantBasicDataDetailsPanel.this.stateCombo.getX() + VariantBasicDataDetailsPanel.this.stateCombo.getWidth() + VariantBasicDataDetailsPanel.this.horizontalBorder, VariantBasicDataDetailsPanel.this.stateCombo.getY());
            VariantBasicDataDetailsPanel.this.customer.setSize(250, (int)VariantBasicDataDetailsPanel.this.customer.getPreferredSize().getHeight());
            if (VariantBasicDataDetailsPanel.this.eanCode != null) {
                VariantBasicDataDetailsPanel.this.eanCode.setLocation(VariantBasicDataDetailsPanel.this.customer.getX() + VariantBasicDataDetailsPanel.this.customer.getWidth() + VariantBasicDataDetailsPanel.this.horizontalBorder, VariantBasicDataDetailsPanel.this.customer.getY());
                VariantBasicDataDetailsPanel.this.eanCode.setSize(200, (int)VariantBasicDataDetailsPanel.this.eanCode.getPreferredSize().getHeight());
            }
            VariantBasicDataDetailsPanel.this.englishName.setLocation(VariantBasicDataDetailsPanel.this.horizontalBorder, VariantBasicDataDetailsPanel.this.name.getY() + VariantBasicDataDetailsPanel.this.name.getHeight() + VariantBasicDataDetailsPanel.this.verticalBorder);
            VariantBasicDataDetailsPanel.this.englishName.setSize(300, (int)VariantBasicDataDetailsPanel.this.englishName.getPreferredSize().getHeight());
            currentY = VariantBasicDataDetailsPanel.this.englishName.getY();
            VariantBasicDataDetailsPanel.this.yield.setLocation(VariantBasicDataDetailsPanel.this.englishName.getX() + VariantBasicDataDetailsPanel.this.englishName.getWidth() + VariantBasicDataDetailsPanel.this.horizontalBorder, currentY);
            VariantBasicDataDetailsPanel.this.yield.setSize((int)VariantBasicDataDetailsPanel.this.yield.getPreferredSize().getWidth(), (int)VariantBasicDataDetailsPanel.this.yield.getPreferredSize().getHeight());
            VariantBasicDataDetailsPanel.this.equalsSign.setLocation(VariantBasicDataDetailsPanel.this.yield.getX() + VariantBasicDataDetailsPanel.this.yield.getWidth() + 5, (int)((double)(VariantBasicDataDetailsPanel.this.yield.getY() + VariantBasicDataDetailsPanel.this.yield.getHeight()) - VariantBasicDataDetailsPanel.this.equalsSign.getPreferredSize().getHeight()));
            VariantBasicDataDetailsPanel.this.equalsSign.setSize(VariantBasicDataDetailsPanel.this.equalsSign.getPreferredSize());
            VariantBasicDataDetailsPanel.this.conversion.setLocation(VariantBasicDataDetailsPanel.this.equalsSign.getX() + VariantBasicDataDetailsPanel.this.equalsSign.getWidth() + 5, currentY);
            VariantBasicDataDetailsPanel.this.conversion.setSize(VariantBasicDataDetailsPanel.this.conversion.getPreferredSize());
            VariantBasicDataDetailsPanel.this.conversionUnit.setLocation(VariantBasicDataDetailsPanel.this.conversion.getX() + VariantBasicDataDetailsPanel.this.conversion.getWidth() + 3, (int)((double)(currentY + VariantBasicDataDetailsPanel.this.conversion.getHeight()) - VariantBasicDataDetailsPanel.this.conversionUnit.getPreferredSize().getHeight()));
            VariantBasicDataDetailsPanel.this.conversionUnit.setSize(VariantBasicDataDetailsPanel.this.conversionUnit.getPreferredSize());
            int currentX = VariantBasicDataDetailsPanel.this.conversionUnit.getX() + VariantBasicDataDetailsPanel.this.conversionUnit.getWidth() + VariantBasicDataDetailsPanel.this.horizontalBorder * 2;
            if (VariantBasicDataDetailsPanel.this.batchSize != null) {
                VariantBasicDataDetailsPanel.this.batchSize.setLocation(VariantBasicDataDetailsPanel.this.conversionUnit.getX() + VariantBasicDataDetailsPanel.this.conversionUnit.getWidth() + VariantBasicDataDetailsPanel.this.horizontalBorder * 2, currentY);
                VariantBasicDataDetailsPanel.this.batchSize.setSize(VariantBasicDataDetailsPanel.this.batchSize.getPreferredSize());
                currentX = VariantBasicDataDetailsPanel.this.batchSize.getX() + VariantBasicDataDetailsPanel.this.batchSize.getWidth() + VariantBasicDataDetailsPanel.this.horizontalBorder * 2;
            }
            VariantBasicDataDetailsPanel.this.imagePreview.setLocation(currentX, currentY);
            VariantBasicDataDetailsPanel.this.imagePreview.setSize(VariantBasicDataDetailsPanel.this.imagePreview.getPreferredSize());
            int catWidth = (parent.getWidth() - (2 * VariantBasicDataDetailsPanel.this.horizontalBorder + 3 * VariantBasicDataDetailsPanel.this.inner_horizontalBorder)) / 4;
            VariantBasicDataDetailsPanel.this.cat1.setLocation(VariantBasicDataDetailsPanel.this.horizontalBorder, currentY += VariantBasicDataDetailsPanel.this.stateCombo.getHeight() + VariantBasicDataDetailsPanel.this.verticalBorder);
            VariantBasicDataDetailsPanel.this.cat1.setSize(catWidth, (int)VariantBasicDataDetailsPanel.this.cat1.getPreferredSize().getHeight());
            VariantBasicDataDetailsPanel.this.cat2.setLocation(VariantBasicDataDetailsPanel.this.cat1.getX() + VariantBasicDataDetailsPanel.this.cat1.getWidth() + VariantBasicDataDetailsPanel.this.inner_horizontalBorder, currentY);
            VariantBasicDataDetailsPanel.this.cat2.setSize(catWidth, (int)VariantBasicDataDetailsPanel.this.cat2.getPreferredSize().getHeight());
            VariantBasicDataDetailsPanel.this.cat3.setLocation(VariantBasicDataDetailsPanel.this.cat2.getX() + VariantBasicDataDetailsPanel.this.cat2.getWidth() + VariantBasicDataDetailsPanel.this.inner_horizontalBorder, currentY);
            VariantBasicDataDetailsPanel.this.cat3.setSize(catWidth, (int)VariantBasicDataDetailsPanel.this.cat3.getPreferredSize().getHeight());
            VariantBasicDataDetailsPanel.this.cat4.setLocation(VariantBasicDataDetailsPanel.this.cat3.getX() + VariantBasicDataDetailsPanel.this.cat3.getWidth() + VariantBasicDataDetailsPanel.this.inner_horizontalBorder, currentY);
            VariantBasicDataDetailsPanel.this.cat4.setSize(catWidth, (int)VariantBasicDataDetailsPanel.this.cat4.getPreferredSize().getHeight());
            VariantBasicDataDetailsPanel.this.defaultDepartment.setLocation(VariantBasicDataDetailsPanel.this.horizontalBorder, currentY += VariantBasicDataDetailsPanel.this.cat1.getHeight() + VariantBasicDataDetailsPanel.this.verticalBorder);
            VariantBasicDataDetailsPanel.this.defaultDepartment.setSize(350, (int)VariantBasicDataDetailsPanel.this.defaultDepartment.getPreferredSize().getHeight());
            if (!isNoPro) {
                currentX = VariantBasicDataDetailsPanel.this.defaultDepartment.getX() + VariantBasicDataDetailsPanel.this.defaultDepartment.getWidth();
                if (VariantBasicDataDetailsPanel.this.preparationGroup != null) {
                    VariantBasicDataDetailsPanel.this.preparationGroup.setLocation(currentX + VariantBasicDataDetailsPanel.this.horizontalBorder, VariantBasicDataDetailsPanel.this.defaultDepartment.getY());
                    VariantBasicDataDetailsPanel.this.preparationGroup.setSize(200, (int)VariantBasicDataDetailsPanel.this.preparationGroup.getPreferredSize().getHeight());
                    currentX = VariantBasicDataDetailsPanel.this.preparationGroup.getX() + VariantBasicDataDetailsPanel.this.preparationGroup.getWidth();
                }
                VariantBasicDataDetailsPanel.this.productGroup.setLocation(currentX + VariantBasicDataDetailsPanel.this.horizontalBorder, currentY);
                VariantBasicDataDetailsPanel.this.productGroup.setSize(200, (int)VariantBasicDataDetailsPanel.this.productGroup.getPreferredSize().getHeight());
                VariantBasicDataDetailsPanel.this.halal.setLocation(VariantBasicDataDetailsPanel.this.productGroup.getX() + VariantBasicDataDetailsPanel.this.productGroup.getWidth() + VariantBasicDataDetailsPanel.this.horizontalBorder, (int)((double)(VariantBasicDataDetailsPanel.this.defaultDepartment.getY() + VariantBasicDataDetailsPanel.this.defaultDepartment.getHeight()) - (VariantBasicDataDetailsPanel.this.halal.getPreferredSize().getHeight() - 4.0)));
                VariantBasicDataDetailsPanel.this.halal.setSize(VariantBasicDataDetailsPanel.this.halal.getPreferredSize());
                VariantBasicDataDetailsPanel.this.useDefaultCostCenterForCCP2.setLocation(VariantBasicDataDetailsPanel.this.horizontalBorder, VariantBasicDataDetailsPanel.this.defaultDepartment.getY() + VariantBasicDataDetailsPanel.this.defaultDepartment.getHeight() + VariantBasicDataDetailsPanel.this.inner_verticalBorder);
                VariantBasicDataDetailsPanel.this.useDefaultCostCenterForCCP2.setSize(VariantBasicDataDetailsPanel.this.useDefaultCostCenterForCCP2.getPreferredSize());
                currentX = VariantBasicDataDetailsPanel.this.useDefaultCostCenterForCCP2.getX() + VariantBasicDataDetailsPanel.this.useDefaultCostCenterForCCP2.getWidth();
                if (VariantBasicDataDetailsPanel.this.excludeFromKonterProbe != null) {
                    VariantBasicDataDetailsPanel.this.excludeFromKonterProbe.setLocation(currentX + VariantBasicDataDetailsPanel.this.horizontalBorder, VariantBasicDataDetailsPanel.this.useDefaultCostCenterForCCP2.getY());
                    VariantBasicDataDetailsPanel.this.excludeFromKonterProbe.setSize(VariantBasicDataDetailsPanel.this.excludeFromKonterProbe.getPreferredSize());
                    currentX = VariantBasicDataDetailsPanel.this.excludeFromKonterProbe.getX() + VariantBasicDataDetailsPanel.this.excludeFromKonterProbe.getWidth();
                }
                VariantBasicDataDetailsPanel.this.useReserve.setLocation(currentX + VariantBasicDataDetailsPanel.this.horizontalBorder, VariantBasicDataDetailsPanel.this.useDefaultCostCenterForCCP2.getY());
                VariantBasicDataDetailsPanel.this.useReserve.setSize(VariantBasicDataDetailsPanel.this.useReserve.getPreferredSize());
                currentX = VariantBasicDataDetailsPanel.this.useReserve.getX() + VariantBasicDataDetailsPanel.this.useReserve.getWidth();
                VariantBasicDataDetailsPanel.this.alwaysShowOnOPRP05Log.setLocation(currentX + VariantBasicDataDetailsPanel.this.horizontalBorder, VariantBasicDataDetailsPanel.this.useDefaultCostCenterForCCP2.getY());
                VariantBasicDataDetailsPanel.this.alwaysShowOnOPRP05Log.setSize(VariantBasicDataDetailsPanel.this.alwaysShowOnOPRP05Log.getPreferredSize());
                currentX = VariantBasicDataDetailsPanel.this.alwaysShowOnOPRP05Log.getX() + VariantBasicDataDetailsPanel.this.alwaysShowOnOPRP05Log.getWidth();
                VariantBasicDataDetailsPanel.this.directlyInProduct.setLocation(currentX + VariantBasicDataDetailsPanel.this.horizontalBorder, VariantBasicDataDetailsPanel.this.useDefaultCostCenterForCCP2.getY());
                VariantBasicDataDetailsPanel.this.directlyInProduct.setSize(VariantBasicDataDetailsPanel.this.directlyInProduct.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = VariantBasicDataDetailsPanel.this.verticalBorder;
            h = (int)((double)h + VariantBasicDataDetailsPanel.this.stateCombo.getPreferredSize().getHeight());
            h += VariantBasicDataDetailsPanel.this.verticalBorder;
            h = (int)((double)h + VariantBasicDataDetailsPanel.this.englishName.getPreferredSize().getHeight());
            h += VariantBasicDataDetailsPanel.this.verticalBorder;
            h = (int)((double)h + VariantBasicDataDetailsPanel.this.cat1.getPreferredSize().getHeight());
            h += VariantBasicDataDetailsPanel.this.verticalBorder;
            h = (int)((double)h + VariantBasicDataDetailsPanel.this.defaultDepartment.getPreferredSize().getHeight());
            if (!isNoPro) {
                h += VariantBasicDataDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + VariantBasicDataDetailsPanel.this.useDefaultCostCenterForCCP2.getPreferredSize().getHeight());
            }
            return new Dimension(0, h += VariantBasicDataDetailsPanel.this.verticalBorder);
        }
    }
}

