/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.reorderlevel.details;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelEntryComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelLight;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ArticlesDetailsPanel
extends TableDetailsPanel<ReorderLevelLight> {
    private static final long serialVersionUID = 1L;

    public ArticlesDetailsPanel(RowEditor<ReorderLevelLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ARTICLES);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.ARTICLE, "", String.class, null, "", 120, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo("Daily Usage", "", (Class)String.class, null, "", 150));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setUseAccessRight(true);
        table.setDontUseScrollBar(15);
        table.setSortedColumn(0);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        return new TableRowImpl(model);
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(ReorderLevelComplete_.articles));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private TextLabel article;
        private RDInputComboBox dailyUsage;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            BasicArticleComplete artC = (BasicArticleComplete)m.getNode().getChildNamed(SafetyStockArticleComplete_.article).getValue(BasicArticleComplete.class);
            ViewNode un = new ViewNode("");
            if (artC != null) {
                List units = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)new Timestamp(System.currentTimeMillis()), (TransactionType)TransactionType.PURCHASE, (UserComplete)ArticlesDetailsPanel.this.currentUser, null, null, (SystemSettingsComplete)ArticlesDetailsPanel.this.settings);
                for (UnitComplete u : units) {
                    un.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)u, false, true), 0L);
                }
            }
            this.article = new TextLabel(m.getNode().getChildNamed(ReorderLevelEntryComplete_.article), ConverterRegistry.getConverter(BasicArticleConverter.class));
            this.dailyUsage = new RDInputComboBox(ArticlesDetailsPanel.this.provider, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.dailyUsage.setOverrideName(ReorderLevelComplete_.articles);
            this.dailyUsage.setNode(m.getNode().getChildNamed(new DtoField[]{ReorderLevelEntryComplete_.dailyUsageInStoreUnit, QuantityComplete_.quantity}), m.getNode().getChildNamed(new DtoField[]{ReorderLevelEntryComplete_.dailyUsageInStoreUnit, QuantityComplete_.unit}));
            this.dailyUsage.setPossibleUnits((Node)un);
            this.setLayout(new Layout());
            this.add(this.article);
            this.add(this.dailyUsage);
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(new DtoField[]{ReorderLevelEntryComplete_.article, BasicArticleLight_.number}).getValue();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.dailyUsage);
            return focusList;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.article.kill();
            this.article = null;
            this.dailyUsage = null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = 0;
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(0);
                TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.article.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(1);
                TableRowImpl.this.dailyUsage.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.dailyUsage.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.dailyUsage.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.dailyUsage.getPreferredSize().getHeight());
            }
        }
    }
}

