/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.requisitionorder.manager.details.utils;

import ch.icit.pegasus.client.converter.PriceWithUnitConverter;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.StockTransactionRemarkButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.loaders.ArticleChargeLoader;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.remark.StockTransactionRemarkComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.List;

public class OrderAmountChangingPopup<T extends StockTransactionRemarkComplete>
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private TitledItem<QuantityRenderer> oldAmount;
    private TitledItem<InputComboBox2> newAmount;
    private final Timestamp validity;
    private Node<SupplierConditionComplete> supplierCondition;
    private StockTransactionRemarkButton<T> remark;
    private Node art;
    private LoadingAnimation animation;
    private TitledItem<TextLabel> oldOrderPriceWithUnit;
    private TitledItem<InputComboBox2> newOrderPrice;
    private TitledItem<ComboBox> newOrderPriceUnit;
    private boolean isAnimating = false;
    UserComplete currentUser;
    SystemSettingsComplete settings;
    private TransactionType type;

    public OrderAmountChangingPopup(Node newAmount, Node oldAmount, Node artC, Timestamp validity, Node remarksNode, Class<T> remarks, TransactionType type) {
        this(newAmount, oldAmount, artC, validity, null, null, null, null, remarksNode, remarks, null, true, type);
    }

    public OrderAmountChangingPopup(Node newAmount, Node oldAmount, Node artC, Timestamp validity, Node newOrderPrice, Node oldOrderPrice, Node newOrderPriceUnit, Node oldOrderPriceUnit, Node remarksNode, Class<T> remarks, Node<SupplierConditionComplete> supplierCondition, boolean conversionIsValid, TransactionType type) {
        this.type = type;
        this.currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (supplierCondition != null) {
            Node groupNode = new Node();
            groupNode.addChild(oldOrderPrice, 0L);
            groupNode.addChild(oldOrderPriceUnit, 0L);
            this.oldOrderPriceWithUnit = new TitledItem<TextLabel>(new TextLabel(groupNode, ConverterRegistry.getConverter(PriceWithUnitConverter.class)), Words.OLD_PRICE, TitledItem.TitledItemOrientation.NORTH);
            this.newOrderPrice = new TitledItem<InputComboBox2>(new InputComboBox2(newOrderPrice.getChildNamed(PriceComplete_.price), newOrderPrice.getChildNamed(PriceComplete_.currency), InputComboBox.InputComboBoxType.PRICE_DOUBLE), Words.NEW_PRICE, TitledItem.TitledItemOrientation.NORTH);
            this.newOrderPrice.getElement().setMaxKommaStellen(3);
            this.newOrderPriceUnit = new TitledItem<ComboBox>(new ComboBox(newOrderPriceUnit, null, ConverterRegistry.getConverter(UnitConverter.class)), Words.UNIT, TitledItem.TitledItemOrientation.NORTH);
        }
        this.oldAmount = new TitledItem<QuantityRenderer>(new QuantityRenderer((Node<?>)oldAmount), Words.ORDERED_AMOUNT, TitledItem.TitledItemOrientation.NORTH);
        this.newAmount = new TitledItem<InputComboBox2>(new InputComboBox2(newAmount.getChildNamed(StoreQuantityComplete_.amount), newAmount.getChildNamed(StoreQuantityComplete_.unit), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG), Words.NEW_ORDER_AMOUNT, TitledItem.TitledItemOrientation.NORTH);
        this.validity = validity;
        this.supplierCondition = supplierCondition;
        if (!conversionIsValid) {
            this.oldAmount.getElement().setInvalid();
            BasicArticleLight article = (BasicArticleLight)artC.getValue();
            UnitComplete storeUnit = article.getFloatStoreUnit();
            this.newAmount.getElement().setSelectedUnit(storeUnit);
        }
        if (remarks != null) {
            this.remark = new StockTransactionRemarkButton<T>(true, remarks);
            this.remark.setNode(remarksNode);
        }
        this.art = artC;
        this.setLayout(new Layout());
        this.add(this.oldAmount);
        this.add(this.newAmount);
        if (this.remark != null) {
            // empty if block
        }
        this.oldAmount.setVisible(false);
        this.newAmount.setVisible(false);
        if (this.remark != null) {
            this.remark.setVisible(false);
        }
        if (supplierCondition != null) {
            this.add(this.oldOrderPriceWithUnit);
            this.add(this.newOrderPriceUnit);
            this.add(this.newOrderPrice);
        }
        this.loadArticleData();
    }

    private void loadArticleData() {
        if (this.art.getValue(BasicArticleLight.class) != null) {
            if (this.art.getValue(BasicArticleComplete.class) != null) {
                this.remoteObjectLoaded(this.art);
            } else {
                new BasicArticleLoader((BasicArticleReference)((BasicArticleLight)this.art.getValue(BasicArticleLight.class)), this, this.art, this);
                this.ensureAnimation();
            }
        } else if (this.art.getValue(ArticleChargeComplete.class) != null) {
            this.remoteObjectLoaded(this.art);
        } else {
            new ArticleChargeLoader((ArticleChargeLight)this.art.getValue(ArticleChargeLight.class), this, this.art, this);
        }
    }

    private void ensureAnimation() {
        this.isAnimating = true;
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(Words.LOAD_ARTICLE);
            this.add(this.animation);
            this.animation.fadeIn();
            this.animation.start();
        }
    }

    private void killAnimation() {
        this.isAnimating = false;
        if (this.animation != null) {
            this.animation.kill();
        }
        this.animation = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.newAmount.getFocusComponents();
        if (this.newOrderPrice != null) {
            a.addAll(this.newOrderPrice.getFocusComponents());
        }
        return a;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[2];
        o[0] = this.newAmount.getElement().getValueNode();
        if (this.remark != null) {
            o[1] = this.remark.getNode();
        }
        return o;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.oldAmount.kill();
        this.newAmount.kill();
        if (this.remark != null) {
            this.remark.kill();
        }
        if (this.supplierCondition != null) {
            this.oldOrderPriceWithUnit.kill();
            this.newOrderPriceUnit.kill();
            this.newOrderPrice.kill();
        }
        this.oldOrderPriceWithUnit = null;
        this.newOrderPriceUnit = null;
        this.newOrderPrice = null;
        this.oldAmount = null;
        this.newAmount = null;
        this.remark = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.killAnimation();
        this.oldAmount.setVisible(true);
        this.newAmount.setVisible(true);
        if (this.remark != null) {
            this.remark.setVisible(true);
        }
        if (this.art.getValue(BasicArticleComplete.class) != null) {
            if (this.supplierCondition != null && this.supplierCondition.getValue() != null) {
                BasicArticleComplete artC = (BasicArticleComplete)this.art.getValue(BasicArticleComplete.class);
                List units = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)this.validity, (TransactionType)this.type, (UserComplete)this.currentUser, null, null, (SystemSettingsComplete)this.settings);
                this.newAmount.getElement().setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                if (units.isEmpty()) {
                    this.newAmount.getElement().clearSelectedUnit();
                }
                List priceUnit = UnitConversionToolkit.getAllUnits((UnitComplete)artC.getPriceUnit());
                this.newOrderPriceUnit.getElement().refreshPossibleValues((Node)UnitConversionToolkitNodeBased.getUnitList(priceUnit));
            } else {
                RequisitionOrderPositionComplete order;
                BasicArticleComplete artC = (BasicArticleComplete)this.art.getValue(BasicArticleComplete.class);
                StoreLight store = null;
                if (node.getParent().getValue() instanceof RequisitionOrderPositionComplete && (order = (RequisitionOrderPositionComplete)node.getParent().getValue()) != null && order.getReceivingStore() != null) {
                    store = order.getReceivingStore().getStore();
                }
                List possibleUnits = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)this.validity, (TransactionType)this.type, (UserComplete)this.currentUser, null, store, (SystemSettingsComplete)this.settings);
                this.newAmount.getElement().setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(possibleUnits));
            }
        } else if (this.supplierCondition != null && Boolean.TRUE.equals(((SupplierConditionComplete)this.supplierCondition.getValue()).getUsePackingQuantity())) {
            ViewNode unitList = UnitConversionToolkitNodeBased.getUnitList((SupplierConditionComplete)this.supplierCondition.getValue());
            this.newAmount.getElement().setPossibleUnits((Node)unitList);
            this.newOrderPriceUnit.getElement().refreshPossibleValues((Node)unitList);
        } else {
            ArticleChargeComplete charge = (ArticleChargeComplete)this.art.getValue(ArticleChargeComplete.class);
            List possibleUnits = StoreToolkit.getPossibleUnits((ArticleChargeComplete)charge, (TransactionType)this.type, (UserComplete)this.currentUser, null, null, (SystemSettingsComplete)this.settings);
            this.newAmount.getElement().setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(possibleUnits));
        }
        this.invalidate();
        this.validate();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (OrderAmountChangingPopup.this.isAnimating) {
                OrderAmountChangingPopup.this.animation.setLocation((int)((double)parent.getWidth() - OrderAmountChangingPopup.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - OrderAmountChangingPopup.this.animation.getPreferredSize().getHeight()) / 2);
                OrderAmountChangingPopup.this.animation.setSize(OrderAmountChangingPopup.this.animation.getPreferredSize());
            } else {
                OrderAmountChangingPopup.this.oldAmount.setLocation(0, 0);
                OrderAmountChangingPopup.this.oldAmount.setSize((int)OrderAmountChangingPopup.this.oldAmount.getPreferredSize().getWidth(), (int)OrderAmountChangingPopup.this.oldAmount.getPreferredSize().getHeight());
                OrderAmountChangingPopup.this.newAmount.setLocation(0, OrderAmountChangingPopup.this.oldAmount.getY() + OrderAmountChangingPopup.this.oldAmount.getHeight() + 10);
                OrderAmountChangingPopup.this.newAmount.setSize((int)OrderAmountChangingPopup.this.newAmount.getPreferredSize().getWidth(), (int)OrderAmountChangingPopup.this.newAmount.getPreferredSize().getHeight());
                int y = OrderAmountChangingPopup.this.newAmount.getY() + OrderAmountChangingPopup.this.newAmount.getHeight();
                if (OrderAmountChangingPopup.this.supplierCondition != null) {
                    OrderAmountChangingPopup.this.oldOrderPriceWithUnit.setLocation(0, OrderAmountChangingPopup.this.newAmount.getY() + OrderAmountChangingPopup.this.newAmount.getHeight() + 10);
                    OrderAmountChangingPopup.this.oldOrderPriceWithUnit.setSize((int)OrderAmountChangingPopup.this.oldOrderPriceWithUnit.getPreferredSize().getWidth(), (int)OrderAmountChangingPopup.this.oldOrderPriceWithUnit.getPreferredSize().getHeight());
                    OrderAmountChangingPopup.this.newOrderPrice.setLocation(0, OrderAmountChangingPopup.this.oldOrderPriceWithUnit.getY() + OrderAmountChangingPopup.this.oldOrderPriceWithUnit.getHeight() + 10);
                    OrderAmountChangingPopup.this.newOrderPrice.setSize((int)OrderAmountChangingPopup.this.newOrderPrice.getPreferredSize().getWidth(), (int)OrderAmountChangingPopup.this.newOrderPrice.getPreferredSize().getHeight());
                    OrderAmountChangingPopup.this.newOrderPriceUnit.setLocation(OrderAmountChangingPopup.this.newOrderPrice.getX() + OrderAmountChangingPopup.this.newOrderPrice.getWidth() + 3, OrderAmountChangingPopup.this.oldOrderPriceWithUnit.getY() + OrderAmountChangingPopup.this.oldOrderPriceWithUnit.getHeight() + 10);
                    OrderAmountChangingPopup.this.newOrderPriceUnit.setSize((int)OrderAmountChangingPopup.this.newOrderPriceUnit.getPreferredSize().getWidth(), (int)OrderAmountChangingPopup.this.newOrderPriceUnit.getPreferredSize().getHeight());
                }
                if (OrderAmountChangingPopup.this.remark != null) {
                    OrderAmountChangingPopup.this.remark.setLocation(OrderAmountChangingPopup.this.newAmount.getX() + OrderAmountChangingPopup.this.newAmount.getWidth() + 5, (int)((double)y - OrderAmountChangingPopup.this.remark.getPreferredSize().getHeight() - 4.0));
                    OrderAmountChangingPopup.this.remark.setSize(OrderAmountChangingPopup.this.remark.getPreferredSize());
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)OrderAmountChangingPopup.this.oldAmount.getPreferredSize().getHeight();
            h += 10;
            h = (int)((double)h + OrderAmountChangingPopup.this.newAmount.getPreferredSize().getHeight());
            h += 10;
            if (OrderAmountChangingPopup.this.supplierCondition != null) {
                h = (int)((double)h + OrderAmountChangingPopup.this.oldOrderPriceWithUnit.getPreferredSize().getHeight());
                h += 10;
                h = (int)((double)h + OrderAmountChangingPopup.this.newOrderPriceUnit.getPreferredSize().getHeight());
                h += 10;
            }
            return new Dimension(0, h);
        }
    }
}

