/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.sageimport;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.sageimport.SageImportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.importer.FlightImportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.sage.SageImportComplete;
import ch.icit.pegasus.server.core.dtos.sage.SageImportLight;
import ch.icit.pegasus.server.core.dtos.sage.SageImportReference;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;

public class SageImportModuleDataHandler
extends DefaultDataHandler<SageImportLight, SageImportComplete> {
    public SageImportModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return Words.CHECK_CUSTOMER_CODE;
    }

    @Override
    public void updateData(final Node<SageImportLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit();
                SageImportComplete oldDTO = (SageImportComplete)node.getValue();
                SageImportComplete dto = (SageImportComplete)((SageImportServiceManager)ServiceManagerRegistry.getService(SageImportServiceManager.class)).updateSageImport(oldDTO).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<SageImportComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit();
                SageImportComplete oldDTO = (SageImportComplete)node.getValue();
                if (oldDTO.getEligibleLocations().isEmpty()) {
                    oldDTO.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                SageImportComplete dto = (SageImportComplete)((SageImportServiceManager)ServiceManagerRegistry.getService(SageImportServiceManager.class)).createSageImport(oldDTO).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SageImportModuleDataHandler.this.setCurrentLoadMaximum(2);
                SageImportModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return SageImportModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<SageImportComplete> resetData(Node<SageImportComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<SageImportComplete> createEmptyNode() {
        SageImportComplete newOne = new SageImportComplete();
        newOne.setClientOId(Long.valueOf(ADTO.getNextId()));
        LocationComplete loc = (LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue();
        newOne.getEligibleLocations().add(loc);
        newOne.setImportValidity(Boolean.valueOf(false));
        newOne.setPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)newOne, false, false);
        INodeCreator.getDefaultImpl().initUpdate(n);
        return n;
    }

    @Override
    public Class<FlightImportComplete> getCommittingClass() {
        return FlightImportComplete.class;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SageImportLight fil = (SageImportLight)node.getValue(SageImportLight.class);
                SageImportComplete c = (SageImportComplete)((SageImportServiceManager)ServiceManagerRegistry.getService(SageImportServiceManager.class)).getSageImport((SageImportReference)fil).getValue();
                node.removeExistingValues();
                node.setValue((Object)c, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void doRemoteValidation(Node<SageImportLight> node, final RemoteLoader listener, ProgressListener l, boolean validateAll) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }
}

