/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stowinglist.details;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StowingListTemplateVariantConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.AVariantTemplateDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.ArrayList;
import java.util.List;

public class TemplateDetailsPanel
extends AVariantTemplateDetailsPanel<StowingListTemplateComplete, StowingListTemplateVariantLight> {
    private static final long serialVersionUID = 1L;

    public TemplateDetailsPanel(RowEditor<StowingListTemplateComplete> editor, RDProvider provider) {
        super(editor, provider);
        provider.addAccessRightToUseItAnyway(ProductAccess.COPY_FROM_TEMPLATE);
    }

    public boolean isTemplateSelected() {
        return true;
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    public Converter<?, String> getVariantViewConverter() {
        return ConverterRegistry.getConverter(StowingListTemplateVariantConverter.class);
    }

    @Override
    public SearchTextField2<StowingListTemplateComplete> createSearchField() {
        return SearchTextField2Factory.getStowingTemplateSearchField(false, new DTOProxyNode());
    }

    @Override
    public String getSearchFieldTitle() {
        return Words.STOWING_LIST_TEMPLATE;
    }

    @Override
    public StowingListTemplateComplete reloadItem(StowingListTemplateComplete item) throws ClientServerCallException {
        return (StowingListTemplateComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getStowingListTemplateComplete(new StowingListTemplateReference(item.getId())).getValue();
    }

    @Override
    public Class<StowingListTemplateComplete> getVariantMasterClass() {
        return StowingListTemplateComplete.class;
    }

    @Override
    public List<StowingListTemplateVariantLight> reloadVariants(List<StowingListTemplateVariantLight> variants) throws ClientServerCallException {
        ArrayList<StowingListTemplateVariantLight> refs = new ArrayList<StowingListTemplateVariantLight>();
        refs.addAll(variants);
        return ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariants(new ListWrapper(refs)).getList();
    }

    @Override
    public StowingListTemplateComplete copyItem(StowingListTemplateComplete master, StowingListTemplateVariantLight variant, boolean upload, boolean copyAllVariants) throws ClientServerCallException {
        StowingListTemplateComplete v = CopyTemplateToolkit.copyStowingListTemplate(master, copyAllVariants ? null : variant, false);
        v.setCurrentVariant((StowingListTemplateVariantLight)v.getVariants().get(0));
        return v;
    }

    @Override
    public Class<StowingListTemplateVariantLight> getVariantClass() {
        return StowingListTemplateVariantLight.class;
    }

    @Override
    public void initNewVariant(StowingListTemplateComplete newVariant) {
        newVariant.getCurrentVariant().setName("");
        newVariant.getCurrentVariant().setState(ModificationStateE.DRAFT);
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
        return a;
    }
}

