/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.tradegoods.details.utils;

import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public class PriceLoader
implements LoadingGroup,
RemoteLoader {
    private List<ReloadablePriceView> products = new ArrayList<ReloadablePriceView>();
    private ReloadablePriceView totalCost;
    private boolean isRunning;
    private PriorityQueue<ReloadablePriceView> loadingQueue = new PriorityQueue<ReloadablePriceView>(10, new InnerComparator());
    private static final int TYPE_PRODUCT = 2;
    private static final int TYPE_TOTAL = 3;

    public void addProduct(ReloadablePriceView p) {
        this.products.add(p);
    }

    public void setTotalCost(ReloadablePriceView total) {
        this.totalCost = total;
    }

    @Override
    public void updateMe(ReloadablePriceView rpv) {
        if (this.getType(rpv) == 2) {
            this.addToQueue(rpv);
            this.addToQueue(this.totalCost);
        } else if (this.getType(rpv) == 3) {
            this.addToQueue(this.totalCost);
        }
        this.runMe();
    }

    private void runMe() {
        if (this.isRunning) {
            return;
        }
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                while (!PriceLoader.this.loadingQueue.isEmpty()) {
                    ReloadablePriceView r = (ReloadablePriceView)PriceLoader.this.loadingQueue.poll();
                    if (r == null) continue;
                    CalculationRunnable runing = r.getCurrentRunnable();
                    if (runing != null && runing.isAlive()) {
                        runing.run();
                        r.loaded();
                        continue;
                    }
                    r.loaded();
                }
                PriceLoader.this.isRunning = false;
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PriceLoader.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        this.isRunning = true;
        ThreadSafeLoader.run(run);
    }

    private int getType(ReloadablePriceView rpv) {
        if (rpv == this.totalCost) {
            return 3;
        }
        return 2;
    }

    private void addToQueue(ReloadablePriceView rpv) {
        if (rpv != null) {
            this.loadingQueue.add(rpv);
        }
    }

    public void remoteObjectLoaded(Node<?> node) {
    }

    public void errorOccurred(ClientException exception) {
    }

    private class InnerComparator
    implements Comparator<ReloadablePriceView> {
        private InnerComparator() {
        }

        @Override
        public int compare(ReloadablePriceView o1, ReloadablePriceView o2) {
            Integer i1 = PriceLoader.this.getType(o1);
            Integer i2 = PriceLoader.this.getType(o2);
            return i1.compareTo(i2);
        }
    }
}

