/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.wag.details;

import ch.icit.pegasus.client.converter.ProductCustomerNumberViewConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flight.utils.WAGEditableChecker;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.FlightToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ProductsDetailsPanel
extends TableDetailsPanel<FlightLight>
implements LafListener {
    private static final long serialVersionUID = 1L;
    private Node<FlightComplete> root;
    private WAGEditableChecker checker = new WAGEditableChecker();
    private boolean isDeletable = true;

    public ProductsDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true, true);
        this.setTitleText(Words.PRODUCTS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tc = CheckBox.getPreferredWidth() + this.table.getCellPadding() * 2;
        columns.add(new TableColumnInfo(Words.PRODUCT, "", null, null, "", 150));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.6f);
        columns.add(new TableColumnInfo(Words.PORTION, "", null, null, "", 75));
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        columns.add(new TableColumnInfo(Words.REMARK, "", null, null, "", 40));
        ((TableColumnInfo)columns.get(2)).setxExpand(0.4f);
        int expiryWidth = DateChooser.getPreferredWidth(this, false) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.EXPIRY_DATE, "", null, null, "", expiryWidth));
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        int delWidth = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", "", null, null, "", delWidth += 2 * this.table.getCellPadding()));
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setComparator(new Comparator<TableRowEditor>(){

            @Override
            public int compare(TableRowEditor o1, TableRowEditor o2) {
                boolean sortFlightAdditionalOrdersBySequence = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getSortFlightAdditionalsBySequence());
                Node order1 = o1.getModel().getNode();
                Node order2 = o2.getModel().getNode();
                if (sortFlightAdditionalOrdersBySequence) {
                    Integer t1 = (Integer)order1.getChildNamed(AdditionalOrderComplete_.sequenceNumber).getValue();
                    Integer t2 = (Integer)order2.getChildNamed(AdditionalOrderComplete_.sequenceNumber).getValue();
                    if (t1 == null) {
                        return t2 == null ? 0 : -1;
                    }
                    if (t2 == null) {
                        return 1;
                    }
                    return t1.compareTo(t2);
                }
                if (order1.getChildNamed(AdditionalOrderComplete_.product).getValue() == null) {
                    return order2.getChildNamed(AdditionalOrderComplete_.product).getValue() == null ? 0 : 1;
                }
                if (order2.getChildNamed(AdditionalOrderComplete_.product).getValue() == null) {
                    return -1;
                }
                Integer t1 = (Integer)order1.getChildNamed(AdditionalOrderComplete_.sequenceNumber).getValue();
                Integer t2 = (Integer)order2.getChildNamed(AdditionalOrderComplete_.sequenceNumber).getValue();
                if (t1 == null) {
                    return t2 == null ? 0 : -1;
                }
                if (t2 == null) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
        });
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        AdditionalOrderComplete nDto = new AdditionalOrderComplete();
        nDto.setSequenceNumber(Integer.valueOf(this.table.getRowCount()));
        nDto.setCabinClass(settings.getDefaultAdditionalCabinClass());
        nDto.setLabelColor(settings.getDefaultAdditionalLabelColor());
        nDto.setPrintSingleLabels(Boolean.valueOf(Boolean.TRUE.equals(settings.getPrintAdditionalOnSeparateLabel())));
        nDto.setExpiryDate(FlightToolkit.createAdditionalExpiryDate((SystemSettingsComplete)settings, (FlightLight)((FlightLight)this.root.getValue(FlightComplete.class)), null));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)nDto, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        if (Boolean.FALSE.equals(settings.getSortFlightAdditionalsBySequence())) {
            this.ensureSequenceNo();
        }
    }

    @Override
    public void childRemoved() {
        this.ensureSequenceNo();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowEditor rowPanel = new TableRowEditor(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    private void ensureSequenceNo() {
        int count = 0;
        for (Table2RowPanel table2RowPanel : this.table.getRows()) {
            table2RowPanel.getModel().getNode().getChildNamed(AdditionalOrderComplete_.sequenceNumber).setValue((Object)count, 0L);
            ++count;
        }
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        this.isDeletable = this.provider.isDeletable(FlightComplete_.additionalOrders);
        this.root = node;
        if (this.root != null) {
            Node additionalOrders = this.root.getChildNamed(FlightComplete_.additionalOrders);
            this.table.getModel().setNode(additionalOrders);
        } else {
            this.table.getModel().setNode(null);
        }
        super.setNode(node);
    }

    @Override
    public void setValid(boolean valid) {
        this.table.enableAddButton(valid);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            for (Table2RowPanel rowPanel : this.table.getRows()) {
                TableRowEditor rowPanelImpl = (TableRowEditor)rowPanel;
                List<ScreenValidationObject> warnings = rowPanelImpl.validateRow();
                if (warnings == null) {
                    rowPanelImpl.setValid();
                    continue;
                }
                rowPanelImpl.setInvalid();
                validationObjects.addAll(warnings);
            }
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean editFlight = this.checker.canEditFlight(this.root, this.provider, isEnabled);
        super.setEnabled(editFlight);
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
    }

    @Override
    public boolean isInnerComponent(Component c) {
        for (Table2RowPanel rowPanel : this.table.getRows()) {
            TableRowEditor rowEditor = (TableRowEditor)rowPanel;
            if (!rowEditor.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.table.getModel().addFocusCycleChangeListener(listener);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public boolean hasExpandableContent() {
        return true;
    }

    private class TableRowEditor
    extends Table2RowPanel
    implements NodeListener,
    LafListener,
    ButtonListener,
    SearchTextField2Listener {
        private static final long serialVersionUID = 1L;
        private RDSearchTextField2<ProductComplete> additional;
        private RDTextField count;
        private RDTextField paxName;
        private RDDateChooser expiryDate;
        private DeleteButton delete;

        public TableRowEditor(Table2RowModel m) {
            super(m);
            this.setLayout(new TableRowEditorLayout());
            m.getNode().addNodeListener((NodeListener)this);
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.product));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.quantity));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.passengerName));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.expiryDate));
            if (this.count.getEditor() != null) {
                ((TextField)this.count.getEditor()).addActionListener(e -> ProductsDetailsPanel.this.table.getAddButton().requestFocusInWindowNow());
            }
            this.lafAttributeChanged("All attribues changed");
            if (ProductsDetailsPanel.this.isDeletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
                this.delete.fadeIn();
            }
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.additional != null) {
                this.additional.requestFocusInWindowNow();
            }
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    if (this.additional.getEditor() != null) {
                        return ((SearchTextField2)this.additional.getEditor()).getText();
                    }
                    if (this.additional.getRenderer() != null) {
                        return ((TextLabel)this.additional.getRenderer()).getText();
                    }
                    return "";
                }
                case 1: {
                    return this.count.getStringValue();
                }
                case 2: {
                    return this.paxName.getStringValue();
                }
                case 3: {
                    return this.expiryDate.getStringValue();
                }
            }
            return null;
        }

        public void setInvalid() {
        }

        public void setValid() {
            this.additional.setValid();
        }

        public List<ScreenValidationObject> validateRow() {
            ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
            if (this.model.getNode().getChildNamed(AdditionalOrderComplete_.product).getValue() == null) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_PRODUCT_IS_SET));
                this.additional.setInvalid();
            } else {
                this.additional.setValid();
            }
            Integer i = (Integer)this.model.getNode().getChildNamed(AdditionalOrderComplete_.quantity).getValue();
            if (i == null) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.COUNT_MUST_BE_GREATER_THAN_O_OR_REMOVED));
                this.count.setInvalid();
            } else {
                this.count.setValid();
            }
            return validationObjects;
        }

        public void childAdded(Node<?> source, Node<?> child) {
            if (child.getName().equals(AdditionalOrderComplete_.product.getFieldName())) {
                Node<?> node = child;
                this.additional = new RDSearchTextField2(ProductsDetailsPanel.this.provider, RDSearchTextField2.SearchTypes.PRODUCT);
                this.additional.setConverter(ConverterRegistry.getConverter(ProductCustomerNumberViewConverter.class));
                this.additional.setNode(node);
                this.additional.addSearchTextFieldListener(this);
                if (this.additional.getEditor() != null) {
                    Date endDate = new Date(((Timestamp)ProductsDetailsPanel.this.root.getChildNamed(FlightLight_.sta).getValue()).getTime());
                    Date startDate = new Date(((Timestamp)ProductsDetailsPanel.this.root.getChildNamed(FlightLight_.std).getValue()).getTime());
                    CustomerLight customer = (CustomerLight)ProductsDetailsPanel.this.root.getChildNamed(FlightLight_.customer).getValue();
                    if (customer == null) {
                        customer = ((FlightComplete)ProductsDetailsPanel.this.root.getValue()).getCustomer();
                    }
                    Object[] o = new Object[]{startDate, endDate, customer};
                    ((SearchTextField2)this.additional.getEditor()).setAdditionalSearchField(o);
                }
                ProductComplete p = (ProductComplete)node.getValue();
                this.updateInfoButton(p);
                this.add(this.additional);
                this.additional.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.quantity.getFieldName())) {
                this.count = new RDTextField(ProductsDetailsPanel.this.provider, TextFieldType.INT);
                this.count.setNode(child);
                this.add(this.count);
                this.count.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.passengerName.getFieldName())) {
                this.paxName = new RDTextField(ProductsDetailsPanel.this.provider);
                this.paxName.setNode(child);
                this.add(this.paxName);
                this.paxName.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.expiryDate.getFieldName())) {
                this.expiryDate = new RDDateChooser(ProductsDetailsPanel.this.provider);
                this.expiryDate.setNode(child);
                this.add(this.expiryDate);
                this.expiryDate.fadeIn();
            }
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void valueChanged(Node<?> node) {
        }

        @Override
        public void lafAttributeChanged(String att) {
            Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            if (this.count != null) {
                this.count.setFont(f);
            }
            if (this.paxName != null) {
                this.paxName.setFont(f);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getParentModel().getNode().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.additional);
            CheckedListAdder.addToList(focusList, this.count);
            CheckedListAdder.addToList(focusList, this.paxName);
            CheckedListAdder.addToList(focusList, this.expiryDate);
            if (this.delete != null) {
                CheckedListAdder.addToList(focusList, this.delete);
            }
            return focusList;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            Node p;
            boolean enableAndReady = isEnabled;
            if (this.model.getNode() != null && (p = this.model.getNode().getChildNamed(AdditionalOrderComplete_.product)) != null) {
                enableAndReady = enableAndReady && p.getValue() != null;
            }
            this.additional.setEnabled(isEnabled);
            this.count.setEnabled(enableAndReady);
            this.paxName.setEnabled(enableAndReady);
            this.expiryDate.setEnabled(enableAndReady);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.additional.kill();
            this.count.kill();
            this.paxName.kill();
            this.expiryDate.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            this.additional = null;
            this.count = null;
            this.paxName = null;
            this.expiryDate = null;
            this.delete = null;
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) {
            this.setEnabled(this.isEnabled());
            if (n.getValue() != null) {
                this.updateInfoButton((ProductComplete)n.getValue());
                this.updateExpiryDate((ProductComplete)n.getValue());
            }
            ProductsDetailsPanel.this.editor.createFocusCycle();
            this.count.requestFocusInWindowNow();
        }

        private void updateInfoButton(ProductComplete p) {
            if (p != null) {
                // empty if block
            }
        }

        private void updateExpiryDate(ProductComplete p) {
            Date additionalExpiryDate = FlightToolkit.createAdditionalExpiryDate((SystemSettingsComplete)ProductsDetailsPanel.this.settings, (FlightLight)((FlightLight)ProductsDetailsPanel.this.editor.getModel().getTypeSafeNode().getValue()), (ProductComplete)p);
            this.model.getNode().getChildNamed(AdditionalOrderComplete_.expiryDate).setValue((Object)additionalExpiryDate, 0L);
        }

        private class TableRowEditorLayout
        extends DefaultLayout {
            private TableRowEditorLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int h = parent.getHeight();
                int w = TableRowEditor.this.model.getParentModel().getColumnWidth(0);
                TableRowEditor.this.additional.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.additional.getPreferredSize().getHeight()) / 2.0));
                TableRowEditor.this.additional.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.additional.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowEditor.this.model.getParentModel().getColumnWidth(1);
                TableRowEditor.this.count.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowEditor.this.count.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.count.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowEditor.this.model.getParentModel().getColumnWidth(2);
                TableRowEditor.this.paxName.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.paxName.getPreferredSize().getHeight()) / 2.0));
                TableRowEditor.this.paxName.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.paxName.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowEditor.this.model.getParentModel().getColumnWidth(3);
                TableRowEditor.this.expiryDate.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.expiryDate.getPreferredSize().getHeight()) / 2.0));
                TableRowEditor.this.expiryDate.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.expiryDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowEditor.this.model.getParentModel().getColumnWidth(4);
                TableRowEditor.this.setControlsX(currentX);
                if (TableRowEditor.this.delete != null) {
                    TableRowEditor.this.delete.setLocation((int)((double)currentX + ((double)w - TableRowEditor.this.delete.getPreferredSize().getWidth()) / 2.0), (int)(((double)h - TableRowEditor.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowEditor.this.delete.setSize((int)TableRowEditor.this.delete.getPreferredSize().getWidth(), (int)TableRowEditor.this.delete.getPreferredSize().getHeight());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowEditor.this.getDefaultRowHeight());
            }
        }
    }
}

