/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.details;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.util.VariantLight;
import ch.icit.pegasus.server.core.dtos.util.VariantMasterLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AVariantTemplateDetailsPanel<T extends IDTO, V extends VariantLight>
extends DefaultDetailsPanel<T>
implements SearchTextField2Listener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2<T>> searchField;
    private TitledItem<CheckBox> copyAllVariants;
    private TitledItem<ComboBox> variantSelectionBox;
    private TextButton copyButton;
    private static final int STATE_RELOADING = 3;
    private static final int STATE_PERIST = 5;
    private static final int STATE_COPIED = 7;
    private int currentState = 3;
    private Node currentNode;

    public AVariantTemplateDetailsPanel(RowEditor<T> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.TEMPLATE);
        this.searchField = new TitledItem<SearchTextField2<SearchTextField2<T>>>(this.createSearchField(), this.getSearchFieldTitle(), TitledItem.TitledItemOrientation.NORTH);
        this.searchField.getElement().addSearchTextFieldListener(this);
        this.variantSelectionBox = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, this.getVariantViewConverter()), Words.VARIANTS, TitledItem.TitledItemOrientation.NORTH);
        this.variantSelectionBox.getElement().setIgnoreSorting(true);
        this.copyButton = new TextButton(Words.COPY);
        this.copyButton.addButtonListener(this);
        this.copyAllVariants = new TitledItem<CheckBox>(new CheckBox(), Words.COPY_ALL_VARIANTS, TitledItem.TitledItemOrientation.EAST);
        this.setCustomLayouter(new Layout());
        this.addToView(this.searchField);
        this.addToView(this.variantSelectionBox);
        this.addToView(this.copyAllVariants);
        this.addToView(this.copyButton);
    }

    public boolean isAccessible() {
        return true;
    }

    public abstract Converter<?, String> getVariantViewConverter();

    public abstract SearchTextField2<T> createSearchField();

    public abstract String getSearchFieldTitle();

    @Override
    public boolean grabsFocus() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.searchField.kill();
        this.variantSelectionBox.kill();
        this.copyButton.kill();
        this.copyAllVariants.kill();
        this.searchField = null;
        this.variantSelectionBox = null;
        this.copyButton = null;
        this.copyAllVariants = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean doit = this.isAccessible() && isEnabled;
        boolean selected = this.searchField.getElement().isItemSelected();
        super.setEnabled(doit);
        this.searchField.setEnabled(doit);
        this.variantSelectionBox.setEnabled(doit);
        this.copyButton.setEnabled(doit & selected);
        this.copyAllVariants.setEnabled(doit);
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setNode(Node<?> node) {
        this.currentNode = node;
        this.setEnabled(this.isEnabled());
    }

    private Node getNewestVariant(Node variantList) {
        if (variantList == null) {
            return null;
        }
        Iterator it = variantList.getFailSafeChildIterator();
        Node newst = null;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (newst == null) {
                newst = n;
                continue;
            }
            Date d1 = ((VariantLight)newst.getValue(VariantLight.class)).getValidityPeriod().getStartDate();
            Date d2 = ((VariantLight)n.getValue(VariantLight.class)).getValidityPeriod().getStartDate();
            if (d2.getTime() <= d1.getTime()) continue;
            newst = n;
        }
        return newst;
    }

    public abstract T reloadItem(T var1) throws ClientServerCallException;

    public abstract Class<T> getVariantMasterClass();

    public abstract List<V> reloadVariants(List<V> var1) throws ClientServerCallException;

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.copyButton) {
            this.doCopy();
        } else {
            super.buttonPressed(source, x, y);
        }
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        this.editor.setEnabled(false);
        this.currentState = 3;
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (AVariantTemplateDetailsPanel.this.searchField != null && ((SearchTextField2)AVariantTemplateDetailsPanel.this.searchField.getElement()).getNode() != null && ((SearchTextField2)AVariantTemplateDetailsPanel.this.searchField.getElement()).getNode().getValue() != null) {
                    IDTO l = (IDTO)((SearchTextField2)AVariantTemplateDetailsPanel.this.searchField.getElement()).getNode().getValue(AVariantTemplateDetailsPanel.this.getVariantMasterClass());
                    ((SearchTextField2)AVariantTemplateDetailsPanel.this.searchField.getElement()).getNode().setValue((Object)AVariantTemplateDetailsPanel.this.reloadItem(l), 0L);
                    List rv = AVariantTemplateDetailsPanel.this.reloadVariants((List)((SearchTextField2)AVariantTemplateDetailsPanel.this.searchField.getElement()).getNode().getChildNamed(new String[]{"variants"}).getValue());
                    ArrayList refs = new ArrayList();
                    refs.addAll(rv);
                    Node node = ((SearchTextField2)AVariantTemplateDetailsPanel.this.searchField.getElement()).getNode().getChildNamed(new String[]{"variants"});
                    ((SearchTextField2)AVariantTemplateDetailsPanel.this.searchField.getElement()).getNode().getChildNamed(new String[]{"variants"}).removeExistingValues();
                    ((VariantMasterLight)((ProxyNode)((SearchTextField2)AVariantTemplateDetailsPanel.this.searchField.getElement()).getNode()).getRefNode().getValue()).setVariants(refs);
                    node.setValue(rv, 0L);
                    node.updateNode();
                    for (VariantLight v : rv) {
                        Node q = INodeCreator.getDefaultImpl().getNode4DTO((Object)v, true, false);
                        ((SearchTextField2)AVariantTemplateDetailsPanel.this.searchField.getElement()).getNode().getChildNamed(new String[]{"variants"}).addChild(q, 0L);
                    }
                    return ((SearchTextField2)AVariantTemplateDetailsPanel.this.searchField.getElement()).getNode();
                }
                ViewNode r = new ViewNode("Error");
                r.setValue((Object)new ClientGetFromServerException(""), 0L);
                return r;
            }

            @Override
            public RemoteLoader getInvoker() {
                return AVariantTemplateDetailsPanel.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.searchField);
        return a;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.currentState == 5) {
            this.editor.getModel().getParentModel().getNode().addChild(node, 0L);
            this.editor.setEnabled(true);
            this.editor.hideCommittingAnimation();
        } else if (this.currentState == 3) {
            ViewNode nn = new ViewNode("");
            if (node != null) {
                if (node.getChildNamed(new String[]{"variants"}) != null) {
                    Iterator it = node.getChildNamed(new String[]{"variants"}).getChilds();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        nn.addChild(n, 0L);
                    }
                }
                this.variantSelectionBox.getElement().refreshPossibleValues((Node)nn);
                Node selectedNode = this.getNewestVariant(node.getChildNamed(new String[]{"variants"}));
                if (selectedNode != null && !this.variantSelectionBox.getElement().getSelectedItem().equals(selectedNode)) {
                    this.variantSelectionBox.getElement().setSelectedItem(selectedNode);
                }
            }
            this.editor.setEnabled(true);
            this.editor.hideCommittingAnimation();
            this.invalidate();
        } else if (this.currentState == 7) {
            this.editor.getModel().getNode().removeExistingValues();
            this.editor.getModel().getNode().removeAllChilds();
            this.editor.getModel().getNode().setValue(node.getValue(this.getVariantMasterClass()), 0L);
            this.editor.getModel().getNode().updateNode();
            Iterator it = this.editor.getModel().getNode().getChildNamed(new String[]{"variants"}).getChilds();
            while (it.hasNext()) {
                it.next();
            }
            this.editor.setNode(this.editor.getModel().getNode());
            this.editor.setEnabled(true);
            this.editor.hideCommittingAnimation();
            this.invalidate();
        }
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public abstract T copyItem(T var1, V var2, boolean var3, boolean var4) throws ClientServerCallException;

    public abstract Class<V> getVariantClass();

    public abstract void initNewVariant(T var1);

    private void doCopy() {
        this.currentState = 7;
        this.editor.setEnabled(false);
        this.editor.showCommittingAnimation("Copy Product from Template");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node v = (Node)((ComboBox)AVariantTemplateDetailsPanel.this.variantSelectionBox.getElement()).getSelectedItem();
                IDTO l = (IDTO)((SearchTextField2)AVariantTemplateDetailsPanel.this.searchField.getElement()).getNode().getValue(AVariantTemplateDetailsPanel.this.getVariantMasterClass());
                IDTO np = AVariantTemplateDetailsPanel.this.copyItem(l, (VariantLight)v.getValue(AVariantTemplateDetailsPanel.this.getVariantClass()), false, ((CheckBox)AVariantTemplateDetailsPanel.this.copyAllVariants.getElement()).isChecked());
                AVariantTemplateDetailsPanel.this.initNewVariant(np);
                ViewNode nn = new ViewNode("Return");
                nn.setValue((Object)np, 0L);
                return nn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return AVariantTemplateDetailsPanel.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            AVariantTemplateDetailsPanel.this.searchField.setLocation(AVariantTemplateDetailsPanel.this.horizontalBorder, AVariantTemplateDetailsPanel.this.verticalBorder);
            AVariantTemplateDetailsPanel.this.searchField.setSize((int)((double)parent.getWidth() - ((double)AVariantTemplateDetailsPanel.this.inner_horizontalBorder + AVariantTemplateDetailsPanel.this.copyAllVariants.getPreferredSize().getWidth() + (double)AVariantTemplateDetailsPanel.this.horizontalBorder + AVariantTemplateDetailsPanel.this.copyButton.getPreferredSize().getWidth() + (double)(2 * AVariantTemplateDetailsPanel.this.horizontalBorder))), (int)AVariantTemplateDetailsPanel.this.searchField.getPreferredSize().getHeight());
            AVariantTemplateDetailsPanel.this.copyAllVariants.setLocation(AVariantTemplateDetailsPanel.this.searchField.getX() + AVariantTemplateDetailsPanel.this.searchField.getWidth() + AVariantTemplateDetailsPanel.this.inner_horizontalBorder, (int)((double)(AVariantTemplateDetailsPanel.this.searchField.getY() + AVariantTemplateDetailsPanel.this.searchField.getHeight()) - (((SearchTextField2)AVariantTemplateDetailsPanel.this.searchField.getElement()).getPreferredSize().getHeight() + AVariantTemplateDetailsPanel.this.copyAllVariants.getPreferredSize().getHeight()) / 2.0));
            AVariantTemplateDetailsPanel.this.copyAllVariants.setSize(AVariantTemplateDetailsPanel.this.copyAllVariants.getPreferredSize());
            AVariantTemplateDetailsPanel.this.copyButton.setLocation(AVariantTemplateDetailsPanel.this.copyAllVariants.getX() + AVariantTemplateDetailsPanel.this.copyAllVariants.getWidth() + AVariantTemplateDetailsPanel.this.horizontalBorder, (int)((double)(AVariantTemplateDetailsPanel.this.searchField.getY() + AVariantTemplateDetailsPanel.this.searchField.getHeight()) - AVariantTemplateDetailsPanel.this.copyButton.getPreferredSize().getHeight()));
            AVariantTemplateDetailsPanel.this.copyButton.setSize(AVariantTemplateDetailsPanel.this.copyButton.getPreferredSize());
            AVariantTemplateDetailsPanel.this.variantSelectionBox.setLocation(AVariantTemplateDetailsPanel.this.horizontalBorder, AVariantTemplateDetailsPanel.this.searchField.getY() + AVariantTemplateDetailsPanel.this.searchField.getHeight() + AVariantTemplateDetailsPanel.this.verticalBorder);
            AVariantTemplateDetailsPanel.this.variantSelectionBox.setSize(parent.getWidth() - (AVariantTemplateDetailsPanel.this.copyButton.getWidth() + 3 * AVariantTemplateDetailsPanel.this.horizontalBorder), (int)AVariantTemplateDetailsPanel.this.variantSelectionBox.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = AVariantTemplateDetailsPanel.this.verticalBorder;
            h = (int)((double)h + AVariantTemplateDetailsPanel.this.searchField.getPreferredSize().getHeight());
            h += AVariantTemplateDetailsPanel.this.verticalBorder;
            h = (int)((double)h + AVariantTemplateDetailsPanel.this.variantSelectionBox.getPreferredSize().getHeight());
            return new Dimension(0, h += AVariantTemplateDetailsPanel.this.verticalBorder);
        }
    }
}

