/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.delete;

import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.GenericServiceManager;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.notification.ChangeNotificationServiceManager;
import ch.icit.pegasus.client.services.interfaces.quality.QualityServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.ArticleStockSwapServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.ArticleSwapServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationReference;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102ConfigComplete;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.swap.ArticleSwapDataImportLight;
import ch.icit.pegasus.server.core.dtos.swap.ArticleSwapDataImportReference;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportLight;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportReference;
import ch.icit.pegasus.server.core.dtos.system.ADeletableDTO;
import ch.icit.pegasus.server.core.dtos.system.APermanentDeletableDTO;
import ch.icit.pegasus.server.core.dtos.system.IPermanentDeletableDTO;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.IPermanentDeletableDTOWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ActionDeleteComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private MultiLineTextLabel field;
    private Node node;
    private TitledItem<DateChooser> endDate;
    private CheckBox useEndDate;

    public ActionDeleteComponent(Node node, RowModel mode) {
        super(false, false);
        this.node = node;
        this.getViewContainer().setLayout(new Layout());
        this.field = new MultiLineTextLabel(Words.DELETE_SELECTED_ITEM);
        if (node.getValue() instanceof ProductComplete) {
            this.useEndDate = new CheckBox();
            this.useEndDate.addButtonListener((source, x, y) -> this.endDate.setEnabled(this.useEndDate.isChecked()));
            this.endDate = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), "Change End Date to", TitledItem.TitledItemOrientation.NORTH);
            this.endDate.setEnabled(false);
            this.getViewContainer().add(this.useEndDate);
            this.getViewContainer().add(this.endDate);
        }
        this.getViewContainer().add(this.field);
    }

    @Override
    protected String getProgressText() {
        return Words.DELETE_ITEM;
    }

    @Override
    protected String getFinishedText() {
        return Words.ITEM_DELETED;
    }

    @Override
    protected void startPrinting() {
        this.startPrinting2();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (ActionDeleteComponent.this.node != null) {
                    if (ActionDeleteComponent.this.node.getValue() instanceof InvoiceReference) {
                        ((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).delete((InvoiceReference)ActionDeleteComponent.this.node.getValue());
                    } else if (ActionDeleteComponent.this.node.getValue() instanceof APermanentDeletableDTO) {
                        ((GenericServiceManager)ServiceManagerRegistry.getService(GenericServiceManager.class)).deletePermanently(new IPermanentDeletableDTOWrapper((IPermanentDeletableDTO)((APermanentDeletableDTO)ActionDeleteComponent.this.node.getValue())));
                    } else if (ActionDeleteComponent.this.node.getValue() instanceof RetailInMotionDataImportReference) {
                        ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).deleteRetailInMotionData((RetailInMotionDataImportReference)ActionDeleteComponent.this.node.getValue());
                    } else if (ActionDeleteComponent.this.node.getValue() instanceof ChangeNotificationReference) {
                        ((ChangeNotificationServiceManager)ServiceManagerRegistry.getService(ChangeNotificationServiceManager.class)).deleteChangeNotification((ChangeNotificationReference)ActionDeleteComponent.this.node.getValue());
                    } else if (ActionDeleteComponent.this.node.getValue() instanceof ArticleSwapDataImportLight) {
                        ((ArticleSwapServiceManager)ServiceManagerRegistry.getService(ArticleSwapServiceManager.class)).deleteArticleSwapData((ArticleSwapDataImportReference)ActionDeleteComponent.this.node.getValue());
                    } else if (ActionDeleteComponent.this.node.getValue() instanceof ArticleStockSwapDataImportLight) {
                        ((ArticleStockSwapServiceManager)ServiceManagerRegistry.getService(ArticleStockSwapServiceManager.class)).deleteArticleStockSwapData((ArticleStockSwapDataImportReference)((ArticleStockSwapDataImportLight)ActionDeleteComponent.this.node.getValue()));
                    } else if (ActionDeleteComponent.this.node.getValue() instanceof WeeklyPlanLight) {
                        ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).deleteWeeklyPlan((WeeklyPlanLight)ActionDeleteComponent.this.node.getValue());
                    } else if (ActionDeleteComponent.this.node.getValue() instanceof CCP0102ConfigComplete) {
                        ((QualityServiceManager)ServiceManagerRegistry.getService(QualityServiceManager.class)).deleteCCP0102Config((CCP0102ConfigComplete)ActionDeleteComponent.this.node.getValue());
                    } else {
                        ADeletableDTO dDto = (ADeletableDTO)ActionDeleteComponent.this.node.getValue();
                        if (!dDto.getIsDeleted().booleanValue()) {
                            if (dDto instanceof BasicArticleLight) {
                                ((BasicArticleLight)dDto).setIsInUse(Boolean.valueOf(false));
                                ((BasicArticleLight)dDto).setCanCreateTransactions(Boolean.valueOf(false));
                                dDto = (ADeletableDTO)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateBasicArticleLight((BasicArticleLight)dDto).getValue();
                            }
                            if (ActionDeleteComponent.this.useEndDate != null && ActionDeleteComponent.this.useEndDate.isChecked()) {
                                Date date = (Date)((DateChooser)ActionDeleteComponent.this.endDate.getElement()).getNode().getValue();
                                if (dDto instanceof ProductComplete) {
                                    ProductComplete product = (ProductComplete)dDto;
                                    List variants = ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantsByReferences(new ListWrapper(product.getVariants())).getList();
                                    ArrayList<ProductVariantLight> productiveVariants = new ArrayList<ProductVariantLight>();
                                    ArrayList<ProductVariantLight> tenderVariants = new ArrayList<ProductVariantLight>();
                                    Collections.sort(variants);
                                    for (ProductVariantLight variant : variants) {
                                        if (variant.getValidityPeriod().getStartDate().after(date)) {
                                            throw new ClientActionOnServerException("Unable to set new end date. Variant with start date after new end date found");
                                        }
                                        if (Boolean.TRUE.equals(variant.getTenderVariant())) {
                                            tenderVariants.add(variant);
                                            continue;
                                        }
                                        productiveVariants.add(variant);
                                    }
                                    product.setPeriod(new PeriodComplete(product.getPeriod().getStartDate(), date));
                                    Collections.sort(productiveVariants);
                                    Collections.sort(tenderVariants);
                                    ProductVariantLight lastVariant = (ProductVariantLight)productiveVariants.get(productiveVariants.size() - 1);
                                    lastVariant.setValidityPeriod(new PeriodComplete(lastVariant.getValidityPeriod().getStartDate(), date));
                                    if (!tenderVariants.isEmpty()) {
                                        lastVariant = (ProductVariantLight)tenderVariants.get(tenderVariants.size() - 1);
                                        lastVariant.setValidityPeriod(new PeriodComplete(lastVariant.getValidityPeriod().getStartDate(), date));
                                    }
                                    product.getVariants().clear();
                                    product.getVariants().addAll(productiveVariants);
                                    product.getVariants().addAll(tenderVariants);
                                    ProductComplete productComplete = (ProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateProduct(product).getValue();
                                    dDto = productComplete;
                                }
                            }
                            ((GenericServiceManager)ServiceManagerRegistry.getService(GenericServiceManager.class)).delete(dDto);
                        }
                    }
                    if (ActionDeleteComponent.this.node.getParent() != null) {
                        ActionDeleteComponent.this.node.getParent().removeChild(ActionDeleteComponent.this.node, 0L);
                    }
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionDeleteComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.field.setVisible(false);
        if (this.useEndDate != null) {
            this.useEndDate.setVisible(false);
            this.endDate.setVisible(false);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        return super.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleString() {
        return "";
    }

    @Override
    public String getTitleValue() {
        return "";
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, ActionDeleteComponent.this.getInheritedComponentsHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ActionDeleteComponent.this.layoutInheritedComponents(parent);
            int additionalHeight = 0;
            if (ActionDeleteComponent.this.useEndDate != null) {
                additionalHeight = (int)(ActionDeleteComponent.this.endDate.getPreferredSize().getHeight() + (double)(ActionDeleteComponent.this.border * 2));
            }
            ActionDeleteComponent.this.field.setLocation(0, 0);
            ActionDeleteComponent.this.field.setSize(parent.getWidth(), parent.getHeight() - additionalHeight);
            if (ActionDeleteComponent.this.useEndDate != null) {
                ActionDeleteComponent.this.useEndDate.setLocation(0, ActionDeleteComponent.this.field.getY() + ActionDeleteComponent.this.field.getHeight() + ActionDeleteComponent.this.border + 23);
                ActionDeleteComponent.this.useEndDate.setSize(ActionDeleteComponent.this.useEndDate.getPreferredSize());
                ActionDeleteComponent.this.endDate.setLocation(ActionDeleteComponent.this.useEndDate.getX() + ActionDeleteComponent.this.useEndDate.getWidth() + ActionDeleteComponent.this.border, ActionDeleteComponent.this.field.getY() + ActionDeleteComponent.this.field.getHeight() + ActionDeleteComponent.this.border);
                ActionDeleteComponent.this.endDate.setSize(ActionDeleteComponent.this.endDate.getPreferredSize());
            }
        }
    }
}

