/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.article.remote_new.customs.inventory;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AsynchronusAnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateTimeChooserAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateTimePeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.article.CustomsInventoryAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Timestamp;

public class CustomsInventoryAnalysisComponent
extends AsynchronusAnalysisPopupInsert<BasicArticleLight> {
    private static final long serialVersionUID = 1L;
    private TitledDateTimePeriodChooser period;
    private TitledItem<DateTimeChooser> ignoreTransactionsBefore;
    private TitledItem<CheckBox> includeTransactionSheets;
    private TitledItem<CheckBox> includeIrregularities;
    private TitledItem<CheckBox> useFloatStores;

    public CustomsInventoryAnalysisComponent(AnalysisSmartExternalOpenTool<BasicArticleLight> subProv) {
        super(subProv);
    }

    @Override
    public void addOptionItems() {
        TimestampPeriodComplete p = new TimestampPeriodComplete();
        p.setStartTime(new Timestamp(System.currentTimeMillis()));
        p.setEndTime(new Timestamp(System.currentTimeMillis()));
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        this.period = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false));
        this.ignoreTransactionsBefore = new TitledItem<DateTimeChooser>(new DateTimeChooser((Node<Timestamp>)INodeCreator.getDefaultImpl().getNode4DTO((Object)ts, false, false)), Words.IGNORE_TRANSACTIONS_BEFORE, TitledItem.TitledItemOrientation.NORTH);
        this.includeIrregularities = new TitledItem<CheckBox>(new CheckBox(), "Include Irregularities", TitledItem.TitledItemOrientation.EAST);
        this.useFloatStores = new TitledItem<CheckBox>(new CheckBox(), "Use Float Store", TitledItem.TitledItemOrientation.EAST);
        this.includeTransactionSheets = new TitledItem<CheckBox>(new CheckBox(), "Include Transactions Sheets", TitledItem.TitledItemOrientation.EAST);
        this.includeTransactionSheets.getElement().setChecked(true);
        this.addOptionsItem(new DateTimePeriodEditorAnalysisItem(this.period, "period"));
        this.addOptionsItem(new DateTimeChooserAnalysisItem(this.ignoreTransactionsBefore, "ignoreTransactionsBefore"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeIrregularities, "includeIrregularities"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeTransactionSheets, "includeTransactionSheets"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.useFloatStores, "useFloatStores"));
    }

    @Override
    protected boolean includeCSVExportFormat() {
        return false;
    }

    @Override
    protected boolean includePDFExportFormat() {
        return false;
    }

    @Override
    public boolean chooseExportFormat() {
        return false;
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        CustomsInventoryAnalysisReportConfiguration conf = new CustomsInventoryAnalysisReportConfiguration();
        TimestampPeriodComplete p = this.period.getTimePeriod();
        conf.setPeriodStartDate(p.getStartTime());
        conf.setPeriodEndDate(p.getEndTime());
        Timestamp ts = this.ignoreTransactionsBefore.getElement().getTimestamp();
        conf.setIgnoreTransactionsBefore(ts);
        conf.setIncludeIrregularities(Boolean.valueOf(this.includeIrregularities.getElement().isChecked()));
        conf.setIncludeTransactionSheets(Boolean.valueOf(this.includeTransactionSheets.getElement().isChecked()));
        conf.setUseFloatStore(Boolean.valueOf(this.useFloatStores.getElement().isChecked()));
        return conf;
    }
}

