/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.article.remote_new.customs.stock;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AsynchronusAnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateTimeChooserAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.SearchTextField2AnalysisItem;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.article.CustomsStockAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;

public class CustomsStockAnalysisComponent
extends AsynchronusAnalysisPopupInsert<BasicArticleLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> includeCosts;
    private TitledItem<CheckBox> hideZeroStock;
    private TitledItem<CheckBox> splitByCharge;
    private TitledItem<CheckBox> includeChargeCreationTransaction;
    private TitledItem<DateTimeChooser> dueDateStore;
    private TitledItem<CheckBox> includeTransactionSheet;
    private TitledItem<CheckBox> includeIrregularities;
    private TitledItem<CheckBox> deactivateRequisitionPreparation;
    private TitledItem<CheckBox> deactivateRequisitionAcceptance;
    private TitledItem<CheckBox> onlyMainStores;
    private TitledItem<CheckBox> showOnlyInDocs;
    private TitledItem<SearchTextField2<StoreLight>> storeSearch;

    public CustomsStockAnalysisComponent(AnalysisSmartExternalOpenTool<BasicArticleLight> subProv) {
        super(subProv);
    }

    @Override
    public void addOptionItems() {
        this.hideZeroStock = new TitledItem<CheckBox>(new CheckBox(), "Hide zero Stocks", TitledItem.TitledItemOrientation.EAST);
        this.includeCosts = new TitledItem<CheckBox>(new CheckBox(), "Include Price", TitledItem.TitledItemOrientation.EAST);
        this.splitByCharge = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CHARGE, TitledItem.TitledItemOrientation.EAST);
        this.includeChargeCreationTransaction = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CHARGE_CREATION_TRANSACTION, TitledItem.TitledItemOrientation.EAST);
        this.dueDateStore = new TitledItem<DateTimeChooser>(new DateTimeChooser((Node<Timestamp>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new Timestamp(System.currentTimeMillis()), false, false)), Words.DUE_DATE_STORE, TitledItem.TitledItemOrientation.NORTH);
        this.includeTransactionSheet = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_TRANSACTION_SHEET + " (includes transactions from due date - now)", TitledItem.TitledItemOrientation.EAST);
        this.includeIrregularities = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_IRREGULARITIES_FLIGHT_RELEVANT, TitledItem.TitledItemOrientation.EAST);
        this.deactivateRequisitionPreparation = new TitledItem<CheckBox>(new CheckBox(), Words.DEACTIVATE_REQUISITION_PREPARATION, TitledItem.TitledItemOrientation.EAST);
        this.deactivateRequisitionAcceptance = new TitledItem<CheckBox>(new CheckBox(), Words.DEACTIVATE_REQUISITION_ACCEPTATION, TitledItem.TitledItemOrientation.EAST);
        this.onlyMainStores = new TitledItem<CheckBox>(new CheckBox(), Words.ONLY_MAIN_STORES, TitledItem.TitledItemOrientation.EAST);
        this.storeSearch = new TitledItem<SearchTextField2<StoreLight>>(SearchTextField2Factory.getStoreSearchField(true, new DTOProxyNode()), Words.STORE, TitledItem.TitledItemOrientation.NORTH);
        this.showOnlyInDocs = new TitledItem<CheckBox>(new CheckBox(), "Show Checkin Docs only", TitledItem.TitledItemOrientation.EAST);
        this.splitByCharge.getElement().addButtonListener((source, x, y) -> {
            boolean checked = this.splitByCharge.getElement().isChecked();
            if (!checked) {
                this.includeChargeCreationTransaction.getElement().setChecked(false);
            }
            this.includeChargeCreationTransaction.setEnabled(checked);
        });
        this.addOptionsItem(new DateTimeChooserAnalysisItem(this.dueDateStore, "dueDateStore"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeCosts, "includeCosts"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.hideZeroStock, "zeroStock"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.splitByCharge, "spitByCharge"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeChargeCreationTransaction, "includeChargeCreationTransaction"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeTransactionSheet, "includeTransactionSheet"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeIrregularities, "includeIrregularities"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.deactivateRequisitionPreparation, "deactivateRequisitionPreparation"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.deactivateRequisitionAcceptance, "deactivateRequisitionAcceptance"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.onlyMainStores, "onlyMainStores"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.showOnlyInDocs, "showInDocsOnly"));
        this.addOptionsItem(new SearchTextField2AnalysisItem(this.storeSearch, "store"));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.includeTransactionSheet.setEnabled(false);
        this.includeIrregularities.setEnabled(false);
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        CustomsStockAnalysisReportConfiguration conf = new CustomsStockAnalysisReportConfiguration();
        conf.setHideZeroStock(this.hideZeroStock.getElement().isChecked());
        conf.setIncludeCosts(this.includeCosts.getElement().isChecked());
        if (this.dueDateStore.getElement().getNode().getValue() instanceof Timestamp) {
            Timestamp ts = (Timestamp)this.dueDateStore.getElement().getNode().getValue();
            conf.setDueDateStore(new Date(ts.getTime()));
        } else if (this.dueDateStore.getElement().getNode().getValue() instanceof Date) {
            conf.setDueDateStore((Date)this.dueDateStore.getElement().getNode().getValue());
        }
        conf.setSplitByCharge(this.splitByCharge.getElement().isChecked());
        conf.setIncludeChargeCreationTransaction(this.includeChargeCreationTransaction.getElement().isChecked());
        conf.setIncludeTransactionSheet(this.includeTransactionSheet.getElement().isChecked());
        conf.setIncludeIrrgularities(this.includeIrregularities.getElement().isChecked());
        conf.setDeactivateRequisitionPreparation(this.deactivateRequisitionPreparation.getElement().isChecked());
        conf.setDeactivateRequisitionAcceptation(this.deactivateRequisitionAcceptance.getElement().isChecked());
        conf.setOnlyMainStores(this.onlyMainStores.getElement().isChecked());
        conf.setStore((StoreLight)this.storeSearch.getElement().getNode().getValue());
        conf.setOnlyCheckinDocs(this.showOnlyInDocs.getElement().isChecked());
        return conf;
    }
}

