/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.aishistory;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.List;

public class AnalysisAISHistoryComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> includeAIS;
    private TitledItem<CheckBox> aisGrouped;
    private TitledItem<CheckBox> includeErrorLog;
    private TitledItem<CheckBox> includeDeliverySlip;

    public AnalysisAISHistoryComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.includeAIS = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_INFO_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeAIS.getElement().addButtonListener(this);
        this.aisGrouped = new TitledItem<CheckBox>(new CheckBox(), Words.GROUPED, TitledItem.TitledItemOrientation.EAST);
        this.includeErrorLog = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ERROR_LOG, TitledItem.TitledItemOrientation.EAST);
        this.includeDeliverySlip = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_DELIVERY_SLIP, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAIS, "ais"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.aisGrouped, "grouped"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeErrorLog, "log"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeDeliverySlip, "slip"));
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public String getTitleString() {
        return Words.ALLERGEN_HISTORY;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.includeAIS != null) {
            boolean checked = this.includeAIS.getElement().isChecked();
            checked = checked && enabled;
            this.includeAIS.setEnabled(enabled);
            this.aisGrouped.setEnabled(checked);
            this.includeDeliverySlip.setEnabled(enabled);
        }
    }

    @Override
    public String getTitleValue() {
        return Words.FLIGHTS;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        if (item.getId() != null) {
            return new FlightReference(item.getId());
        }
        return null;
    }

    @Override
    public String getFileEnding() {
        return ".pdf";
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> screenValidationObjects = super.validateBeforePrint();
        if (!this.includeAIS.getElement().isChecked() && !this.includeErrorLog.getElement().isChecked()) {
            screenValidationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Include at least one Allergen Sheet type"));
        }
        return screenValidationObjects;
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        List references = this.loadItemReferences();
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).getAllergenSheetsCombinded(new ListWrapper(references), this.aisGrouped.getElement().isChecked(), this.includeAIS.getElement().isChecked(), this.includeErrorLog.getElement().isChecked(), this.includeDeliverySlip.getElement().isChecked()).getValue();
        return file;
    }
}

