/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.wagon.show;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AnalysisItem;
import ch.icit.pegasus.client.gui.utils.tables.WagonStockTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.WagonStockComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.awt.Component;
import java.util.List;

public class ShowWagonStockComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private WagonStockTable returnWagonTable;
    private Node<List<WagonStockComplete>> wagonNode;

    public ShowWagonStockComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis, false, false, false);
    }

    @Override
    public boolean loadDataBeforeShowing() {
        return true;
    }

    @Override
    public void addOptionItems() {
        this.returnWagonTable = new WagonStockTable();
        this.addOptionsItem(new AnalysisItem<WagonStockTable>(this.returnWagonTable, "Wagons"){

            @Override
            public Object getPersistValue() {
                return null;
            }

            @Override
            public void updatePersistValue(String newValue) {
            }
        });
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ListWrapper wagonStock = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getWagonStock();
                ShowWagonStockComponent.this.wagonNode = INodeCreator.getDefaultImpl().createNodes(wagonStock.getList(), false);
                return ShowWagonStockComponent.this.wagonNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ShowWagonStockComponent.this.returnWagonTable.setNode(ShowWagonStockComponent.this.wagonNode);
                        ShowWagonStockComponent.this.revalidate();
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)ShowWagonStockComponent.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.runInBackground(run);
    }

    @Override
    public String getTitleString() {
        return "Upload Return Wagons";
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        return null;
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        return null;
    }
}

