/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.inventory.remote.transition;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.SingleArticleCategoryConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.InventoryReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.InventoryDetailsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.InventoryDetailsReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AnalysisInventoryTransitionComponent
extends DefaultScrollablePrintPopup2<InventoryLight> {
    private static final long serialVersionUID = 1L;
    private Node<InventoryDetailsReportConfiguration> configNode;
    private TextLabel printOptionTitle;
    private TitledDateTimePeriodChooser timePeriodChooser;
    private TitledItem<ComboBox> bonded;
    private TitledItem<ComboBox> includeUnused;
    private TitledItem<ComboBox> includeDeleted;
    private TitledItem<ComboBox> includeNominated;
    private TitledItem<ComboBox> includeCustomerOwned;
    private TitledItem<ComboBox> includeArticleFromInventory;
    private TitledItem<CheckBox> includeCustomerData;
    private TitledItem<CheckBox> includeCustomsDocuments;
    private TitledItem<CheckBox> includePrices;
    private TitledItem<CheckBox> includeIrregularity;
    private TitledItem<CheckBox> includeUnCountedArticles;
    private TitledItem<CheckBox> includeStoreBasedData;
    private TitledItem<CheckBox> includeComment;
    private TitledItem<CheckBox> autoBoundary;
    private TitledItem<ComboBox> category;
    private TitledItem<ComboBox> group;
    private TitledItem<ComboBox> subGroup;
    private Table2 startInventories;
    private Table2 endInventories;

    public AnalysisInventoryTransitionComponent() {
        super(false, true, ReportTypeE.INVENTORY_TRANSITION_SHEET);
        InventoryDetailsReportConfiguration config = new InventoryDetailsReportConfiguration(null);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.autoBoundary.getElement()) {
            this.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.printOptionTitle = new TextLabel(Words.OPTIONS);
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        TimestampPeriodComplete p = new TimestampPeriodComplete();
        p.setStartTime(new Timestamp(System.currentTimeMillis()));
        p.setEndTime(new Timestamp(System.currentTimeMillis()));
        this.timePeriodChooser = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false));
        this.bonded = new TitledItem<ComboBox>(new ComboBox(this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.bonded), NodeToolkit.getAffixList(BondedStateE.class), ConverterRegistry.getConverter(BondedStateEConverter.class)), Words.INCLUDE_BONDED, TitledItem.TitledItemOrientation.NORTH);
        this.installTables();
        this.includeCustomerData = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.includeCustomerData)), Words.INCLUDE_CUSTOMER_DATA, TitledItem.TitledItemOrientation.EAST);
        this.includeCustomsDocuments = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.includeCustomsDocuments)), Words.INCLUDE_CUSTOMS_DOCS, TitledItem.TitledItemOrientation.EAST);
        this.includePrices = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.includePrices)), Words.INCLUDE_PRICES, TitledItem.TitledItemOrientation.EAST);
        this.includeIrregularity = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.includeIrregularity)), Words.INCLUDE_IRREGULARITY, TitledItem.TitledItemOrientation.EAST);
        this.includeUnCountedArticles = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.includeUnCountedArticles)), Words.EXPAND_WITH_ALL_ARTICLE, TitledItem.TitledItemOrientation.EAST);
        this.includeStoreBasedData = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.includeStoreBasedInfo)), Words.INCLUDE_STORE_BASED_INFO, TitledItem.TitledItemOrientation.EAST);
        this.autoBoundary = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.autoBoundary)), Words.AUTO_BOUNDARY, TitledItem.TitledItemOrientation.EAST);
        this.includeComment = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InventoryDetailsReportConfiguration_.includeComment)), Words.INCLUDE_COMMENT, TitledItem.TitledItemOrientation.EAST);
        this.includeArticleFromInventory = new TitledItem<ComboBox>(new ComboBox(), Words.INCLUDE_ARTICLE_FROM_INVENTORY, TitledItem.TitledItemOrientation.NORTH);
        this.includeArticleFromInventory.getElement().addItem(Words.ALL);
        this.includeArticleFromInventory.getElement().addItem(Words.START_INVENTORY);
        this.includeArticleFromInventory.getElement().addItem(Words.END_INVENTORY);
        this.includeArticleFromInventory.getElement().setSelectedItem(Words.ALL);
        this.includeArticleFromInventory.getElement().addItemListener(this);
        this.includeUnused = new TitledItem<ComboBox>(new ComboBox(), Words.INCLUDE_INUSE, TitledItem.TitledItemOrientation.NORTH);
        this.includeUnused.getElement().addItem(Words.ALL);
        this.includeUnused.getElement().addItem(Words.IN_USE);
        this.includeUnused.getElement().addItem(Words.NOT_USE_ONLY);
        this.includeUnused.getElement().setSelectedItem(Words.ALL);
        this.includeDeleted = new TitledItem<ComboBox>(new ComboBox(), Words.INCLUDE_DELETED, TitledItem.TitledItemOrientation.NORTH);
        this.includeDeleted.getElement().addItem(Words.ALL);
        this.includeDeleted.getElement().addItem(Words.DELETED_ONLY);
        this.includeDeleted.getElement().addItem(Words.NOT_DELETED_ONLY);
        this.includeDeleted.getElement().setSelectedItem(Words.NOT_DELETED_ONLY);
        this.includeNominated = new TitledItem<ComboBox>(new ComboBox(), Words.INCLUDE_NOMINATED, TitledItem.TitledItemOrientation.NORTH);
        this.includeNominated.getElement().addItem(Words.ALL);
        this.includeNominated.getElement().addItem(Words.NOMINATED_ONLY);
        this.includeNominated.getElement().addItem(Words.NOT_NOMINATED);
        this.includeNominated.getElement().setSelectedItem(Words.ALL);
        this.includeCustomerOwned = new TitledItem<ComboBox>(new ComboBox(), Words.INCLUDE_CUSTOMER_OWNED, TitledItem.TitledItemOrientation.NORTH);
        this.includeCustomerOwned.getElement().addItem(Words.ALL);
        this.includeCustomerOwned.getElement().addItem(Words.CUSTOMER_OWNED_ONLY);
        this.includeCustomerOwned.getElement().addItem(Words.NOT_CUSTOMER_OWNED);
        this.includeCustomerOwned.getElement().setSelectedItem(Words.ALL);
        this.includeCustomerData.getElement().setChecked(true);
        this.includeCustomsDocuments.getElement().setChecked(true);
        this.includePrices.getElement().setChecked(true);
        this.autoBoundary.getElement().setChecked(true);
        this.autoBoundary.getElement().addButtonListener(this);
        this.category = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(ArticleCategoryComplete.class), ConverterRegistry.getConverter(SingleArticleCategoryConverter.class), true), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
        this.group = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(SingleArticleCategoryConverter.class), true), Words.GROUP, TitledItem.TitledItemOrientation.NORTH);
        this.subGroup = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(SingleArticleCategoryConverter.class), true), Words.SUB_GROUP, TitledItem.TitledItemOrientation.NORTH);
        this.category.getElement().addItemListener(this);
        this.group.getElement().addItemListener(this);
        this.getViewContainer().add(this.printOptionTitle);
        this.getViewContainer().add(this.timePeriodChooser);
        this.getViewContainer().add(this.bonded);
        this.getViewContainer().add(this.includeCustomerData);
        this.getViewContainer().add(this.includeCustomsDocuments);
        this.getViewContainer().add(this.includePrices);
        this.getViewContainer().add(this.includeUnused);
        this.getViewContainer().add(this.includeDeleted);
        this.getViewContainer().add(this.includeIrregularity);
        this.getViewContainer().add(this.includeUnCountedArticles);
        this.getViewContainer().add(this.includeStoreBasedData);
        this.getViewContainer().add(this.includeArticleFromInventory);
        this.getViewContainer().add(this.includeNominated);
        this.getViewContainer().add(this.includeCustomerOwned);
        this.getViewContainer().add(this.category);
        this.getViewContainer().add(this.group);
        this.getViewContainer().add(this.subGroup);
        this.getViewContainer().add(this.autoBoundary);
        this.getViewContainer().add(this.includeComment);
        this.setEnabled(true);
    }

    private void installTables() {
        Table2 sTable = new Table2(true, Words.TABLE_ADD, true, true, Words.START);
        sTable.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                AnalysisInventoryTransitionComponent.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                DTOProxyNode i = new DTOProxyNode();
                AnalysisInventoryTransitionComponent.this.startInventories.getModel().getNode().addChild((Node)i, 0L);
                AnalysisInventoryTransitionComponent.this.revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.INVENTORY, "", null, null, "", 20, 20, 20));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + sTable.getCellPadding() * 2;
        columns.add(new TableColumnInfo("", "", null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        sTable.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1, true)));
        this.startInventories = sTable;
        sTable.getModel().setNode((Node)new ViewNode(Words.START_INVENTORY));
        this.getViewContainer().add(this.startInventories);
        Table2 eTable = new Table2(true, Words.TABLE_ADD, true, true, Words.END);
        eTable.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                AnalysisInventoryTransitionComponent.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                DTOProxyNode i = new DTOProxyNode();
                AnalysisInventoryTransitionComponent.this.endInventories.getModel().getNode().addChild((Node)i, 0L);
                AnalysisInventoryTransitionComponent.this.revalidate();
            }
        });
        columns = new ArrayList();
        columns.add(new TableColumnInfo(Words.INVENTORY, "", null, null, "", 20, 20, 20));
        columns.add(new TableColumnInfo("", "", null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        eTable.setModel(new Table2Model(columns, model -> new TableRowImpl(model, false)));
        this.endInventories = eTable;
        this.endInventories.getModel().setNode((Node)new ViewNode(Words.END_INVENTORY));
        this.getViewContainer().add(this.endInventories);
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> validationObjects = super.validateBeforePrint();
        if (validationObjects == null) {
            validationObjects = new ArrayList<ScreenValidationObject>();
        }
        if (this.startInventories.getRowCount() == 0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AT_LEAST_ONE_START_INVENTORY));
        }
        if (this.endInventories.getRowCount() == 0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AT_LEAST_ONE_END_INVENTORY));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.printOptionTitle.setEnabled(isEnabled);
        this.timePeriodChooser.setEnabled(isEnabled);
        this.bonded.setEnabled(isEnabled);
        this.startInventories.setEnabled(isEnabled);
        this.endInventories.setEnabled(isEnabled);
        this.includeDeleted.setEnabled(isEnabled);
        this.includeArticleFromInventory.setEnabled(isEnabled);
        this.includeNominated.setEnabled(isEnabled);
        this.includeCustomerOwned.setEnabled(isEnabled);
        this.category.setEnabled(isEnabled);
        this.group.setEnabled(isEnabled);
        this.subGroup.setEnabled(isEnabled);
        this.autoBoundary.setEnabled(isEnabled);
        this.includeComment.setEnabled(isEnabled);
        boolean allArticleFromInventories = this.includeArticleFromInventory.getElement().getSelectedItem().equals(Words.ALL);
        this.includeUnCountedArticles.setEnabled(isEnabled && allArticleFromInventories);
        boolean b = false;
        if (this.asXLS != null) {
            b = ((RadioButton)this.asXLS.getElement()).isChecked();
        }
        b = b && isEnabled;
        this.includeCustomerData.setEnabled(b);
        this.includeCustomsDocuments.setEnabled(b);
        this.includePrices.setEnabled(b);
        this.includeUnused.setEnabled(isEnabled);
        this.includeIrregularity.setEnabled(b);
        this.includeStoreBasedData.setEnabled(b);
        if (isEnabled) {
            this.popup.createFocusCycle();
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.timePeriodChooser);
        CheckedListAdder.addToList(focusList, this.bonded);
        CheckedListAdder.addToList(focusList, this.includeUnused);
        CheckedListAdder.addToList(focusList, this.includeDeleted);
        CheckedListAdder.addToList(focusList, this.includeArticleFromInventory);
        CheckedListAdder.addToList(focusList, this.includeNominated);
        CheckedListAdder.addToList(focusList, this.includeCustomerOwned);
        CheckedListAdder.addToList(focusList, this.category);
        CheckedListAdder.addToList(focusList, this.group);
        CheckedListAdder.addToList(focusList, this.subGroup);
        CheckedListAdder.addToList(focusList, this.includeCustomerData);
        CheckedListAdder.addToList(focusList, this.includeCustomsDocuments);
        CheckedListAdder.addToList(focusList, this.includePrices);
        CheckedListAdder.addToList(focusList, this.includeIrregularity);
        CheckedListAdder.addToList(focusList, this.includeUnCountedArticles);
        CheckedListAdder.addToList(focusList, this.includeStoreBasedData);
        CheckedListAdder.addToList(focusList, this.autoBoundary);
        CheckedListAdder.addToList(focusList, this.includeComment);
        CheckedListAdder.addToList(focusList, this.startInventories);
        CheckedListAdder.addToList(focusList, this.endInventories);
        return focusList;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "includeCustomerData": {
                    this.includeCustomerData.getElement().setChecked(b);
                    break;
                }
                case "includeCustomsDocuments": {
                    this.includeCustomsDocuments.getElement().setChecked(b);
                    break;
                }
                case "includePrices": {
                    this.includePrices.getElement().setChecked(b);
                    break;
                }
                case "includeIrregularity": {
                    this.includeIrregularity.getElement().setChecked(b);
                    break;
                }
                case "includeUncounted": {
                    this.includeUnCountedArticles.getElement().setChecked(b);
                    break;
                }
                case "includeStoreBased": {
                    this.includeStoreBasedData.getElement().setChecked(b);
                    break;
                }
                case "autoBoundary": {
                    this.autoBoundary.getElement().setChecked(b);
                    break;
                }
                case "includeComment": {
                    this.includeComment.getElement().setChecked(b);
                }
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("includeCustomerData", "" + this.includeCustomerData.getElement().isChecked());
        conf.addProperty("includeCustomsDocuments", "" + this.includeCustomsDocuments.getElement().isChecked());
        conf.addProperty("includePrices", "" + this.includePrices.getElement().isChecked());
        conf.addProperty("includeIrregularity", "" + this.includeIrregularity.getElement().isChecked());
        conf.addProperty("includeUncounted", "" + this.includeUnCountedArticles.getElement().isChecked());
        conf.addProperty("includeStoreBased", "" + this.includeStoreBasedData.getElement().isChecked());
        conf.addProperty("autoBoundary", "" + this.autoBoundary.getElement().isChecked());
        conf.addProperty("includeComment", "" + this.includeComment.getElement().isChecked());
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.INVENTORY_TRANSITION;
    }

    @Override
    public String getTitleValue() {
        return Words.INVENTORY;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.timePeriodChooser != null) {
            this.timePeriodChooser.kill();
        }
        if (this.bonded != null) {
            this.bonded.kill();
        }
        if (this.startInventories != null) {
            this.startInventories.kill();
        }
        if (this.endInventories != null) {
            this.endInventories.kill();
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.kill();
        }
        if (this.includeCustomsDocuments != null) {
            this.includeCustomsDocuments.kill();
        }
        if (this.includePrices != null) {
            this.includePrices.kill();
        }
        if (this.includeUnused != null) {
            this.includeUnused.kill();
        }
        if (this.includeIrregularity != null) {
            this.includeIrregularity.kill();
        }
        if (this.includeDeleted != null) {
            this.includeDeleted.kill();
        }
        if (this.includeUnCountedArticles != null) {
            this.includeUnCountedArticles.kill();
        }
        if (this.includeArticleFromInventory != null) {
            this.includeArticleFromInventory.kill();
        }
        if (this.includeStoreBasedData != null) {
            this.includeStoreBasedData.kill();
        }
        if (this.includeNominated != null) {
            this.includeNominated.kill();
        }
        if (this.includeCustomerOwned != null) {
            this.includeCustomerOwned.kill();
        }
        if (this.category != null) {
            this.category.kill();
        }
        if (this.group != null) {
            this.group.kill();
        }
        if (this.subGroup != null) {
            this.subGroup.kill();
        }
        if (this.autoBoundary != null) {
            this.autoBoundary.kill();
        }
        if (this.includeComment != null) {
            this.includeComment.kill();
        }
        this.printOptionTitle = null;
        this.timePeriodChooser = null;
        this.startInventories = null;
        this.endInventories = null;
        this.bonded = null;
        this.includeCustomerData = null;
        this.includeCustomsDocuments = null;
        this.includePrices = null;
        this.includeUnused = null;
        this.includeIrregularity = null;
        this.includeDeleted = null;
        this.includeUnCountedArticles = null;
        this.includeArticleFromInventory = null;
        this.includeStoreBasedData = null;
        this.includeNominated = null;
        this.includeCustomerOwned = null;
        this.category = null;
        this.group = null;
        this.subGroup = null;
        this.autoBoundary = null;
        this.includeComment = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.timePeriodChooser != null) {
            this.timePeriodChooser.setVisible(true);
        }
        if (this.bonded != null) {
            this.bonded.setVisible(true);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setVisible(true);
        }
        if (this.includeCustomsDocuments != null) {
            this.includeCustomsDocuments.setVisible(true);
        }
        if (this.includeIrregularity != null) {
            this.includeIrregularity.setVisible(true);
        }
        if (this.includePrices != null) {
            this.includePrices.setVisible(true);
        }
        if (this.includeUnused != null) {
            this.includeUnused.setVisible(true);
        }
        if (this.includeUnCountedArticles != null) {
            this.includeUnCountedArticles.setVisible(true);
        }
        if (this.includeStoreBasedData != null) {
            this.includeStoreBasedData.setVisible(true);
        }
        if (this.includeDeleted != null) {
            this.includeDeleted.setVisible(true);
        }
        if (this.includeArticleFromInventory != null) {
            this.includeArticleFromInventory.setVisible(true);
        }
        if (this.includeNominated != null) {
            this.includeNominated.setVisible(true);
        }
        if (this.includeCustomerOwned != null) {
            this.includeCustomerOwned.setVisible(true);
        }
        if (this.startInventories != null) {
            this.startInventories.setVisible(true);
        }
        if (this.endInventories != null) {
            this.endInventories.setVisible(true);
        }
        if (this.category != null) {
            this.category.setVisible(true);
        }
        if (this.group != null) {
            this.group.setVisible(true);
        }
        if (this.subGroup != null) {
            this.subGroup.setVisible(true);
        }
        if (this.autoBoundary != null) {
            this.autoBoundary.setVisible(true);
        }
        if (this.includeComment != null) {
            this.includeComment.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.timePeriodChooser != null) {
            this.timePeriodChooser.setVisible(false);
        }
        if (this.bonded != null) {
            this.bonded.setVisible(false);
        }
        if (this.includeCustomerData != null) {
            this.includeCustomerData.setVisible(false);
        }
        if (this.includeIrregularity != null) {
            this.includeIrregularity.setVisible(false);
        }
        if (this.includeCustomsDocuments != null) {
            this.includeCustomsDocuments.setVisible(false);
        }
        if (this.includePrices != null) {
            this.includePrices.setVisible(false);
        }
        if (this.includeUnused != null) {
            this.includeUnused.setVisible(false);
        }
        if (this.includeUnCountedArticles != null) {
            this.includeUnCountedArticles.setVisible(false);
        }
        if (this.includeStoreBasedData != null) {
            this.includeStoreBasedData.setVisible(false);
        }
        if (this.includeDeleted != null) {
            this.includeDeleted.setVisible(false);
        }
        if (this.includeArticleFromInventory != null) {
            this.includeArticleFromInventory.setVisible(false);
        }
        if (this.includeNominated != null) {
            this.includeNominated.setVisible(false);
        }
        if (this.includeCustomerOwned != null) {
            this.includeCustomerOwned.setVisible(false);
        }
        if (this.startInventories != null) {
            this.startInventories.setVisible(false);
        }
        if (this.endInventories != null) {
            this.endInventories.setVisible(false);
        }
        if (this.category != null) {
            this.category.setVisible(false);
        }
        if (this.group != null) {
            this.group.setVisible(false);
        }
        if (this.subGroup != null) {
            this.subGroup.setVisible(false);
        }
        if (this.autoBoundary != null) {
            this.autoBoundary.setVisible(false);
        }
        if (this.includeComment != null) {
            this.includeComment.setVisible(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (e.getStateChange() == 1) {
            Node n;
            Object o;
            if (this.includeArticleFromInventory != null && e.getSource() == this.includeArticleFromInventory.getElement()) {
                this.setEnabled(this.isEnabled());
            }
            if (this.category != null && e.getSource() == this.category.getElement()) {
                o = this.category.getElement().getSelectedItem();
                this.group.getElement().removeAllItems();
                if (o instanceof String) {
                    this.group.getElement().addItem(Words.ALL);
                } else if (o instanceof Node) {
                    n = (Node)o;
                    this.group.getElement().refreshPossibleValues(n.getChildNamed(ArticleCategoryComplete_.subCategories));
                    this.group.getElement().setSelectedItem(null);
                    this.subGroup.getElement().setSelectedItem(null);
                }
            }
            if (this.subGroup != null && e.getSource() == this.group.getElement()) {
                o = this.group.getElement().getSelectedItem();
                this.subGroup.getElement().removeAllItems();
                if (o instanceof String) {
                    this.subGroup.getElement().addItem(Words.ALL);
                } else if (o instanceof Node) {
                    n = (Node)o;
                    this.subGroup.getElement().refreshPossibleValues(n.getChildNamed(ArticleCategoryComplete_.subCategories));
                    this.subGroup.getElement().setSelectedItem(null);
                }
            }
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node<? extends InventoryReference> n;
                TableRowImpl impl;
                ReportFileComplete file = AnalysisInventoryTransitionComponent.this.getSelectedReport();
                AnalysisInventoryTransitionComponent.this.configNode.commit();
                InventoryDetailsReportConfiguration config = (InventoryDetailsReportConfiguration)AnalysisInventoryTransitionComponent.this.configNode.getValue();
                config.setStylesheet(file);
                if (((RadioButton)AnalysisInventoryTransitionComponent.this.asXLS.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                } else {
                    config.setFormat(ReportingOutputFormatE.PDF);
                }
                boolean wasClosing = false;
                if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeUnused.getElement()).getSelectedItem().equals(Words.ALL)) {
                    config.setIncludeUnused(null);
                } else if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeUnused.getElement()).getSelectedItem().equals(Words.IN_USE)) {
                    config.setIncludeUnused(Boolean.valueOf(false));
                } else if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeUnused.getElement()).getSelectedItem().equals(Words.NOT_USE_ONLY)) {
                    config.setIncludeUnused(Boolean.valueOf(true));
                }
                if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeDeleted.getElement()).getSelectedItem().equals(Words.ALL)) {
                    config.setIncludeDeleted(null);
                } else if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeDeleted.getElement()).getSelectedItem().equals(Words.DELETED_ONLY)) {
                    config.setIncludeDeleted(Boolean.valueOf(true));
                } else if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeDeleted.getElement()).getSelectedItem().equals(Words.NOT_DELETED_ONLY)) {
                    config.setIncludeDeleted(Boolean.valueOf(false));
                }
                if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeArticleFromInventory.getElement()).getSelectedItem().equals(Words.ALL)) {
                    config.setIncludeArticleFromStartInventory(null);
                } else if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeArticleFromInventory.getElement()).getSelectedItem().equals(Words.START_INVENTORY)) {
                    config.setIncludeArticleFromStartInventory(Boolean.valueOf(true));
                } else if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeArticleFromInventory.getElement()).getSelectedItem().equals(Words.END_INVENTORY)) {
                    config.setIncludeArticleFromStartInventory(Boolean.valueOf(false));
                }
                if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeNominated.getElement()).getSelectedItem().equals(Words.ALL)) {
                    config.setIncludeNominated(null);
                } else if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeNominated.getElement()).getSelectedItem().equals(Words.NOMINATED_ONLY)) {
                    config.setIncludeNominated(Boolean.valueOf(true));
                } else if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeNominated.getElement()).getSelectedItem().equals(Words.NOT_NOMINATED)) {
                    config.setIncludeNominated(Boolean.valueOf(false));
                }
                if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeCustomerOwned.getElement()).getSelectedItem().equals(Words.ALL)) {
                    config.setIncludeCustomerOwned(null);
                } else if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeCustomerOwned.getElement()).getSelectedItem().equals(Words.CUSTOMER_OWNED_ONLY)) {
                    config.setIncludeCustomerOwned(Boolean.valueOf(true));
                } else if (((ComboBox)AnalysisInventoryTransitionComponent.this.includeCustomerOwned.getElement()).getSelectedItem().equals(Words.NOT_CUSTOMER_OWNED)) {
                    config.setIncludeCustomerOwned(Boolean.valueOf(false));
                }
                boolean useAutoBoundary = ((CheckBox)AnalysisInventoryTransitionComponent.this.autoBoundary.getElement()).isChecked();
                for (Table2RowPanel row : AnalysisInventoryTransitionComponent.this.startInventories.getRows()) {
                    Node f;
                    impl = (TableRowImpl)row;
                    n = impl.getInventoryNode();
                    if (n.getValue() == null) continue;
                    InventoryReference inv = new InventoryReference(((InventoryReference)n.getValue()).getId());
                    config.getStartInventories().add(inv);
                    if (!useAutoBoundary) continue;
                    Timestamp s = impl.getEnRouteBoundary();
                    Timestamp r = impl.getReturnsBoundary();
                    ViewNode iFlights = impl.getiFlights();
                    ViewNode eFlights = impl.geteFlights();
                    config.getEnRouteBorder().put(inv, s);
                    config.getReturnsBorder().put(inv, r);
                    ArrayList<FlightReference> inFlights = new ArrayList<FlightReference>();
                    ArrayList<FlightReference> exFlights = new ArrayList<FlightReference>();
                    Iterator it = iFlights.getFailSafeChildIterator();
                    while (it.hasNext()) {
                        f = (Node)it.next();
                        inFlights.add(new FlightReference(((FlightLight)f.getValue()).getId()));
                    }
                    it = eFlights.getFailSafeChildIterator();
                    while (it.hasNext()) {
                        f = (Node)it.next();
                        exFlights.add(new FlightReference(((FlightLight)f.getValue()).getId()));
                    }
                    config.getIncludeFlights().put(inv, new ListWrapper(inFlights));
                    config.getExcludeFlights().put(inv, new ListWrapper(exFlights));
                }
                for (Table2RowPanel row : AnalysisInventoryTransitionComponent.this.endInventories.getRows()) {
                    impl = (TableRowImpl)row;
                    n = impl.getInventoryNode();
                    if (n.getValue() == null) continue;
                    config.getEndInventories().add(new InventoryReference(((InventoryReference)n.getValue()).getId()));
                }
                config.setIncludeStoreBasedInfo(Boolean.valueOf(((CheckBox)AnalysisInventoryTransitionComponent.this.includeStoreBasedData.getElement()).isChecked()));
                config.setPeriod(AnalysisInventoryTransitionComponent.this.timePeriodChooser.getTimePeriod());
                config.setCategory((ArticleCategoryReference)((ComboBox)AnalysisInventoryTransitionComponent.this.category.getElement()).getNode().getValue());
                config.setGroup((ArticleCategoryReference)((ComboBox)AnalysisInventoryTransitionComponent.this.group.getElement()).getNode().getValue());
                config.setSubGroup((ArticleCategoryReference)((ComboBox)AnalysisInventoryTransitionComponent.this.subGroup.getElement()).getNode().getValue());
                if (wasClosing) {
                    AnalysisInventoryTransitionComponent.this.ensureAnimation(AnalysisInventoryTransitionComponent.this.getProgressText());
                }
                PegasusFileComplete t = (PegasusFileComplete)((InventoryReportServiceManager)ServiceManagerRegistry.getService(InventoryReportServiceManager.class)).getInventoryTransactionsReport(config).getValue();
                AnalysisInventoryTransitionComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return AnalysisInventoryTransitionComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<InventoryLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<InventoryLight> createBatchJob(Node<InventoryLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    SearchTextField2Listener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<InventoryLight> inventoryField;
        private DateTimeChooser enRouteBorder;
        private DateTimeChooser returnsBorder;
        private TextButton includeFlights;
        private TextButton excludeFlights;
        private ViewNode iFlights;
        private ViewNode eFlights;
        private DeleteButton delete;
        private boolean dates;

        public TableRowImpl(Table2RowModel m, boolean needDates) {
            super(m);
            this.dates = needDates;
            this.setLayout(new RowLayout());
            if (this.dates) {
                this.iFlights = new ViewNode("iFlights");
                this.eFlights = new ViewNode("eFlights");
                Timestamp s = new Timestamp(System.currentTimeMillis());
                this.enRouteBorder = new DateTimeChooser((Node<Timestamp>)INodeCreator.getDefaultImpl().getNode4DTO((Object)s, false, false));
                Timestamp r = new Timestamp(System.currentTimeMillis());
                this.returnsBorder = new DateTimeChooser((Node<Timestamp>)INodeCreator.getDefaultImpl().getNode4DTO((Object)r, false, false));
                this.includeFlights = new TextButton(Words.INCLUDE);
                this.excludeFlights = new TextButton(Words.EXCLUDE);
                this.includeFlights.addButtonListener(this);
                this.excludeFlights.addButtonListener(this);
            }
            this.inventoryField = SearchTextField2Factory.getInventorySearchField(true, (Node<InventoryLight>)new DTOProxyNode());
            this.inventoryField.addSearchTextFieldListener(this);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.add(this.inventoryField);
            if (this.dates) {
                this.add(this.enRouteBorder);
                this.add(this.returnsBorder);
                this.add(this.includeFlights);
                this.add(this.excludeFlights);
            }
            this.add(this.delete);
        }

        public Timestamp getReturnsBoundary() {
            return this.returnsBorder.getTimestamp();
        }

        public Timestamp getEnRouteBoundary() {
            return this.enRouteBorder.getTimestamp();
        }

        public ViewNode getiFlights() {
            return this.iFlights;
        }

        public ViewNode geteFlights() {
            return this.eFlights;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.inventoryField.requestFocusInWindowNow();
        }

        public Node<? extends InventoryReference> getInventoryNode() {
            return this.inventoryField.getNode();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.inventoryField);
            if (this.dates) {
                CheckedListAdder.addToList(focusList, this.enRouteBorder);
                CheckedListAdder.addToList(focusList, this.returnsBorder);
                CheckedListAdder.addToList(focusList, this.includeFlights);
                CheckedListAdder.addToList(focusList, this.excludeFlights);
            }
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.inventoryField.setEnabled(isEnabled);
            if (this.dates) {
                boolean isAutoBoundary = false;
                if (((CheckBox)AnalysisInventoryTransitionComponent.this.autoBoundary.getElement()).isChecked()) {
                    isAutoBoundary = true;
                }
                this.enRouteBorder.setEnabled(isAutoBoundary);
                this.returnsBorder.setEnabled(isAutoBoundary);
                this.includeFlights.setEnabled(isAutoBoundary);
                this.excludeFlights.setEnabled(isAutoBoundary);
            }
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.inventoryField.kill();
            this.delete.kill();
            if (this.enRouteBorder != null) {
                this.enRouteBorder.kill();
            }
            if (this.returnsBorder != null) {
                this.returnsBorder.kill();
            }
            if (this.includeFlights != null) {
                this.includeFlights.kill();
            }
            if (this.excludeFlights != null) {
                this.excludeFlights.kill();
            }
            this.inventoryField = null;
            this.enRouteBorder = null;
            this.returnsBorder = null;
            this.includeFlights = null;
            this.excludeFlights = null;
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getParentModel().getNode().removeChild(this.getModel().getNode(), 0L);
            } else if (source == this.includeFlights || source == this.excludeFlights) {
                // empty if block
            }
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
            if (source.isItemSelected()) {
                this.model.getParentModel().getTable().getAddButton().requestFocusInWindowNow();
            }
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.dates ? TableRowImpl.this.getDefaultRowHeight() * 2 : TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                int tw = TableRowImpl.this.dates ? (int)((double)w - (2.0 * TableRowImpl.this.enRouteBorder.getPreferredSize().getWidth() + (double)(4 * AnalysisInventoryTransitionComponent.this.border))) : w - 2 * AnalysisInventoryTransitionComponent.this.border;
                TableRowImpl.this.inventoryField.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(TableRowImpl.this.dates ? (double)AnalysisInventoryTransitionComponent.this.border : ((double)parent.getHeight() - TableRowImpl.this.inventoryField.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.inventoryField.setSize(tw, (int)TableRowImpl.this.inventoryField.getPreferredSize().getHeight());
                if (TableRowImpl.this.dates) {
                    TableRowImpl.this.enRouteBorder.setLocation(TableRowImpl.this.inventoryField.getX() + TableRowImpl.this.inventoryField.getWidth() + AnalysisInventoryTransitionComponent.this.border, AnalysisInventoryTransitionComponent.this.border);
                    TableRowImpl.this.enRouteBorder.setSize(TableRowImpl.this.enRouteBorder.getPreferredSize());
                    TableRowImpl.this.returnsBorder.setLocation(TableRowImpl.this.enRouteBorder.getX() + TableRowImpl.this.enRouteBorder.getWidth() + AnalysisInventoryTransitionComponent.this.border, AnalysisInventoryTransitionComponent.this.border);
                    TableRowImpl.this.returnsBorder.setSize(TableRowImpl.this.enRouteBorder.getPreferredSize());
                    TableRowImpl.this.includeFlights.setLocation(TableRowImpl.this.enRouteBorder.getX(), TableRowImpl.this.enRouteBorder.getY() + TableRowImpl.this.enRouteBorder.getHeight() + AnalysisInventoryTransitionComponent.this.border / 2);
                    TableRowImpl.this.includeFlights.setSize(TableRowImpl.this.enRouteBorder.getSize());
                    TableRowImpl.this.excludeFlights.setLocation(TableRowImpl.this.returnsBorder.getX(), TableRowImpl.this.includeFlights.getY());
                    TableRowImpl.this.excludeFlights.setSize(TableRowImpl.this.enRouteBorder.getSize());
                }
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(TableRowImpl.this.dates ? (double)AnalysisInventoryTransitionComponent.this.border : ((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = AnalysisInventoryTransitionComponent.this.layoutInheritedComponents(parent);
            if (AnalysisInventoryTransitionComponent.this.printOptionTitle != null) {
                AnalysisInventoryTransitionComponent.this.printOptionTitle.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border);
                AnalysisInventoryTransitionComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * AnalysisInventoryTransitionComponent.this.border, (int)AnalysisInventoryTransitionComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = AnalysisInventoryTransitionComponent.this.printOptionTitle.getY() + AnalysisInventoryTransitionComponent.this.printOptionTitle.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.timePeriodChooser != null) {
                AnalysisInventoryTransitionComponent.this.timePeriodChooser.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border);
                AnalysisInventoryTransitionComponent.this.timePeriodChooser.setSize(parent.getWidth() - 2 * AnalysisInventoryTransitionComponent.this.border, (int)AnalysisInventoryTransitionComponent.this.timePeriodChooser.getPreferredSize().getHeight());
                y = AnalysisInventoryTransitionComponent.this.timePeriodChooser.getY() + AnalysisInventoryTransitionComponent.this.timePeriodChooser.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.bonded != null) {
                AnalysisInventoryTransitionComponent.this.bonded.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.bonded.setSize((parent.getWidth() - 3 * AnalysisInventoryTransitionComponent.this.border) / 2, (int)AnalysisInventoryTransitionComponent.this.bonded.getPreferredSize().getHeight());
            }
            if (AnalysisInventoryTransitionComponent.this.includeUnused != null) {
                AnalysisInventoryTransitionComponent.this.includeUnused.setLocation(AnalysisInventoryTransitionComponent.this.bonded.getX() + AnalysisInventoryTransitionComponent.this.bonded.getWidth() + AnalysisInventoryTransitionComponent.this.border, AnalysisInventoryTransitionComponent.this.bonded.getY());
                AnalysisInventoryTransitionComponent.this.includeUnused.setSize(AnalysisInventoryTransitionComponent.this.bonded.getSize());
            }
            if (AnalysisInventoryTransitionComponent.this.includeDeleted != null) {
                AnalysisInventoryTransitionComponent.this.includeDeleted.setLocation(AnalysisInventoryTransitionComponent.this.border, AnalysisInventoryTransitionComponent.this.bonded.getY() + AnalysisInventoryTransitionComponent.this.bonded.getHeight() + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.includeDeleted.setSize(AnalysisInventoryTransitionComponent.this.bonded.getSize());
                y = AnalysisInventoryTransitionComponent.this.includeDeleted.getY() + AnalysisInventoryTransitionComponent.this.includeDeleted.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.includeArticleFromInventory != null) {
                AnalysisInventoryTransitionComponent.this.includeArticleFromInventory.setLocation(AnalysisInventoryTransitionComponent.this.includeUnused.getX(), AnalysisInventoryTransitionComponent.this.bonded.getY() + AnalysisInventoryTransitionComponent.this.bonded.getHeight() + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.includeArticleFromInventory.setSize(AnalysisInventoryTransitionComponent.this.bonded.getSize());
            }
            if (AnalysisInventoryTransitionComponent.this.includeNominated != null) {
                AnalysisInventoryTransitionComponent.this.includeNominated.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.includeNominated.setSize(AnalysisInventoryTransitionComponent.this.bonded.getSize());
            }
            if (AnalysisInventoryTransitionComponent.this.includeCustomerOwned != null) {
                AnalysisInventoryTransitionComponent.this.includeCustomerOwned.setLocation(AnalysisInventoryTransitionComponent.this.includeUnused.getX(), y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.includeCustomerOwned.setSize(AnalysisInventoryTransitionComponent.this.bonded.getSize());
                y = AnalysisInventoryTransitionComponent.this.includeCustomerOwned.getY() + AnalysisInventoryTransitionComponent.this.includeCustomerOwned.getHeight();
            }
            int cw = (parent.getWidth() - 4 * AnalysisInventoryTransitionComponent.this.border) / 3;
            if (AnalysisInventoryTransitionComponent.this.category != null) {
                AnalysisInventoryTransitionComponent.this.category.setLocation(AnalysisInventoryTransitionComponent.this.bonded.getX(), y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.category.setSize(cw, (int)AnalysisInventoryTransitionComponent.this.category.getPreferredSize().getHeight());
            }
            if (AnalysisInventoryTransitionComponent.this.group != null) {
                AnalysisInventoryTransitionComponent.this.group.setLocation(AnalysisInventoryTransitionComponent.this.category.getX() + AnalysisInventoryTransitionComponent.this.category.getWidth() + AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.group.setSize(AnalysisInventoryTransitionComponent.this.category.getSize());
            }
            if (AnalysisInventoryTransitionComponent.this.subGroup != null) {
                AnalysisInventoryTransitionComponent.this.subGroup.setLocation(AnalysisInventoryTransitionComponent.this.group.getX() + AnalysisInventoryTransitionComponent.this.group.getWidth() + AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.subGroup.setSize(AnalysisInventoryTransitionComponent.this.group.getSize());
                y = AnalysisInventoryTransitionComponent.this.subGroup.getY() + AnalysisInventoryTransitionComponent.this.subGroup.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.includeCustomerData != null) {
                AnalysisInventoryTransitionComponent.this.includeCustomerData.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border);
                AnalysisInventoryTransitionComponent.this.includeCustomerData.setSize(parent.getWidth() - 2 * AnalysisInventoryTransitionComponent.this.border, (int)AnalysisInventoryTransitionComponent.this.includeCustomerData.getPreferredSize().getHeight());
                y = AnalysisInventoryTransitionComponent.this.includeCustomerData.getY() + AnalysisInventoryTransitionComponent.this.includeCustomerData.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.includeCustomsDocuments != null) {
                AnalysisInventoryTransitionComponent.this.includeCustomsDocuments.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.includeCustomsDocuments.setSize(AnalysisInventoryTransitionComponent.this.includeCustomsDocuments.getPreferredSize());
                y = AnalysisInventoryTransitionComponent.this.includeCustomsDocuments.getY() + AnalysisInventoryTransitionComponent.this.includeCustomsDocuments.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.includePrices != null) {
                AnalysisInventoryTransitionComponent.this.includePrices.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.includePrices.setSize(AnalysisInventoryTransitionComponent.this.includePrices.getPreferredSize());
                y = AnalysisInventoryTransitionComponent.this.includePrices.getY() + AnalysisInventoryTransitionComponent.this.includePrices.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.includeIrregularity != null) {
                AnalysisInventoryTransitionComponent.this.includeIrregularity.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.includeIrregularity.setSize(AnalysisInventoryTransitionComponent.this.includeIrregularity.getPreferredSize());
                y = AnalysisInventoryTransitionComponent.this.includeIrregularity.getY() + AnalysisInventoryTransitionComponent.this.includeIrregularity.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.includeUnCountedArticles != null) {
                AnalysisInventoryTransitionComponent.this.includeUnCountedArticles.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.includeUnCountedArticles.setSize(AnalysisInventoryTransitionComponent.this.includeUnCountedArticles.getPreferredSize());
                y = AnalysisInventoryTransitionComponent.this.includeUnCountedArticles.getY() + AnalysisInventoryTransitionComponent.this.includeUnCountedArticles.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.includeStoreBasedData != null) {
                AnalysisInventoryTransitionComponent.this.includeStoreBasedData.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.includeStoreBasedData.setSize(AnalysisInventoryTransitionComponent.this.includeStoreBasedData.getPreferredSize());
                y = AnalysisInventoryTransitionComponent.this.includeStoreBasedData.getY() + AnalysisInventoryTransitionComponent.this.includeStoreBasedData.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.autoBoundary != null) {
                AnalysisInventoryTransitionComponent.this.autoBoundary.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.autoBoundary.setSize(AnalysisInventoryTransitionComponent.this.autoBoundary.getPreferredSize());
                y = AnalysisInventoryTransitionComponent.this.autoBoundary.getY() + AnalysisInventoryTransitionComponent.this.autoBoundary.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.includeComment != null) {
                AnalysisInventoryTransitionComponent.this.includeComment.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border / 2);
                AnalysisInventoryTransitionComponent.this.includeComment.setSize(AnalysisInventoryTransitionComponent.this.includeComment.getPreferredSize());
                y = AnalysisInventoryTransitionComponent.this.includeComment.getY() + AnalysisInventoryTransitionComponent.this.includeComment.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.startInventories != null) {
                AnalysisInventoryTransitionComponent.this.startInventories.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border);
                AnalysisInventoryTransitionComponent.this.startInventories.setSize(parent.getWidth() - 2 * AnalysisInventoryTransitionComponent.this.border, 240);
                y = AnalysisInventoryTransitionComponent.this.startInventories.getY() + AnalysisInventoryTransitionComponent.this.startInventories.getHeight();
            }
            if (AnalysisInventoryTransitionComponent.this.endInventories != null) {
                AnalysisInventoryTransitionComponent.this.endInventories.setLocation(AnalysisInventoryTransitionComponent.this.border, y + AnalysisInventoryTransitionComponent.this.border);
                AnalysisInventoryTransitionComponent.this.endInventories.setSize(parent.getWidth() - 2 * AnalysisInventoryTransitionComponent.this.border, 240);
                y = AnalysisInventoryTransitionComponent.this.endInventories.getY() + AnalysisInventoryTransitionComponent.this.endInventories.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = AnalysisInventoryTransitionComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += AnalysisInventoryTransitionComponent.this.border;
            if (AnalysisInventoryTransitionComponent.this.animation != null) {
                return new Dimension(w, h);
            }
            if (AnalysisInventoryTransitionComponent.this.printOptionTitle != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border;
            }
            if (AnalysisInventoryTransitionComponent.this.timePeriodChooser != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.timePeriodChooser.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border / 2;
            }
            if (AnalysisInventoryTransitionComponent.this.bonded != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.bonded.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border / 2;
            }
            if (AnalysisInventoryTransitionComponent.this.includeArticleFromInventory != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.bonded.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border / 2;
            }
            if (AnalysisInventoryTransitionComponent.this.includeNominated != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.includeNominated.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border / 2;
            }
            if (AnalysisInventoryTransitionComponent.this.category != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.category.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border;
            }
            if (AnalysisInventoryTransitionComponent.this.includeCustomerData != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.includeCustomerData.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border / 2;
            }
            if (AnalysisInventoryTransitionComponent.this.includeCustomsDocuments != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.includeCustomsDocuments.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border / 2;
            }
            if (AnalysisInventoryTransitionComponent.this.includeIrregularity != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.includeIrregularity.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border / 2;
            }
            if (AnalysisInventoryTransitionComponent.this.includePrices != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.includePrices.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border / 2;
            }
            if (AnalysisInventoryTransitionComponent.this.includeUnCountedArticles != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.includeUnCountedArticles.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border / 2;
            }
            if (AnalysisInventoryTransitionComponent.this.includeStoreBasedData != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.includeStoreBasedData.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border / 2;
            }
            if (AnalysisInventoryTransitionComponent.this.autoBoundary != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.autoBoundary.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border / 2;
            }
            if (AnalysisInventoryTransitionComponent.this.includeComment != null) {
                h = (int)((double)h + AnalysisInventoryTransitionComponent.this.includeComment.getPreferredSize().getHeight());
                h += AnalysisInventoryTransitionComponent.this.border / 2;
            }
            if (AnalysisInventoryTransitionComponent.this.startInventories != null) {
                h += 240;
                h += AnalysisInventoryTransitionComponent.this.border;
            }
            if (AnalysisInventoryTransitionComponent.this.endInventories != null) {
                h += 240;
                h += AnalysisInventoryTransitionComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

