/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.details;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AsynchronusAnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.product.ProductDetailsAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;

public class ProductDetailsAnalysisComponent
extends AsynchronusAnalysisPopupInsert<ProductComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;
    private TitledItem<CheckBox> includeCosts;
    private TitledItem<CheckBox> resolveRecipeToArticle;

    public ProductDetailsAnalysisComponent(AnalysisSmartExternalOpenTool<ProductComplete> subProv) {
        super(subProv);
    }

    @Override
    public void addOptionItems() {
        Node dateNode = new Node();
        dateNode.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        boolean canExportProductCosts = ProductToolkit.canExportProductCosts(false);
        if (canExportProductCosts) {
            this.includeCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MAT_COSTS, TitledItem.TitledItemOrientation.EAST);
        }
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
        if (this.includeCosts != null) {
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeCosts, "costs"));
        }
        this.resolveRecipeToArticle = new TitledItem<CheckBox>(new CheckBox(), "Resolve Recipe to Article", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.resolveRecipeToArticle, "resolveRecipeToArticle"));
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        ProductDetailsAnalysisReportConfiguration conf = new ProductDetailsAnalysisReportConfiguration();
        if (this.includeCosts != null) {
            conf.setIncludeCosts(this.includeCosts.getElement().isChecked());
        } else {
            conf.setIncludeCosts(false);
        }
        conf.setValidityDate((Date)this.validityDate.getElement().getNode().getValue());
        conf.setResolveRecipeToArticle(Boolean.valueOf(this.resolveRecipeToArticle.getElement().isChecked()));
        return conf;
    }
}

