/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.purchaseorder.dailyops.haccp;

import ch.icit.pegasus.client.converter.StandaloneContactConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderOpenPositionReportConfiguration;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.List;

public class PrintOrderDailyOpsHACCPComponent
extends DefaultScrollablePrintPopup2<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor periodEditor;
    private TitledItem<ComboBox> deliveryAddresses;
    private TitledItem<ComboBox> filterBonded;
    private TitledItem<CheckBox> paperProcess;

    public PrintOrderDailyOpsHACCPComponent() {
        super(false, false, ReportTypeE.PURCHASE_ORDER_DAILY_OPS);
    }

    @Override
    public void insertElements() {
        this.createComponents();
        PeriodComplete periodComplete = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
        Node periodNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)periodComplete, false, false);
        this.periodEditor = new TitledPeriodEditor((Node<Date>)periodNode.getChildNamed(PeriodComplete_.startDate), (Node<Date>)periodNode.getChildNamed(PeriodComplete_.endDate), true, null);
        this.deliveryAddresses = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixClass(SystemSettingsComplete.class).getChildNamed(SystemSettingsComplete_.deliveryAddresses), ConverterRegistry.getConverter(StandaloneContactConverter.class)), Words.DELIVERY_ADDRESS, TitledItem.TitledItemOrientation.NORTH);
        if (this.deliveryAddresses.getElement().getItemCount() > 1) {
            this.deliveryAddresses.getElement().setSelectedIndex(0);
        }
        this.paperProcess = new TitledItem<CheckBox>(new CheckBox(), Words.EMPTY_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.filterBonded = new TitledItem<ComboBox>(new ComboBox(), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
        this.filterBonded.getElement().addItem(BondedStateE.ALL);
        this.filterBonded.getElement().addItem(BondedStateE.NOT_BONDED);
        this.filterBonded.getElement().addItem(BondedStateE.ONLY_BONDED);
        this.filterBonded.getElement().selectItem(BondedStateE.ALL);
        this.periodEditor.setVisible(true);
        this.deliveryAddresses.setVisible(true);
        this.filterBonded.setVisible(true);
        this.paperProcess.setVisible(true);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.periodEditor);
        this.getViewContainer().add(this.deliveryAddresses);
        this.getViewContainer().add(this.filterBonded);
        this.getViewContainer().add(this.paperProcess);
    }

    @Override
    public boolean isReportAllowed(ReportFileComplete reportFile) {
        if (!reportFile.getFileName().contains("HACCP")) {
            return false;
        }
        return super.isReportAllowed(reportFile);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.periodEditor.setVisible(true);
        this.deliveryAddresses.setVisible(true);
        this.filterBonded.setVisible(true);
        this.paperProcess.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.periodEditor.setVisible(false);
        this.deliveryAddresses.setVisible(false);
        this.filterBonded.setVisible(false);
        this.paperProcess.setVisible(false);
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (super.isInnerComponent(c)) {
            return true;
        }
        if (this.deliveryAddresses != null && this.deliveryAddresses.getElement().getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.deliveryAddresses.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseOrderOpenPositionReportConfiguration p = new PurchaseOrderOpenPositionReportConfiguration();
                p.setStylesheet(PrintOrderDailyOpsHACCPComponent.this.getSelectedReport());
                if (((ComboBox)PrintOrderDailyOpsHACCPComponent.this.deliveryAddresses.getElement()).getNode().getValue() != null) {
                    p.setDeliveryAddress((ContactComplete)((ComboBox)PrintOrderDailyOpsHACCPComponent.this.deliveryAddresses.getElement()).getNode().getValue());
                }
                p.setPeriod(PrintOrderDailyOpsHACCPComponent.this.periodEditor.getPeriod());
                if (((CheckBox)PrintOrderDailyOpsHACCPComponent.this.paperProcess.getElement()).isChecked()) {
                    p.setOnlyOpenPositions(true);
                } else {
                    p.setOnlyOpenPositions(false);
                }
                p.setPaperProcess(((CheckBox)PrintOrderDailyOpsHACCPComponent.this.paperProcess.getElement()).isChecked());
                switch ((BondedStateE)((ComboBox)PrintOrderDailyOpsHACCPComponent.this.filterBonded.getElement()).getSelectedItem()) {
                    case ALL: {
                        p.setBonded(null);
                        break;
                    }
                    case ONLY_BONDED: {
                        p.setBonded(Boolean.valueOf(true));
                        break;
                    }
                    case NOT_BONDED: {
                        p.setBonded(Boolean.valueOf(false));
                        break;
                    }
                    default: {
                        p.setBonded(null);
                    }
                }
                PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createDailyOpsSheetHACCP(p).getValue();
                PrintOrderDailyOpsHACCPComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintOrderDailyOpsHACCPComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<PurchaseOrderLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<PurchaseOrderLight> createBatchJob(Node<PurchaseOrderLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public String getTitleString() {
        return Words.HACCP_LOG;
    }

    @Override
    public String getTitleValue() {
        return Words.HACCP_SPOT_CHECK;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.periodEditor);
        CheckedListAdder.addToList(focusList, this.deliveryAddresses);
        CheckedListAdder.addToList(focusList, this.paperProcess);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.periodEditor != null) {
            this.periodEditor.kill();
        }
        if (this.deliveryAddresses != null) {
            this.deliveryAddresses.kill();
        }
        if (this.filterBonded != null) {
            this.filterBonded.kill();
        }
        if (this.paperProcess != null) {
            this.paperProcess.kill();
        }
        this.periodEditor = null;
        this.deliveryAddresses = null;
        this.filterBonded = null;
        this.paperProcess = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintOrderDailyOpsHACCPComponent.this.getInheritedComponentsHeight();
            h += PrintOrderDailyOpsHACCPComponent.this.border;
            h = (int)((double)h + PrintOrderDailyOpsHACCPComponent.this.periodEditor.getPreferredSize().getHeight());
            h += PrintOrderDailyOpsHACCPComponent.this.border / 2;
            h = (int)((double)h + PrintOrderDailyOpsHACCPComponent.this.deliveryAddresses.getPreferredSize().getHeight());
            h += PrintOrderDailyOpsHACCPComponent.this.border;
            h = (int)((double)h + PrintOrderDailyOpsHACCPComponent.this.filterBonded.getPreferredSize().getHeight());
            h += PrintOrderDailyOpsHACCPComponent.this.border;
            h = (int)((double)h + PrintOrderDailyOpsHACCPComponent.this.paperProcess.getPreferredSize().getHeight());
            return new Dimension(0, h += PrintOrderDailyOpsHACCPComponent.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintOrderDailyOpsHACCPComponent.this.layoutInheritedComponents(parent);
            PrintOrderDailyOpsHACCPComponent.this.periodEditor.setLocation(PrintOrderDailyOpsHACCPComponent.this.border, y += PrintOrderDailyOpsHACCPComponent.this.border);
            PrintOrderDailyOpsHACCPComponent.this.periodEditor.setSize(PrintOrderDailyOpsHACCPComponent.this.periodEditor.getPreferredSize());
            PrintOrderDailyOpsHACCPComponent.this.deliveryAddresses.setLocation(PrintOrderDailyOpsHACCPComponent.this.border, PrintOrderDailyOpsHACCPComponent.this.periodEditor.getY() + PrintOrderDailyOpsHACCPComponent.this.periodEditor.getHeight() + PrintOrderDailyOpsHACCPComponent.this.border / 2);
            PrintOrderDailyOpsHACCPComponent.this.deliveryAddresses.setSize(parent.getWidth() - 2 * PrintOrderDailyOpsHACCPComponent.this.border, (int)PrintOrderDailyOpsHACCPComponent.this.deliveryAddresses.getPreferredSize().getHeight());
            PrintOrderDailyOpsHACCPComponent.this.filterBonded.setLocation(PrintOrderDailyOpsHACCPComponent.this.border, PrintOrderDailyOpsHACCPComponent.this.deliveryAddresses.getY() + PrintOrderDailyOpsHACCPComponent.this.deliveryAddresses.getHeight() + PrintOrderDailyOpsHACCPComponent.this.border / 2);
            PrintOrderDailyOpsHACCPComponent.this.filterBonded.setSize(parent.getWidth() - 2 * PrintOrderDailyOpsHACCPComponent.this.border, ((PrintOrderDailyOpsHACCPComponent)PrintOrderDailyOpsHACCPComponent.this).filterBonded.getPreferredSize().height);
            PrintOrderDailyOpsHACCPComponent.this.paperProcess.setLocation(PrintOrderDailyOpsHACCPComponent.this.border, PrintOrderDailyOpsHACCPComponent.this.filterBonded.getY() + PrintOrderDailyOpsHACCPComponent.this.filterBonded.getHeight() + PrintOrderDailyOpsHACCPComponent.this.border);
            PrintOrderDailyOpsHACCPComponent.this.paperProcess.setSize(parent.getWidth() - 2 * PrintOrderDailyOpsHACCPComponent.this.border, ((PrintOrderDailyOpsHACCPComponent)PrintOrderDailyOpsHACCPComponent.this).paperProcess.getPreferredSize().height);
        }
    }
}

