/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.purchaseorder.halal;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AsynchronusAnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.PeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.PurchaseAllergenAnalysisReportConfiguration;
import java.sql.Date;

public class HalalCheckAnalysisComponent
extends AsynchronusAnalysisPopupInsert<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor periodEditor;
    private TitledItem<CheckBox> includeHistory;

    public HalalCheckAnalysisComponent(AnalysisSmartExternalOpenTool<PurchaseOrderLight> subProv) {
        super(subProv, false, false, null, false);
    }

    @Override
    public void addOptionItems() {
        PeriodComplete p = new PeriodComplete();
        p.setStartDate(new Date(System.currentTimeMillis()));
        p.setEndDate(new Date(System.currentTimeMillis()));
        Node pNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        this.periodEditor = new TitledPeriodEditor((Node<Date>)pNode.getChildNamed(PeriodComplete_.startDate), (Node<Date>)pNode.getChildNamed(PeriodComplete_.endDate), true, null);
        this.includeHistory = new TitledItem<CheckBox>(new CheckBox(), "Include History", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.periodEditor, "period"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeHistory, "include_history"));
    }

    @Override
    public void doProcessData() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HalalCheckAnalysisComponent.this.writeConfigurationValues();
                PurchaseAllergenAnalysisReportConfiguration reportConfiguration = (PurchaseAllergenAnalysisReportConfiguration)HalalCheckAnalysisComponent.this.getReportConfiguration();
                PegasusFileComplete report = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createHalalCheckReport(reportConfiguration).getValue();
                HalalCheckAnalysisComponent.this.ensureAnimation("Downloading");
                PegasusFileComplete res = report;
                if (res == null) {
                    HalalCheckAnalysisComponent.this.nullReturned();
                    return null;
                }
                HalalCheckAnalysisComponent.this.processPegasusFile(res);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return HalalCheckAnalysisComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        PurchaseAllergenAnalysisReportConfiguration a = new PurchaseAllergenAnalysisReportConfiguration();
        a.setIncludeHistory(Boolean.valueOf(this.includeHistory.getElement().isChecked()));
        a.setPeriod(this.periodEditor.getPeriod());
        return a;
    }
}

