/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.userrights.dataaccess;

import ch.icit.pegasus.client.gui.submodules.analysis.export.DefaultExportAnalysisComponent;
import ch.icit.pegasus.client.gui.submodules.analysis.userrights.dataaccess.DataAccessAnalysis;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataRightsE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelRow;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;

public class DataAccessAnalysisComponent
extends DefaultExportAnalysisComponent<UserLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> modulesCheckbox;
    private TitledItem<CheckBox> submodulesCheckbox;
    private TitledItem<CheckBox> accessRightsCheckbox;
    private TitledItem<CheckBox> fieldRightsCheckbox;

    public DataAccessAnalysisComponent(DataAccessAnalysis dataAccessAnalysis) {
        super(dataAccessAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.modulesCheckbox = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MODULES, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.modulesCheckbox, "modules"));
        this.submodulesCheckbox = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SUB_MODULES, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.submodulesCheckbox, "subModules"));
        this.accessRightsCheckbox = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ACCESS_RIGHTS, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.accessRightsCheckbox, "accessRights"));
        this.fieldRightsCheckbox = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_FIELD_RIGHTS, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.fieldRightsCheckbox, "fieldRights"));
    }

    @Override
    public void process(Iterator<UserLight> sri, List<ExcelRow> rows) throws ClientServerCallException {
        boolean withModules = this.modulesCheckbox.getElement().isChecked();
        while (sri.hasNext()) {
            this.updateItemCount();
            UserLight user = sri.next();
            try {
                UserComplete oc = (UserComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getUser((UserReference)user).getValue();
                this.addUsernameRow(rows, oc);
                if (!withModules) continue;
                this.addModuleRows(rows, oc);
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        }
    }

    private ExcelRow addUsernameRow(List<ExcelRow> rows, UserComplete oc) {
        ExcelRow row = new ExcelRow();
        row.setHeader(true);
        String name = oc.getUserName();
        if (oc.getContact() != null && oc.getContact().getFirstName() != null && oc.getContact().getLastName() != null) {
            name = name + " (" + oc.getContact().getFirstName() + " " + oc.getContact().getLastName() + ")";
        }
        row.addCell((Object)name, new String[0]);
        rows.add(row);
        return row;
    }

    private void addModuleRows(List<ExcelRow> rows, UserComplete oc) {
        for (ModuleAccessRightComplete right : oc.getModules()) {
            ExcelRow row = new ExcelRow();
            row.setHeader(true);
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)right.getModule().getDisplayName(), new String[0]);
            rows.add(row);
            boolean withSubModules = this.submodulesCheckbox.getElement().isChecked();
            boolean withAccessRights = this.accessRightsCheckbox.getElement().isChecked();
            boolean withFieldsRights = this.fieldRightsCheckbox.getElement().isChecked();
            if (withAccessRights) {
                this.addAccessRights(rows, right);
            }
            if (withSubModules) {
                this.addSubModules(rows, right);
            }
            if (!withFieldsRights) continue;
            this.addFieldRights(rows, right);
        }
    }

    private void addSubModules(List<ExcelRow> rows, ModuleAccessRightComplete right) {
        if (!right.getSubModules().isEmpty()) {
            ExcelRow row = new ExcelRow();
            row.setHeader(true);
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)Words.SUB_MODULE, new String[0]);
            rows.add(row);
            for (SubModuleAccessRightComplete subAccessRight : right.getSubModules()) {
                if (subAccessRight.getModule().getInvokingName() == null || subAccessRight.getModule().getInvokingName().isEmpty()) continue;
                row = new ExcelRow((Object)subAccessRight);
                row.addCell((Object)"", new String[0]);
                row.addCell((Object)"", new String[0]);
                row.addCell((Object)"", new String[0]);
                row.addCell((Object)subAccessRight.getModule().getDisplayName(), new String[0]);
                rows.add(row);
            }
        }
    }

    private void addFieldRights(List<ExcelRow> rows, ModuleAccessRightComplete right) {
        if (!right.getFieldAccessRights().isEmpty()) {
            ExcelRow row = new ExcelRow();
            row.setHeader(true);
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)Words.FIELD_RIGHTS, new String[0]);
            rows.add(row);
            for (DataFieldAccessRightComplete fr : right.getFieldAccessRights()) {
                row = new ExcelRow((Object)fr);
                row.addCell((Object)"", new String[0]);
                row.addCell((Object)"", new String[0]);
                row.addCell((Object)"", new String[0]);
                row.addCell((Object)(fr.getField().getName() + " [" + fr.getAccessRight().toString() + "]"), new String[0]);
                rows.add(row);
            }
        }
    }

    private void addAccessRights(List<ExcelRow> rows, ModuleAccessRightComplete right) {
        ExcelRow row;
        boolean foundADDRight = false;
        boolean foundDELETERight = false;
        for (DataAccessRightComplete aright : right.getAccessRights()) {
            if (!foundADDRight && aright.getDataAccessRight().getAccessRight() == DataRightsE.ADD) {
                foundADDRight = true;
            }
            if (foundDELETERight || aright.getDataAccessRight().getAccessRight() != DataRightsE.DELETE) continue;
            foundDELETERight = true;
        }
        if (foundADDRight || foundDELETERight) {
            row = new ExcelRow();
            row.setHeader(true);
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)Words.ACCESS_RIGHTS, new String[0]);
            rows.add(row);
        }
        if (foundADDRight) {
            row = new ExcelRow();
            row = new ExcelRow();
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)Words.ADD, new String[0]);
            rows.add(row);
        }
        if (foundDELETERight) {
            row = new ExcelRow();
            row = new ExcelRow();
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)"", new String[0]);
            row.addCell((Object)Words.DELETE, new String[0]);
            rows.add(row);
        }
    }

    @Override
    protected List<ExcelRow> createRow(UserLight next) throws ClientServerCallException {
        return null;
    }
}

