/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.substitutionlog;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.LanguageCodeComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class PrintSubstitutionLogComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> currentFlight;
    private TitledItem<CheckBox> includeAIS;

    public PrintSubstitutionLogComponent(Node<FlightLight> node) {
        super(false, false, ReportTypeE.FLIGHT_SUBSTITUTION_LOG);
        this.currentFlight = node;
        this.loadBeforeShowing(() -> {
            try {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(LanguageCodeComplete.class, false);
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        });
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.includeAIS = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALLERGEN_INFO_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.includeAIS);
        this.createComponents();
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        if (this.currentFlight.getValue() != null) {
            return ((FlightLight)this.currentFlight.getValue()).getOutboundCode();
        }
        return "-";
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.includeAIS);
        return focusList;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.includeAIS != null) {
            this.includeAIS.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.includeAIS != null) {
            this.includeAIS.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintSubstitutionLogComponent.this.getSelectedReport();
                ReportingOutputFormatE f = ReportingOutputFormatE.PDF;
                FlightLight flight = (FlightLight)PrintSubstitutionLogComponent.this.currentFlight.getValue();
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).generateSubstitutionChangeLog((FlightReference)flight, ((CheckBox)PrintSubstitutionLogComponent.this.includeAIS.getElement()).isChecked(), f, file).getValue();
                PrintSubstitutionLogComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintSubstitutionLogComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.currentFlight;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintSubstitutionLogComponent.this.layoutInheritedComponents(parent);
            PrintSubstitutionLogComponent.this.includeAIS.setLocation(PrintSubstitutionLogComponent.this.border, y += PrintSubstitutionLogComponent.this.border / 2);
            PrintSubstitutionLogComponent.this.includeAIS.setSize(PrintSubstitutionLogComponent.this.includeAIS.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintSubstitutionLogComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintSubstitutionLogComponent.this.border;
            h = (int)((double)h + PrintSubstitutionLogComponent.this.includeAIS.getPreferredSize().getHeight());
            return new Dimension(w, h += PrintSubstitutionLogComponent.this.border);
        }
    }
}

