/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.shared.deliveryslip;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.impl.FlightPrintBatch;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserPopup;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.panels.PaxLegTable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.IFlightReference;
import ch.icit.pegasus.server.core.dtos.report.DeliverySlipReportConfiguration;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.AFlightAccess;
import ch.icit.pegasus.server.core.dtos.util.SalesOnBoardReportStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public abstract class PrintDeliverySlipComponent<T extends IFlightReference, L extends ALegComplete>
extends DefaultScrollablePrintPopup2<T>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    protected TitledItem<DateChooserPopup> dateChooser;
    protected TextLabel printOptionTitle;
    protected TitledItem<CheckBox> finalizeFlight;
    protected TitledItem<RadioButton> useCATITNo;
    protected TitledItem<RadioButton> useCustomerNo;
    protected TitledItem<RadioButton> useProductLabelName;
    protected TitledItem<RadioButton> useAISName;
    protected TitledItem<RadioButton> useProductName;
    protected TitledItem<RadioButton> quantityBased;
    protected TitledItem<RadioButton> cashBased;
    protected TitledItem<CheckBox> sortProductsByNumber;
    protected TitledItem<CheckBox> includeArticles;
    protected TitledItem<CheckBox> includeHandling;
    protected TitledItem<CheckBox> includeStandard;
    protected TitledItem<CheckBox> includeNullValues;
    protected TitledItem<CheckBox> includePaxUpdate;
    protected TitledItem<CheckBox> includeDrawersCount;
    protected TitledItem<CheckBox> includeTemperature;
    protected TitledItem<CheckBox> includeSeals;
    protected TitledItem<CheckBox> includeAIS;
    protected TitledItem<CheckBox> groupAdditional;
    protected TitledItem<CheckBox> sendDeliverySlip;
    protected TitledItem<CheckBox> showAdditionalSeparately;
    protected TitledItem<CheckBox> showSpecialMealsSeparately;
    protected TitledItem<CheckBox> includeCrewPax;
    protected TitledItem<CheckBox> summarizeCrew;
    protected TitledItem<CheckBox> excludeZeroPax;
    protected TitledItem<CheckBox> hideFlightFromToNSDS;
    protected MultiLineTextLabel infoLabel;
    protected TitledItem<PaxLegTable> paxCount;
    private final RDProvider provider;
    protected TitledItem<RadioButton> showAllProducts;
    protected TitledItem<RadioButton> showSobProductsOnly;
    protected TitledItem<RadioButton> showNoSobProductsOnly;
    protected TitledItem<RadioButton> printAll;
    protected TitledItem<RadioButton> printTitlePageOnly;
    protected TitledItem<RadioButton> printWithoutTitlePage;
    protected TitledItem<CheckBox> printProducesText;
    protected TitledItem<CheckBox> printIngredientListInfo;
    private boolean isHideNSDSActive;
    private boolean showSobState = true;
    private static final String AIS_CONFIG = "sign_ais";
    private static final String CASH_CONFIG_NAME = "cash";
    private static final String ARTICLES_CONFIG_NAME = "overview";
    private static final String HANDLING_CONFIG_NAME = "handlings";
    private static final String STANDARD_CONFIG_NAME = "standard";
    private static final String DRAWER_CONFIG_NAME = "drawer";
    private static final String TEMPERATURE_CONFIG_NAME = "temperature";
    private static final String SEALS_CONFIG_NAME = "seals";
    private static final String CREW_PAX_CONFIG_NAME = "crewpax";
    private static final String NUMBER_CONFIG_NAME = "number";
    private static final String AIS_NAME = "ais";
    private static final String PRODUCT_LABEL_NAME = "productName";
    private static final String PRODUCT_NAME = "useproductname";
    private static final String INCLUDE_NULL_CONFIG_NAME = "include_null";
    private static final String SUMMARIZE_CREW = "summarize_crew";
    private static final String HIDE_NS_DS_FLIGHTS = "hide_ns_ds_flights";
    private static final String SOB_STATE = "sobState";
    private static final String GROUP_ADDITIONALS = "groupAdditional";
    private static final String EXCLUDE_ZERO_PAX_ = "excludeZeroPax";
    private static final String SHOW_ADDITIONALS_SEPARATELY = "showAdditionalSeparately";
    private static final String SHOW_SPMLS_SEPARATELY = "showSPMLsSeparately";
    private static final String SHOW_ALL_PRODUCTS = "showAllProducts";
    private static final String SHOW_SOB_ONLY = "showSobOnly";
    private static final String SHOW_NON_SOB_ONLY = "showNonSobOnly";
    private static final String PRINT_ALL = "printAll";
    private static final String PRINT_TITLEPAGE_ONLY = "printTitlePageOnly";
    private static final String PRINT_WITHOUT_TITLEPAGE = "printWithoutTitlePage";
    private static final String FINALIZE_FLIGHT = "finalizeFlight";
    private static final String PRINT_PRODUCES_TEXT_TYPE = "printProducesText";
    private static final String PRINT_INGREDIENT_LIST_INFO_TYPE = "printIngredientListInfo";

    public PrintDeliverySlipComponent(RDProvider provider, boolean showHideNSDS) {
        this(provider, showHideNSDS, true);
    }

    public PrintDeliverySlipComponent(RDProvider provider, boolean showHideNSDS, boolean showSobState) {
        super(true, false, false, false, ReportTypeE.DELIVERYSLIP);
        this.provider = provider;
        this.showSobState = showSobState;
        this.isHideNSDSActive = showHideNSDS;
    }

    @Override
    public boolean isReportAllowed(ReportFileComplete reportFile) {
        if (reportFile.getDescription().contains("Summary")) {
            if (this.provider != null) {
                return this.provider.isWritable(AFlightAccess.PRINT_COST_DELIVERY_SLIP);
            }
            return false;
        }
        return super.isReportAllowed(reportFile);
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.quantityBased);
        if (this.cashBased != null) {
            CheckedListAdder.addToList(focusList, this.cashBased);
        }
        CheckedListAdder.addToList(focusList, this.sortProductsByNumber);
        CheckedListAdder.addToList(focusList, this.sendDeliverySlip);
        CheckedListAdder.addToList(focusList, this.finalizeFlight);
        CheckedListAdder.addToList(focusList, this.useCATITNo);
        CheckedListAdder.addToList(focusList, this.useCustomerNo);
        CheckedListAdder.addToList(focusList, this.useProductLabelName);
        CheckedListAdder.addToList(focusList, this.useAISName);
        CheckedListAdder.addToList(focusList, this.useProductName);
        CheckedListAdder.addToList(focusList, this.includeStandard);
        CheckedListAdder.addToList(focusList, this.includeHandling);
        CheckedListAdder.addToList(focusList, this.includeArticles);
        CheckedListAdder.addToList(focusList, this.includeNullValues);
        CheckedListAdder.addToList(focusList, this.includeDrawersCount);
        CheckedListAdder.addToList(focusList, this.includeTemperature);
        CheckedListAdder.addToList(focusList, this.includeSeals);
        CheckedListAdder.addToList(focusList, this.includeAIS);
        CheckedListAdder.addToList(focusList, this.groupAdditional);
        CheckedListAdder.addToList(focusList, this.showAdditionalSeparately);
        CheckedListAdder.addToList(focusList, this.showSpecialMealsSeparately);
        CheckedListAdder.addToList(focusList, this.excludeZeroPax);
        CheckedListAdder.addToList(focusList, this.includeCrewPax);
        CheckedListAdder.addToList(focusList, this.summarizeCrew);
        CheckedListAdder.addToList(focusList, this.hideFlightFromToNSDS);
        CheckedListAdder.addToList(focusList, this.showAllProducts);
        CheckedListAdder.addToList(focusList, this.showSobProductsOnly);
        CheckedListAdder.addToList(focusList, this.showNoSobProductsOnly);
        CheckedListAdder.addToList(focusList, this.printAll);
        CheckedListAdder.addToList(focusList, this.printTitlePageOnly);
        CheckedListAdder.addToList(focusList, this.printWithoutTitlePage);
        CheckedListAdder.addToList(focusList, this.printProducesText);
        CheckedListAdder.addToList(focusList, this.printIngredientListInfo);
        if (this.dateChooser != null) {
            CheckedListAdder.addToList(focusList, this.dateChooser);
        }
        if (this.paxCount != null) {
            CheckedListAdder.addToList(focusList, this.paxCount);
        }
        return focusList;
    }

    @Override
    public String getPreferredSelection() {
        return Words.DELIVERY_SLIP_SHEET;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.quantityBased != null) {
            this.quantityBased.setEnabled(isEnabled);
        }
        if (this.cashBased != null) {
            this.cashBased.setEnabled(isEnabled);
        }
        if (this.sendDeliverySlip != null) {
            this.sendDeliverySlip.setEnabled(isEnabled);
        }
        this.useCATITNo.setEnabled(isEnabled);
        this.useCustomerNo.setEnabled(isEnabled);
        this.useProductLabelName.setEnabled(isEnabled);
        this.useAISName.setEnabled(isEnabled);
        this.useProductName.setEnabled(isEnabled);
        if (this.sortProductsByNumber != null) {
            this.sortProductsByNumber.setEnabled(isEnabled);
        }
        if (this.finalizeFlight != null) {
            this.finalizeFlight.setEnabled(isEnabled);
        }
        this.includeArticles.setEnabled(isEnabled);
        this.includeHandling.setEnabled(isEnabled);
        this.includeStandard.setEnabled(isEnabled);
        this.includePaxUpdate.setEnabled(isEnabled);
        this.includeDrawersCount.setEnabled(isEnabled);
        this.includeTemperature.setEnabled(isEnabled);
        this.includeSeals.setEnabled(isEnabled);
        this.includeAIS.setEnabled(isEnabled);
        this.groupAdditional.setEnabled(isEnabled);
        this.showAdditionalSeparately.setEnabled(isEnabled);
        this.showSpecialMealsSeparately.setEnabled(isEnabled);
        this.excludeZeroPax.setEnabled(isEnabled);
        this.includeCrewPax.setEnabled(isEnabled);
        this.summarizeCrew.setEnabled(isEnabled && this.includeCrewPax.getElement().isChecked());
        this.includeNullValues.setEnabled(isEnabled);
        if (this.hideFlightFromToNSDS != null) {
            this.hideFlightFromToNSDS.setEnabled(isEnabled);
        }
        if (this.showSobState) {
            this.showAllProducts.setEnabled(isEnabled);
            this.showSobProductsOnly.setEnabled(isEnabled);
            this.showNoSobProductsOnly.setEnabled(isEnabled);
        }
        this.printAll.setEnabled(isEnabled);
        this.printTitlePageOnly.setEnabled(isEnabled);
        this.printWithoutTitlePage.setEnabled(isEnabled);
        this.printProducesText.setEnabled(isEnabled);
        this.printIngredientListInfo.setEnabled(isEnabled);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.printOptionTitle = new TextLabel(Words.OPTIONS);
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.getViewContainer().add(this.printOptionTitle);
        this.quantityBased = new TitledItem<RadioButton>(new RadioButton(), Words.QUANTITY_DELIVERY_SLIP, TitledItem.TitledItemOrientation.EAST);
        this.quantityBased.getElement().addButtonListener(this);
        if (this.provider.isWritable(AFlightAccess.PRINT_COST_DELIVERY_SLIP)) {
            this.cashBased = new TitledItem<RadioButton>(new RadioButton(), Words.CASH_DELIVERY_SLIP, TitledItem.TitledItemOrientation.EAST);
            this.cashBased.getElement().addButtonListener(this);
        }
        this.quantityBased.getElement().setChecked(true);
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        ArrayList<RadioButton> l = new ArrayList<RadioButton>();
        l.add(this.quantityBased.getElement());
        if (this.cashBased != null) {
            l.add(this.cashBased.getElement());
        }
        this.quantityBased.getElement().setEffectedRadioButtons(l);
        if (this.cashBased != null) {
            this.cashBased.getElement().setEffectedRadioButtons(l);
        }
        this.quantityBased.getTitle().setForeground(fb);
        this.quantityBased.getTitle().setFont(f);
        if (this.cashBased != null) {
            this.cashBased.getTitle().setForeground(fb);
            this.cashBased.getTitle().setFont(f);
        }
        this.getViewContainer().add(this.quantityBased);
        if (this.cashBased != null) {
            this.getViewContainer().add(this.cashBased);
        }
        this.useCATITNo = new TitledItem<RadioButton>(new RadioButton(), Words.SHOW_CATIT_PRODUCT_NO, TitledItem.TitledItemOrientation.EAST);
        this.useCustomerNo = new TitledItem<RadioButton>(new RadioButton(), Words.SHOW_CUSTOMER_PRODUCT_NO, TitledItem.TitledItemOrientation.EAST);
        this.useCATITNo.getElement().setChecked(true);
        this.useCustomerNo.getElement().setChecked(false);
        ArrayList<RadioButton> l2 = new ArrayList<RadioButton>();
        l2.add(this.useCATITNo.getElement());
        l2.add(this.useCustomerNo.getElement());
        this.useCATITNo.getElement().setEffectedRadioButtons(l2);
        this.useCustomerNo.getElement().setEffectedRadioButtons(l2);
        this.useCATITNo.getTitle().setForeground(fb);
        this.useCATITNo.getTitle().setFont(f);
        this.useCustomerNo.getTitle().setForeground(fb);
        this.useCustomerNo.getTitle().setFont(f);
        this.getViewContainer().add(this.useCATITNo);
        this.getViewContainer().add(this.useCustomerNo);
        this.useProductLabelName = new TitledItem<RadioButton>(new RadioButton(), Words.USE_LABEL_NAME, TitledItem.TitledItemOrientation.EAST);
        this.useAISName = new TitledItem<RadioButton>(new RadioButton(), Words.USE_ALLERGEN_SHEET_NAME, TitledItem.TitledItemOrientation.EAST);
        this.useProductName = new TitledItem<RadioButton>(new RadioButton(), Words.USE_PRODUCT_NAME, TitledItem.TitledItemOrientation.EAST);
        this.useProductLabelName.getElement().setChecked(true);
        this.useAISName.getElement().setChecked(false);
        this.useProductName.getElement().setChecked(false);
        ArrayList<RadioButton> l3 = new ArrayList<RadioButton>();
        l3.add(this.useProductLabelName.getElement());
        l3.add(this.useAISName.getElement());
        l3.add(this.useProductName.getElement());
        this.useProductLabelName.getElement().setEffectedRadioButtons(l3);
        this.useAISName.getElement().setEffectedRadioButtons(l3);
        this.useProductName.getElement().setEffectedRadioButtons(l3);
        this.useProductLabelName.getTitle().setForeground(fb);
        this.useProductLabelName.getTitle().setFont(f);
        this.useAISName.getTitle().setForeground(fb);
        this.useAISName.getTitle().setFont(f);
        this.useProductName.getTitle().setForeground(fb);
        this.useProductName.getTitle().setFont(f);
        this.getViewContainer().add(this.useProductLabelName);
        this.getViewContainer().add(this.useAISName);
        this.getViewContainer().add(this.useProductName);
        this.sortProductsByNumber = new TitledItem<CheckBox>(new CheckBox(), Words.SORT_BY_NUMBER, TitledItem.TitledItemOrientation.EAST);
        this.sortProductsByNumber.getTitle().setForeground(fb);
        this.sortProductsByNumber.getElement().setChecked(true);
        this.includeArticles = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ARTICLE + " *", TitledItem.TitledItemOrientation.EAST);
        this.includeArticles.getTitle().setForeground(fb);
        this.includeArticles.getElement().setChecked(true);
        this.includeHandling = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_HANDLING, TitledItem.TitledItemOrientation.EAST);
        this.includeHandling.getTitle().setForeground(fb);
        this.includeHandling.getElement().setChecked(true);
        this.includeStandard = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STANDARD, TitledItem.TitledItemOrientation.EAST);
        this.includeStandard.getTitle().setForeground(fb);
        this.includeStandard.getElement().setChecked(true);
        this.includePaxUpdate = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PAX_UPDATE, TitledItem.TitledItemOrientation.EAST);
        this.includePaxUpdate.getTitle().setForeground(fb);
        this.includePaxUpdate.getElement().setChecked(false);
        this.includeDrawersCount = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_DRAWER_COUNT, TitledItem.TitledItemOrientation.EAST);
        this.includeDrawersCount.getTitle().setForeground(fb);
        this.includeDrawersCount.getElement().setChecked(false);
        this.includeTemperature = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_TEMPERATURE, TitledItem.TitledItemOrientation.EAST);
        this.includeTemperature.getTitle().setForeground(fb);
        this.includeTemperature.getElement().setChecked(false);
        this.includeSeals = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SEALS, TitledItem.TitledItemOrientation.EAST);
        this.includeSeals.getTitle().setForeground(fb);
        this.includeSeals.getElement().setChecked(false);
        this.includeAIS = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_AIS_SIGN, TitledItem.TitledItemOrientation.EAST);
        this.includeAIS.getTitle().setForeground(fb);
        this.includeAIS.getElement().setChecked(false);
        this.excludeZeroPax = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_CLASS_WITHOUT_PAX, TitledItem.TitledItemOrientation.EAST);
        this.excludeZeroPax.getTitle().setForeground(fb);
        this.includeCrewPax = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CREW_PAX, TitledItem.TitledItemOrientation.EAST);
        this.includeCrewPax.getTitle().setForeground(fb);
        this.includeCrewPax.getElement().setChecked(true);
        this.includeCrewPax.getElement().addButtonListener(this);
        this.summarizeCrew = new TitledItem<CheckBox>(new CheckBox(), Words.SUMMARIZE_CREW, TitledItem.TitledItemOrientation.EAST);
        this.summarizeCrew.getTitle().setForeground(fb);
        this.includeNullValues = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_NULL_VALUES, TitledItem.TitledItemOrientation.EAST);
        this.includeNullValues.getTitle().setForeground(fb);
        this.includeNullValues.getElement().setChecked(true);
        this.groupAdditional = new TitledItem<CheckBox>(new CheckBox(), Words.GROUP_ADDITONALS, TitledItem.TitledItemOrientation.EAST);
        this.groupAdditional.getTitle().setForeground(fb);
        this.groupAdditional.getElement().setChecked(false);
        this.showAdditionalSeparately = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ADDITIONALS_SEPARATELY, TitledItem.TitledItemOrientation.EAST);
        this.showAdditionalSeparately.getTitle().setForeground(fb);
        this.showAdditionalSeparately.getElement().setChecked(true);
        this.showSpecialMealsSeparately = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_SPML_SEPARATELY, TitledItem.TitledItemOrientation.EAST);
        this.showSpecialMealsSeparately.getTitle().setForeground(fb);
        this.showSpecialMealsSeparately.getElement().setChecked(true);
        if (this.isHideNSDSActive) {
            this.hideFlightFromToNSDS = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_FLIGHTS_FROMTO_NS_DS, TitledItem.TitledItemOrientation.EAST);
            this.hideFlightFromToNSDS.getTitle().setForeground(fb);
            this.hideFlightFromToNSDS.getElement().setChecked(false);
        }
        if (this.showSobState) {
            l = new ArrayList();
            this.showAllProducts = new TitledItem<RadioButton>(new RadioButton(), Words.SHOW_ALL_PRODUCTS, TitledItem.TitledItemOrientation.EAST);
            this.showSobProductsOnly = new TitledItem<RadioButton>(new RadioButton(), Words.SHOW_SOB_ONLY, TitledItem.TitledItemOrientation.EAST);
            this.showNoSobProductsOnly = new TitledItem<RadioButton>(new RadioButton(), Words.SHOW_NON_SOB_ONLY, TitledItem.TitledItemOrientation.EAST);
            this.showAllProducts.getTitle().setForeground(fb);
            this.showSobProductsOnly.getTitle().setForeground(fb);
            this.showNoSobProductsOnly.getTitle().setForeground(fb);
            l.add(this.showAllProducts.getElement());
            l.add(this.showSobProductsOnly.getElement());
            l.add(this.showNoSobProductsOnly.getElement());
            this.showAllProducts.getElement().setChecked(true);
            this.showAllProducts.getElement().setEffectedRadioButtons(l);
            this.showSobProductsOnly.getElement().setEffectedRadioButtons(l);
            this.showNoSobProductsOnly.getElement().setEffectedRadioButtons(l);
        }
        l = new ArrayList();
        this.printAll = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_ALL, TitledItem.TitledItemOrientation.EAST);
        this.printTitlePageOnly = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_TITLEPAGE_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.printWithoutTitlePage = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_WITHOUT_TITLEPAGE, TitledItem.TitledItemOrientation.EAST);
        this.printAll.getTitle().setForeground(fb);
        this.printTitlePageOnly.getTitle().setForeground(fb);
        this.printWithoutTitlePage.getTitle().setForeground(fb);
        l.add(this.printAll.getElement());
        l.add(this.printTitlePageOnly.getElement());
        l.add(this.printWithoutTitlePage.getElement());
        this.printAll.getElement().setChecked(true);
        this.printAll.getElement().setEffectedRadioButtons(l);
        this.printTitlePageOnly.getElement().setEffectedRadioButtons(l);
        this.printWithoutTitlePage.getElement().setEffectedRadioButtons(l);
        this.printProducesText = new TitledItem<CheckBox>(new CheckBox(), Words.PRINT_PRODUCES_TEXT, TitledItem.TitledItemOrientation.EAST);
        this.printProducesText.getTitle().setForeground(fb);
        this.printIngredientListInfo = new TitledItem<CheckBox>(new CheckBox(), Words.PRINT_INGREDIENT_LIST_INFO, TitledItem.TitledItemOrientation.EAST);
        this.printIngredientListInfo.getTitle().setForeground(fb);
        this.infoLabel = new MultiLineTextLabel("<html>* Be aware of<ul><li>Articles and Products marked as 'always on Delivery Sheet' are shown anyway</li><li>Articles show their Label Name, if none is defined, Article's Name is shown</li></ul></html>");
        this.getViewContainer().add(this.includeArticles);
        this.getViewContainer().add(this.includeHandling);
        this.getViewContainer().add(this.includeStandard);
        this.getViewContainer().add(this.includeDrawersCount);
        this.getViewContainer().add(this.includeTemperature);
        this.getViewContainer().add(this.includePaxUpdate);
        this.getViewContainer().add(this.includeSeals);
        this.getViewContainer().add(this.includeAIS);
        this.getViewContainer().add(this.excludeZeroPax);
        this.getViewContainer().add(this.includeCrewPax);
        this.getViewContainer().add(this.summarizeCrew);
        this.getViewContainer().add(this.infoLabel);
        this.getViewContainer().add(this.includeNullValues);
        this.getViewContainer().add(this.groupAdditional);
        this.getViewContainer().add(this.showAdditionalSeparately);
        this.getViewContainer().add(this.showSpecialMealsSeparately);
        this.getViewContainer().add(this.sortProductsByNumber);
        this.getViewContainer().add(this.printProducesText);
        this.getViewContainer().add(this.printIngredientListInfo);
        if (this.hideFlightFromToNSDS != null) {
            this.getViewContainer().add(this.hideFlightFromToNSDS);
        }
        if (this.showSobState) {
            this.getViewContainer().add(this.showAllProducts);
            this.getViewContainer().add(this.showSobProductsOnly);
            this.getViewContainer().add(this.showNoSobProductsOnly);
        }
        this.getViewContainer().add(this.printAll);
        this.getViewContainer().add(this.printTitlePageOnly);
        this.getViewContainer().add(this.printWithoutTitlePage);
        if (this.finalizeFlight != null) {
            this.getViewContainer().add(this.finalizeFlight);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = false;
            try {
                b = Boolean.valueOf(v);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (n) {
                case "cash": {
                    if (this.cashBased != null) {
                        this.cashBased.getElement().setChecked(b);
                    }
                    if (this.quantityBased == null) break;
                    this.quantityBased.getElement().setChecked(b == false);
                    break;
                }
                case "standard": {
                    this.includeStandard.getElement().setChecked(b);
                    break;
                }
                case "overview": {
                    this.includeArticles.getElement().setChecked(b);
                    break;
                }
                case "handlings": {
                    this.includeHandling.getElement().setChecked(b);
                    break;
                }
                case "drawer": {
                    this.includeDrawersCount.getElement().setChecked(b);
                    break;
                }
                case "temperature": {
                    this.includeTemperature.getElement().setChecked(b);
                    break;
                }
                case "seals": {
                    this.includeSeals.getElement().setChecked(b);
                    break;
                }
                case "sign_ais": {
                    this.includeAIS.getElement().setChecked(b);
                    break;
                }
                case "crewpax": {
                    this.includeCrewPax.getElement().setChecked(b);
                    break;
                }
                case "number": {
                    this.useCATITNo.getElement().setChecked(b);
                    this.useCustomerNo.getElement().setChecked(b == false);
                    break;
                }
                case "ais": {
                    this.useAISName.getElement().setChecked(b);
                    this.useProductLabelName.getElement().setChecked(b == false);
                    this.useProductName.getElement().setChecked(b == false);
                    break;
                }
                case "productName": {
                    this.useAISName.getElement().setChecked(b == false);
                    this.useProductLabelName.getElement().setChecked(b);
                    this.useProductName.getElement().setChecked(b == false);
                    break;
                }
                case "useproductname": {
                    this.useAISName.getElement().setChecked(b == false);
                    this.useProductLabelName.getElement().setChecked(b == false);
                    this.useProductName.getElement().setChecked(b);
                    break;
                }
                case "include_null": {
                    this.includeNullValues.getElement().setChecked(b);
                    break;
                }
                case "summarize_crew": {
                    this.summarizeCrew.getElement().setChecked(b);
                    break;
                }
                case "hide_ns_ds_flights": {
                    if (this.hideFlightFromToNSDS == null) break;
                    this.hideFlightFromToNSDS.getElement().setChecked(b);
                    break;
                }
                case "groupAdditional": {
                    if (this.groupAdditional == null) break;
                    this.groupAdditional.getElement().setChecked(b);
                    break;
                }
                case "excludeZeroPax": {
                    if (this.excludeZeroPax == null) break;
                    this.excludeZeroPax.getElement().setChecked(b);
                    break;
                }
                case "showAdditionalSeparately": {
                    if (this.showAdditionalSeparately == null) break;
                    this.showAdditionalSeparately.getElement().setChecked(b);
                    break;
                }
                case "showSPMLsSeparately": {
                    if (this.showSpecialMealsSeparately == null) break;
                    this.showSpecialMealsSeparately.getElement().setChecked(b);
                    break;
                }
                case "showAllProducts": {
                    if (this.showAllProducts == null) break;
                    this.showAllProducts.getElement().setChecked(b);
                    break;
                }
                case "showSobOnly": {
                    if (this.showSobProductsOnly == null) break;
                    this.showSobProductsOnly.getElement().setChecked(b);
                    break;
                }
                case "showNonSobOnly": {
                    if (this.showNoSobProductsOnly == null) break;
                    this.showNoSobProductsOnly.getElement().setChecked(b);
                    break;
                }
                case "printAll": {
                    if (this.printAll == null) break;
                    this.printAll.getElement().setChecked(b);
                    break;
                }
                case "printTitlePageOnly": {
                    if (this.printTitlePageOnly == null) break;
                    this.printTitlePageOnly.getElement().setChecked(b);
                    break;
                }
                case "printWithoutTitlePage": {
                    if (this.printWithoutTitlePage == null) break;
                    this.printWithoutTitlePage.getElement().setChecked(b);
                    break;
                }
                case "finalizeFlight": {
                    if (this.finalizeFlight == null) break;
                    this.finalizeFlight.getElement().setChecked(b);
                    break;
                }
                case "sortByNumber": {
                    if (this.sortProductsByNumber == null) break;
                    this.sortProductsByNumber.getElement().setChecked(b);
                    break;
                }
                case "includePaxUpdate": {
                    if (this.includePaxUpdate == null) break;
                    this.includePaxUpdate.getElement().setChecked(b);
                    break;
                }
                case "printProducesText": {
                    this.printProducesText.getElement().setChecked(b);
                    break;
                }
                case "printIngredientListInfo": {
                    this.printIngredientListInfo.getElement().setChecked(b);
                }
            }
        }
        this.setEnabled(this.isEnabled());
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        if (this.quantityBased != null) {
            conf.addProperty(CASH_CONFIG_NAME, "" + !this.quantityBased.getElement().isChecked());
        }
        conf.addProperty(AIS_NAME, "" + this.useAISName.getElement().isChecked());
        conf.addProperty(NUMBER_CONFIG_NAME, "" + this.useCATITNo.getElement().isChecked());
        conf.addProperty(STANDARD_CONFIG_NAME, "" + this.includeStandard.getElement().isChecked());
        conf.addProperty(ARTICLES_CONFIG_NAME, "" + this.includeArticles.getElement().isChecked());
        conf.addProperty(HANDLING_CONFIG_NAME, "" + this.includeHandling.getElement().isChecked());
        conf.addProperty(DRAWER_CONFIG_NAME, "" + this.includeDrawersCount.getElement().isChecked());
        conf.addProperty(TEMPERATURE_CONFIG_NAME, "" + this.includeTemperature.getElement().isChecked());
        conf.addProperty(SEALS_CONFIG_NAME, "" + this.includeSeals.getElement().isChecked());
        conf.addProperty(AIS_CONFIG, "" + this.includeAIS.getElement().isChecked());
        conf.addProperty(CREW_PAX_CONFIG_NAME, "" + this.includeCrewPax.getElement().isChecked());
        conf.addProperty(INCLUDE_NULL_CONFIG_NAME, "" + this.includeNullValues.getElement().isChecked());
        conf.addProperty(SUMMARIZE_CREW, "" + this.summarizeCrew.getElement().isChecked());
        conf.addProperty(GROUP_ADDITIONALS, "" + this.groupAdditional.getElement().isChecked());
        conf.addProperty(EXCLUDE_ZERO_PAX_, "" + this.excludeZeroPax.getElement().isChecked());
        conf.addProperty(SHOW_ADDITIONALS_SEPARATELY, "" + this.showAdditionalSeparately.getElement().isChecked());
        conf.addProperty(SHOW_SPMLS_SEPARATELY, "" + this.showSpecialMealsSeparately.getElement().isChecked());
        conf.addProperty(SHOW_ALL_PRODUCTS, "" + this.showAllProducts.getElement().isChecked());
        conf.addProperty(SHOW_SOB_ONLY, "" + this.showSobProductsOnly.getElement().isChecked());
        conf.addProperty(SHOW_NON_SOB_ONLY, "" + this.showNoSobProductsOnly.getElement().isChecked());
        conf.addProperty(PRINT_ALL, "" + this.printAll.getElement().isChecked());
        conf.addProperty(PRINT_TITLEPAGE_ONLY, "" + this.printTitlePageOnly.getElement().isChecked());
        conf.addProperty(PRINT_WITHOUT_TITLEPAGE, "" + this.printWithoutTitlePage.getElement().isChecked());
        if (this.finalizeFlight != null) {
            conf.addProperty(FINALIZE_FLIGHT, "" + this.finalizeFlight.getElement().isChecked());
        }
        if (this.hideFlightFromToNSDS != null) {
            conf.addProperty(HIDE_NS_DS_FLIGHTS, "" + this.hideFlightFromToNSDS.getElement().isChecked());
        }
        if (this.sendDeliverySlip != null) {
            conf.addProperty("sendDeliverySlip", "" + this.sendDeliverySlip.getElement().isChecked());
        }
        conf.addProperty("sortByNumber", "" + this.sortProductsByNumber.getElement().isChecked());
        conf.addProperty("includePaxUpdate", "" + this.includePaxUpdate.getElement().isChecked());
        conf.addProperty(PRINT_PRODUCES_TEXT_TYPE, "" + this.printProducesText.getElement().isChecked());
        conf.addProperty(PRINT_INGREDIENT_LIST_INFO_TYPE, "" + this.printIngredientListInfo.getElement().isChecked());
        return conf;
    }

    @Override
    public String getTitleString() {
        return WordsToolkit.toUpperCase((String)Words.DELIVERY_SLIP_SHEET);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[16];
        o[2] = this.includeArticles.getElement().isChecked();
        o[3] = this.includeDrawersCount.getElement().isChecked();
        o[4] = true;
        o[5] = this.includeTemperature.getElement().isChecked();
        o[6] = this.includeSeals.getElement().isChecked();
        o[7] = this.includeHandling.getElement().isChecked();
        o[8] = this.includeStandard.getElement().isChecked();
        o[9] = this.useCATITNo.getElement().isChecked();
        o[10] = this.includeCrewPax.getElement().isChecked();
        o[11] = this.includeNullValues.getElement().isChecked();
        o[12] = this.summarizeCrew.getElement().isChecked();
        o[13] = this.groupAdditional.getElement().isChecked();
        o[14] = this.printProducesText.getElement().isChecked();
        o[15] = this.printIngredientListInfo.getElement().isChecked();
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.sendDeliverySlip != null) {
            this.sendDeliverySlip.kill();
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.finalizeFlight != null) {
            this.finalizeFlight.kill();
        }
        if (this.includeStandard != null) {
            this.includeStandard.kill();
        }
        if (this.includeArticles != null) {
            this.includeArticles.kill();
        }
        if (this.includeTemperature != null) {
            this.includeTemperature.kill();
        }
        if (this.includeSeals != null) {
            this.includeSeals.kill();
        }
        if (this.sortProductsByNumber != null) {
            this.sortProductsByNumber.kill();
        }
        if (this.includeAIS != null) {
            this.includeAIS.kill();
        }
        if (this.dateChooser != null) {
            this.dateChooser.kill();
        }
        if (this.paxCount != null) {
            this.paxCount.kill();
        }
        if (this.infoLabel != null) {
            this.infoLabel.kill();
        }
        this.infoLabel = null;
        if (this.showAllProducts != null) {
            this.showAllProducts.kill();
        }
        this.showAllProducts = null;
        if (this.showSobProductsOnly != null) {
            this.showSobProductsOnly.kill();
        }
        this.showSobProductsOnly = null;
        if (this.showNoSobProductsOnly != null) {
            this.showNoSobProductsOnly.kill();
        }
        this.showNoSobProductsOnly = null;
        if (this.includeHandling != null) {
            this.includeHandling.kill();
        }
        if (this.includePaxUpdate != null) {
            this.includePaxUpdate.kill();
        }
        this.includePaxUpdate = null;
        this.includeHandling = null;
        this.paxCount = null;
        if (this.cashBased != null) {
            this.cashBased.kill();
        }
        if (this.quantityBased != null) {
            this.quantityBased.kill();
        }
        if (this.includeDrawersCount != null) {
            this.includeDrawersCount.kill();
        }
        if (this.useCATITNo != null) {
            this.useCATITNo.kill();
        }
        this.useCATITNo = null;
        if (this.useCustomerNo != null) {
            this.useCustomerNo.kill();
        }
        this.useCustomerNo = null;
        if (this.useAISName != null) {
            this.useAISName.kill();
        }
        this.useAISName = null;
        if (this.useProductLabelName != null) {
            this.useProductLabelName.kill();
        }
        this.useProductLabelName = null;
        if (this.useProductName != null) {
            this.useProductName.kill();
        }
        this.useProductName = null;
        if (this.excludeZeroPax != null) {
            this.excludeZeroPax.kill();
        }
        this.excludeZeroPax = null;
        if (this.includeCrewPax != null) {
            this.includeCrewPax.kill();
        }
        this.includeCrewPax = null;
        if (this.includeNullValues != null) {
            this.includeNullValues.kill();
        }
        this.includeNullValues = null;
        if (this.summarizeCrew != null) {
            this.summarizeCrew.kill();
        }
        this.summarizeCrew = null;
        if (this.groupAdditional != null) {
            this.groupAdditional.kill();
        }
        this.groupAdditional = null;
        if (this.showAdditionalSeparately != null) {
            this.showAdditionalSeparately.kill();
        }
        this.showAdditionalSeparately = null;
        if (this.showSpecialMealsSeparately != null) {
            this.showSpecialMealsSeparately.kill();
        }
        this.showSpecialMealsSeparately = null;
        if (this.hideFlightFromToNSDS != null) {
            this.hideFlightFromToNSDS.kill();
        }
        this.hideFlightFromToNSDS = null;
        if (this.printProducesText != null) {
            this.printProducesText.kill();
        }
        this.printProducesText = null;
        if (this.printIngredientListInfo != null) {
            this.printIngredientListInfo.kill();
        }
        this.printIngredientListInfo = null;
        this.printOptionTitle = null;
        this.finalizeFlight = null;
        this.includeDrawersCount = null;
        this.includeSeals = null;
        this.cashBased = null;
        this.includeStandard = null;
        this.includeArticles = null;
        this.quantityBased = null;
        this.includeAIS = null;
        this.sortProductsByNumber = null;
        this.dateChooser = null;
        if (this.printAll != null) {
            this.printAll.kill();
        }
        if (this.printTitlePageOnly != null) {
            this.printTitlePageOnly.kill();
        }
        if (this.printWithoutTitlePage != null) {
            this.printWithoutTitlePage.kill();
        }
        this.sendDeliverySlip = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.sendDeliverySlip != null) {
            this.sendDeliverySlip.setVisible(true);
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.quantityBased != null) {
            this.quantityBased.setVisible(true);
        }
        if (this.cashBased != null) {
            this.cashBased.setVisible(true);
        }
        if (this.useCATITNo != null) {
            this.useCATITNo.setVisible(true);
        }
        if (this.useCustomerNo != null) {
            this.useCustomerNo.setVisible(true);
        }
        if (this.useAISName != null) {
            this.useAISName.setVisible(true);
        }
        if (this.sortProductsByNumber != null) {
            this.sortProductsByNumber.setVisible(true);
        }
        if (this.useProductLabelName != null) {
            this.useProductLabelName.setVisible(true);
        }
        if (this.useProductName != null) {
            this.useProductName.setVisible(true);
        }
        if (this.includePaxUpdate != null) {
            this.includePaxUpdate.setVisible(true);
        }
        if (this.finalizeFlight != null) {
            this.finalizeFlight.setVisible(true);
        }
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(true);
        }
        if (this.paxCount != null) {
            this.paxCount.setVisible(true);
        }
        if (this.includeArticles != null) {
            this.includeArticles.setVisible(true);
        }
        if (this.includeStandard != null) {
            this.includeStandard.setVisible(true);
        }
        if (this.includeDrawersCount != null) {
            this.includeDrawersCount.setVisible(true);
        }
        if (this.includeTemperature != null) {
            this.includeTemperature.setVisible(true);
        }
        if (this.includeSeals != null) {
            this.includeSeals.setVisible(true);
        }
        if (this.includeAIS != null) {
            this.includeAIS.setVisible(true);
        }
        if (this.groupAdditional != null) {
            this.groupAdditional.setVisible(true);
        }
        if (this.showAdditionalSeparately != null) {
            this.showAdditionalSeparately.setVisible(true);
        }
        if (this.showSpecialMealsSeparately != null) {
            this.showSpecialMealsSeparately.setVisible(true);
        }
        if (this.includeHandling != null) {
            this.includeHandling.setVisible(true);
        }
        if (this.excludeZeroPax != null) {
            this.excludeZeroPax.setVisible(true);
        }
        if (this.includeCrewPax != null) {
            this.includeCrewPax.setVisible(true);
        }
        if (this.summarizeCrew != null) {
            this.summarizeCrew.setVisible(true);
        }
        if (this.infoLabel != null) {
            this.infoLabel.setVisible(true);
        }
        if (this.includeNullValues != null) {
            this.includeNullValues.setVisible(true);
        }
        if (this.hideFlightFromToNSDS != null) {
            this.hideFlightFromToNSDS.setVisible(true);
        }
        if (this.showAllProducts != null) {
            this.showAllProducts.setVisible(true);
        }
        if (this.showSobProductsOnly != null) {
            this.showSobProductsOnly.setVisible(true);
        }
        if (this.showNoSobProductsOnly != null) {
            this.showNoSobProductsOnly.setVisible(true);
        }
        if (this.printAll != null) {
            this.printAll.setVisible(true);
        }
        if (this.printTitlePageOnly != null) {
            this.printTitlePageOnly.setVisible(true);
        }
        if (this.printWithoutTitlePage != null) {
            this.printWithoutTitlePage.setVisible(true);
        }
        if (this.printProducesText != null) {
            this.printProducesText.setVisible(true);
        }
        if (this.printIngredientListInfo != null) {
            this.printIngredientListInfo.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.sendDeliverySlip != null) {
            this.sendDeliverySlip.setVisible(false);
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.quantityBased != null) {
            this.quantityBased.setVisible(false);
        }
        if (this.includePaxUpdate != null) {
            this.includePaxUpdate.setVisible(true);
        }
        if (this.cashBased != null) {
            this.cashBased.setVisible(false);
        }
        if (this.sortProductsByNumber != null) {
            this.sortProductsByNumber.setVisible(false);
        }
        if (this.useCATITNo != null) {
            this.useCATITNo.setVisible(false);
        }
        if (this.useCustomerNo != null) {
            this.useCustomerNo.setVisible(false);
        }
        if (this.useAISName != null) {
            this.useAISName.setVisible(false);
        }
        if (this.useProductLabelName != null) {
            this.useProductLabelName.setVisible(false);
        }
        if (this.useProductName != null) {
            this.useProductName.setVisible(false);
        }
        if (this.finalizeFlight != null) {
            this.finalizeFlight.setVisible(false);
        }
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(false);
        }
        if (this.paxCount != null) {
            this.paxCount.setVisible(false);
        }
        if (this.includeArticles != null) {
            this.includeArticles.setVisible(false);
        }
        if (this.includeStandard != null) {
            this.includeStandard.setVisible(false);
        }
        if (this.includeDrawersCount != null) {
            this.includeDrawersCount.setVisible(false);
        }
        if (this.includeTemperature != null) {
            this.includeTemperature.setVisible(false);
        }
        if (this.includeSeals != null) {
            this.includeSeals.setVisible(false);
        }
        if (this.includeAIS != null) {
            this.includeAIS.setVisible(false);
        }
        if (this.groupAdditional != null) {
            this.groupAdditional.setVisible(false);
        }
        if (this.showAdditionalSeparately != null) {
            this.showAdditionalSeparately.setVisible(false);
        }
        if (this.showSpecialMealsSeparately != null) {
            this.showSpecialMealsSeparately.setVisible(false);
        }
        if (this.includeHandling != null) {
            this.includeHandling.setVisible(false);
        }
        if (this.excludeZeroPax != null) {
            this.excludeZeroPax.setVisible(false);
        }
        if (this.includeCrewPax != null) {
            this.includeCrewPax.setVisible(false);
        }
        if (this.summarizeCrew != null) {
            this.summarizeCrew.setVisible(false);
        }
        if (this.infoLabel != null) {
            this.infoLabel.setVisible(false);
        }
        if (this.includeNullValues != null) {
            this.includeNullValues.setVisible(false);
        }
        if (this.hideFlightFromToNSDS != null) {
            this.hideFlightFromToNSDS.setVisible(false);
        }
        if (this.showAllProducts != null) {
            this.showAllProducts.setVisible(false);
        }
        if (this.showSobProductsOnly != null) {
            this.showSobProductsOnly.setVisible(false);
        }
        if (this.showNoSobProductsOnly != null) {
            this.showNoSobProductsOnly.setVisible(false);
        }
        if (this.printAll != null) {
            this.printAll.setVisible(false);
        }
        if (this.printTitlePageOnly != null) {
            this.printTitlePageOnly.setVisible(false);
        }
        if (this.printWithoutTitlePage != null) {
            this.printWithoutTitlePage.setVisible(false);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> a;
        List<ScreenValidationObject> b;
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        if (this.paxCount != null && (b = this.paxCount.getElement().validatePaxTable()) != null) {
            l.addAll(b);
        }
        if ((a = super.validateBeforePrint()) != null) {
            l.addAll(a);
        }
        return l;
    }

    public void getConfig(DeliverySlipReportConfiguration<?, L> config) {
        config.setUseLabelNames(Boolean.valueOf(true));
        if (this.cashBased != null) {
            config.setCashDeliverySlip(Boolean.valueOf(this.cashBased.getElement().isChecked()));
        } else {
            config.setCashDeliverySlip(Boolean.valueOf(false));
        }
        config.setIncludeNullValues(Boolean.valueOf(this.includeNullValues.getElement().isChecked()));
        config.setIncludeArticles(Boolean.valueOf(this.includeArticles.getElement().isChecked()));
        config.setIncludeDrawers(Boolean.valueOf(this.includeDrawersCount.getElement().isChecked()));
        config.setIncludeTemperature(Boolean.valueOf(this.includeTemperature.getElement().isChecked()));
        config.setIncludeSeals(Boolean.valueOf(this.includeSeals.getElement().isChecked()));
        config.setIncludeAIS(Boolean.valueOf(this.includeAIS.getElement().isChecked()));
        config.setIncludeHandlings(Boolean.valueOf(this.includeHandling.getElement().isChecked()));
        config.setIncludeStandard(Boolean.valueOf(this.includeStandard.getElement().isChecked()));
        config.setUseCATITProductNo(Boolean.valueOf(this.useCATITNo.getElement().isChecked()));
        config.setIncludeCrewClasses(Boolean.valueOf(this.includeCrewPax.getElement().isChecked()));
        config.setSummarizeCrew(Boolean.valueOf(this.summarizeCrew.getElement().isChecked()));
        config.setGroupAdditionals(Boolean.valueOf(this.groupAdditional.getElement().isChecked()));
        config.setIncludePaxUpdateField(Boolean.valueOf(this.includePaxUpdate.getElement().isChecked()));
        config.setShowAdditionalSeparately(Boolean.valueOf(this.showAdditionalSeparately.getElement().isChecked()));
        config.setShowSpecialMealSeparately(Boolean.valueOf(this.showSpecialMealsSeparately.getElement().isChecked()));
        config.setExcludeZeroPax(Boolean.valueOf(this.excludeZeroPax.getElement().isChecked()));
        config.setUseLabelNames(Boolean.valueOf(this.useProductLabelName.getElement().isChecked()));
        config.setSortByNumber(Boolean.valueOf(this.sortProductsByNumber.getElement().isChecked()));
        config.setUseName(Boolean.valueOf(this.useProductName.getElement().isChecked()));
        config.setPrintProducesText(Boolean.valueOf(this.printProducesText.getElement().isChecked()));
        config.setPrintIngredientListInfo(Boolean.valueOf(this.printIngredientListInfo.getElement().isChecked()));
        config.setSendDeliverySlip(Boolean.valueOf(this.sendDeliverySlip != null ? this.sendDeliverySlip.getElement().isChecked() : false));
        if (this.hideFlightFromToNSDS != null) {
            config.setHideFlightFromToNSDS(Boolean.valueOf(this.hideFlightFromToNSDS.getElement().isChecked()));
        }
        if (this.showSobState) {
            if (this.showAllProducts.getElement().isChecked()) {
                config.setSobState(SalesOnBoardReportStateE.ALL);
            } else if (this.showSobProductsOnly.getElement().isChecked()) {
                config.setSobState(SalesOnBoardReportStateE.ONLY_SOB_PRODUCTS);
            } else if (this.showNoSobProductsOnly.getElement().isChecked()) {
                config.setSobState(SalesOnBoardReportStateE.NO_SOB_PRODUCTS);
            }
        } else {
            config.setSobState(SalesOnBoardReportStateE.ALL);
        }
        if (this.printAll.getElement().isChecked()) {
            config.setPrintTitlepage(Boolean.valueOf(true));
            config.setPrintBody(Boolean.valueOf(true));
        } else if (this.printTitlePageOnly.getElement().isChecked()) {
            config.setPrintTitlepage(Boolean.valueOf(true));
            config.setPrintBody(Boolean.valueOf(false));
        } else if (this.printWithoutTitlePage.getElement().isChecked()) {
            config.setPrintTitlepage(Boolean.valueOf(false));
            config.setPrintBody(Boolean.valueOf(true));
        }
        if (this.finalizeFlight != null) {
            config.setFinalizeFlight(Boolean.valueOf(this.finalizeFlight.getElement().isChecked()));
        }
        config.setPrintProducesText(Boolean.valueOf(this.printProducesText.getElement().isChecked()));
        config.setPrintIngredientListInfo(Boolean.valueOf(this.printIngredientListInfo.getElement().isChecked()));
    }

    @Override
    public BatchJob<T> createBatchJob(Node<T> value, ThreadSafeExecutable job) {
        return new FlightPrintBatch<T>(job, value, this.getPrintProcessor(), false);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintDeliverySlipComponent.this.layoutInheritedComponents(parent);
            y += PrintDeliverySlipComponent.this.border;
            if (PrintDeliverySlipComponent.this.printOptionTitle != null) {
                PrintDeliverySlipComponent.this.printOptionTitle.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.printOptionTitle.getY() + PrintDeliverySlipComponent.this.printOptionTitle.getHeight() + PrintDeliverySlipComponent.this.border / 2;
            }
            if (PrintDeliverySlipComponent.this.printAll != null) {
                PrintDeliverySlipComponent.this.printAll.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.printAll.setSize(parent.getWidth() - (PrintDeliverySlipComponent.this.printAll.getX() + PrintDeliverySlipComponent.this.border), (int)PrintDeliverySlipComponent.this.printAll.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.printAll.getY() + PrintDeliverySlipComponent.this.printAll.getHeight() + PrintDeliverySlipComponent.this.border / 4;
                PrintDeliverySlipComponent.this.printTitlePageOnly.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.printTitlePageOnly.setSize(parent.getWidth() - (PrintDeliverySlipComponent.this.printTitlePageOnly.getX() + PrintDeliverySlipComponent.this.border), (int)PrintDeliverySlipComponent.this.printTitlePageOnly.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.printTitlePageOnly.getY() + PrintDeliverySlipComponent.this.printTitlePageOnly.getHeight() + PrintDeliverySlipComponent.this.border / 4;
                PrintDeliverySlipComponent.this.printWithoutTitlePage.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.printWithoutTitlePage.setSize(parent.getWidth() - (PrintDeliverySlipComponent.this.printWithoutTitlePage.getX() + PrintDeliverySlipComponent.this.border), (int)PrintDeliverySlipComponent.this.printWithoutTitlePage.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.printWithoutTitlePage.getY() + PrintDeliverySlipComponent.this.printWithoutTitlePage.getHeight() + PrintDeliverySlipComponent.this.border / 4;
            }
            y += PrintDeliverySlipComponent.this.border;
            if (PrintDeliverySlipComponent.this.quantityBased != null) {
                PrintDeliverySlipComponent.this.quantityBased.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.quantityBased.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.quantityBased.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.quantityBased.getY() + PrintDeliverySlipComponent.this.quantityBased.getHeight();
            }
            if (PrintDeliverySlipComponent.this.cashBased != null) {
                PrintDeliverySlipComponent.this.cashBased.setLocation(PrintDeliverySlipComponent.this.border, y += PrintDeliverySlipComponent.this.border / 4);
                PrintDeliverySlipComponent.this.cashBased.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.cashBased.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.cashBased.getY() + PrintDeliverySlipComponent.this.cashBased.getHeight();
            }
            y += PrintDeliverySlipComponent.this.border;
            if (PrintDeliverySlipComponent.this.sortProductsByNumber != null) {
                PrintDeliverySlipComponent.this.sortProductsByNumber.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.sortProductsByNumber.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.sortProductsByNumber.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.sortProductsByNumber.getY() + PrintDeliverySlipComponent.this.sortProductsByNumber.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.finalizeFlight != null) {
                PrintDeliverySlipComponent.this.finalizeFlight.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.finalizeFlight.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.finalizeFlight.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.finalizeFlight.getY() + PrintDeliverySlipComponent.this.finalizeFlight.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.sendDeliverySlip != null) {
                PrintDeliverySlipComponent.this.sendDeliverySlip.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.sendDeliverySlip.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.sendDeliverySlip.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.sendDeliverySlip.getY() + PrintDeliverySlipComponent.this.sendDeliverySlip.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.useCATITNo != null && PrintDeliverySlipComponent.this.useCustomerNo != null) {
                PrintDeliverySlipComponent.this.useCATITNo.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.useCATITNo.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.useCATITNo.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.useCATITNo.getY() + PrintDeliverySlipComponent.this.useCATITNo.getHeight() + PrintDeliverySlipComponent.this.border / 4;
                PrintDeliverySlipComponent.this.useCustomerNo.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.useCustomerNo.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.useCustomerNo.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.useCustomerNo.getY() + PrintDeliverySlipComponent.this.useCustomerNo.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.useAISName != null && PrintDeliverySlipComponent.this.useProductLabelName != null && PrintDeliverySlipComponent.this.useProductName != null) {
                PrintDeliverySlipComponent.this.useProductLabelName.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.useProductLabelName.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.useProductLabelName.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.useProductLabelName.getY() + PrintDeliverySlipComponent.this.useProductLabelName.getHeight() + PrintDeliverySlipComponent.this.border / 4;
                PrintDeliverySlipComponent.this.useAISName.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.useAISName.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.useAISName.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.useAISName.getY() + PrintDeliverySlipComponent.this.useAISName.getHeight() + PrintDeliverySlipComponent.this.border / 4;
                PrintDeliverySlipComponent.this.useProductName.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.useProductName.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.useProductName.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.useProductName.getY() + PrintDeliverySlipComponent.this.useProductName.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.includeStandard != null) {
                PrintDeliverySlipComponent.this.includeStandard.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.includeStandard.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.includeStandard.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.includeStandard.getY() + PrintDeliverySlipComponent.this.includeStandard.getHeight() + PrintDeliverySlipComponent.this.border / 4;
            }
            if (PrintDeliverySlipComponent.this.includeHandling != null) {
                PrintDeliverySlipComponent.this.includeHandling.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.includeHandling.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.includeHandling.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.includeHandling.getY() + PrintDeliverySlipComponent.this.includeHandling.getHeight() + PrintDeliverySlipComponent.this.border / 4;
            }
            if (PrintDeliverySlipComponent.this.includeArticles != null) {
                PrintDeliverySlipComponent.this.includeArticles.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.includeArticles.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.includeArticles.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.includeArticles.getY() + PrintDeliverySlipComponent.this.includeArticles.getHeight() + PrintDeliverySlipComponent.this.border / 4;
            }
            if (PrintDeliverySlipComponent.this.includeNullValues != null) {
                PrintDeliverySlipComponent.this.includeNullValues.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.includeNullValues.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.includeNullValues.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.includeNullValues.getY() + PrintDeliverySlipComponent.this.includeNullValues.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.includePaxUpdate != null) {
                PrintDeliverySlipComponent.this.includePaxUpdate.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.includePaxUpdate.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.includePaxUpdate.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.includePaxUpdate.getY() + PrintDeliverySlipComponent.this.includePaxUpdate.getHeight() + PrintDeliverySlipComponent.this.border / 4;
            }
            if (PrintDeliverySlipComponent.this.includeDrawersCount != null) {
                PrintDeliverySlipComponent.this.includeDrawersCount.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.includeDrawersCount.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.includeDrawersCount.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.includeDrawersCount.getY() + PrintDeliverySlipComponent.this.includeDrawersCount.getHeight() + PrintDeliverySlipComponent.this.border / 4;
            }
            if (PrintDeliverySlipComponent.this.includeTemperature != null) {
                PrintDeliverySlipComponent.this.includeTemperature.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.includeTemperature.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.includeTemperature.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.includeTemperature.getY() + PrintDeliverySlipComponent.this.includeTemperature.getHeight() + PrintDeliverySlipComponent.this.border / 4;
            }
            if (PrintDeliverySlipComponent.this.includeSeals != null) {
                PrintDeliverySlipComponent.this.includeSeals.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.includeSeals.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.includeSeals.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.includeSeals.getY() + PrintDeliverySlipComponent.this.includeSeals.getHeight() + PrintDeliverySlipComponent.this.border / 4;
            }
            if (PrintDeliverySlipComponent.this.includeAIS != null) {
                PrintDeliverySlipComponent.this.includeAIS.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.includeAIS.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.includeAIS.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.includeAIS.getY() + PrintDeliverySlipComponent.this.includeAIS.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.groupAdditional != null) {
                PrintDeliverySlipComponent.this.groupAdditional.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.groupAdditional.setSize(parent.getWidth() - (PrintDeliverySlipComponent.this.groupAdditional.getX() + PrintDeliverySlipComponent.this.border), (int)PrintDeliverySlipComponent.this.groupAdditional.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.groupAdditional.getY() + PrintDeliverySlipComponent.this.groupAdditional.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.printProducesText != null) {
                PrintDeliverySlipComponent.this.printProducesText.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.printProducesText.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.printProducesText.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.printProducesText.getY() + PrintDeliverySlipComponent.this.printProducesText.getHeight() + PrintDeliverySlipComponent.this.border / 4;
            }
            if (PrintDeliverySlipComponent.this.printIngredientListInfo != null) {
                PrintDeliverySlipComponent.this.printIngredientListInfo.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.printIngredientListInfo.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.printIngredientListInfo.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.printIngredientListInfo.getY() + PrintDeliverySlipComponent.this.printIngredientListInfo.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.showAdditionalSeparately != null) {
                PrintDeliverySlipComponent.this.showAdditionalSeparately.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.showAdditionalSeparately.setSize(parent.getWidth() - (PrintDeliverySlipComponent.this.showAdditionalSeparately.getX() + PrintDeliverySlipComponent.this.border), (int)PrintDeliverySlipComponent.this.showAdditionalSeparately.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.showAdditionalSeparately.getY() + PrintDeliverySlipComponent.this.showAdditionalSeparately.getHeight() + PrintDeliverySlipComponent.this.border / 4;
            }
            if (PrintDeliverySlipComponent.this.showSpecialMealsSeparately != null) {
                PrintDeliverySlipComponent.this.showSpecialMealsSeparately.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.showSpecialMealsSeparately.setSize(parent.getWidth() - (PrintDeliverySlipComponent.this.showSpecialMealsSeparately.getX() + PrintDeliverySlipComponent.this.border), (int)PrintDeliverySlipComponent.this.showSpecialMealsSeparately.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.showSpecialMealsSeparately.getY() + PrintDeliverySlipComponent.this.showSpecialMealsSeparately.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.excludeZeroPax != null) {
                PrintDeliverySlipComponent.this.excludeZeroPax.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.excludeZeroPax.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.excludeZeroPax.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.excludeZeroPax.getY() + PrintDeliverySlipComponent.this.excludeZeroPax.getHeight() + PrintDeliverySlipComponent.this.border / 4;
            }
            if (PrintDeliverySlipComponent.this.includeCrewPax != null) {
                PrintDeliverySlipComponent.this.includeCrewPax.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.includeCrewPax.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.includeCrewPax.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.includeCrewPax.getY() + PrintDeliverySlipComponent.this.includeCrewPax.getHeight() + PrintDeliverySlipComponent.this.border / 4;
            }
            if (PrintDeliverySlipComponent.this.includeCrewPax != null) {
                PrintDeliverySlipComponent.this.summarizeCrew.setLocation(PrintDeliverySlipComponent.this.border + PrintDeliverySlipComponent.this.includeCrewPax.getElement().getWidth() + PrintDeliverySlipComponent.this.includeCrewPax.getInnerGap(), y);
                PrintDeliverySlipComponent.this.summarizeCrew.setSize(parent.getWidth() - (PrintDeliverySlipComponent.this.summarizeCrew.getX() + PrintDeliverySlipComponent.this.border), (int)PrintDeliverySlipComponent.this.summarizeCrew.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.summarizeCrew.getY() + PrintDeliverySlipComponent.this.summarizeCrew.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.hideFlightFromToNSDS != null) {
                PrintDeliverySlipComponent.this.hideFlightFromToNSDS.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.hideFlightFromToNSDS.setSize(parent.getWidth() - (PrintDeliverySlipComponent.this.hideFlightFromToNSDS.getX() + PrintDeliverySlipComponent.this.border), (int)PrintDeliverySlipComponent.this.hideFlightFromToNSDS.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.hideFlightFromToNSDS.getY() + PrintDeliverySlipComponent.this.hideFlightFromToNSDS.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.showSobState && PrintDeliverySlipComponent.this.showAllProducts != null) {
                PrintDeliverySlipComponent.this.showAllProducts.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.showAllProducts.setSize(parent.getWidth() - (PrintDeliverySlipComponent.this.showAllProducts.getX() + PrintDeliverySlipComponent.this.border), (int)PrintDeliverySlipComponent.this.showAllProducts.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.showAllProducts.getY() + PrintDeliverySlipComponent.this.showAllProducts.getHeight() + PrintDeliverySlipComponent.this.border / 4;
                PrintDeliverySlipComponent.this.showSobProductsOnly.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.showSobProductsOnly.setSize(parent.getWidth() - (PrintDeliverySlipComponent.this.showSobProductsOnly.getX() + PrintDeliverySlipComponent.this.border), (int)PrintDeliverySlipComponent.this.showSobProductsOnly.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.showSobProductsOnly.getY() + PrintDeliverySlipComponent.this.showSobProductsOnly.getHeight() + PrintDeliverySlipComponent.this.border / 4;
                PrintDeliverySlipComponent.this.showNoSobProductsOnly.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.showNoSobProductsOnly.setSize(parent.getWidth() - (PrintDeliverySlipComponent.this.showNoSobProductsOnly.getX() + PrintDeliverySlipComponent.this.border), (int)PrintDeliverySlipComponent.this.showNoSobProductsOnly.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.showNoSobProductsOnly.getY() + PrintDeliverySlipComponent.this.showNoSobProductsOnly.getHeight() + PrintDeliverySlipComponent.this.border / 2;
            }
            if (PrintDeliverySlipComponent.this.infoLabel != null) {
                PrintDeliverySlipComponent.this.infoLabel.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.infoLabel.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.infoLabel.getX(), (int)PrintDeliverySlipComponent.this.infoLabel.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.infoLabel.getY() + PrintDeliverySlipComponent.this.infoLabel.getHeight() + PrintDeliverySlipComponent.this.border / 2;
            }
            if (PrintDeliverySlipComponent.this.dateChooser != null) {
                PrintDeliverySlipComponent.this.dateChooser.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.dateChooser.setSize(PrintDeliverySlipComponent.this.dateChooser.getPreferredSize());
                y = PrintDeliverySlipComponent.this.dateChooser.getY() + PrintDeliverySlipComponent.this.dateChooser.getHeight() + PrintDeliverySlipComponent.this.border;
            }
            if (PrintDeliverySlipComponent.this.paxCount != null) {
                PrintDeliverySlipComponent.this.paxCount.setLocation(PrintDeliverySlipComponent.this.border, y);
                PrintDeliverySlipComponent.this.paxCount.setSize(parent.getWidth() - 2 * PrintDeliverySlipComponent.this.border, (int)PrintDeliverySlipComponent.this.paxCount.getPreferredSize().getHeight());
                y = PrintDeliverySlipComponent.this.paxCount.getY() + PrintDeliverySlipComponent.this.paxCount.getHeight() + PrintDeliverySlipComponent.this.border;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintDeliverySlipComponent.this.getInheritedComponentsHeight();
            if (PrintDeliverySlipComponent.this.animation != null) {
                return new Dimension(PrintDeliverySlipComponent.this.animation.getPreferredSize());
            }
            h += PrintDeliverySlipComponent.this.border;
            if (PrintDeliverySlipComponent.this.printOptionTitle != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.printOptionTitle.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 2)));
            }
            if (PrintDeliverySlipComponent.this.printAll != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.printAll.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
                h = (int)((double)h + (PrintDeliverySlipComponent.this.printTitlePageOnly.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
                h = (int)((double)h + (PrintDeliverySlipComponent.this.printWithoutTitlePage.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 2)));
            }
            if (PrintDeliverySlipComponent.this.quantityBased != null) {
                h = (int)((double)h + PrintDeliverySlipComponent.this.quantityBased.getPreferredSize().getHeight());
            }
            if (PrintDeliverySlipComponent.this.cashBased != null) {
                h = (int)((double)h + ((double)(PrintDeliverySlipComponent.this.border / 4) + PrintDeliverySlipComponent.this.cashBased.getPreferredSize().getHeight()));
            }
            h += PrintDeliverySlipComponent.this.border;
            if (PrintDeliverySlipComponent.this.useCATITNo != null && PrintDeliverySlipComponent.this.useCustomerNo != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.useCATITNo.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
                h = (int)((double)h + (PrintDeliverySlipComponent.this.useCustomerNo.getPreferredSize().getHeight() + (double)PrintDeliverySlipComponent.this.border));
            }
            if (PrintDeliverySlipComponent.this.useProductLabelName != null && PrintDeliverySlipComponent.this.useAISName != null && PrintDeliverySlipComponent.this.useProductName != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.useProductLabelName.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
                h = (int)((double)h + (PrintDeliverySlipComponent.this.useAISName.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
                h = (int)((double)h + (PrintDeliverySlipComponent.this.useProductName.getPreferredSize().getHeight() + (double)PrintDeliverySlipComponent.this.border));
            }
            if (PrintDeliverySlipComponent.this.sortProductsByNumber != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.sortProductsByNumber.getPreferredSize().getHeight() + (double)PrintDeliverySlipComponent.this.border));
            }
            if (PrintDeliverySlipComponent.this.finalizeFlight != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.finalizeFlight.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.sendDeliverySlip != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.sendDeliverySlip.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.includeStandard != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.includeStandard.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.includeHandling != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.includeHandling.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.includeArticles != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.includeArticles.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.includeNullValues != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.includeNullValues.getPreferredSize().getHeight() + (double)PrintDeliverySlipComponent.this.border));
            }
            if (PrintDeliverySlipComponent.this.includePaxUpdate != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.includePaxUpdate.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.includeDrawersCount != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.includeDrawersCount.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.includeTemperature != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.includeTemperature.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.includeSeals != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.includeSeals.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.includeAIS != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.includeAIS.getPreferredSize().getHeight() + (double)PrintDeliverySlipComponent.this.border));
            }
            if (PrintDeliverySlipComponent.this.groupAdditional != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.groupAdditional.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.showAdditionalSeparately != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.showAdditionalSeparately.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.showSpecialMealsSeparately != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.showSpecialMealsSeparately.getPreferredSize().getHeight() + (double)PrintDeliverySlipComponent.this.border));
            }
            if (PrintDeliverySlipComponent.this.excludeZeroPax != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.excludeZeroPax.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.includeCrewPax != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.includeCrewPax.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.summarizeCrew != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.summarizeCrew.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.hideFlightFromToNSDS != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.hideFlightFromToNSDS.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
            }
            if (PrintDeliverySlipComponent.this.showSobState && PrintDeliverySlipComponent.this.showAllProducts != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.showAllProducts.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
                h = (int)((double)h + (PrintDeliverySlipComponent.this.showSobProductsOnly.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 4)));
                h = (int)((double)h + (PrintDeliverySlipComponent.this.showNoSobProductsOnly.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 2)));
            }
            if (PrintDeliverySlipComponent.this.infoLabel != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.infoLabel.getPreferredSize().getHeight() + (double)(PrintDeliverySlipComponent.this.border / 2)));
            }
            if (PrintDeliverySlipComponent.this.dateChooser != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.dateChooser.getPreferredSize().getHeight() + (double)PrintDeliverySlipComponent.this.border));
            }
            if (PrintDeliverySlipComponent.this.paxCount != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.paxCount.getPreferredSize().getHeight() + (double)PrintDeliverySlipComponent.this.border));
            }
            if (PrintDeliverySlipComponent.this.printProducesText != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.printProducesText.getPreferredSize().getHeight() + (double)PrintDeliverySlipComponent.this.border));
            }
            if (PrintDeliverySlipComponent.this.printIngredientListInfo != null) {
                h = (int)((double)h + (PrintDeliverySlipComponent.this.printIngredientListInfo.getPreferredSize().getHeight() + (double)PrintDeliverySlipComponent.this.border));
            }
            return new Dimension(0, h);
        }
    }
}

