/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.store.actualstock;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StockReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.StockReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class PrintActualStockSheetComponent
extends DefaultScrollablePrintPopup2<StoreLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> bonded;
    private Node<StoreLight> node;
    private TitledItem<CheckBox> printCustomerNo;
    private TitledItem<SearchTextField2<CustomerLight>> customerSearchField;
    private TitledItem<ComboBox> sortBy;
    private TitledItem<CheckBox> includeZeroStockItems;
    private TitledItem<DateTimeChooser> dueDateStore;
    private Node<StockReportConfiguration> configNode;

    public PrintActualStockSheetComponent(Node<StoreLight> node) {
        super(false, true, false, ReportTypeE.ACTUAL_STOCK_SHEET);
        this.node = node;
        StockReportConfiguration config = new StockReportConfiguration();
        config.setFormat(ReportingOutputFormatE.PDF);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.bonded.setEnabled(isEnabled);
        this.printCustomerNo.setEnabled(false);
        this.customerSearchField.setEnabled(isEnabled);
        this.sortBy.setEnabled(isEnabled);
        this.includeZeroStockItems.setEnabled(isEnabled);
        this.dueDateStore.setEnabled(false);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.bonded.setVisible(false);
        this.printCustomerNo.setVisible(false);
        this.customerSearchField.setVisible(false);
        this.sortBy.setVisible(false);
        this.includeZeroStockItems.setVisible(false);
        this.dueDateStore.setVisible(false);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.bonded != null) {
            this.bonded.kill();
        }
        if (this.printCustomerNo != null) {
            this.printCustomerNo.kill();
        }
        if (this.customerSearchField != null) {
            this.customerSearchField.kill();
        }
        if (this.sortBy != null) {
            this.sortBy.kill();
        }
        if (this.includeZeroStockItems != null) {
            this.includeZeroStockItems.kill();
        }
        if (this.dueDateStore != null) {
            this.dueDateStore.kill();
        }
        this.bonded = null;
        this.printCustomerNo = null;
        this.customerSearchField = null;
        this.sortBy = null;
        this.includeZeroStockItems = null;
        this.dueDateStore = null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.dueDateStore = new TitledItem<DateTimeChooser>(new DateTimeChooser((Node<Timestamp>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new Timestamp(System.currentTimeMillis()), false, false)), Words.DUE_DATE_ONLY_EXCEL, TitledItem.TitledItemOrientation.NORTH);
        if (this.asPDF != null && ((RadioButton)this.asPDF.getElement()).isChecked()) {
            this.dueDateStore.getElement().setEnabled(false);
        }
        if (this.asXLS != null && ((RadioButton)this.asXLS.getElement()).isChecked()) {
            this.dueDateStore.getElement().setEnabled(true);
        }
        this.printCustomerNo = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(StockReportConfiguration_.includeCustomerData)), Words.INCLUDE_CUSTOMER_DATA, TitledItem.TitledItemOrientation.EAST);
        this.printCustomerNo.getElement().setChecked(true);
        this.bonded = new TitledItem<ComboBox>(new ComboBox(this.configNode.getChildNamed(StockReportConfiguration_.bonded), NodeToolkit.getAffixList(BondedStateE.class), ConverterRegistry.getConverter(BondedStateEConverter.class)), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
        this.customerSearchField = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, this.configNode.getChildNamed(StockReportConfiguration_.customer)), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.customerSearchField.setProgress(1.0f);
        this.sortBy = new TitledItem<ComboBox>(new ComboBox(), Words.SORT_BY, TitledItem.TitledItemOrientation.WEST);
        this.sortBy.getElement().addItem(Words.ARTICLE_NUMBER);
        this.sortBy.getElement().addItem(Words.ARTICLE_NAME);
        this.sortBy.getElement().addItem(Words.CUSTOMER_ARTICLE_NUMBER);
        this.sortBy.setIgnorePrefWidth(true);
        this.includeZeroStockItems = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(StockReportConfiguration_.includeZeroStockItems)), Words.INCLUDE_ZERO_STOCK_ITEMS, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.printCustomerNo);
        this.getViewContainer().add(this.bonded);
        this.getViewContainer().add(this.customerSearchField);
        this.getViewContainer().add(this.sortBy);
        this.getViewContainer().add(this.includeZeroStockItems);
        this.getViewContainer().add(this.dueDateStore);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.box != null) {
            CheckedListAdder.addToList(a, this.box);
            if (this.asPDF != null && ((RadioButton)this.asPDF.getElement()).isChecked()) {
                this.dueDateStore.getElement().setEnabled(false);
            }
            if (this.asXLS != null && ((RadioButton)this.asXLS.getElement()).isChecked()) {
                this.dueDateStore.getElement().setEnabled(true);
            }
        }
        return a;
    }

    @Override
    public String getTitleString() {
        return Words.STORE;
    }

    @Override
    public String getTitleValue() {
        return ((StoreLight)this.node.getValue()).getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintActualStockSheetComponent.this.getSelectedReport();
                PrintActualStockSheetComponent.this.configNode.commit();
                StockReportConfiguration config = (StockReportConfiguration)PrintActualStockSheetComponent.this.configNode.getValue();
                config.getIncludedStores().add(new StoreReference(((StoreLight)PrintActualStockSheetComponent.this.node.getValue()).getId()));
                config.setStylesheet(file);
                config.setTitle2(Words.ACTUAL_STOCK_SHEET);
                if (PrintActualStockSheetComponent.this.asXLS != null && ((RadioButton)PrintActualStockSheetComponent.this.asXLS.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                    if (((DateTimeChooser)PrintActualStockSheetComponent.this.dueDateStore.getElement()).getNode().getValue() instanceof Timestamp) {
                        Timestamp ts = (Timestamp)((DateTimeChooser)PrintActualStockSheetComponent.this.dueDateStore.getElement()).getNode().getValue();
                        config.setDueDateStore(new Date(ts.getTime()));
                    } else if (((DateTimeChooser)PrintActualStockSheetComponent.this.dueDateStore.getElement()).getNode().getValue() instanceof Date) {
                        config.setDueDateStore((Date)((DateTimeChooser)PrintActualStockSheetComponent.this.dueDateStore.getElement()).getNode().getValue());
                    }
                } else {
                    config.setFormat(ReportingOutputFormatE.PDF);
                }
                if (((ComboBox)PrintActualStockSheetComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.ARTICLE_NAME)) {
                    config.setSortByArticleName(Boolean.valueOf(true));
                    config.setSortByArticleNumber(Boolean.valueOf(false));
                    config.setSortByCustomerNumber(Boolean.valueOf(false));
                } else if (((ComboBox)PrintActualStockSheetComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.ARTICLE_NUMBER)) {
                    config.setSortByArticleName(Boolean.valueOf(false));
                    config.setSortByArticleNumber(Boolean.valueOf(true));
                    config.setSortByCustomerNumber(Boolean.valueOf(false));
                } else if (((ComboBox)PrintActualStockSheetComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.CUSTOMER_ARTICLE_NUMBER)) {
                    config.setSortByArticleName(Boolean.valueOf(false));
                    config.setSortByArticleNumber(Boolean.valueOf(false));
                    config.setSortByCustomerNumber(Boolean.valueOf(true));
                }
                config.setIncludeCustomerArticle(Boolean.valueOf(true));
                config.setIncludeArticleSupplierNumber(Boolean.valueOf(false));
                config.setEmptySheet(Boolean.valueOf(false));
                PegasusFileComplete t = PrintActualStockSheetComponent.this.asXLS != null && ((RadioButton)PrintActualStockSheetComponent.this.asXLS.getElement()).isChecked() ? (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createActualStockReport(config).getValue() : (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createActualStockSheet(config).getValue();
                PrintActualStockSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintActualStockSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintActualStockSheetComponent.this.layoutInheritedComponents(parent) + PrintActualStockSheetComponent.this.border;
            if (PrintActualStockSheetComponent.this.bonded != null) {
                PrintActualStockSheetComponent.this.dueDateStore.setLocation(PrintActualStockSheetComponent.this.border, y);
                PrintActualStockSheetComponent.this.dueDateStore.setSize(PrintActualStockSheetComponent.this.dueDateStore.getPreferredSize());
                PrintActualStockSheetComponent.this.bonded.setLocation(PrintActualStockSheetComponent.this.border, PrintActualStockSheetComponent.this.dueDateStore.getY() + PrintActualStockSheetComponent.this.dueDateStore.getHeight() + PrintActualStockSheetComponent.this.border);
                PrintActualStockSheetComponent.this.bonded.setSize(150, (int)PrintActualStockSheetComponent.this.bonded.getPreferredSize().getHeight());
                PrintActualStockSheetComponent.this.printCustomerNo.setLocation(PrintActualStockSheetComponent.this.border, PrintActualStockSheetComponent.this.bonded.getY() + PrintActualStockSheetComponent.this.bonded.getHeight() + PrintActualStockSheetComponent.this.border);
                PrintActualStockSheetComponent.this.printCustomerNo.setSize(PrintActualStockSheetComponent.this.printCustomerNo.getPreferredSize());
                PrintActualStockSheetComponent.this.sortBy.setLocation(PrintActualStockSheetComponent.this.border, PrintActualStockSheetComponent.this.printCustomerNo.getY() + PrintActualStockSheetComponent.this.printCustomerNo.getHeight() + PrintActualStockSheetComponent.this.border / 2);
                PrintActualStockSheetComponent.this.sortBy.setSize(parent.getWidth() - 2 * PrintActualStockSheetComponent.this.border, (int)PrintActualStockSheetComponent.this.sortBy.getPreferredSize().getHeight());
                PrintActualStockSheetComponent.this.customerSearchField.setLocation(PrintActualStockSheetComponent.this.border, PrintActualStockSheetComponent.this.sortBy.getY() + PrintActualStockSheetComponent.this.sortBy.getHeight() + PrintActualStockSheetComponent.this.border);
                PrintActualStockSheetComponent.this.customerSearchField.setSize(parent.getWidth() - 2 * PrintActualStockSheetComponent.this.border, (int)PrintActualStockSheetComponent.this.customerSearchField.getPreferredSize().getHeight());
                PrintActualStockSheetComponent.this.includeZeroStockItems.setLocation(PrintActualStockSheetComponent.this.border, PrintActualStockSheetComponent.this.customerSearchField.getY() + PrintActualStockSheetComponent.this.customerSearchField.getHeight() + PrintActualStockSheetComponent.this.border);
                PrintActualStockSheetComponent.this.includeZeroStockItems.setSize(PrintActualStockSheetComponent.this.includeZeroStockItems.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintActualStockSheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (PrintActualStockSheetComponent.this.bonded != null) {
                h += PrintActualStockSheetComponent.this.border;
                h = (int)((double)h + PrintActualStockSheetComponent.this.dueDateStore.getPreferredSize().getHeight());
                h += PrintActualStockSheetComponent.this.border;
                h = (int)((double)h + PrintActualStockSheetComponent.this.bonded.getPreferredSize().getHeight());
                h += PrintActualStockSheetComponent.this.border;
                h = (int)((double)h + PrintActualStockSheetComponent.this.printCustomerNo.getPreferredSize().getHeight());
                h += PrintActualStockSheetComponent.this.border / 2;
                h = (int)((double)h + PrintActualStockSheetComponent.this.sortBy.getPreferredSize().getHeight());
                h += PrintActualStockSheetComponent.this.border;
                h = (int)((double)h + PrintActualStockSheetComponent.this.customerSearchField.getPreferredSize().getHeight());
                h += PrintActualStockSheetComponent.this.border;
                h = (int)((double)h + PrintActualStockSheetComponent.this.includeZeroStockItems.getPreferredSize().getHeight());
                h += PrintActualStockSheetComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

