/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.weeklyplan.recipe;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.submodules.print.weeklyplan.recipe.ProductionItemSelectionTable;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanReference;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class PrintProductionSheetComponent
extends DefaultScrollablePrintPopup2<WeeklyPlanLight> {
    private static final long serialVersionUID = 1L;
    private Node<WeeklyPlanLight> node;
    private TitledItem<ComboBox> days;
    private ProductionItemSelectionTable table;

    public PrintProductionSheetComponent(Node<WeeklyPlanLight> node) {
        super(false, false, ReportTypeE.RECIPECARD);
        this.node = node;
        this.loadBeforeShowing(() -> {
            try {
                WeeklyPlanComplete complete = (WeeklyPlanComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getComplete(new WeeklyPlanReference(((WeeklyPlanLight)node.getValue()).getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)complete, 0L);
                SwingUtilities.invokeLater(() -> {
                    Date date = new Date(System.currentTimeMillis());
                    if (date.getTime() < ((WeeklyPlanLight)node.getValue()).getPeriod().getStartDate().getTime() || date.getTime() > ((WeeklyPlanLight)node.getValue()).getPeriod().getEndDate().getTime()) {
                        date = new Date(((WeeklyPlanLight)node.getValue()).getPeriod().getStartDate().getTime());
                    }
                    String firstDay = this.generateComboName(date);
                    this.days.getElement().setSelectedItem(firstDay);
                });
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        });
        this.days = new TitledItem<ComboBox>(new ComboBox(), "Day", TitledItem.TitledItemOrientation.NORTH);
        this.table = new ProductionItemSelectionTable();
        Date currentDate = new Date(((WeeklyPlanLight)node.getValue()).getPeriod().getStartDate().getTime());
        while (currentDate.getTime() <= ((WeeklyPlanLight)node.getValue()).getPeriod().getEndDate().getTime()) {
            String dayName = this.generateComboName(currentDate);
            this.days.getElement().addItem(dayName);
            this.days.getElement().setSelectedItem(dayName);
            currentDate = new Date(((Date)DateUtil.addDays((java.util.Date)currentDate, (int)1)).getTime());
        }
        this.days.getElement().addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.updateProductionItemTable((String)this.days.getElement().getSelectedItem());
            }
        });
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.days);
        this.getViewContainer().add(this.table);
    }

    private void updateProductionItemTable(String selectedDay) {
        Date currentDate = new Date(((WeeklyPlanLight)this.node.getValue()).getPeriod().getStartDate().getTime());
        while (currentDate.getTime() < ((WeeklyPlanLight)this.node.getValue()).getPeriod().getEndDate().getTime()) {
            String dayName = this.generateComboName(currentDate);
            if (selectedDay.equals(dayName)) {
                this.selectNewItems(currentDate);
            }
            currentDate = new Date(((Date)DateUtil.addDays((java.util.Date)currentDate, (int)1)).getTime());
        }
    }

    private String generateComboName(Date currentDate) {
        String dayName = DateUtil.getDayName((java.util.Date)currentDate);
        return new SimpleDateFormat("dd.MM.").format(currentDate) + " " + dayName;
    }

    private void selectNewItems(Date currentDate) {
        Node n = new Node();
        WeeklyPlanComplete value = (WeeklyPlanComplete)this.node.getValue(WeeklyPlanComplete.class);
        PeriodComplete p = new PeriodComplete(new Date(currentDate.getTime()), new Date(currentDate.getTime()));
        for (JobComplete job : value.getJobs()) {
            if (job.getJobSchedule().getTime() < p.getStartDate().getTime() || job.getJobSchedule().getTime() > p.getEndDate().getTime()) continue;
            n.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)job, true, true), 0L);
        }
        this.table.getModel().setNode(n);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public List<Component> getFocusComponents() {
        return super.getFocusComponents();
    }

    @Override
    public String getTitleString() {
        return "Weekly Plan";
    }

    @Override
    public String getTitleValue() {
        return ((WeeklyPlanLight)this.node.getValue()).getPeriod().toString();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                WeeklyPlanLight flight = (WeeklyPlanLight)PrintProductionSheetComponent.this.node.getValue();
                List<JobComplete> jobs = PrintProductionSheetComponent.this.table.getJobs();
                ArrayList refs = new ArrayList();
                jobs.forEach(job -> refs.add(new JobReference(job.getId())));
                PegasusFileComplete f = (PegasusFileComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).printProductionSheets(new ListWrapper(refs)).getValue();
                PrintProductionSheetComponent.this.processFile(f);
                PrintProductionSheetComponent.this.printed = true;
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductionSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public Node<WeeklyPlanLight> getCurrentNode() {
        return this.node;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
    }

    @Override
    public BatchJob<WeeklyPlanLight> createBatchJob(Node<WeeklyPlanLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public boolean validateContent() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintProductionSheetComponent.this.layoutInheritedComponents(parent);
            PrintProductionSheetComponent.this.days.setLocation(PrintProductionSheetComponent.this.border, y += PrintProductionSheetComponent.this.border);
            PrintProductionSheetComponent.this.days.setSize(parent.getWidth() - 2 * PrintProductionSheetComponent.this.border, (int)PrintProductionSheetComponent.this.days.getPreferredSize().getHeight());
            PrintProductionSheetComponent.this.table.setLocation(PrintProductionSheetComponent.this.border, PrintProductionSheetComponent.this.days.getY() + PrintProductionSheetComponent.this.days.getHeight() + PrintProductionSheetComponent.this.border);
            PrintProductionSheetComponent.this.table.setSize(parent.getWidth() - 2 * PrintProductionSheetComponent.this.border, parent.getHeight() - (PrintProductionSheetComponent.this.table.getY() + PrintProductionSheetComponent.this.border));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductionSheetComponent.this.getInheritedComponentsHeight();
            h += PrintProductionSheetComponent.this.border;
            h += 200;
            return new Dimension(0, h += PrintProductionSheetComponent.this.border);
        }
    }
}

