/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.logic;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.InventoryListViewModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.utils.ExcecutionTimeDisplayer;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.AircraftServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.AircraftToolkit;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.client.util.toolkits.LogicToolkit;
import ch.icit.pegasus.client.util.toolkits.MealPlanToolkit;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.APassengerSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.EquipmentTemplateDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.LinearFunctionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.LinearFunctionSetQuantityCalculationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ProductDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ServiceDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.StepFunctionQuantityCalculationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliveryInstructionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.EquipmentDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentInsertComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentReservedSpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSpecificationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FillStrategyTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentInsertTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentSystemComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.StowagePositionTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupTemplateComplete;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.EquipmentTemplateSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataInterface {
    private static DataInterface theInterface;
    static Logger log;

    private DataInterface() {
    }

    public static DataInterface getInterface() {
        if (theInterface == null) {
            theInterface = new DataInterface();
        }
        return theInterface;
    }

    public Node writeDownData(int state, Node node, PegasusSubModule peg) throws ServiceException {
        switch (state) {
            case 3: {
                node.commit(AircraftComplete.class);
                AircraftComplete dto = (AircraftComplete)node.getValue(AircraftComplete.class);
                List<ScreenValidationObject> a = AircraftToolkit.validateAircraft(dto);
                if (a.isEmpty()) {
                    AircraftComplete air = (AircraftComplete)((AircraftServiceManager)ServiceManagerRegistry.getService(AircraftServiceManager.class)).updateAircraft((AircraftLight)dto).getValue();
                    node.removeExistingValues();
                    node.setValue((Object)air, 0L);
                    node.updateNode();
                    break;
                }
                peg.validationException(null, a);
                break;
            }
            case 7: {
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                if (node.getValue(StowingListTemplateVariantComplete.class) instanceof StowingListTemplateVariantComplete) {
                    LogicToolkit.revalidateDeliveryInstructions(node, System.currentTimeMillis());
                    node.commit(StowingListTemplateVariantComplete.class);
                    StowingListTemplateVariantComplete osto = (StowingListTemplateVariantComplete)node.getValue(StowingListTemplateVariantComplete.class);
                    LogicToolkit.validateStowings(osto.getGalleyEquipmentSets());
                    List<ScreenValidationObject> o = DataInterface.ensureDeliveryInstruction(osto);
                    this.ensureDepartmentIsSet(osto.getGalleyEquipmentSets(), o);
                    List<ScreenValidationObject> validationObjects = LogicToolkit.checkDuplicateLabelNames(osto);
                    o.addAll(validationObjects);
                    this.updateDataStructureForEquipments(new ArrayList<GalleyEquipmentSetComplete>(osto.getGalleyEquipmentSets()));
                    this.updateDataStructureForDelivery(new ArrayList<DeliverableComplete>(osto.getDeliverables()));
                    LogicToolkit.validateContainedEquipment(osto.getDeliverables());
                    LogicToolkit.ensurePaxCount(osto.getDeliverables());
                    LogicToolkit.ensureEquipmentLabelConfig(osto.getDeliverables());
                    LogicToolkit.revalidDeliveryAmount(osto.getDeliverables());
                    LogicToolkit.revalidateLooseEquipmentAndInserts(osto.getGalleyEquipmentSets(), settings);
                    DataInterface.ensureCabinClasses(osto);
                    List warnings = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).validateStowingListTemplateComplete(osto).getList();
                    warnings.forEach(s -> o.add(0, new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, s)));
                    List<ScreenValidationObject> errors = LogicToolkit.checkHoldPositions(osto);
                    List<ScreenValidationObject> errors2 = LogicToolkit.checkRCDepartments(osto);
                    o.addAll(errors);
                    o.addAll(errors2);
                    if (o != null && !o.isEmpty() && ScreenValidationObject.isFatal(o)) {
                        peg.validationException(null, o);
                        break;
                    }
                    if (o != null && !o.isEmpty()) {
                        InnerPopupFactory.showMessageDialog(o, "Stowing List Validation", (Component)peg);
                    }
                    this.updateDataStructureForEquipments(new ArrayList<GalleyEquipmentSetComplete>(osto.getGalleyEquipmentSets()));
                    StowingListTemplateVariantComplete sto = (StowingListTemplateVariantComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).updateVariant((StowingListTemplateVariantLight)osto).getValue();
                    node.removeExistingValues();
                    node.setValue((Object)sto, 0L);
                    node.disableEventsGlobally();
                    node.updateNode();
                    node.enableEventsGlobally();
                    break;
                }
                if (!(node.getValue(StowingListComplete.class) instanceof StowingListComplete)) break;
                LogicToolkit.revalidateDeliveryInstructions(node, System.currentTimeMillis());
                node.commit(StowingListComplete.class);
                StowingListComplete osto = (StowingListComplete)node.getValue(StowingListComplete.class);
                LogicToolkit.validateStowings(osto.getGalleyEquipmentSets());
                List<ScreenValidationObject> o = DataInterface.ensureDeliveryInstruction(osto);
                this.ensureDepartmentIsSet(osto.getGalleyEquipmentSets(), o);
                LogicToolkit.ensurePaxCount(osto.getDeliverables());
                LogicToolkit.ensureEquipmentLabelConfig(osto.getDeliverables());
                LogicToolkit.revalidDeliveryAmount(osto.getDeliverables());
                LogicToolkit.revalidateLooseEquipmentAndInserts(osto.getGalleyEquipmentSets(), settings);
                DataInterface.ensureCabinClasses(osto);
                List warnings = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).validateStowingListComplete(osto).getList();
                warnings.forEach(s -> o.add(0, new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, s)));
                if (o != null && !o.isEmpty() && ScreenValidationObject.isFatal(o)) {
                    peg.validationException(null, o);
                    break;
                }
                if (o != null && !o.isEmpty()) {
                    InnerPopupFactory.showMessageDialog(o, "Stowing List Validation", (Component)peg);
                }
                StowingListComplete sto = (StowingListComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).updateStowingList(osto).getValue();
                LogicToolkit.resetAllClientIDs(sto);
                node.removeExistingValues();
                node.setValue((Object)sto, 0L);
                node.disableEventsGlobally();
                node.updateNode();
                node.enableEventsGlobally();
            }
        }
        return node;
    }

    private void updateDataStructureForDelivery(List<DeliverableComplete> deliveries) {
        for (DeliverableComplete delivery : deliveries) {
            for (GalleyDistributionRuleComplete galleyDistributionRuleComplete : delivery.getDeliveryInstruction().getGalleyDistributionRules()) {
            }
        }
    }

    private void updateDataStructureForEquipments(List<GalleyEquipmentSetComplete> sets) {
        for (GalleyEquipmentSetComplete set : sets) {
            for (GalleyEquipmentSpecificationComplete eqs : set.getGalleyEquipmentSpecifications()) {
                this.updateDataStructureForGalley(set, eqs);
            }
            for (GalleyDistributionRuleComplete galleyDistributionRule : set.getGalleyDistributionRules()) {
                if (galleyDistributionRule.getGalleyEquipmentSet() != null) continue;
                galleyDistributionRule.setGalleyEquipmentSet(set);
            }
        }
    }

    private void updateDataStructureForGalley(GalleyEquipmentSetComplete set, GalleyEquipmentSpecificationComplete specs) {
        for (GalleyEquipmentComplete eq : specs.getUsedGalleyEquipment()) {
            if (eq.getContainingGalley() == null) {
                eq.setContainingGalley((GalleyEquipmentSetLight)set);
            }
            for (EquipmentDistributionRuleComplete edr : eq.getEquipmentDistributionRules()) {
                if (edr.getGalleyEquipment() != null) continue;
                edr.setGalleyEquipment(eq);
            }
            this.updateDataStructureForEquipment(eq);
        }
    }

    private void updateDataStructureForEquipment(GalleyEquipmentComplete eq) {
        for (DeliverySpaceComplete deliverySpace : eq.getDeliverySpaces()) {
            if (deliverySpace.getContainingEquipment() == null) {
                deliverySpace.setContainingEquipment((GalleyEquipmentLight)eq);
            }
            for (DeliverySpaceDistributionRuleComplete dr : deliverySpace.getDistributionRules()) {
                if (dr.getDeliverySpace() != null) continue;
                dr.setDeliverySpace(deliverySpace);
            }
        }
    }

    private void ensureDepartmentIsSet(Collection<GalleyEquipmentSetComplete> galleys, List<ScreenValidationObject> o) {
        for (GalleyEquipmentSetComplete g : galleys) {
            for (GalleyEquipmentSpecificationComplete specs : g.getGalleyEquipmentSpecifications()) {
                this.ensureDepartmentIsSet(specs, g, o);
            }
            this.ensureDepartmentIsSet(g.getLooseEquipment(), g, o);
        }
    }

    private void ensureDepartmentIsSet(GalleyEquipmentSpecificationComplete spec, GalleyEquipmentSetComplete set, List<ScreenValidationObject> o) {
        for (GalleyEquipmentComplete eq : spec.getUsedGalleyEquipment()) {
            this.ensureDepartmentIsSet(eq, set, o);
        }
    }

    private void ensureDepartmentIsSet(GalleyEquipmentComplete spec, GalleyEquipmentSetComplete set, List<ScreenValidationObject> o) {
        if (Boolean.TRUE.equals(spec.getInUse())) {
            if (spec.getGenerateReservedSpaceLabels().booleanValue()) {
                for (DeliverySpaceComplete space : spec.getDeliverySpaces()) {
                    if (space.getLabelConfiguration() == null || space.getLabelConfiguration().getDisplay() == null || !Boolean.TRUE.equals(space.getLabelConfiguration().getDisplay()) || !space.getCostCenter().isEmpty()) continue;
                    o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Insert " + space.getSpaceName() + " in Equipment " + spec.getCode() + " in Galley " + set.getGalleyCode() + " has no department set"));
                }
            } else if (Boolean.TRUE.equals(spec.getLabelConfiguration().getDisplay()) && spec.getCostCenter().isEmpty()) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Equipment " + spec.getCode() + " " + spec.getEquipmentSetType() + " in Galley " + set.getGalleyCode() + " has no department set"));
            }
        }
    }

    private void removeAllNullIDNodes(Node root, Set<Node> checkedNodes) {
        if (checkedNodes.contains(root)) {
            return;
        }
        Iterator it = root.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getValue() == null || !(n.getValue() instanceof IDTO)) continue;
            if (((IDTO)n.getValue()).getId() == null) {
                root.removeChild(n, 0L);
                INodeCreator.getDefaultImpl().removeFromAllNodes(n);
            }
            this.removeAllNullIDNodes(n, checkedNodes);
        }
    }

    public ThreadSafeExecutable getInventory(final long id, final RemoteLoader invoker, final IStowingListLight dto, final LoadingAnimation animation) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                int count;
                List r;
                StowingListTemplateVariantLight ll;
                Node n = null;
                animation.stateChanged("Load stowable items");
                ProductSearchConfiguration psc = new ProductSearchConfiguration();
                EquipmentTemplateSearchConfiguration c = new EquipmentTemplateSearchConfiguration();
                if (dto instanceof StowingListTemplateVariantLight) {
                    ll = (StowingListTemplateVariantLight)dto;
                    psc.setCustomer(ll.getBase().getCustomer());
                    psc.setPeriod(ll.getValidityPeriod());
                    c.setCustomer((CustomerReference)ll.getBase().getCustomer());
                    c.setPeriod(ll.getBase().getPeriod());
                    r = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getStowableServiceByTemplateVariant((StowingListTemplateVariantReference)ll).getList();
                    for (CateringServiceScheduleComplete s : r) {
                        for (LoadingGroupTemplateComplete loadingGroup : s.getLoadingGroups()) {
                            loadingGroup.setContainingService(s);
                        }
                    }
                    Iterator it = r.iterator();
                    while (it.hasNext()) {
                        CateringServiceScheduleComplete cc = (CateringServiceScheduleComplete)it.next();
                        if (!cc.getIsDeleted().booleanValue()) continue;
                        it.remove();
                    }
                    n = INodeCreator.getDefaultImpl().createNodes(r, false);
                } else if (dto instanceof StowingListLight) {
                    ll = (StowingListLight)dto;
                    r = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getStowableService((StowingListReference)ll).getList();
                    FlightReference flightReference = new FlightReference(ll.getFlight() != null ? ll.getFlight().getId() : ll.getFlightId());
                    boolean mustLoadLoadingGroups = false;
                    for (Object s : r) {
                        for (Object part : s.getParts()) {
                            if (part.getLoadingGroup() != null || part.getLoadingGroupId() == null) continue;
                            mustLoadLoadingGroups = true;
                        }
                    }
                    if (mustLoadLoadingGroups) {
                        List ret = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightLoadingGroups(flightReference).getList();
                        for (CateringServiceComplete s : r) {
                            for (CateringServicePartComplete part : s.getParts()) {
                                part.afterUnmarshal(null, (Object)part);
                            }
                        }
                    }
                    n = INodeCreator.getDefaultImpl().createNodes(r, false);
                }
                ListNode theProducts = new ListNode();
                psc.setNumResults(30);
                SearchResultIterator sriProduct = new SearchResultIterator((ASearchConfiguration)psc);
                Iterator it = sriProduct.iterator();
                for (count = 0; it.hasNext() && count <= psc.getNumResults(); ++count) {
                    theProducts.addChild(INodeCreator.getDefaultImpl().getNode4DTO(it.next(), true, false), 0L);
                }
                theProducts.setName("Products");
                BasicArticleSearchConfiguration asc = new BasicArticleSearchConfiguration();
                asc.setNumResults(30);
                ListNode theAricles = new ListNode();
                SearchResultIterator sriArticle = new SearchResultIterator((ASearchConfiguration)asc);
                Iterator it2 = sriArticle.iterator();
                for (count = 0; it2.hasNext() && count <= asc.getNumResults(); ++count) {
                    theAricles.addChild(INodeCreator.getDefaultImpl().getNode4DTO(it2.next(), true, false), 0L);
                }
                theAricles.setName("Articles");
                ListNode equipmentTempaltes = new ListNode();
                c.setNumResults(30);
                SearchResultIterator sriTemplates = new SearchResultIterator((ASearchConfiguration)c);
                Iterator it3 = sriTemplates.iterator();
                for (count = 0; it3.hasNext() && count <= c.getNumResults(); ++count) {
                    equipmentTempaltes.addChild(INodeCreator.getDefaultImpl().getNode4DTO(it3.next(), true, false), 0L);
                }
                equipmentTempaltes.setName(InventoryListViewModel.equipmentString);
                ListNode theInventory = new ListNode();
                if (n != null) {
                    n.setName("MealServices");
                    theInventory.addChild(n, 0L);
                }
                theInventory.addChild((Node)theProducts, 0L);
                theInventory.addChild((Node)theAricles, 0L);
                theInventory.addChild((Node)equipmentTempaltes, 0L);
                theInventory.setName("Inventory");
                return theInventory;
            }

            @Override
            public RemoteLoader getInvoker() {
                return invoker;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        return run;
    }

    public Node<String> getBoxes() throws ClientServerCallException {
        Node theBoxes = null;
        theBoxes = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(GalleyEquipmentTypeComplete.class);
        return theBoxes;
    }

    public Node<String> getStowagePositions() throws ClientServerCallException {
        ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
        Node theStowagePositions = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(StowagePositionTypeComplete.class);
        theStowagePositions.setName("Boxes");
        HashSet<String> usedCodes = new HashSet<String>();
        Iterator it = theStowagePositions.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node c = (Node)it.next();
            if (usedCodes.contains(((StowagePositionTypeComplete)c.getValue()).getCode())) {
                theStowagePositions.removeChild(c, 0L);
                continue;
            }
            usedCodes.add(((StowagePositionTypeComplete)c.getValue()).getCode());
        }
        NodeToolkit.addAffix((Node)theStowagePositions);
        if (theStowagePositions instanceof Node) {
            theStowagePositions.setValue((Object)"Stowage Positions", 0L);
        }
        return theStowagePositions;
    }

    private static boolean hasGDR(Collection<DeliverableComplete> deliverys, GalleyEquipmentSetComplete set, GalleyDistributionRuleComplete gdr) {
        for (DeliverableComplete di : deliverys) {
            for (GalleyDistributionRuleComplete g : di.getDeliveryInstruction().getGalleyDistributionRules()) {
                if (!g.equals((Object)gdr) || !g.getGalleyEquipmentSet().equals((Object)set)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasEDR(Collection<DeliverableComplete> deliverys, GalleyEquipmentComplete eq, EquipmentDistributionRuleComplete edr) {
        for (DeliverableComplete di : deliverys) {
            for (GalleyDistributionRuleComplete g : di.getDeliveryInstruction().getGalleyDistributionRules()) {
                for (EquipmentDistributionRuleComplete e : g.getEquipmentDistributionRules()) {
                    if (!e.equals((Object)edr) || !edr.getGalleyEquipment().equals((Object)eq)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasIDR(Collection<DeliverableComplete> deliverys, DeliverySpaceComplete eq, DeliverySpaceDistributionRuleComplete idr) {
        for (DeliverableComplete di : deliverys) {
            for (GalleyDistributionRuleComplete g : di.getDeliveryInstruction().getGalleyDistributionRules()) {
                for (EquipmentDistributionRuleComplete e : g.getEquipmentDistributionRules()) {
                    for (DeliverySpaceDistributionRuleComplete i : e.getInsertDistributionRule()) {
                        if (!i.equals((Object)idr)) continue;
                        if (i.getDeliverySpace() instanceof GalleyEquipmentInsertComplete && i.getDeliverySpace().equals((Object)eq)) {
                            return true;
                        }
                        if (!(i.getDeliverySpace() instanceof GalleyEquipmentReservedSpaceComplete) || !i.getDeliverySpace().equals((Object)eq)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static void checkMaxPaxPerLeg(List<SeatConfigurationComplete> paxes, List<ScreenValidationObject> rets) {
        int totalPax = 0;
        for (SeatConfigurationComplete scc : paxes) {
            totalPax += scc.getNumber().intValue();
        }
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (s.getMaxNumPax() < totalPax) {
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Total Pax per Leg (" + totalPax + ") must no exceed " + s.getMaxNumPax()));
        }
    }

    public static List<ScreenValidationObject> ensureDeliveryInstruction(StowingListTemplateVariantComplete l) {
        String t;
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        DataInterface.checkMaxPaxPerLeg(l.getSeatConfigurations(), rets);
        HashMap<ALoadingGroupComplete, DeliveryInstructionComplete> instructions = new HashMap<ALoadingGroupComplete, DeliveryInstructionComplete>();
        Iterator it = l.getDeliverables().iterator();
        while (it.hasNext()) {
            ServiceDeliverableComplete sdc;
            DeliverableComplete deliverable = (DeliverableComplete)it.next();
            DeliveryInstructionComplete di = deliverable.getDeliveryInstruction();
            boolean wasKilled = false;
            if (deliverable instanceof ServiceDeliverableComplete && (sdc = (ServiceDeliverableComplete)deliverable).getLoadingGroup() != null) {
                if (instructions.get(sdc.getLoadingGroup()) != null) {
                    t = "Found Delivery Instruction (" + DataInterface.getDeliveryInstructionName(deliverable) + ") without Galley Distribution Rule => REMOVED";
                    log.debug(t);
                    DataInterface.removeCurrentDeliveryInstruction(di);
                    wasKilled = true;
                } else {
                    instructions.put(sdc.getLoadingGroup(), di);
                }
            }
            if (!wasKilled) {
                DataInterface.ensureDI(deliverable, rets);
            }
            if (di.getGalleyDistributionRules().size() != 0) continue;
            String t2 = "Found Delivery Instruction (" + DataInterface.getDeliveryInstructionName(deliverable) + ") without Galley Distribution Rule => REMOVED";
            log.debug(t2);
            it.remove();
        }
        for (GalleyEquipmentSetComplete set : l.getGalleyEquipmentSets()) {
            Iterator it_g = set.getGalleyDistributionRules().iterator();
            while (it_g.hasNext()) {
                GalleyDistributionRuleComplete gdr = (GalleyDistributionRuleComplete)it_g.next();
                if (DataInterface.hasGDR(l.getDeliverables(), set, gdr)) continue;
                t = "Found a Galley Distribution Rule (" + DataInterface.getPositionString(set, null, null) + ") which is not referenced from a Delivery Instruction => REMOVED";
                log.debug(t);
                it_g.remove();
            }
            for (GalleyEquipmentSpecificationComplete spec : set.getGalleyEquipmentSpecifications()) {
                for (GalleyEquipmentComplete e : spec.getUsedGalleyEquipment()) {
                    Iterator it_e = e.getEquipmentDistributionRules().iterator();
                    while (it_e.hasNext()) {
                        EquipmentDistributionRuleComplete edr = (EquipmentDistributionRuleComplete)it_e.next();
                        if (DataInterface.hasEDR(l.getDeliverables(), e, edr)) continue;
                        String t3 = "Found a Equipment Distribution Rule " + DataInterface.getPositionString(set, e, null) + " which is not referenced from a Delivery Instruction => REMOVED";
                        log.debug(t3);
                        it_e.remove();
                    }
                    for (DeliverySpaceComplete space : e.getDeliverySpaces()) {
                        Iterator it_d = space.getDistributionRules().iterator();
                        while (it_d.hasNext()) {
                            DeliverySpaceDistributionRuleComplete d = (DeliverySpaceDistributionRuleComplete)it_d.next();
                            if (DataInterface.hasIDR(l.getDeliverables(), space, d)) continue;
                            String t4 = "Found a Delivery Space Rule " + DataInterface.getPositionString(set, e, space) + " which is not referenced from a Delivery Instruction = > REMOVED";
                            log.debug(t4);
                            it_d.remove();
                        }
                    }
                }
            }
        }
        return rets;
    }

    private static void removeCurrentDeliveryInstruction(DeliveryInstructionComplete di) {
        for (GalleyDistributionRuleComplete gdrc : di.getGalleyDistributionRules()) {
            gdrc.getGalleyEquipmentSet().getGalleyDistributionRules().remove(gdrc);
            for (EquipmentDistributionRuleComplete edrc : gdrc.getEquipmentDistributionRules()) {
                edrc.getGalleyEquipment().getEquipmentDistributionRules().remove(edrc);
                for (DeliverySpaceDistributionRuleComplete dsdrc : edrc.getInsertDistributionRule()) {
                    dsdrc.getDeliverySpace().getDistributionRules().remove(dsdrc);
                }
                edrc.getInsertDistributionRule().clear();
            }
            gdrc.getEquipmentDistributionRules().clear();
        }
        di.getGalleyDistributionRules().clear();
    }

    private static List<ScreenValidationObject> ensureCabinClasses(StowingListTemplateVariantComplete l) {
        HashSet<CabinClassComplete> classes = new HashSet<CabinClassComplete>();
        for (SeatConfigurationComplete sc : l.getSeatConfigurations()) {
            classes.add(sc.getCabinClass());
        }
        for (DeliverableComplete di : l.getDeliverables()) {
            if (di.getQuantityCalculation() instanceof LinearFunctionSetQuantityCalculationComplete) {
                LinearFunctionSetQuantityCalculationComplete f = (LinearFunctionSetQuantityCalculationComplete)di.getQuantityCalculation();
                for (LinearFunctionComplete func : f.getFunctions()) {
                    Iterator it = func.getPaxKeySets().iterator();
                    while (it.hasNext()) {
                        APassengerSetComplete set = (APassengerSetComplete)it.next();
                        if (classes.contains(set.getPaxClass())) continue;
                        it.remove();
                    }
                }
                continue;
            }
            if (!(di.getQuantityCalculation() instanceof StepFunctionQuantityCalculationComplete)) continue;
            StepFunctionQuantityCalculationComplete s = (StepFunctionQuantityCalculationComplete)di.getQuantityCalculation();
            Iterator it = s.getPaxKeySets().iterator();
            while (it.hasNext()) {
                APassengerSetComplete set = (APassengerSetComplete)it.next();
                if (classes.contains(set.getPaxClass())) continue;
                it.remove();
            }
        }
        return null;
    }

    private static List<ScreenValidationObject> ensureCabinClasses(StowingListComplete l) {
        HashSet<CabinClassComplete> classes = new HashSet<CabinClassComplete>();
        for (SeatConfigurationComplete sc : l.getSeatConfigurations()) {
            classes.add(sc.getCabinClass());
        }
        for (DeliverableComplete di : l.getDeliverables()) {
            if (di.getQuantityCalculation() instanceof LinearFunctionSetQuantityCalculationComplete) {
                LinearFunctionSetQuantityCalculationComplete f = (LinearFunctionSetQuantityCalculationComplete)di.getQuantityCalculation();
                for (LinearFunctionComplete func : f.getFunctions()) {
                    Iterator it = func.getPaxKeySets().iterator();
                    while (it.hasNext()) {
                        APassengerSetComplete set = (APassengerSetComplete)it.next();
                        if (classes.contains(set.getPaxClass())) continue;
                        it.remove();
                    }
                }
                continue;
            }
            if (!(di.getQuantityCalculation() instanceof StepFunctionQuantityCalculationComplete)) continue;
            StepFunctionQuantityCalculationComplete s = (StepFunctionQuantityCalculationComplete)di.getQuantityCalculation();
            Iterator it = s.getPaxKeySets().iterator();
            while (it.hasNext()) {
                APassengerSetComplete set = (APassengerSetComplete)it.next();
                if (classes.contains(set.getPaxClass())) continue;
                it.remove();
            }
        }
        return null;
    }

    private static List<ScreenValidationObject> ensureDeliveryInstruction(StowingListComplete l) {
        String t;
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        DataInterface.checkMaxPaxPerLeg(l.getSeatConfigurations(), rets);
        HashMap<ALoadingGroupComplete, DeliveryInstructionComplete> instructions = new HashMap<ALoadingGroupComplete, DeliveryInstructionComplete>();
        Iterator it = l.getDeliverables().iterator();
        while (it.hasNext()) {
            ServiceDeliverableComplete sdc;
            DeliverableComplete deliverable = (DeliverableComplete)it.next();
            DeliveryInstructionComplete di = deliverable.getDeliveryInstruction();
            boolean wasKilled = false;
            if (deliverable instanceof ServiceDeliverableComplete && (sdc = (ServiceDeliverableComplete)deliverable).getLoadingGroup() != null) {
                if (instructions.get(sdc.getLoadingGroup()) != null) {
                    t = "The Loading Group " + sdc.getLoadingGroup().getName() + " is stowed with two different Delivery Instructions => REMOVED";
                    log.debug(t);
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t));
                    DataInterface.removeCurrentDeliveryInstruction(di);
                    wasKilled = true;
                } else {
                    instructions.put(sdc.getLoadingGroup(), di);
                }
            }
            if (!wasKilled) {
                DataInterface.ensureDI(deliverable, rets);
            }
            if (di.getGalleyDistributionRules().size() != 0) continue;
            wasKilled = true;
            String t2 = "Found Delivery Instruction (" + DataInterface.getDeliveryInstructionName(deliverable) + ") without Galley Distribution Rule => REMOVED";
            log.debug(t2);
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t2));
            it.remove();
        }
        for (GalleyEquipmentSetComplete set : l.getGalleyEquipmentSets()) {
            Iterator it_g = set.getGalleyDistributionRules().iterator();
            while (it_g.hasNext()) {
                GalleyDistributionRuleComplete gdr = (GalleyDistributionRuleComplete)it_g.next();
                if (DataInterface.hasGDR(l.getDeliverables(), set, gdr)) continue;
                t = "Found a Galley Distribution Rule (" + DataInterface.getPositionString(set, null, null) + ") which is not referenced from a Delivery Instruction => REMOVED";
                log.debug(t);
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t));
                it_g.remove();
            }
            for (GalleyEquipmentSpecificationComplete spec : set.getGalleyEquipmentSpecifications()) {
                for (GalleyEquipmentComplete e : spec.getUsedGalleyEquipment()) {
                    Iterator it_e = e.getEquipmentDistributionRules().iterator();
                    while (it_e.hasNext()) {
                        EquipmentDistributionRuleComplete edr = (EquipmentDistributionRuleComplete)it_e.next();
                        if (DataInterface.hasEDR(l.getDeliverables(), e, edr)) continue;
                        String t3 = "Found a Equipment Distribution Rule " + DataInterface.getPositionString(set, e, null) + " which is not referenced from a Delivery Instruction => REMOVED";
                        log.debug(t3);
                        rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t3));
                        it_e.remove();
                    }
                    for (DeliverySpaceComplete space : e.getDeliverySpaces()) {
                        Iterator it_d = space.getDistributionRules().iterator();
                        while (it_d.hasNext()) {
                            DeliverySpaceDistributionRuleComplete d = (DeliverySpaceDistributionRuleComplete)it_d.next();
                            if (DataInterface.hasIDR(l.getDeliverables(), space, d)) continue;
                            String t4 = "Found a Delivery Space Rule " + DataInterface.getPositionString(set, e, space) + " which is not referenced from a Delivery Instruction = > REMOVED";
                            log.debug(t4);
                            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t4));
                            it_d.remove();
                        }
                    }
                }
            }
        }
        return rets;
    }

    private static void ensureDI(DeliverableComplete di, List<ScreenValidationObject> rets) {
        ArticleDeliverableComplete adc;
        Converter c;
        if (di instanceof ArticleDeliverableLight) {
            ArticleDeliverableLight adl = (ArticleDeliverableLight)di;
            if (adl.getUnit() == null) {
                c = ConverterRegistry.getConverter(BasicArticleConverter.class);
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, "(A) " + (String)c.convert((Object)adl.getArticle(), null, new Object[0]) + " has no unit defined. CATIT auto fixed it to " + adl.getArticle().getBaseUnit().getShortName() + ". Please review " + adl.getArticle().getName()));
                adl.setUnit(adl.getArticle().getBaseUnit());
            }
        } else if (di instanceof ArticleDeliverableComplete && (adc = (ArticleDeliverableComplete)di).getUnit() == null) {
            c = ConverterRegistry.getConverter(BasicArticleConverter.class);
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, "(A) " + (String)c.convert((Object)adc.getArticle(), null, new Object[0]) + " has no unit defined. CATIT auto fixed it to " + adc.getArticle().getBaseUnit().getShortName() + ". Please review " + adc.getArticle().getName()));
            adc.setUnit(adc.getArticle().getBaseUnit());
        }
        Iterator it = di.getDeliveryInstruction().getGalleyDistributionRules().iterator();
        while (it.hasNext()) {
            String t;
            GalleyDistributionRuleComplete gdr = (GalleyDistributionRuleComplete)it.next();
            boolean bad = false;
            if (gdr.getGalleyEquipmentSet() == null) {
                bad = true;
                t = "Found a Galley Distribution Rule (" + DataInterface.getDeliveryInstructionName(di) + ") which is not referenced within the Galley Equipment Sets => REMOVED";
                log.debug(t);
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t));
            } else if (!gdr.getGalleyEquipmentSet().getGalleyDistributionRules().contains(gdr)) {
                gdr.getGalleyEquipmentSet().getGalleyDistributionRules().add(gdr);
                t = "Found a Galley Distribution Rule (" + DataInterface.getDeliveryInstructionName(di) + ") which references a Galley Equipment Set " + DataInterface.getPositionString(gdr.getGalleyEquipmentSet(), null, null) + " but is not referenced by the Galley Equipment Set => readd";
                log.debug(t);
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t));
            }
            DataInterface.ensureGDR(gdr, di, rets);
            if (gdr.getEquipmentDistributionRules().size() == 0) {
                t = "Found a Galley Distribution Rule (" + DataInterface.getDeliveryInstructionName(di) + ") on " + DataInterface.getPositionString(gdr, null, null) + " which has no Equipment Distribution Rules refernced => REMOVED";
                log.debug(t);
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t));
                if (gdr.getGalleyEquipmentSet() != null) {
                    gdr.getGalleyEquipmentSet().getGalleyDistributionRules().remove(gdr);
                }
                it.remove();
                continue;
            }
            if (!bad) continue;
            it.remove();
            gdr.getGalleyEquipmentSet().getGalleyDistributionRules().remove(gdr);
        }
    }

    private static void ensureGDR(GalleyDistributionRuleComplete gdr, DeliverableComplete di, List<ScreenValidationObject> rets) {
        Iterator it = gdr.getEquipmentDistributionRules().iterator();
        while (it.hasNext()) {
            String t;
            EquipmentDistributionRuleComplete edr = (EquipmentDistributionRuleComplete)it.next();
            boolean bad = false;
            if (edr.getGalleyEquipment() == null || edr.getGalleyEquipment().getId() == null) {
                t = "Found a Equipment Distribution Rule with no Galley Equpiment " + DataInterface.getPositionString(gdr, null, null) + " referenced => REMOVED";
                log.debug(t);
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t));
                bad = true;
            } else if (!edr.getGalleyEquipment().getEquipmentDistributionRules().contains(edr)) {
                edr.getGalleyEquipment().getEquipmentDistributionRules().add(edr);
                t = "Found a Equipment Distribution Rule (" + DataInterface.getDeliveryInstructionName(di) + ") which references a Galley Equipment " + DataInterface.getPositionString(gdr, edr, null) + " but is not referenced by the Galley Equipment => readd";
                log.debug(t);
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t));
            }
            DataInterface.ensureEDR(edr, gdr, di, rets);
            if (edr.getInsertDistributionRule().size() == 0) {
                t = "Found a Equipment Distribution Rule (" + DataInterface.getDeliveryInstructionName(di) + ") on " + DataInterface.getPositionString(gdr, edr, null) + " which has no Insert Distribution Rules referenced => REMOVED";
                log.debug(t);
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t));
                it.remove();
                edr.getGalleyEquipment().getEquipmentDistributionRules().remove(edr);
                continue;
            }
            if (!bad) continue;
            it.remove();
            edr.getGalleyEquipment().getEquipmentDistributionRules().remove(edr);
        }
    }

    private static String getDeliveryInstructionName(DeliverableComplete instru) {
        if (instru != null) {
            if (instru instanceof ArticleDeliverableComplete) {
                ArticleDeliverableComplete ac = (ArticleDeliverableComplete)instru;
                return "(A) " + ac.getArticle().getNumber() + " - " + ac.getArticle().getName();
            }
            if (instru instanceof ArticleDeliverableLight) {
                ArticleDeliverableLight ac = (ArticleDeliverableLight)instru;
                return "(A) " + ac.getArticle().getNumber() + " - " + ac.getArticle().getName();
            }
            if (instru instanceof ProductDeliverableComplete) {
                ProductDeliverableComplete p = (ProductDeliverableComplete)instru;
                return "(P) " + p.getProduct().getNumber() + " - " + p.getProduct().getCurrentVariant().getName();
            }
            if (instru instanceof ServiceDeliverableComplete) {
                ServiceDeliverableComplete d = (ServiceDeliverableComplete)instru;
                return "(S) " + MealPlanToolkit.createPostfixServicePartString(d.getLoadingGroup().getContainingService().getCabinClass(), d.getLoadingGroup().getContainingService().getLegs(), d.getLoadingGroup(), d.getLoadingGroup().getContainingService().getType(), false, null);
            }
            if (instru instanceof EquipmentTemplateDeliverableComplete) {
                EquipmentTemplateDeliverableComplete d = (EquipmentTemplateDeliverableComplete)instru;
                return "(E) " + d.getEquipment().getCurrentVariant().getName();
            }
        }
        return "-";
    }

    private static String getPositionString(GalleyDistributionRuleComplete gdr, EquipmentDistributionRuleComplete edr, DeliverySpaceDistributionRuleComplete dsdc) {
        String t = "";
        if (gdr != null) {
            t = gdr.getGalleyEquipmentSet().getGalleyCode();
        }
        if (edr != null) {
            t = t + " " + edr.getGalleyEquipment().getCode();
        }
        if (dsdc != null) {
            if (dsdc.getDeliverySpace().getSpaceName() != null && !dsdc.getDeliverySpace().getSpaceName().isEmpty()) {
                t = t + " " + dsdc.getDeliverySpace().getSpaceName();
            } else if (dsdc.getDeliverySpace() instanceof GalleyEquipmentInsertComplete) {
                t = t + " " + ((GalleyEquipmentInsertComplete)dsdc.getDeliverySpace()).getCode();
            } else if (dsdc.getDeliverySpace() instanceof GalleyEquipmentReservedSpaceComplete) {
                t = t + " " + dsdc.getDeliverySpace().getSpaceName();
            }
        }
        return t;
    }

    private static String getPositionString(GalleyEquipmentSetComplete set, GalleyEquipmentComplete eq, DeliverySpaceComplete space) {
        String t = "-";
        if (set != null) {
            t = set.getGalleyCode();
        }
        if (eq != null) {
            t = t + " " + eq.getPositionCode();
        }
        if (space != null) {
            if (space.getSpaceName() != null) {
                t = t + " " + space.getSpaceName();
            } else if (space instanceof GalleyEquipmentInsertComplete) {
                t = t + ((GalleyEquipmentInsertComplete)space).getCode();
            } else if (space instanceof GalleyEquipmentReservedSpaceComplete) {
                t = t + "(R) " + ((GalleyEquipmentReservedSpaceComplete)space).getContainedInsertType().getName();
            }
        }
        return t;
    }

    private static void ensureEDR(EquipmentDistributionRuleComplete edr, GalleyDistributionRuleComplete gdr, DeliverableComplete di, List<ScreenValidationObject> rets) {
        Iterator it = edr.getInsertDistributionRule().iterator();
        while (it.hasNext()) {
            String t;
            DeliverySpaceDistributionRuleComplete dsdrc = (DeliverySpaceDistributionRuleComplete)it.next();
            if (dsdrc.getQuantity() < 1) {
                t = "Found a Insert Distribution Rule (" + DataInterface.getDeliveryInstructionName(di) + ") on (" + DataInterface.getPositionString(gdr, edr, dsdrc) + ") with a quantity < 1";
                log.debug(t);
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, t));
                continue;
            }
            if (!edr.getGalleyEquipment().getDeliverySpaces().contains(dsdrc.getDeliverySpace())) {
                it.remove();
                continue;
            }
            if (dsdrc.getDeliverySpace() == null) {
                t = "Found a Insert Distribution Rule (" + DataInterface.getDeliveryInstructionName(di) + ") on (" + DataInterface.getPositionString(gdr, edr, dsdrc) + ") with no Insert Space referenced => REMOVED";
                log.debug(t);
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t));
                it.remove();
                continue;
            }
            if (!dsdrc.getDeliverySpace().getDistributionRules().contains(dsdrc)) {
                dsdrc.getDeliverySpace().getDistributionRules().add(dsdrc);
                t = "Found a Insert Distribution Rule (" + DataInterface.getDeliveryInstructionName(di) + ") on (" + DataInterface.getPositionString(gdr, edr, dsdrc) + ") which references a Insert but the Insert but is not referenced by the Insert => readd";
                log.debug(t);
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t));
                continue;
            }
            DeliverySpaceComplete s = dsdrc.getDeliverySpace();
            List drs = edr.getGalleyEquipment().getDeliverySpaces();
            boolean found = false;
            for (DeliverySpaceComplete ds : drs) {
                if (!ds.equals((Object)s)) continue;
                found = true;
            }
            if (found) continue;
            String t2 = "Found a Insert Distribution Rule " + DataInterface.getDeliveryInstructionName(di) + " on (" + DataInterface.getPositionString(gdr, edr, dsdrc) + ") which references a Insert which is not in Galley Equpiments Insert List => ADD";
            log.debug(t2);
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t2));
            edr.getGalleyEquipment().getDeliverySpaces().add(s);
        }
    }

    public ThreadSafeExecutable getStowingList(final IStowingListLight stowing, final long loadingId, final RemoteLoader invoker, final LoadingAnimation animation, final PegasusSubModule peg) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                List<ScreenValidationObject> r = null;
                animation.stateChanged("Load Stowing List");
                Node stowingList = null;
                if (stowing instanceof StowingListTemplateVariantLight) {
                    StowingListTemplateVariantLight ll = (StowingListTemplateVariantLight)stowing;
                    StowingListTemplateVariantComplete l = (StowingListTemplateVariantComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariant(new StowingListTemplateVariantReference(ll.getId())).getValue();
                    boolean reloadServiceGroups = false;
                    for (DeliverableComplete deliverable : l.getDeliverables()) {
                        ServiceDeliverableComplete sd;
                        LoadingGroupTemplateComplete group;
                        if (!(deliverable instanceof ServiceDeliverableComplete) || (group = (LoadingGroupTemplateComplete)(sd = (ServiceDeliverableComplete)deliverable).getLoadingGroup()).getContainingService() != null || group.getContainingServiceId() == null) continue;
                        reloadServiceGroups = true;
                    }
                    if (reloadServiceGroups) {
                        HashMap<Long, CateringServiceScheduleComplete> groupIndex = new HashMap<Long, CateringServiceScheduleComplete>();
                        List services = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getStowableServiceByTemplateVariant(new StowingListTemplateVariantReference(ll.getId())).getList();
                        for (CateringServiceScheduleComplete service : services) {
                            groupIndex.put(service.getId(), service);
                        }
                        for (DeliverableComplete deliverable : l.getDeliverables()) {
                            ServiceDeliverableComplete sd;
                            LoadingGroupTemplateComplete group;
                            if (!(deliverable instanceof ServiceDeliverableComplete) || (group = (LoadingGroupTemplateComplete)(sd = (ServiceDeliverableComplete)deliverable).getLoadingGroup()).getContainingService() != null || group.getContainingServiceId() == null) continue;
                            group.setContainingService((CateringServiceScheduleComplete)groupIndex.get(group.getContainingServiceId()));
                        }
                    }
                    r = DataInterface.ensureDeliveryInstruction(l);
                    peg.setLocked(ll.getState() == ModificationStateE.ACCEPTED);
                    stowingList = INodeCreator.getDefaultImpl().getNode4DTO((Object)l, false, false);
                    stowingList.setValue((Object)l, 0L);
                    stowingList.updateNode();
                    stowingList.setName("StowingList");
                } else if (stowing instanceof StowingListLight) {
                    StowingListLight ll = (StowingListLight)stowing;
                    StowingListComplete l = (StowingListComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getStowingList(new StowingListReference(ll.getId())).getValue();
                    r = DataInterface.ensureDeliveryInstruction(l);
                    FlightReference flightReference = new FlightReference(l.getFlight() != null ? l.getFlight().getId() : l.getFlightId());
                    FlightComplete flight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(flightReference).getValue();
                    peg.setLocked(false);
                    stowingList = INodeCreator.getDefaultImpl().getNode4DTO((Object)l, false, false);
                    stowingList.removeExistingValues();
                    stowingList.setValue((Object)l, 0L);
                    stowingList.updateNode();
                    stowingList.setName("StowingList");
                }
                INodeCreator.getDefaultImpl().initUpdate(stowingList);
                return stowingList;
            }

            @Override
            public RemoteLoader getInvoker() {
                return invoker;
            }

            @Override
            public long getID() {
                return loadingId;
            }
        };
        return run;
    }

    public ThreadSafeExecutable getMasterData(final long id, final RemoteLoader invoker, final LoadingAnimation animation) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                animation.stateChanged("Load Master Data");
                Node colors = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
                colors.setName("LabelColors");
                NodeToolkit.addAffix((Node)colors);
                Node types = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(GalleyEquipmentTypeComplete.class);
                types.setName("EquipmentTypes");
                NodeToolkit.addAffix((Node)types);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperProductCategories();
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                StaticEnumServiceManager.getAllSPMLFillStrategies();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                StaticEnumServiceManager.getGalleyFillStrategies();
                StaticEnumServiceManager.getChoiceCalculationStrategy();
                StaticEnumServiceManager.getEquipmentFillStrategies();
                StaticEnumServiceManager.getRoundingStrategies((boolean)false);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(FillStrategyTypeComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(GalleyEquipmentSystemComplete.class);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return invoker;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        return run;
    }

    public ThreadSafeExecutable getInserts(final long id, final RemoteLoader invoker, final LoadingAnimation animation) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                animation.stateChanged("Load Equipments");
                Node boxes = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(GalleyEquipmentInsertTypeComplete.class);
                boxes.setName("Boxes");
                NodeToolkit.addAffix((Node)boxes);
                ExcecutionTimeDisplayer.getExcecutionTimeDisplayer().closeGroup();
                return boxes;
            }

            @Override
            public RemoteLoader getInvoker() {
                return invoker;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        return run;
    }

    static {
        log = LoggerFactory.getLogger(LegToolkit.class);
    }
}

