/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details;

import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbTable;
import ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.utils.RotationBreadCrumbPanel;
import ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.utils.RotationBreadCrumbPartsTable;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.RoundingStrategyE;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartChoiceComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PartsDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T> {
    private static final long serialVersionUID = 1L;
    private RotationBreadCrumbPanel panel;
    private Node<CateringServiceScheduleVariantComplete> currentNode;

    public PartsDetailsPanel(RowEditor<T> editor, Node<MealPlanLight> mealPlanNode, RDProvider provider) {
        super(editor, null);
        this.setTitleText(Words.PARTS_CHOICES);
        this.panel = new RotationBreadCrumbPanel(editor.getModel().getParentModel().getDataHandler(), Integer.MAX_VALUE, editor, mealPlanNode, provider);
        this.panel.enableSorting();
        this.setCustomLayouter(new Layout());
        this.addToView(this.panel);
    }

    public RotationBreadCrumbPanel getPanel() {
        return this.panel;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.currentNode = node;
        this.panel.setNode(this.currentNode);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.panel.kill();
        this.panel = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean shouldEnable = isEnabled;
        MealPlanLight mp = (MealPlanLight)this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.mealplan).getValue();
        if (mp != null) {
            shouldEnable = mp.getState() == ModificationStateE.DRAFT && shouldEnable;
        }
        super.setEnabled(shouldEnable);
        this.panel.setEnabled(shouldEnable);
    }

    public void enableAddButton(boolean isEnabled) {
        Iterator<BreadCrumbTable> it = this.panel.getTables();
        while (it.hasNext()) {
            BreadCrumbTable t = it.next();
            if (!(t instanceof RotationBreadCrumbPartsTable) || t.getAddButton() == null) continue;
            t.enableAddButton(isEnabled);
        }
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.panel);
        return a;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        boolean isValid = true;
        Iterator it = this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotations).getChilds();
        HashMap<MealTypeComplete, Integer> fills = new HashMap<MealTypeComplete, Integer>();
        boolean checkedFills = false;
        while (it.hasNext()) {
            Node rot = (Node)it.next();
            Iterator it2 = rot.getChildNamed(CateringServiceRotationComplete_.parts).getChilds();
            while (it2.hasNext()) {
                MealTypeComplete mt;
                Node part = (Node)it2.next();
                int n = 0;
                Iterator it3 = part.getChildNamed(CateringServicePartComplete_.choices).getChilds();
                while (it3.hasNext()) {
                    Node choice = (Node)it3.next();
                    if (choice.getChildNamed(CateringServicePartChoiceComplete_.product).getValue() == null) {
                        isValid = false;
                    }
                    if (choice.getChildNamed(CateringServicePartChoiceComplete_.roundingStrategy).getValue() != RoundingStrategyE.FILL) continue;
                    ++n;
                }
                if (n > 1) {
                    o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure FILL option is choosen only once per Part (" + part.getChildNamed(new String[]{CateringServicePartComplete_.loadingGroup + "-" + ALoadingGroupComplete_.name}).getValue() + ")"));
                    continue;
                }
                if (n != true || (mt = (MealTypeComplete)part.getChildNamed(new DtoField[]{CateringServicePartComplete_.loadingGroup, ALoadingGroupComplete_.mealType}).getValue()) == null) continue;
                Integer i = (Integer)fills.get(mt);
                if (i == null) {
                    i = 0;
                }
                i = i + n;
                fills.put(mt, i);
            }
            if (checkedFills) continue;
            for (Map.Entry entry : fills.entrySet()) {
                if ((Integer)entry.getValue() <= 1) continue;
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Meal Type " + ((MealTypeComplete)entry.getKey()).getCode() + " has more than one choice with rounding strategy FILL"));
            }
            checkedFills = true;
        }
        if (!isValid) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Choices have a Product set"));
        }
        boolean isValid2 = true;
        it = this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.loadingGroups).getFailSafeChildIterator();
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            String string = (String)n.getChildNamed(LoadingGroupTemplateComplete_.name).getValue();
            if (string == null) continue;
            if (map.get(string) != null) {
                isValid2 = false;
                continue;
            }
            map.put(string, n.getValue(ALoadingGroupComplete.class));
        }
        if (!isValid2) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Loading Group Names must be unique within a Service"));
        }
        return o;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PartsDetailsPanel.this.panel.setLocation(0, 0);
            PartsDetailsPanel.this.panel.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 400);
        }
    }
}

