/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.utils.popupinsert.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class DayButton
extends Button
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private String text;
    private boolean isChoosen = false;
    private Node<Boolean> node;
    private BufferedImage image_selected;
    private BufferedImage image_over;
    private Color foreground_used;
    private Color foreground_unused;
    private static Font selected_date_font;

    public DayButton(String t, Node<Boolean> c) {
        this.node = c;
        this.text = t;
        this.image_selected = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("calendar_widget_dayunterline_selected"));
        this.image_over = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("calendar_widget_dayunterline_over"));
        this.foreground_used = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("calendar_foreground_dates_used"));
        this.foreground_unused = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("calendar_foreground_dates_unused"));
        selected_date_font = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("calendar_font_size_dates"), LafLoader.getLafLoader().getAttribute("calendar_selected_date_font_type"));
        this.isChoosen = (Boolean)this.node.getValue();
        this.addButtonListener(this);
        this.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.text = null;
        this.image_selected = null;
        this.image_over = null;
        this.foreground_used = null;
        this.foreground_unused = null;
        selected_date_font = null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isChoosen) {
            g2.drawImage(this.image_selected, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), null);
            g2.setColor(this.foreground_used);
        } else if (this.isOver) {
            g2.drawImage(this.image_over, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), null);
            g2.setColor(this.foreground_unused);
        }
        g2.setFont(selected_date_font);
        g2.drawString(this.text, (this.getWidth() - g2.getFontMetrics().stringWidth(this.text)) / 2, (this.getHeight() + g2.getFont().getSize()) / 2 - 1);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.isChoosen = !this.isChoosen;
        this.node.setValue((Object)this.isChoosen, System.currentTimeMillis());
        this.repaint(32L);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image_selected == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.image_selected.getWidth(), this.image_selected.getHeight());
    }
}

