/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.store.article.movementnew;

import ch.icit.pegasus.client.gui.modules.stock.StockModuleDataHandler;
import ch.icit.pegasus.client.gui.screentemplates.SubModuleScreenInsert;
import ch.icit.pegasus.client.gui.submodules.tool.store.article.movementnew.TableRowImplNEW2;
import ch.icit.pegasus.client.gui.table.DefaultFootablePanel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.fake.FakeSmartScreenTableRow;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.RemarkButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.ArticleMiniComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ImportPopupInsert;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.ArticleChargeBatchSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.StoreAccess;
import ch.icit.pegasus.server.core.dtos.search.ArticleChargeBatchSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ArticleChargeSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StorePositionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StoreSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.util.DeletedStateE;
import ch.icit.pegasus.server.core.dtos.util.InUseStateE;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MovementCBSubModuleNEW
extends SubModuleScreenInsert<StoreLight>
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    protected PageableTable2 lowerTable;
    protected PageableTable2 upperTable;
    private final RDProvider provider = new RDProvider(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), StoreAccess.MODULE_STORE);
    private static final int STATE_LOADING_STORE = 12;
    protected static final String FILTER_ARTICLE_ID = "Article";
    protected static final String FILTER_POSITION_ID = "Position";
    protected static final String FILTER_DELETED = "Deleted";
    protected static final String FILTER_INUSE = "Inuse";
    protected static final String FILTER_CUSTOMER = "Customer";
    protected static final int STATE_INVALID = 0;
    protected boolean moveWhileInventory = this.provider.isWritable(StoreAccess.CAN_MOVE_CHARGE_WHEN_INVENTORY_IS_ACTIVE);
    protected ArticleMiniComboBox miniCombo;
    protected String fc1;
    protected String fc2;
    protected StorePositionLight selectedStorePosition;
    protected DeletedStateE fc3;
    protected InUseStateE fc4;
    protected CustomerReference customer;
    protected StoreLight storeDTO;
    private StockModuleDataHandler dataHandler;
    private ComboBox deleted;
    private ComboBox inUse;
    private TitledItem<TextButton> importButton;
    private int currentState;
    private SearchAlgorithm<?> searcher;

    public MovementCBSubModuleNEW() {
        this.setOpaque(false);
    }

    public boolean isMoveWhileInventory() {
        return this.moveWhileInventory;
    }

    public boolean isChargeBased() {
        return true;
    }

    @Override
    public String getScreenTitle() {
        return StoreAccess.TOOL_STORE_MOVEMENT_CB.getDisplayName();
    }

    public String getPanelTitle() {
        return Words.ARTICLE_CHARGES;
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.lowerTable.kill();
        this.lowerTable = null;
        this.upperTable.kill();
        this.upperTable = null;
        if (this.importButton != null) {
            this.importButton.kill();
        }
        this.importButton = null;
        this.miniCombo.kill();
        this.miniCombo = null;
        this.deleted.kill();
        this.deleted = null;
        this.inUse.kill();
        this.inUse = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.lowerTable.setEnabled(isEnabled);
        this.upperTable.setEnabled(isEnabled);
        if (this.importButton != null) {
            this.importButton.setEnabled(isEnabled);
        }
    }

    public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> getSearchConfig(String id, Object value) {
        ArticleChargeBatchSearchConfiguration c = new ArticleChargeBatchSearchConfiguration();
        if (this.moveWhileInventory) {
            c.setHideCountedArticles(Boolean.valueOf(false));
        }
        if (FILTER_ARTICLE_ID.equals(id)) {
            this.fc1 = (String)value;
        } else if (FILTER_POSITION_ID.equals(id)) {
            this.selectedStorePosition = (StorePositionLight)value;
        } else if (FILTER_DELETED.equals(id)) {
            if (value instanceof DeletedStateE) {
                this.fc3 = (DeletedStateE)value;
            }
        } else if (FILTER_INUSE.equals(id)) {
            if (value instanceof InUseStateE) {
                this.fc4 = (InUseStateE)value;
            }
        } else if (FILTER_CUSTOMER.equals(id)) {
            this.customer = value instanceof CustomerReference ? (CustomerReference)value : null;
        }
        if (this.fc1 != null && this.fc1.trim().isEmpty()) {
            this.fc1 = null;
        }
        if (this.fc2 != null && this.fc2.trim().isEmpty()) {
            this.fc2 = null;
        }
        String t = this.fc1;
        Integer ti = null;
        try {
            ti = Integer.valueOf(t);
        }
        catch (NumberFormatException e) {
            ti = null;
        }
        switch (this.miniCombo.getSelectedType()) {
            case ALL: {
                c.setArticleName(t);
                c.setArticleNumber(ti);
                c.setCustomerArticleNumber(t);
                break;
            }
            case ARTICLE_NAME: {
                c.setArticleName(t);
                break;
            }
            case ARTICLE_NUMBER: {
                c.setArticleNumber(ti);
                break;
            }
            case CUSTOMER_NUMBER: {
                c.setCustomerArticleNumber(t);
                break;
            }
        }
        c.setStorePosition(this.selectedStorePosition);
        c.setCurrentStore(this.storeDTO);
        c.setCustomer(this.customer);
        UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        Boolean canMoveAny = false;
        for (ModuleAccessRightComplete module : currentUser.getModules()) {
            if (!module.getModule().getInvokingName().equals(StoreAccess.MODULE_STORE.getIdentifier())) continue;
            for (DataFieldAccessRightComplete fieldAccessRight : module.getFieldAccessRights()) {
                if (!fieldAccessRight.getField().getName().equals(StoreAccess.MOVE_ANY_ARTICLE.getName())) continue;
                canMoveAny = null;
            }
        }
        if (canMoveAny == null) {
            c.setOnlyArticleWithTransactionsAllowed(null);
        } else {
            c.setOnlyArticleWithTransactionsAllowed(Boolean.valueOf(true));
        }
        if (this.fc3 != null) {
            switch (this.fc3) {
                case ALL: {
                    c.setIsDeleted(null);
                    break;
                }
                case NOT_DELETED: {
                    c.setIsDeleted(Boolean.valueOf(false));
                    break;
                }
                case ONLY_DELETED: {
                    c.setIsDeleted(Boolean.valueOf(true));
                    break;
                }
                default: {
                    c.setIsDeleted(null);
                }
            }
        }
        if (this.fc4 != null) {
            switch (this.fc4) {
                case ALL: {
                    c.setInUse(null);
                    break;
                }
                case NOT_USED: {
                    c.setInUse(Boolean.valueOf(false));
                    break;
                }
                case ONLY_USED: {
                    c.setInUse(Boolean.valueOf(true));
                    break;
                }
                default: {
                    c.setInUse(null);
                }
            }
        }
        c.setSortColumn((Enum)ArticleChargeBatchSearchConfiguration.ARTICLE_CHARGE_BATCH_COLUMN.STORE_POSITION);
        c.setNumResults(30);
        return c;
    }

    private void init(FakeSmartScreenTableRow<StoreLight> rmodel) {
        this.lowerTable = new PageableTable2("", false){
            private static final long serialVersionUID = 1L;
            private Button box;

            @Override
            public SearchAlgorithm getSearchAlgorithm() {
                return MovementCBSubModuleNEW.this.searcher;
            }

            @Override
            public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
                return MovementCBSubModuleNEW.this.getSearchConfig(id, value);
            }

            @Override
            public void fillFilterChain() {
            }

            @Override
            public void buttonPressed(Button source, int x, int y) {
            }

            @Override
            public String isPageSwitchReady() {
                return super.isPageSwitchReady();
            }
        };
        this.lowerTable.setTitleText(this.getPanelTitle());
        this.lowerTable.setModel(new Table2Model(this.getColumns(), model1 -> new TableRowImplNEW2(model1, this, false)));
        this.lowerTable.getModel().setNode((Node)new ViewNode(""));
        this.lowerTable.initSortedColumn(1, true);
        this.lowerTable.setSortable(false);
        if (this.isChargeBased()) {
            this.lowerTable.setFooterPanel(new DefaultFootablePanel());
            this.importButton = new TitledItem<TextButton>(new TextButton(Words.IMPORT), "Column A = Article Number, C = Charge Number, F = Store Code, G = Position Code", TitledItem.TitledItemOrientation.EAST);
            this.lowerTable.getFootablePanel().setLayout(new FlowLayout(3));
            this.lowerTable.getFootablePanel().add(this.importButton);
            this.importButton.getElement().addButtonListener(this);
        }
        this.add(this.lowerTable);
        this.upperTable = new PageableTable2("", true){
            private static final long serialVersionUID = 1L;

            @Override
            public SearchAlgorithm getSearchAlgorithm() {
                return MovementCBSubModuleNEW.this.searcher;
            }

            @Override
            public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
                return MovementCBSubModuleNEW.this.getSearchConfig(id, value);
            }

            @Override
            public void newResultsFound() {
                MovementCBSubModuleNEW.this.revalidateTables();
            }

            @Override
            public void fillFilterChain() {
                this.filterChain.setDefault_searchFieldWidth(200);
                MovementCBSubModuleNEW.this.miniCombo = new ArticleMiniComboBox(true, false);
                this.filterChain.addConfigurableSearchField(MovementCBSubModuleNEW.FILTER_ARTICLE_ID, Words.ARTICLE, "", MovementCBSubModuleNEW.this.miniCombo);
                if (MovementCBSubModuleNEW.this.isChargeBased()) {
                    SearchTextField2<StorePositionLight> ret = this.filterChain.addStorePositionSearch(MovementCBSubModuleNEW.FILTER_POSITION_ID, Words.POSITION, true);
                    Object[] o = new Object[]{MovementCBSubModuleNEW.this.storeDTO};
                    ret.setAdditionalSearchField(o);
                } else {
                    this.filterChain.addSeachField(MovementCBSubModuleNEW.FILTER_POSITION_ID, Words.POSITION);
                }
                this.filterChain.addCustomerSearchField(MovementCBSubModuleNEW.FILTER_CUSTOMER);
                MovementCBSubModuleNEW.this.deleted = new ComboBox();
                MovementCBSubModuleNEW.this.deleted.addItem(DeletedStateE.ALL);
                MovementCBSubModuleNEW.this.deleted.addItem(DeletedStateE.NOT_DELETED);
                MovementCBSubModuleNEW.this.deleted.addItem(DeletedStateE.ONLY_DELETED);
                MovementCBSubModuleNEW.this.inUse = new ComboBox();
                MovementCBSubModuleNEW.this.inUse.addItem(InUseStateE.ALL);
                MovementCBSubModuleNEW.this.inUse.addItem(InUseStateE.NOT_USED);
                MovementCBSubModuleNEW.this.inUse.addItem(InUseStateE.ONLY_USED);
                this.filterChain.addSelectionCombo(MovementCBSubModuleNEW.FILTER_DELETED, Words.DELETED, MovementCBSubModuleNEW.this.deleted);
                this.filterChain.addSelectionCombo(MovementCBSubModuleNEW.FILTER_INUSE, Words.IN_USE, MovementCBSubModuleNEW.this.inUse);
            }

            @Override
            public String isPageSwitchReady() {
                for (Table2RowPanel p : MovementCBSubModuleNEW.this.lowerTable.getRows()) {
                    TableRowImplNEW2 tableRowImplNEW2 = (TableRowImplNEW2)p;
                }
                return super.isPageSwitchReady();
            }
        };
        this.upperTable.setTitleText(this.getPanelTitle());
        this.setLayout(new Layout());
        this.upperTable.setModel(new Table2Model(this.getColumns(), model -> new TableRowImplNEW2(model, this, true)));
        this.upperTable.initSortedColumn(1, true);
        this.upperTable.setSortable(false);
        this.upperTable.showLoadingAnimation(Words.LOAD_ARTILES);
        this.add(this.upperTable);
        this.setEnabled(false);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.importButton.getElement()) {
            this.setEnabled(false);
            this.lowerTable.showLoadingAnimation(Words.IMPORT);
            this.showFileChooser();
        }
    }

    private void showFileChooser() {
        new ImportPopupInsert(this.lowerTable, this){
            private static final long serialVersionUID = 1L;

            @Override
            public void processFile(File file) {
                ArrayList<ScreenValidationObject> warnings = new ArrayList<ScreenValidationObject>();
                HashMap<String, HashMap<String, StorePositionLight>> positionIndex = new HashMap<String, HashMap<String, StorePositionLight>>();
                int artNoColumnIndex = 0;
                int chargeColumnIndex = 2;
                int storeColumnIndex = 5;
                int storePositionColumnIndex = 6;
                try {
                    List rows = ExcelToolkit.readRows((File)file);
                    for (ExcelRow r : rows) {
                        Integer chargeNo = null;
                        Integer articleNo = null;
                        Object articleName = null;
                        articleNo = ExcelToolkit.readAsInteger((ExcelRow)r, (int)artNoColumnIndex);
                        chargeNo = ExcelToolkit.readAsInteger((ExcelRow)r, (int)chargeColumnIndex);
                        String targetStore = ExcelToolkit.readAsString((ExcelRow)r, (int)storeColumnIndex);
                        String targetStorePosition = ExcelToolkit.readAsString((ExcelRow)r, (int)storePositionColumnIndex);
                        StorePositionLight targetStorePositionDTO = null;
                        StoreLight targetStoreDTO = null;
                        if (targetStore != null && !targetStore.isEmpty()) {
                            if (positionIndex.containsKey(targetStore) && ((Map)positionIndex.get(targetStore)).containsKey(targetStorePosition)) {
                                targetStorePositionDTO = (StorePositionLight)((Map)positionIndex.get(targetStore)).get(targetStorePosition);
                            }
                            if (targetStorePositionDTO == null) {
                                try {
                                    StoreSearchConfiguration sc = new StoreSearchConfiguration();
                                    sc.setCode(targetStore);
                                    SearchResultIterator storeSI = new SearchResultIterator((ASearchConfiguration)sc);
                                    StoreLight storeLight = targetStoreDTO = storeSI.hasNext() ? (StoreLight)storeSI.next() : null;
                                    if (targetStoreDTO != null) {
                                        StorePositionSearchConfiguration c = new StorePositionSearchConfiguration();
                                        c.setPositionName(targetStorePosition);
                                        c.setStore(new StoreReference(targetStoreDTO.getId()));
                                        SearchResultIterator spSI = new SearchResultIterator((ASearchConfiguration)c);
                                        StorePositionLight storePositionLight = targetStorePositionDTO = spSI.hasNext() ? (StorePositionLight)spSI.next() : null;
                                        if (targetStorePositionDTO != null) {
                                            HashMap<String, StorePositionLight> stores = (HashMap<String, StorePositionLight>)positionIndex.get(targetStore);
                                            if (stores == null) {
                                                stores = new HashMap<String, StorePositionLight>();
                                                positionIndex.put(targetStore, stores);
                                            }
                                            stores.put(targetStorePosition, targetStorePositionDTO);
                                        }
                                    }
                                }
                                catch (ServiceException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (chargeNo == null) continue;
                        ArticleChargeSearchConfiguration c = new ArticleChargeSearchConfiguration();
                        c.setNumber(chargeNo);
                        try {
                            SearchResultIterator charges = new SearchResultIterator((ASearchConfiguration)c);
                            for (ArticleChargeLight charge : charges) {
                                ArticleChargeComplete chargeComplete = (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getCharge(new ArticleChargeReference(charge.getId())).getValue();
                                for (ArticleChargeBatchComplete b : chargeComplete.getBatches()) {
                                    Node storeQuant;
                                    if (!b.getPosition().getStore().equals((Object)MovementCBSubModuleNEW.this.storeDTO)) continue;
                                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)b, true, true);
                                    Node pN = n.getChildNamed(new String[]{"recStore"});
                                    if (pN == null) {
                                        pN = new DTOProxyNode();
                                        pN.setPermanent(true);
                                        pN.setName("recStore");
                                        n.addChild(pN, 0L);
                                    }
                                    pN.setValue((Object)targetStorePositionDTO, 0L);
                                    Node remarkNode = n.getChildNamed(new String[]{"recRemark"});
                                    if (remarkNode == null) {
                                        remarkNode = new DTOProxyNode();
                                        remarkNode.setPermanent(true);
                                        remarkNode.setName("recRemark");
                                        n.addChild(remarkNode, 0L);
                                    }
                                    if ((storeQuant = n.getChildNamed(new String[]{"orderQuant"})) == null) {
                                        storeQuant = new EmbeddedDTONode();
                                        storeQuant.setPermanent(true);
                                        storeQuant.setName("orderQuant");
                                        n.addChild(storeQuant, 0L);
                                    }
                                    StoreQuantityComplete q = new StoreQuantityComplete(b.getQuantity());
                                    storeQuant.setValue((Object)q, 0L);
                                    storeQuant.updateNode();
                                    Node customDocs = n.getChildNamed(new String[]{"customsDocs"});
                                    if (customDocs == null) {
                                        customDocs = new ListNode();
                                        customDocs.setPermanent(true);
                                        customDocs.setName("customsDocs");
                                        n.addChild(customDocs, 0L);
                                    }
                                    MovementCBSubModuleNEW.this.lowerTable.getModel().getNode().addChild(n, 0L);
                                }
                            }
                        }
                        catch (ServiceException e) {
                            InnerPopupFactory.showErrorDialog("Unable to import Data: " + e.getMessage(), (Component)MovementCBSubModuleNEW.this);
                            warnings.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.UNABLE_TO_ADD_ARTICLE, (Object[])new Object[]{articleNo, articleName})));
                            e.printStackTrace();
                        }
                    }
                }
                catch (ExcelToolkitException e) {
                    e.printStackTrace();
                }
                MovementCBSubModuleNEW.this.lowerTable.hideLoadingAnimation();
                MovementCBSubModuleNEW.this.setEnabled(true);
            }
        };
    }

    protected List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        int tw = TableColumnInfo.numberColumnWidth;
        headers.add(new TableColumnInfo(0.0, 0.0, Words.NO_NUMBER, null, null, null, "", tw, tw, tw));
        tw = TableColumnInfo.numberColumnWithExpandWidth;
        headers.add(new TableColumnInfo(0.0, 0.0, Words.CUSTOMER_ARTICLE_NUMBER, null, null, null, "", tw, tw, tw));
        headers.add(new TableColumnInfo(0.7, 0.0, Words.NAME, null, null, null, "", 50, 50, 50));
        tw = TableColumnInfo.numberColumnWidth;
        headers.add(new TableColumnInfo(0.0, 0.0, Words.POSITION, null, null, null, "", tw, tw, tw));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.IN_USE, null, null, null, "", 45, 45, 45));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.DELETED, null, null, null, "", 45, 45, 45));
        if (this.isChargeBased()) {
            headers.add(new TableColumnInfo(0.0, 0.0, Words.CHARGE, null, null, null, "", tw, tw, tw));
        }
        tw = DateChooser.getPreferredWidth(this, false) + 2 * this.lowerTable.getCellPadding();
        headers.add(new TableColumnInfo(0.0, 0.0, Words.LATEST_INVENTORY, null, null, null, "", tw, tw, tw));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.STOCK, null, null, null, "", tw, tw, tw));
        tw = ArrowConnectorIcon.getPreferredWidth() + this.lowerTable.getCellPadding() * 2;
        headers.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", tw, tw, tw));
        tw = InputComboBox2.getPreferredWidth(this, 11) + 2 * this.lowerTable.getCellPadding() + 2 * InfoButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + RemarkButton.getPreferredWidth() + 3 * this.lowerTable.getInnerCellPadding();
        headers.add(new TableColumnInfo(0.0, 0.0, Words.QUANTITY, null, null, null, "", tw, tw, tw));
        headers.add(new TableColumnInfo(0.3, 0.0, Words.RECEIVING_STORE, null, null, null, "", 50, 50, 50));
        tw = this.lowerTable.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        headers.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", tw, tw, tw));
        return headers;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.currentState == 11) {
            this.upperTable.hideLoadingAnimation();
            this.cancelDocument();
        } else if (this.currentState == 12) {
            this.startDownloadInner(node);
        } else if (this.currentState == 5) {
            this.upperTable.getModel().setNode((Node)new ViewNode(""));
            this.searcher = this.getSearchAlgorithm();
            this.upperTable.invokeDefaultSearch();
            this.upperTable.hideLoadingAnimation();
            this.setEnabled(true);
        } else if (this.currentState == 7) {
            this.upperTable.getModel().setNode((Node)new ViewNode(""));
            this.upperTable.invokeDefaultSearch();
            this.upperTable.hideLoadingAnimation();
            this.setEnabled(true);
        } else if (this.currentState == 0) {
            this.upperTable.getModel().setNode((Node)new ViewNode(""));
            this.upperTable.invokeDefaultSearch();
            this.setEnabled(true);
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.upperTable.hideLoadingAnimation();
        this.setEnabled(true);
        super.errorOccurred(exception);
    }

    public SearchAlgorithm<?> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(ArticleChargeBatchSearchAlgorithm.class);
    }

    public void redo() {
    }

    public void undo() {
    }

    @Override
    public void saveAndBackDocument() {
        this.upperTable.showLoadingAnimation(Words.SAVE_DATA);
        this.currentState = 11;
        this.doSave();
    }

    @Override
    public void saveDocument() {
        this.upperTable.showLoadingAnimation(Words.SAVE_DATA);
        this.currentState = 7;
        this.doSave();
    }

    public List<ScreenValidationObject> validateMovements() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        for (Table2RowPanel row : this.lowerTable.getRows()) {
            TableRowImplNEW2 implRow = (TableRowImplNEW2)row;
            ScreenValidationObject b = implRow.validateRow();
            if (b == null) continue;
            a.add(b);
        }
        return a;
    }

    private void doSave() {
        this.setEnabled(false);
        List<ScreenValidationObject> validateMovements = this.validateMovements();
        if (!validateMovements.isEmpty()) {
            InnerPopupFactory.showErrorDialog(validateMovements, "Unable to save Movements", (Component)this);
            this.setEnabled(true);
            this.upperTable.hideLoadingAnimation();
        }
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<ManualStockMovementComplete> transactions = new ArrayList<ManualStockMovementComplete>();
                List<Table2RowPanel> rows2 = MovementCBSubModuleNEW.this.lowerTable.getModel().getTable().getRows();
                ArrayList<Table2RowPanel> rows = new ArrayList<Table2RowPanel>();
                rows.addAll(rows2);
                ArrayList<TableRowImplNEW2> removeAfter = new ArrayList<TableRowImplNEW2>();
                for (Table2RowPanel table2RowPanel : rows) {
                    TableRowImplNEW2 row = (TableRowImplNEW2)table2RowPanel;
                    Node n = row.getModel().getNode();
                    if (row.isValidRow()) {
                        Node position;
                        Node firstBatch;
                        Node batches;
                        Node recStore = n.getChildNamed(new String[]{"recStore"});
                        Node recRemark = n.getChildNamed(new String[]{"recRemark"});
                        Node orderQuant = n.getChildNamed(new String[]{"orderQuant"});
                        if (orderQuant.getValue() == null) {
                            orderQuant.setValue((Object)new StoreQuantityComplete(), 0L);
                        }
                        orderQuant.commit();
                        recRemark.commit();
                        recStore.commit();
                        ManualStockMovementComplete sTransaction = new ManualStockMovementComplete();
                        sTransaction.setAmount((StoreQuantityComplete)orderQuant.getValue());
                        if (MovementCBSubModuleNEW.this.isChargeBased()) {
                            if (n.getValue() instanceof ArticleChargeLight) {
                                sTransaction.setCharge((ArticleChargeLight)n.getValue(ArticleChargeLight.class));
                            } else if (n.getValue() instanceof ArticleChargeBatchComplete) {
                                sTransaction.setCharge((ArticleChargeLight)((ArticleChargeBatchComplete)n.getValue()).getCharge());
                            } else {
                                ArticleChargeReference r = (ArticleChargeReference)n.getValue();
                                ArticleChargeComplete rc = (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getCharge(r).getValue();
                                sTransaction.setCharge((ArticleChargeLight)rc);
                            }
                        } else {
                            Node charge = n.getChildNamed(new String[]{"batches"}).getChildAt(0).getChildNamed(new String[]{"charge"});
                            sTransaction.setCharge((ArticleChargeLight)charge.getValue());
                        }
                        sTransaction.setDestinationPosition((StorePositionLight)recStore.getValue());
                        if (MovementCBSubModuleNEW.this.isChargeBased() && (batches = n.getChildNamed(new String[]{"batches"})) != null && (firstBatch = batches.getChildAt(0)) != null && (position = firstBatch.getChildNamed(new String[]{"position"})) != null) {
                            sTransaction.setOriginPosition((StorePositionLight)position.getValue());
                        }
                        row.getModel().getNode().getChildNamed(new String[]{"customsDocs"}).commitThis();
                        List docs = (List)row.getModel().getNode().getChildNamed(new String[]{"customsDocs"}).getValue();
                        sTransaction.setCustomsDocs(docs);
                        if (sTransaction.getOriginPosition() == null) {
                            Node storePos = null;
                            storePos = MovementCBSubModuleNEW.this.isChargeBased() ? n.getChildNamed(new String[]{"position"}) : n.getChildNamed(new String[]{"storePosition"});
                            if (storePos != null) {
                                sTransaction.setOriginPosition((StorePositionLight)storePos.getValue());
                            }
                        }
                        sTransaction.setUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                        if (sTransaction.getOriginPosition() != null) {
                            transactions.add(sTransaction);
                        }
                    } else {
                        MovementCBSubModuleNEW.this.currentState = 0;
                        return null;
                    }
                    n.removeAllChilds();
                    removeAfter.add(row);
                }
                for (Table2RowPanel table2RowPanel : removeAfter) {
                    MovementCBSubModuleNEW.this.lowerTable.getModel().getTable().removeRow(table2RowPanel, false);
                }
                ArrayList<ClientServerCallException> l = new ArrayList<ClientServerCallException>();
                for (ManualStockMovementComplete smc : transactions) {
                    try {
                        ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).move(smc, MovementCBSubModuleNEW.this.isChargeBased(), MovementCBSubModuleNEW.this.moveWhileInventory);
                    }
                    catch (ClientServerCallException e) {
                        l.add(e);
                    }
                }
                if (!l.isEmpty()) {
                    throw new ClientExceptionCollection("Errors on saving Store Movement", l);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return MovementCBSubModuleNEW.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    protected void createFocusCycle() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.addAll(this.upperTable.getFocusComponents());
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void screenSet() {
    }

    @Override
    public void startDataDownload() {
        this.currentState = 12;
        this.remoteObjectLoaded(null);
    }

    public void startDownloadInner(Node n) {
        this.currentState = 5;
        this.remoteObjectLoaded(n);
    }

    @Override
    public void setRowAttributes(RowTransferObject<StoreLight> o) {
        if (o != null) {
            FakeSmartScreenTableRow<StoreLight> rowM = o.getFakeRow();
            this.setRow(rowM);
            this.storeDTO = (StoreLight)o.getDto();
            this.dataHandler = (StockModuleDataHandler)o.getDatahandler();
            this.init(rowM);
        }
    }

    public void addToLowerTable(Table2RowModel model) {
        this.lowerTable.getModel().getNode().addChild(model.getNode(), 0L);
        this.revalidateTables();
    }

    public void removeFromLowerTable(TableRowImplNEW2 tableRowImplNEW2) {
        this.lowerTable.removeRow(tableRowImplNEW2, true);
        this.revalidateTables();
    }

    public void revalidateTables() {
        HashSet<Tuple> used = new HashSet<Tuple>();
        List<Table2RowPanel> usedRows = this.lowerTable.getModel().getTable().getRows();
        for (Table2RowPanel tableRowPanel : usedRows) {
            ADTO adto = (ADTO)tableRowPanel.getModel().getNode().getValue();
            if (!(adto instanceof ArticleChargeBatchComplete)) continue;
            used.add(new Tuple((Object)((ArticleChargeBatchComplete)adto).getCharge().getId(), (Object)((ArticleChargeBatchComplete)adto).getPosition().getId()));
        }
        List<Table2RowPanel> rows = this.upperTable.getModel().getTable().getRows();
        for (Table2RowPanel tableRowPanel : rows) {
            ADTO adto = (ADTO)tableRowPanel.getModel().getNode().getValue();
            if (!(adto instanceof ArticleChargeBatchComplete)) continue;
            if (used.contains(new Tuple((Object)((ArticleChargeBatchComplete)adto).getCharge().getId(), (Object)((ArticleChargeBatchComplete)adto).getPosition().getId()))) {
                ((TableRowImplNEW2)tableRowPanel).setBlocked(true);
                continue;
            }
            ((TableRowImplNEW2)tableRowPanel).setBlocked(false);
        }
    }

    @Override
    public SubModuleDefinitionComplete getSubModuleDefinition() {
        return StoreAccess.getSubModuleDefinition((SubModuleAccessDefinition)StoreAccess.TOOL_STORE_INVENTORY_CB);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = MovementCBSubModuleNEW.this.layoutTitle(parent);
            y = MovementCBSubModuleNEW.this.layoutTitleBar(y, parent.getWidth());
            MovementCBSubModuleNEW.this.upperTable.setLocation(0, y + 10);
            MovementCBSubModuleNEW.this.upperTable.setSize(parent.getWidth(), (parent.getHeight() - y - 30) / 2);
            MovementCBSubModuleNEW.this.lowerTable.setLocation(0, MovementCBSubModuleNEW.this.upperTable.getY() + MovementCBSubModuleNEW.this.upperTable.getHeight() + 10);
            MovementCBSubModuleNEW.this.lowerTable.setSize(parent.getWidth(), (parent.getHeight() - y - 30) / 2 - 10);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

