/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.commiter;

import ch.icit.pegasus.client.gui.table.commiter.ClientFileTransferListener;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import java.io.File;
import javax.swing.SwingUtilities;

public class FileDownloader
implements FileTransferListener {
    private PegasusFileComplete imageRef;
    private ClientFileTransferListener delegationListener;
    private File downloadedFile;

    public FileDownloader(PegasusFileComplete image) {
        this.imageRef = image;
    }

    public void download(ClientFileTransferListener listener) {
        this.delegationListener = listener;
        try {
            File f;
            if (this.imageRef.getId() != null) {
                FileTransferUtil.download((PegasusFileComplete)this.imageRef, (FileTransferListener[])new FileTransferListener[]{this});
                f = FileTransferUtil.download((PegasusFileComplete)this.imageRef, (FileTransferListener[])new FileTransferListener[]{this});
            } else {
                f = this.imageRef.getLocalFile();
            }
            this.downloadedFile = f;
            if (this.delegationListener != null) {
                this.delegationListener.fileDownloaded(f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File getDownloadedFile() {
        return this.downloadedFile;
    }

    public void exceptionOccurred(Exception exception) {
        this.delegationListener.exceptionOccurred(exception);
    }

    public void statusChanged(File file, FileTransferState state) {
        if (this.delegationListener != null) {
            SwingUtilities.invokeLater(() -> this.delegationListener.statusChanged(file, state));
        }
    }
}

