/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table2;

import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.skins.AlignedSizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SortableTable2RowPanel
extends Table2RowPanel
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    protected ArrowButton upButton;
    protected ArrowButton downButton;
    protected DeleteButton deleteButton;
    private boolean isUpEnabled;
    private boolean isDownEnabled;
    protected String attName;
    protected int startOffset;
    protected int endOffset;

    public SortableTable2RowPanel(Table2RowModel m, boolean isOrder, boolean isDelete) {
        super(m);
        this.setSortAttributeName("sequenceNumber");
        if (isOrder) {
            this.upButton = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Up, SizedSkin1Field.SkinSize.SMALL);
            this.downButton = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Down, SizedSkin1Field.SkinSize.SMALL);
            this.upButton.addButtonListener(this);
            this.downButton.addButtonListener(this);
            this.add(this.upButton);
            this.add(this.downButton);
        }
        if (isDelete) {
            this.deleteButton = new DeleteButton(SizedSkin1Field.SkinSize.SMALL);
            this.deleteButton.addButtonListener(this);
            this.add(this.deleteButton);
        }
    }

    public SortableTable2RowPanel(Table2RowModel m) {
        this(m, true, true);
    }

    @Override
    public Object getObject4Column(int column) {
        return this.model.getNode().getChildNamed(new String[]{this.attName}).getValue();
    }

    protected void disableDeleteButton() {
        if (this.deleteButton != null) {
            this.deleteButton.kill();
            this.deleteButton = null;
        }
    }

    protected void setSortAttributeName(DtoField dtoField) {
        this.setSortAttributeName(dtoField.getFieldName());
    }

    @Deprecated
    protected void setSortAttributeName(String attName) {
        this.attName = attName;
    }

    protected void setStartEndOffset(int startOffset, int endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    protected void layoutSortButtons(int currentX, int height) {
        this.layoutSortButtons(currentX, height, false);
    }

    protected void layoutSortButtons(int currentX, int height, boolean isWithin) {
        int w = 0;
        if (this.upButton != null && this.downButton != null) {
            if (isWithin) {
                this.upButton.setLocation(currentX + this.getInnerCellPadding(), (int)(((double)height - this.upButton.getPreferredSize().getHeight()) / 2.0));
            } else {
                this.upButton.setLocation(currentX + this.getCellPadding(), (int)(((double)height - this.upButton.getPreferredSize().getHeight()) / 2.0));
            }
            this.upButton.setSize(this.upButton.getPreferredSize());
            this.downButton.setLocation(this.upButton.getX() + this.upButton.getWidth() + this.getInnerCellPadding(), (int)(((double)height - this.downButton.getPreferredSize().getHeight()) / 2.0));
            this.downButton.setSize(this.downButton.getPreferredSize());
            w = this.downButton.getX() + this.downButton.getWidth() + this.getCellPadding() - currentX;
        } else if (this.deleteButton != null) {
            w = (int)((double)(2 * this.getCellPadding()) + this.deleteButton.getPreferredSize().getWidth() * 2.0 + (double)this.getInnerCellPadding());
        }
        if (this.deleteButton != null) {
            this.deleteButton.setLocation(currentX + w, (int)(((double)height - this.deleteButton.getPreferredSize().getHeight()) / 2.0));
            this.deleteButton.setSize(this.deleteButton.getPreferredSize());
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.upButton != null && this.downButton != null) {
            this.upButton.setEnabled(isEnabled & this.isUpEnabled);
            this.downButton.setEnabled(isEnabled & this.isDownEnabled);
        }
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        return a;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.upButton != null) {
            this.upButton.kill();
        }
        if (this.downButton != null) {
            this.downButton.kill();
        }
        if (this.deleteButton != null) {
            this.deleteButton.kill();
        }
        this.upButton = null;
        this.downButton = null;
        this.deleteButton = null;
    }

    @Override
    public void updateRowOrder() {
        if (this.attName == null || this.upButton == null || this.downButton == null || this.getModel().getNode() == null) {
            return;
        }
        int i = 0;
        i = this.getModel().getNode().getChildNamed(new String[]{this.attName}).getValue() == null ? 0 : (Integer)this.getModel().getNode().getChildNamed(new String[]{this.attName}).getValue();
        if (i == this.startOffset && this.upButton != null) {
            this.upButton.setEnabled(false);
            this.isUpEnabled = false;
        } else if (this.upButton != null) {
            this.upButton.setEnabled(true);
            this.isUpEnabled = true;
        }
        if (i == this.model.getParentModel().getTable().getRowCount() - this.endOffset && this.downButton != null) {
            this.downButton.setEnabled(false);
            this.isDownEnabled = false;
        } else if (this.downButton != null) {
            this.downButton.setEnabled(true);
            this.isDownEnabled = true;
        }
    }

    private void relayoutTable() {
        this.model.getParentModel().getTable().updateOrder();
        this.model.getParentModel().getTable().relayoutRequested();
    }

    @Override
    public Object getSortableObject() {
        return this.model.getNode().getChildNamed(new String[]{this.attName}).getValue();
    }

    protected void moveUp() {
        try {
            int i = this.model.getParentModel().getTable().getRowIndex(this);
            if (i + this.startOffset > this.startOffset) {
                Table2RowPanel p = this.model.getParentModel().getTable().getRowAt(--i);
                if (p != null) {
                    Integer i1 = (Integer)this.getModel().getNode().getChildNamed(new String[]{this.attName}).getValue();
                    Integer i2 = (Integer)p.getModel().getNode().getChildNamed(new String[]{this.attName}).getValue();
                    p.getModel().getNode().getChildNamed(new String[]{this.attName}).setValue((Object)i1, System.currentTimeMillis());
                    this.getModel().getNode().getChildNamed(new String[]{this.attName}).setValue((Object)i2, System.currentTimeMillis());
                    this.model.getParentModel().getTable().updateOrder();
                    this.model.getParentModel().getTable().revalidate();
                } else {
                    this.model.getParentModel().getTable().writeNumber(this.attName, this.startOffset);
                }
            }
        }
        catch (Exception e) {
            this.model.getParentModel().getTable().writeNumber(this.attName, this.startOffset);
        }
    }

    protected void moveDown() {
        try {
            int i = this.model.getParentModel().getTable().getRowIndex(this);
            if (i < this.model.getParentModel().getTable().getRowCount() - this.endOffset) {
                Table2RowPanel p = this.model.getParentModel().getTable().getRowAt(++i);
                if (p != null) {
                    Integer i1 = (Integer)this.getModel().getNode().getChildNamed(new String[]{this.attName}).getValue();
                    Integer i2 = (Integer)p.getModel().getNode().getChildNamed(new String[]{this.attName}).getValue();
                    p.getModel().getNode().getChildNamed(new String[]{this.attName}).setValue((Object)i1, System.currentTimeMillis());
                    this.getModel().getNode().getChildNamed(new String[]{this.attName}).setValue((Object)i2, System.currentTimeMillis());
                    this.model.getParentModel().getTable().updateOrder();
                    this.model.getParentModel().getTable().relayoutRequested();
                } else {
                    this.model.getParentModel().getTable().writeNumber(this.attName, this.startOffset);
                }
            }
        }
        catch (Exception e) {
            this.model.getParentModel().getTable().writeNumber(this.attName, this.startOffset);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.deleteButton) {
            this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            this.model.getParentModel().getTable().writeNumber(this.attName, this.startOffset);
        } else if (source == this.upButton) {
            this.moveUp();
        } else if (source == this.downButton) {
            this.moveDown();
        }
    }
}

