/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.CursorController;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.SelectionManager;
import ch.icit.pegasus.client.gui.utils.animators.Movable;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonStateListener;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.validator.ValidatingObject;
import ch.icit.pegasus.client.validator.Validator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class Button
extends JPanelFadable
implements MouseListener,
MouseMotionListener,
ActionListener,
Movable,
FocusListener,
KeyListener,
Focusable,
InnerPopUpListener2,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    protected int size;
    public static Object pressedItem;
    protected ButtonState state = ButtonState.UP;
    protected VisibleContainer visibleContainer;
    protected boolean hasFocus = false;
    protected boolean isDown = false;
    protected boolean isOver = false;
    protected Mover<Button> mover;
    private boolean isFocusable = true;
    protected Object userObject;
    private MouseListener delegateListener;
    private MouseMotionListener delegateListener2;
    private int delegationConstrains = 0;
    private ValidatingObject userValObjet;
    private Container topLevelParent;
    private Timer continiusTimer;
    protected boolean createContinuesEvents = false;
    private long maxTime4EventCreation = 500L;
    private long minTime4EventCreation = 32L;
    private long currentTime4EventCreation = this.maxTime4EventCreation;
    private long dekrement4EventCreation = 100L;
    private long lastEventCreation;
    private boolean createEventsEvenWhenDisabled = false;
    protected ArrayList<ButtonListener> listeners = new ArrayList();
    private ArrayList<ButtonStateListener> stateListener = new ArrayList();
    private ArrayList<ButtonListener> removeScheduled = new ArrayList();
    private boolean isActiv = true;
    private List<Validator> validators = new ArrayList<Validator>();
    private InnerPopUp2 validatingPopup;
    private boolean validatingValid = true;
    private int validatingX;
    private int validatingY;
    private List<ScreenValidationObject> validatingMessage;
    private Validator currentValidator;
    private List<Validator> enableValidators = new ArrayList<Validator>();
    protected boolean isDisabled = false;
    private boolean isValidating = false;
    private RemoteLoader additionalLoader;

    public Button() {
        this(true);
    }

    public Button(boolean focusable) {
        this.setFocusable(focusable);
        this.isFocusable = focusable;
        if (focusable) {
            this.addFocusListener(this);
            this.activateKeyListener();
        }
        this.setOpaque(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mover = new Mover<Button>(this);
        this.getFader().setDisableWhenHidden(false);
    }

    public void addEnableValidator(Validator val) {
        if (val != null) {
            this.enableValidators.add(val);
        }
    }

    public void validateEnableState(RemoteLoader additionalLoader) {
        this.isValidating = true;
        this.additionalLoader = additionalLoader;
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                boolean valid = true;
                for (Validator v : Button.this.enableValidators) {
                    ValidatingObject b = v.isValid(Button.this.getUserObject(), null);
                    if (b.isValid()) continue;
                    valid = false;
                }
                Node n = new Node();
                n.setValue((Object)valid, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return Button.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.requestFocusInWindow();
    }

    public void delegateMouseEvents(MouseListener l, MouseMotionListener l2, int strat) {
        this.delegationConstrains = strat;
        this.delegateListener = l;
        this.delegateListener2 = l2;
        if (this.delegateListener2 != null) {
            this.removeMouseMotionListener(this);
            this.addMouseMotionListener(this);
        }
        if (this.delegateListener != null) {
            this.removeMouseListener(this);
            this.addMouseListener(this);
        }
    }

    public void setTopLevelParent(Container c) {
        this.topLevelParent = c;
    }

    public void addValidator(Validator val) {
        this.validators.add(val);
    }

    public boolean areValidatorsReady() {
        for (Validator v : this.validators) {
            if (!(v.isRemoteValidation() ? !v.isValidated() : !v.isValid(this.userValObjet, null).isValid())) continue;
            return false;
        }
        return true;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setMouseActiv(boolean b) {
        if (b != this.isActiv) {
            this.isActiv = b;
            if (b) {
                this.addMouseListener(this);
                this.addMouseMotionListener(this);
            } else {
                this.removeMouseListener(this);
                this.removeMouseMotionListener(this);
            }
        }
    }

    public ValidatingObject getUserValObjet() {
        return this.userValObjet;
    }

    public void setUserValObjet(ValidatingObject userValObjet) {
        this.userValObjet = userValObjet;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.listeners == null) {
            return;
        }
        this.listeners.clear();
        this.stateListener.clear();
        this.removeScheduled.clear();
        this.listeners = null;
        this.stateListener = null;
        this.removeScheduled = null;
        this.mover.deregister();
        this.deactivateKeyListener();
        this.mover = null;
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.stopTimer();
        Container parent = this.getParent();
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        if (parent != null) {
            parent.repaint(32L);
        }
        pressedItem = null;
        this.visibleContainer = null;
        if (this.mover != null) {
            this.mover.kill();
        }
        this.mover = null;
        this.userObject = null;
        this.state = null;
        this.delegateListener = null;
        this.delegateListener2 = null;
        this.userValObjet = null;
        this.topLevelParent = null;
        this.continiusTimer = null;
        this.validators.clear();
        this.validators = null;
        this.validatingPopup = null;
        if (this.validatingMessage != null) {
            this.validatingMessage.clear();
        }
        this.validatingMessage = null;
        this.currentValidator = null;
        this.enableValidators.clear();
        this.enableValidators = null;
        this.additionalLoader = null;
    }

    public void deactivateKeyListener() {
        this.removeKeyListener(this);
    }

    public void activateKeyListener() {
        this.addKeyListener(this);
    }

    public boolean isCreateEventsEvenWhenDisabled() {
        return this.createEventsEvenWhenDisabled;
    }

    public void setCreateEventsEvenWhenDisabled(boolean createEventsEvenWhenDisabled) {
        this.createEventsEvenWhenDisabled = createEventsEvenWhenDisabled;
    }

    public boolean isCreateContinuesEvents() {
        return this.createContinuesEvents;
    }

    public void setState(ButtonState newState) {
        if (this.isDisabled) {
            this.state = ButtonState.DISABLED;
            this.repaint(32L);
            return;
        }
        this.state = newState;
        if (this.state == ButtonState.DISABLED) {
            this.setFocusable(false);
        } else if (this.isFocusable) {
            this.setFocusable(true);
        }
        this.repaint(32L);
    }

    public ButtonState getState() {
        return this.state;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isDisabled) {
            this.changeState(ButtonState.DISABLED);
            return;
        }
        if (isEnabled) {
            if (this.hasFocus) {
                this.changeState(ButtonState.FOCUS);
            } else if (this.isDown) {
                this.changeState(ButtonState.DOWN);
            } else if (this.isOver) {
                this.changeState(ButtonState.OVER);
            } else {
                this.changeState(ButtonState.UP);
            }
        } else {
            this.changeState(ButtonState.DISABLED);
        }
        this.repaint(32L);
    }

    @Override
    public boolean isEnabled() {
        return this.state != ButtonState.DISABLED;
    }

    public void setCreateContinuesEvents(boolean cce) {
        this.createContinuesEvents = cce;
    }

    protected void ensureTimer() {
        if (this.continiusTimer == null) {
            this.continiusTimer = new Timer(32, this);
            this.continiusTimer.setRepeats(true);
            this.continiusTimer.start();
            this.lastEventCreation = System.currentTimeMillis();
        }
    }

    private void stopTimer() {
        if (this.continiusTimer != null) {
            this.continiusTimer.stop();
            this.continiusTimer = null;
            this.currentTime4EventCreation = this.maxTime4EventCreation;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        long diff = System.currentTimeMillis() - this.lastEventCreation;
        if (diff > this.currentTime4EventCreation) {
            this.fireEvent(0, 0);
            this.currentTime4EventCreation -= this.dekrement4EventCreation;
            if (this.currentTime4EventCreation < this.minTime4EventCreation) {
                this.currentTime4EventCreation = this.minTime4EventCreation;
            }
            this.lastEventCreation = System.currentTimeMillis();
        }
    }

    protected void delegateFireEventToListeners(int x, int y) {
        for (ButtonListener listener : (ArrayList)this.listeners.clone()) {
            if (listener == null) continue;
            listener.buttonPressed(this, x, y);
        }
    }

    private void endFireEvent(int x, int y) {
        this.delegateFireEventToListeners(x, y);
        if (this.removeScheduled != null) {
            for (ButtonListener l : this.removeScheduled) {
                this.listeners.remove(l);
            }
            this.removeScheduled.clear();
        }
    }

    protected void fireEvent(int x, int y) {
        this.validatingX = x;
        this.validatingY = y;
        if (this.validators.size() > 0) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    boolean isValid = true;
                    Button.this.validatingMessage = new ArrayList();
                    for (Validator val : Button.this.validators) {
                        ValidatingObject o = val.isValid(Button.this.userObject, null);
                        if (!o.isValid()) {
                            isValid = false;
                            Button.this.validatingMessage.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, o.getMessage()));
                        }
                        if (o.getEffectedObject() != null && !o.isValid()) {
                            o.getEffectedObject().setInvalid();
                        }
                        if (o.getInnerObject() != null && o.getInnerObject().size() > 0) {
                            for (ValidatingObject obs : o.getInnerObject()) {
                                if (obs.getEffectedObject() == null || obs.isValid()) continue;
                                obs.getEffectedObject().setInvalid();
                            }
                        }
                        if (isValid) continue;
                        Button.this.validatingValid = isValid;
                        Button.this.currentValidator = val;
                        return null;
                    }
                    Button.this.validatingValid = isValid;
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return Button.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            if (this.topLevelParent != null) {
                this.topLevelParent.setEnabled(false);
            }
            CursorController.showCursor(this, true);
            ThreadSafeLoader.run(run);
        } else {
            this.endFireEvent(x, y);
        }
    }

    private void showValidatingPopUp(List<ScreenValidationObject> msg, int x, int y, Validator v) {
        if (this.validatingPopup == null) {
            InnerPopupFactory.showErrorDialog(msg, null, (Component)this);
        }
    }

    public void addButtonStateListener(ButtonStateListener l) {
        this.stateListener.add(l);
    }

    public void removeButtonStateListener(ButtonStateListener l) {
        this.stateListener.remove(l);
    }

    private void fireStateEvent() {
        if (this.stateListener == null) {
            return;
        }
        for (ButtonStateListener l : this.stateListener) {
            l.buttonStateChanged(this);
        }
    }

    public void removeButtonListenerScheduled(ButtonListener l) {
        this.removeScheduled.add(l);
    }

    public void addButtonListener(ButtonListener listener) {
        this.listeners.add(listener);
    }

    public void removeButtonListener(ButtonListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected void changeState(ButtonState newState) {
        this.setState(newState);
        this.fireStateEvent();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.delegateListener != null && this.delegationConstrains % 13 == 0) {
            this.delegateListener.mouseClicked(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isOver = true;
        if (this.state != ButtonState.DISABLED & this.state != ButtonState.ERROR && !this.hasFocus && (pressedItem == null || pressedItem == this)) {
            if (this.isDown) {
                this.changeState(ButtonState.DOWN);
                if (this.createContinuesEvents) {
                    this.ensureTimer();
                }
            } else {
                this.changeState(ButtonState.OVER);
            }
            if (this.delegateListener != null && this.delegationConstrains % 3 == 0) {
                this.delegateListener.mouseEntered(e);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isOver = false;
        if (this.state != ButtonState.DISABLED && this.state != ButtonState.ERROR) {
            if (this.hasFocus) {
                this.changeState(ButtonState.FOCUS);
            } else if (pressedItem == null || pressedItem == this) {
                this.changeState(ButtonState.UP);
                if (this.delegateListener != null && this.delegationConstrains % 5 == 0) {
                    this.delegateListener.mouseEntered(e);
                }
                this.stopTimer();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.state != ButtonState.DISABLED && this.state != ButtonState.ERROR) {
            this.isDown = true;
            if (this.isFocusable && !this.hasFocus) {
                this.requestFocusInWindow();
            } else if (!this.hasFocus) {
                this.changeState(ButtonState.DOWN);
            }
            pressedItem = this;
            if (this.createContinuesEvents) {
                this.ensureTimer();
            }
            if (this.delegateListener != null && this.delegationConstrains % 7 == 0) {
                this.delegateListener.mouseEntered(e);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.state != ButtonState.DISABLED) {
            pressedItem = null;
            this.isDown = false;
            if (this.isOver) {
                if (this.state != ButtonState.ERROR && !this.hasFocus) {
                    this.changeState(ButtonState.OVER);
                }
                this.fireEvent(e.getX(), e.getY());
            } else if (this.state != ButtonState.ERROR) {
                if (this.hasFocus) {
                    this.changeState(ButtonState.FOCUS);
                } else {
                    this.changeState(ButtonState.UP);
                }
            }
            if (this.delegateListener != null && this.delegationConstrains % 11 == 0) {
                this.delegateListener.mouseEntered(e);
            }
            this.stopTimer();
        } else if (this.createEventsEvenWhenDisabled && this.contains(e.getX(), e.getY())) {
            this.fireEvent(e.getX(), e.getY());
        }
    }

    @Override
    public void setLocationSmooth(int endX, int endY) {
        this.mover.setLocationSmooth(endX, endY);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        SelectionManager.getSelectionManager().focusGained(this);
        if (this.state != ButtonState.DISABLED && this.state != ButtonState.ERROR) {
            this.changeState(ButtonState.FOCUS);
            if (!this.isDown && this.visibleContainer != null) {
                this.visibleContainer.scrollTo(this);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        if (this.state != ButtonState.DISABLED && this.state != ButtonState.ERROR) {
            if (this.isDown) {
                this.changeState(ButtonState.DOWN);
            } else if (this.isOver) {
                this.changeState(ButtonState.OVER);
            } else {
                this.changeState(ButtonState.UP);
            }
        }
    }

    public Mover<Button> getMover() {
        return this.mover;
    }

    public boolean isEnterActiv() {
        return true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.processKeyPressedEvent(e);
    }

    public boolean processKeyPressedEvent(KeyEvent e) {
        if (this.state != ButtonState.DISABLED && e.getKeyCode() == 10 && this.isEnterActiv()) {
            this.enterWasPressed();
            return true;
        }
        return false;
    }

    public void enterWasPressed() {
        this.fireEvent(0, 0);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.isFocusable) {
            a.add(this);
        }
        return a;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (this.topLevelParent != null) {
            this.topLevelParent.setEnabled(true);
        } else {
            this.setEnabled(true);
        }
        this.validatingPopup = null;
    }

    public void setDisabled(boolean b) {
        this.isDisabled = b;
        if (this.isDisabled) {
            this.setState(ButtonState.DISABLED);
        } else if (this.isDown) {
            this.changeState(ButtonState.DOWN);
        } else if (this.isOver) {
            this.changeState(ButtonState.OVER);
        } else {
            this.changeState(ButtonState.UP);
        }
    }

    public void remoteObjectLoaded(Node<?> node) {
        if (this.isValidating) {
            this.isValidating = false;
            if (!((Boolean)node.getValue()).booleanValue()) {
                this.setDisabled(true);
                this.setFocusable(false);
                this.setEnabled(false);
            } else {
                this.setDisabled(false);
            }
            if (this.additionalLoader != null) {
                this.additionalLoader.remoteObjectLoaded(node);
            }
        } else {
            CursorController.showCursor(this, false);
            if (this.validatingValid) {
                if (this.topLevelParent != null) {
                    this.topLevelParent.setEnabled(true);
                } else {
                    this.setEnabled(true);
                }
                this.endFireEvent(this.validatingX, this.validatingY);
            } else if (this.validatingMessage != null && !this.validatingMessage.isEmpty()) {
                this.showValidatingPopUp(this.validatingMessage, this.validatingX, this.validatingY, this.currentValidator);
            }
        }
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)this);
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.visibleContainer = pane;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    public void ensureState() {
        this.isOver = false;
        this.setState(ButtonState.UP);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.delegationConstrains % 19 == 0 && this.delegateListener2 != null) {
            this.delegateListener2.mouseDragged(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.delegationConstrains % 17 == 0 && this.delegateListener2 != null) {
            Point p = SwingUtilities.convertPoint(this, e.getPoint(), (Component)((Object)this.delegateListener2));
            MouseEvent ne = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), (int)p.getX(), (int)p.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), false, e.getButton());
            this.delegateListener2.mouseMoved(ne);
        }
    }

    public static enum ButtonState {
        UP,
        DOWN,
        OVER,
        DISABLED,
        FOCUS,
        STATE_SELECTED,
        STATE_NOTSELECTED,
        ERROR,
        STATE_WARRNING,
        STATE_FOCUS_LEFT,
        STATE_FOCUS_RIGHT,
        LEFT,
        RIGHT,
        HORIZONTAL,
        VERTICAL,
        STATE_COLAPSED_OVER,
        STATE_COLAPSED_UP,
        STATE_EXPANDED;


        public String toString() {
            switch (this) {
                case HORIZONTAL: {
                    return "horizontal";
                }
                case LEFT: {
                    return "left";
                }
                case RIGHT: {
                    return "right";
                }
                case STATE_COLAPSED_OVER: {
                    return "colapsed over";
                }
                case STATE_COLAPSED_UP: {
                    return "colapsed up";
                }
                case DISABLED: {
                    return "disabled";
                }
                case DOWN: {
                    return "down";
                }
                case ERROR: {
                    return "error";
                }
                case STATE_EXPANDED: {
                    return "expanded";
                }
                case FOCUS: {
                    return "focus";
                }
                case STATE_FOCUS_LEFT: {
                    return "focus left";
                }
                case STATE_FOCUS_RIGHT: {
                    return "focus right";
                }
                case STATE_NOTSELECTED: {
                    return "not selected";
                }
                case OVER: {
                    return "over";
                }
                case STATE_SELECTED: {
                    return "selected";
                }
                case UP: {
                    return "up";
                }
                case STATE_WARRNING: {
                    return "warning";
                }
                case VERTICAL: {
                    return "vertical";
                }
            }
            return "unknown state";
        }
    }
}

