/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.TypedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.SupplierInfoButtonSkin;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class SupplierInfoButton
extends Button {
    private static final long serialVersionUID = 1L;
    private TypedSkin1Field skin;
    private SupplierInfoButtonSkin.SupplierStateType currentType = SupplierInfoButtonSkin.SupplierStateType.First;
    private Node supplierNode;

    public SupplierInfoButton(SupplierInfoButtonSkin.SupplierStateType type, Node n) {
        super(true);
        this.currentType = type;
        this.supplierNode = n;
        this.setToolTipText(Words.SHOW_SUPPLIER_INFO);
        this.skin = SkinRegistry.getSkin(SupplierInfoButtonSkin.class);
        this.setSize(this.getPreferredSize());
    }

    public static int getPreferredHeight() {
        TypedSkin1Field s = SkinRegistry.getSkin(SupplierInfoButtonSkin.class);
        return s.getImage(Button.ButtonState.DISABLED, SupplierInfoButtonSkin.SupplierStateType.First).getHeight();
    }

    public Node getNode() {
        return this.supplierNode;
    }

    @Override
    public void kill() {
        super.kill();
        this.skin = null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.skin.getImage(this.state, this.currentType).getWidth(), this.skin.getImage(this.state, this.currentType).getHeight());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.state, this.currentType);
        this.paintChildren(g2);
    }
}

