/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.calendar.agenda.timecomponents;

import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TimeComponent;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.stock.StockUsage;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.IUnit;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;

public class StockInfoTimeComponent
extends JPanelFadable
implements TimeComponent,
StockUsage {
    private final Timestamp time;
    private QuantityComplete quantity;
    private final TimeDurationComplete duration;
    private QuantityComplete currentStock;
    private TextLabel usage;
    private TextLabel stock;

    public StockInfoTimeComponent(Timestamp time, QuantityComplete quantity, TimeDurationComplete duration) {
        this.time = time;
        this.quantity = quantity;
        this.duration = duration;
        this.setLayout(new Layout());
        this.usage = new TextLabel();
        this.stock = new TextLabel();
        this.usage.setFont(this.usage.getFont().deriveFont(9.0f));
        this.stock.setFont(this.stock.getFont().deriveFont(10.0f).deriveFont(1));
        this.updateUsageText();
        this.updateStockText();
        this.add(this.usage);
        this.add(this.stock);
    }

    private void updateUsageText() {
        String sign = this.quantity.getAmount() < 0.0 ? "" : "+";
        this.quantity = (QuantityComplete)UnitCalculator.normalizeQuantity((IQuantity)this.quantity);
        this.usage.setText(sign + "" + ((QuantityConverter2Decimal)ConverterRegistry.getConverter(QuantityConverter2Decimal.class)).convert((Object)this.quantity, null, new Object[0]));
    }

    private void updateStockText() {
        if (this.currentStock != null) {
            String sign = this.currentStock.getAmount() < 0.0 ? "" : "+";
            this.currentStock = (QuantityComplete)UnitCalculator.normalizeQuantity((IQuantity)this.currentStock);
            this.stock.setText(sign + "" + ((QuantityConverter2Decimal)ConverterRegistry.getConverter(QuantityConverter2Decimal.class)).convert((Object)this.currentStock, null, new Object[0]));
            if (this.currentStock.getQuantity() < 0.0) {
                this.stock.setForeground(new Color(229, 76, 72));
            } else {
                this.stock.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
            }
        } else {
            this.stock.setText("-");
        }
    }

    public void addQuantity(QuantityComplete add) {
        double factor = UnitCalculator.getConversionFactorForRecipe((IQuantity)this.quantity, (IUnit)add.getUnit());
        this.quantity.setQuantity(Double.valueOf(factor + add.getQuantity()));
        this.quantity.setUnit(add.getUnit());
        this.quantity = (QuantityComplete)UnitCalculator.normalizeQuantity((IQuantity)this.quantity);
        this.updateUsageText();
    }

    @Override
    public Timestamp getTime() {
        return this.time;
    }

    @Override
    public QuantityComplete getQuantity() {
        return this.quantity;
    }

    @Override
    public void setStock(QuantityComplete newStock) {
        this.currentStock = new QuantityComplete(newStock);
        this.updateStockText();
    }

    @Override
    public void layoutTimeComponent(int x, int y, int w, int h, int parentBoxHeight) {
        this.setLocation(x, y);
        this.setSize(w, h);
    }

    @Override
    public long getDurationInMillis() {
        return this.duration.getDurationInMillis();
    }

    @Override
    public void setCoordinateSpaceOffset(int headerHeight) {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            StockInfoTimeComponent.this.usage.setLocation(3, 0);
            StockInfoTimeComponent.this.usage.setSize(StockInfoTimeComponent.this.usage.getPreferredSize());
            StockInfoTimeComponent.this.stock.setLocation(3, StockInfoTimeComponent.this.usage.getY() + StockInfoTimeComponent.this.usage.getHeight());
            StockInfoTimeComponent.this.stock.setSize(StockInfoTimeComponent.this.stock.getPreferredSize());
        }
    }
}

