/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox.activators;

import ch.icit.pegasus.client.gui.utils.combobox.activators.ActivationAdapter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleModificationStateE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;

public class BasicArticleActivationAdapter
implements ActivationAdapter {
    @Override
    public ActivationAdapter.ActivationType isElementActive(Object data) {
        SystemSettingsComplete settings;
        Object aData = data;
        if (data instanceof Node) {
            aData = ((Node)data).getValue();
        }
        if (!(aData instanceof BasicArticleLight)) {
            return ActivationAdapter.ActivationType.OK;
        }
        BasicArticleLight article = (BasicArticleLight)aData;
        if (Boolean.TRUE.equals(article.getIsDeleted())) {
            return ActivationAdapter.ActivationType.FATAL;
        }
        if (article.getIsInUse() == null || !article.getIsInUse().booleanValue()) {
            return ActivationAdapter.ActivationType.DEACTIVATED;
        }
        if (!Boolean.TRUE.equals(article.getCanCreateTransactions())) {
            return ActivationAdapter.ActivationType.CAN_NOT_CREATE_TRANSACTION;
        }
        if (!article.getAllergensApproved().booleanValue() && ArticleToolkit.isArticleAllergenRelevant(article) && article.getChilled().booleanValue()) {
            return ActivationAdapter.ActivationType.ALLERGEN_WARNING;
        }
        if (article.getState() != ArticleModificationStateE.ACCEPTED) {
            return ActivationAdapter.ActivationType.STATE_WARNING;
        }
        if (!Boolean.TRUE.equals(article.getHalal()) && Boolean.TRUE.equals((settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getShowArticleHighlightedWhenNotHalal())) {
            return ActivationAdapter.ActivationType.HALAL_WARNING;
        }
        return ActivationAdapter.ActivationType.OK;
    }
}

