/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox.activators;

import ch.icit.pegasus.client.gui.utils.combobox.activators.ActivationAdapter;
import ch.icit.pegasus.client.gui.utils.combobox.activators.ActivationAdapterRegistry;
import ch.icit.pegasus.client.gui.utils.combobox.activators.BasicArticleActivationAdapter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;

public class IngredientActivationAdapter
implements ActivationAdapter {
    @Override
    public ActivationAdapter.ActivationType isElementActive(Object data) {
        Object aData = data;
        if (aData instanceof Node) {
            aData = ((Node)data).getValue();
        }
        if (aData instanceof BasicArticleLight) {
            ActivationAdapter a = ActivationAdapterRegistry.getAdapter(BasicArticleActivationAdapter.class);
            return a.isElementActive(aData);
        }
        if (aData instanceof RecipeVariantLight) {
            RecipeVariantLight rv = (RecipeVariantLight)aData;
            return this.getRecipeActivationState(rv);
        }
        if (aData instanceof RecipeComplete) {
            RecipeComplete r = (RecipeComplete)aData;
            return this.getRecipeActivationState(r.getCurrentVariant());
        }
        return ActivationAdapter.ActivationType.OK;
    }

    private ActivationAdapter.ActivationType getRecipeActivationState(RecipeVariantLight rv) {
        if (Boolean.TRUE.equals(rv.getRecipe() != null ? rv.getRecipe().getIsDeleted() : rv.getDeleted())) {
            return ActivationAdapter.ActivationType.FATAL;
        }
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (Boolean.TRUE.equals(settings.getShowRecipeHighlightedWhenNotHalal()) && !Boolean.TRUE.equals(rv.getHalal())) {
            return ActivationAdapter.ActivationType.HALAL_WARNING;
        }
        if (rv.getState() == ModificationStateE.DRAFT) {
            return ActivationAdapter.ActivationType.STATE_WARNING;
        }
        return ActivationAdapter.ActivationType.OK;
    }
}

