/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox.minicombobox;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class MiniComboBox
extends ComboBox {
    private static final long serialVersionUID = 1L;
    private HashMap<Object, Skin1Field> images = new HashMap();
    private Button.ButtonState state;
    private BufferedImage arrow;

    public MiniComboBox() {
        this.setPreferredSize(new Dimension(150, (int)this.getSize().getHeight()));
        this.setUI(new MiniComboBoxUI());
        this.arrow = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("searchtextfield.configuration.arrow.icon.button.image.up"));
    }

    public void addItem(Object item, Skin1Field skin1Field) {
        super.addItem(item);
        this.images.put(item, skin1Field);
        this.recalculateWidth();
    }

    @Override
    public void removeItem(Object item) {
        this.images.remove(item);
        super.removeItem(item);
        this.recalculateWidth();
    }

    private void recalculateWidth() {
        int width = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object mitem = this.getItemAt(i);
            int length = mitem.toString().length();
            if (length <= width) continue;
            width = length;
        }
        this.setPreferredSize(new Dimension(width * 9, (int)this.getSize().getHeight()));
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BufferedImage pfeil = this.arrow;
        g2.drawImage(pfeil, 0, 0, 20, 20, null);
        this.images.get(this.getSelectedItem()).paint(g2, 0, 0, this.state);
    }

    @Override
    public void attributeChanged(String attributeName) {
        super.attributeChanged(attributeName);
        this.repaint(32L);
    }

    @Override
    public void kill() {
        super.kill();
        this.images = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.state = isEnabled ? Button.ButtonState.UP : Button.ButtonState.DISABLED;
        super.setEnabled(isEnabled);
    }

    private class MiniComboBoxUI
    extends BasicComboBoxUI {
        private MiniComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this.comboBox){

                @Override
                protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
                    return super.computePopupBounds(px, py, Math.max(this.comboBox.getPreferredSize().width, pw) + 10, ph);
                }
            };
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }

        @Override
        protected JButton createArrowButton() {
            return null;
        }

        @Override
        protected void installComponents() {
            this.arrowButton = this.createArrowButton();
            if (this.arrowButton != null) {
                this.comboBox.add(this.arrowButton);
                this.configureArrowButton();
            }
            if (this.comboBox.isEditable()) {
                this.addEditor();
            }
            this.comboBox.add(this.currentValuePane);
        }
    }
}

