/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.datechooser;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserListener;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodListener;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class TitledPeriodEditor
extends JPanelFadable
implements DateChooserListener,
Focusable,
ButtonListener,
UIStateLoadable,
Validatable,
ItemListener,
MutableFocusContainer {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDDateChooser> startDate;
    private TitledItem<RDDateChooser> endDate;
    private TitledItem<TextLabel> startLabel;
    private TitledItem<TextLabel> endLabel;
    private boolean isPersistable = true;
    private int startDateOffset = 0;
    private final int connectorOffset = 0;
    private int endDateOffset = 0;
    private boolean isStartDateOffsetSet = false;
    private boolean isEndDateOffsetSet = false;
    private boolean isFilterChain = false;
    private final List<TitledPeriodListener> listeners = new ArrayList<TitledPeriodListener>();
    private List<MutableFocusContainerListener> focusCycleListener = new ArrayList<MutableFocusContainerListener>();
    private ArrowConnectorIcon connector;
    private Node<PeriodComplete> node;
    private Node<Date> startNode;
    private Node<Date> endNode;
    private boolean isEdit = false;
    private boolean hasTitle = true;
    private String id;
    private Date defaultStartDate = new Date(System.currentTimeMillis());
    private Date defaultEndDate = new Date(System.currentTimeMillis());
    private CheckBox checkBox;
    private boolean isInit;
    private String overrideAttName;
    private RDProvider provider;
    private ComboBox comboBox;
    private int comboBoxWidth = 0;
    private boolean ignorePersist;

    public TitledPeriodEditor(Node<Date> start, Node<Date> end, boolean withTitle, RDProvider provider, DtoField attName) {
        this(start, end, withTitle, provider, attName.getFieldName());
    }

    public TitledPeriodEditor(Node<Date> start, Node<Date> end, boolean withTitle, RDProvider provider, String attName) {
        this();
        this.overrideAttName = attName;
        this.provider = provider;
        this.hasTitle = withTitle;
        this.startNode = start;
        this.initStartDate(this.startNode);
        this.endNode = end;
        this.initEndDate(this.endNode);
        this.initConnector();
        this.setProgress(1.0f);
        if (this.startNode != null) {
            this.dateChanged(null, (java.util.Date)this.startNode.getValue());
        }
        this.startDate.getFader().setPermanent(true);
        this.startLabel.getFader().setPermanent(true);
        this.endDate.getFader().setPermanent(true);
        this.endLabel.getFader().setPermanent(true);
        this.add(this.startDate);
        this.add(this.startLabel);
        this.add(this.connector);
        this.add(this.endDate);
        this.add(this.endLabel);
        this.setEdit(true);
    }

    public TitledPeriodEditor(Node<Date> start, Node<Date> end, boolean withTitle, RDProvider provider) {
        this(start, end, withTitle, provider, (String)null);
    }

    public TitledPeriodEditor(Node<PeriodComplete> n, boolean withTitle, RDProvider provider, DtoField attName) {
        this(n, withTitle, provider, attName.getFieldName());
    }

    public TitledPeriodEditor(Node<PeriodComplete> n, boolean withTitle, RDProvider provider, String attName) {
        this((Node<Date>)(n != null ? n.getChildNamed(PeriodComplete_.startDate) : null), (Node<Date>)(n != null ? n.getChildNamed(PeriodComplete_.endDate) : null), withTitle, provider, attName);
    }

    public TitledPeriodEditor(Node<PeriodComplete> n, boolean withTitle, RDProvider provider) {
        this(n, withTitle, provider, (String)null);
    }

    public TitledPeriodEditor(Node<PeriodComplete> n, RDProvider provider) {
        this((Node<Date>)(n != null ? n.getChildNamed(PeriodComplete_.startDate) : null), (Node<Date>)(n != null ? n.getChildNamed(PeriodComplete_.endDate) : null), false, provider);
    }

    public TitledPeriodEditor() {
        this.init();
    }

    public void setInnerGap(int gap) {
        if (this.endDate != null) {
            this.endDate.setInnerGap(gap);
        }
        if (this.startDate != null) {
            this.startDate.setInnerGap(gap);
        }
        if (this.startLabel != null) {
            this.startLabel.setInnerGap(gap);
        }
        if (this.endLabel != null) {
            this.endLabel.setInnerGap(gap);
        }
    }

    public void enableInfinity(boolean atStart, boolean atEnd) {
        if (atStart) {
            this.startDate.getElement().setCheckBoxEnabled();
        }
        if (atEnd) {
            this.endDate.getElement().setCheckBoxEnabled();
        }
    }

    @Override
    public String getPersistString() {
        if (this.ignorePersist) {
            return "";
        }
        String t = this.startDate.getElement().getPersistString();
        t = t + "<>";
        t = t + this.endDate.getElement().getPersistString();
        if (this.checkBox != null) {
            t = t + "<>" + this.checkBox.getPersistString();
        }
        return t;
    }

    public void setCheckBoxChecked(boolean b) {
        if (this.checkBox != null) {
            this.checkBox.setChecked(b);
            this.startDate.setEnabled(this.checkBox.isChecked());
            this.endDate.setEnabled(this.checkBox.isChecked());
        }
    }

    public void setIgnorePersist(boolean ignorePersist) {
        this.ignorePersist = ignorePersist;
    }

    public boolean isIgnorePersist() {
        return this.ignorePersist;
    }

    @Override
    public void loadState(String state, String id) {
        if (this.ignorePersist) {
            return;
        }
        this.isInit = true;
        String[] a = state.split("<>");
        if (this.checkBox != null && a.length > 2) {
            this.checkBox.loadState(a[2], null);
        }
        this.endDate.getElement().loadState(a[1], null);
        this.startDate.getElement().loadState(a[0], null);
        this.isInit = false;
    }

    @Override
    public String getID() {
        return this.getId();
    }

    public void setCheckBoxEnabled() {
        if (this.checkBox == null) {
            this.checkBox = new CheckBox();
            this.checkBox.setChecked(true);
            this.checkBox.setEnabled(true);
            this.checkBox.addButtonListener(this);
            this.add(this.checkBox);
        }
        this.validate();
    }

    public void setCheckBoxDisabled() {
        if (this.checkBox != null) {
            this.checkBox.kill();
            this.checkBox = null;
        }
    }

    private void fireEvent(Date s, Date e) {
        if (this.isInit) {
            return;
        }
        for (TitledPeriodListener l : this.listeners) {
            l.newPeriodSelected(s, e, this);
        }
    }

    public void addTitledPeriodListener(TitledPeriodListener l) {
        this.listeners.add(l);
    }

    public void removeTitledPeriodListener(TitledPeriodListener l) {
        this.listeners.remove(l);
    }

    private void removeSecondsAndMilliSeconds(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTimeInMillis(date.getTime());
        instance.set(13, 0);
        instance.set(14, 0);
        date.setTime(instance.getTimeInMillis());
    }

    public Date getStartDate() {
        if (this.checkBox == null || this.checkBox != null && this.checkBox.isChecked()) {
            java.util.Date d = this.startDate.getElement().getSelectedDate();
            if (this.startDate.getElement().getNode() != null) {
                Object value = this.startDate.getElement().getNode().getValue();
                Date d2 = null;
                if (value instanceof Date) {
                    d2 = (Date)value;
                } else if (value != null) {
                    d2 = new Date(((Timestamp)value).getTime());
                }
                if (d2 != null) {
                    this.removeSecondsAndMilliSeconds(d2);
                    return d2;
                }
            }
            if (d != null) {
                Date dd = new Date(d.getTime());
                this.removeSecondsAndMilliSeconds(dd);
                return dd;
            }
        }
        return null;
    }

    public Date getEndDate() {
        if (this.checkBox == null || this.checkBox != null && this.checkBox.isChecked()) {
            Object value;
            Date d2;
            java.util.Date d = this.endDate.getElement().getSelectedDate();
            if (this.endDate.getElement().getNode() != null && (d2 = (value = this.endDate.getElement().getNode().getValue()) instanceof Date ? (Date)value : (value instanceof Timestamp ? new Date(((Timestamp)value).getTime()) : null)) != null) {
                this.removeSecondsAndMilliSeconds(d2);
                return d2;
            }
            if (d != null) {
                Date dd = new Date(d.getTime());
                this.removeSecondsAndMilliSeconds(dd);
                return dd;
            }
        }
        return null;
    }

    public Date getDefaultStartValue() {
        return this.defaultStartDate;
    }

    public Date getDefaultEndValue() {
        return this.defaultEndDate;
    }

    public void setDefaultValues(Date start, Date end) {
        this.defaultEndDate = end;
        this.defaultStartDate = start;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public int getStartDateOffset() {
        return this.startDateOffset;
    }

    public void setStartDateOffset(int startDateOffset) {
        this.startDateOffset = startDateOffset;
        this.isStartDateOffsetSet = this.startDateOffset != 0;
    }

    public int getConnectorOffset() {
        return 0;
    }

    public void setFilterChain(boolean isFilterChain) {
        this.isFilterChain = isFilterChain;
    }

    public int getEndDateOffset() {
        return this.endDateOffset;
    }

    public void setEndDateOffset(int endDateOffset) {
        this.endDateOffset = endDateOffset;
        this.isEndDateOffsetSet = this.endDateOffset != 0;
    }

    public void setEdit(boolean isEdit) {
        if (this.isEdit != isEdit) {
            this.isEdit = isEdit;
            if (this.isEdit) {
                this.startLabel.fadeOut(false);
                this.startDate.fadeIn();
                this.endLabel.fadeOut(false);
                this.endDate.fadeIn();
            } else {
                this.startDate.fadeOut(false);
                this.startLabel.fadeIn();
                this.endDate.fadeOut(false);
                this.endLabel.fadeIn();
            }
        }
    }

    public boolean isWritable() {
        if (this.startDate != null) {
            return this.startDate.getElement().isWritable();
        }
        if (this.endDate != null) {
            return this.endDate.getElement().isWritable();
        }
        return true;
    }

    private void init() {
        this.setLayout(new Layout());
        this.setOpaque(false);
    }

    public void setTitleText(String titleStartDate, String titleEndDate) {
        this.startDate.setTitleText(titleStartDate);
        this.endDate.setTitleText(titleEndDate);
    }

    public void setTitleFont(Font f) {
        this.startDate.setTitleFont(f);
        this.endDate.setTitleFont(f);
    }

    public TitledItem<RDDateChooser> getStartDateTitledItem() {
        return this.startDate;
    }

    public TitledItem<RDDateChooser> getEndDateTitledItem() {
        return this.endDate;
    }

    public RDDateChooser getStartDateChooser() {
        return this.startDate.getElement();
    }

    public RDDateChooser getEndDateChooser() {
        return this.endDate.getElement();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean b = isEnabled;
        if (this.checkBox != null) {
            this.checkBox.setEnabled(isEnabled);
            b = this.checkBox.isChecked();
        }
        if (this.comboBox != null) {
            this.comboBox.setEnabled(isEnabled & b);
        }
        if (this.startDate != null) {
            this.startDate.setEnabled(isEnabled & b);
        }
        if (this.startLabel != null) {
            this.startLabel.setEnabled(isEnabled & b);
        }
        if (this.connector != null) {
            this.connector.setEnabled(isEnabled & b);
        }
        if (this.endDate != null) {
            this.endDate.setEnabled(isEnabled & b);
        }
        if (this.endLabel != null) {
            this.endLabel.setEnabled(isEnabled & b);
        }
    }

    private void initConnector() {
        this.connector = new ArrowConnectorIcon();
    }

    private void initStartDate(Node<Date> s) {
        String title = "";
        if (this.hasTitle) {
            title = Words.START_DATE;
        }
        this.startDate = new TitledItem<RDDateChooser>(new RDDateChooser(this.provider), title, TitledItem.TitledItemOrientation.NORTH);
        this.startDate.getElement().setOverrideName(this.overrideAttName);
        this.startDate.getElement().setNode(s);
        this.startDate.getElement().addDateChooserListener(this);
        this.startLabel = new TitledItem<TextLabel>(new TextLabel(s, (Converter)new DateConverter()), title, TitledItem.TitledItemOrientation.NORTH);
    }

    private void initEndDate(Node<Date> e) {
        String title = "";
        if (this.hasTitle) {
            title = Words.END_DATE;
        }
        this.endDate = new TitledItem<RDDateChooser>(new RDDateChooser(this.provider), title, TitledItem.TitledItemOrientation.NORTH);
        this.endDate.getElement().setOverrideName(this.overrideAttName);
        this.endDate.getElement().setNode(e);
        this.endLabel = new TitledItem<TextLabel>(new TextLabel(e, (Converter)new DateConverter()), title, TitledItem.TitledItemOrientation.NORTH);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.startDate.kill();
        this.startLabel.kill();
        this.connector.kill();
        this.endDate.kill();
        this.endLabel.kill();
        if (this.checkBox != null) {
            this.checkBox.kill();
        }
        if (this.comboBox != null) {
            this.comboBox.kill();
            this.comboBox = null;
        }
        this.startDate = null;
        this.startLabel = null;
        this.connector = null;
        this.endDate = null;
        this.endLabel = null;
        this.checkBox = null;
    }

    public int getDateChoosersPrefWidth() {
        if (this.isEdit) {
            return 100;
        }
        return (int)this.startLabel.getPreferredSize().getWidth();
    }

    public List<ScreenValidationObject> validateContent() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        java.util.Date sd = null;
        java.util.Date ed = null;
        if (this.startDate != null && this.startDate.getElement().isWritable()) {
            if (this.startDate.getElement().getNode().getValue() == null) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Start Date is not set"));
                this.startDate.getElement().setInvalid();
            } else {
                this.startDate.getElement().setValid();
                sd = (Date)this.startDate.getElement().getNode().getValue();
            }
        }
        if (this.endDate != null && this.endDate.getElement().isWritable()) {
            if (this.endDate.getElement().getNode().getValue() == null) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "End Date is not set"));
                this.endDate.getElement().setInvalid();
            } else {
                this.endDate.getElement().setValid();
                ed = (Date)this.endDate.getElement().getNode().getValue();
            }
        }
        if (sd != null && ed != null && sd.getTime() > ed.getTime()) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Start Date is before End Date"));
        }
        return a;
    }

    public int getConnectorPrefWidth() {
        return (int)this.connector.getPreferredSize().getWidth();
    }

    @Override
    public void dateChanged(DateChooser source, java.util.Date selectedDate) {
        if (selectedDate != null && !this.isInit) {
            this.endDate.getElement().setMinimumDate(selectedDate);
        }
    }

    public static int getPreferredWidth(Component comp) {
        return TitledPeriodEditor.getPreferredWidth(comp, false, false);
    }

    public static int getPreferredWidth(Component comp, boolean withNeverInStart, boolean withNeverInEnd) {
        int w = DateChooser.getPreferredWidth(comp, withNeverInStart);
        int w1 = DateChooser.getPreferredWidth(comp, withNeverInEnd);
        return w + 5 + ArrowConnectorIcon.getPreferredWidth() + 5 + w1 + 9;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.isEdit) {
            if (this.checkBox != null) {
                CheckedListAdder.addToList(a, this.checkBox);
            }
            if (this.comboBox != null) {
                CheckedListAdder.addToList(a, this.comboBox);
            }
            CheckedListAdder.addToList(a, this.startDate);
            CheckedListAdder.addToList(a, this.endDate);
        }
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.startDate.getElement().setVisibleContainer(pane);
        this.endDate.getElement().setVisibleContainer(pane);
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.checkBox) {
            this.startDate.setEnabled(this.checkBox.isChecked());
            this.endDate.setEnabled(this.checkBox.isChecked());
            if (this.comboBox != null) {
                this.comboBox.setEnabled(this.checkBox.isChecked());
            }
            this.fireEvent(null, null);
            this.fireFocusCycleEvent(this);
        }
    }

    @Override
    public void setInvalid() {
        if (this.comboBox != null) {
            this.comboBox.setInvalid();
        }
        if (this.startDate != null) {
            this.startDate.getElement().setInvalid();
        }
        if (this.endDate != null) {
            this.endDate.getElement().setInvalid();
        }
    }

    @Override
    public void setValid() {
        if (this.comboBox != null) {
            this.comboBox.setValid();
        }
        if (this.startDate != null) {
            this.startDate.getElement().setValid();
        }
        if (this.endDate != null) {
            this.endDate.getElement().setValid();
        }
    }

    public void setStartDateNode(Node childNamed) {
        this.startNode = childNamed;
        this.startLabel.getElement().setNode(childNamed);
        this.startDate.getElement().setNode(childNamed);
    }

    public void setEndDateNode(Node childNamed) {
        this.endNode = childNamed;
        this.endLabel.getElement().setNode(childNamed);
        this.endDate.getElement().setNode(childNamed);
        if (this.startNode != null) {
            this.dateChanged(null, (java.util.Date)this.startNode.getValue());
        }
    }

    public void setNode(Node<PeriodComplete> periodNode) {
        this.setStartDateNode(periodNode.getChildNamed(PeriodComplete_.startDate));
        this.setEndDateNode(periodNode.getChildNamed(PeriodComplete_.endDate));
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.checkBox != null) {
            this.checkBox.requestFocusInWindowNow();
        } else if (this.isEdit) {
            this.startDate.requestFocusInWindowNow();
        }
    }

    @Override
    public boolean shouldPersist() {
        return this.isPersistable;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
        this.isPersistable = isPersisting;
    }

    public void setCommitOnFocusLost(boolean b) {
        this.startDate.getElement().setCommitOnFocusLost(b);
        this.endDate.getElement().setCommitOnFocusLost(b);
    }

    @Override
    public void setWarning() {
        if (this.startDate != null) {
            this.startDate.getElement().setWarning();
        }
        if (this.endDate != null) {
            this.endDate.getElement().setWarning();
        }
    }

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    public PeriodComplete getPeriod() {
        return new PeriodComplete(this.getStartDate(), this.getEndDate());
    }

    public void setComboBox(ComboBox d) {
        if (this.comboBox != null) {
            this.remove(this.comboBox);
        }
        this.comboBox = d;
        this.comboBox.addItemListener(this);
        this.add(d);
        this.validate();
    }

    public ComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBoxWidth(int w) {
        this.comboBoxWidth = w;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.comboBox)) {
            this.fireEvent(null, null);
        }
    }

    protected void fireFocusCycleEvent(MutableFocusContainer target) {
        for (MutableFocusContainerListener l : this.focusCycleListener) {
            l.focusCycleChanged(target);
        }
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.focusCycleListener.remove(listener);
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.focusCycleListener.add(listener);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = DateChooser.getPreferredWidth(parent, false);
            int we = DateChooser.getPreferredWidth(parent, true);
            int sw = w;
            if (((RDDateChooser)TitledPeriodEditor.this.startDate.getElement()).isCheckBoxEnabled()) {
                sw = we;
            }
            int aox = 0;
            if (TitledPeriodEditor.this.isStartDateOffsetSet) {
                aox = TitledPeriodEditor.this.startDateOffset;
            }
            if (TitledPeriodEditor.this.checkBox != null) {
                TitledPeriodEditor.this.checkBox.setLocation(aox, (int)((double)parent.getHeight() - TitledPeriodEditor.this.checkBox.getPreferredSize().getHeight()) - 4);
                TitledPeriodEditor.this.checkBox.setSize(TitledPeriodEditor.this.checkBox.getPreferredSize());
                aox += 3 + TitledPeriodEditor.this.checkBox.getWidth();
            }
            if (TitledPeriodEditor.this.comboBox != null) {
                if (TitledPeriodEditor.this.comboBoxWidth == 0) {
                    TitledPeriodEditor.this.comboBoxWidth = (int)TitledPeriodEditor.this.comboBox.getPreferredSize().getWidth();
                }
                TitledPeriodEditor.this.comboBox.setLocation(aox, (int)((double)parent.getHeight() - TitledPeriodEditor.this.comboBox.getPreferredSize().getHeight()) - 1);
                TitledPeriodEditor.this.comboBox.setSize(TitledPeriodEditor.this.comboBoxWidth, (int)TitledPeriodEditor.this.comboBox.getPreferredSize().getHeight());
                aox += 3 + TitledPeriodEditor.this.comboBox.getWidth();
            }
            TitledPeriodEditor.this.startDate.setLocation(aox, 2);
            TitledPeriodEditor.this.startDate.setSize(sw, (int)TitledPeriodEditor.this.startDate.getPreferredSize().getHeight());
            TitledPeriodEditor.this.startLabel.setLocation(aox, 2);
            TitledPeriodEditor.this.startLabel.setSize(sw, (int)TitledPeriodEditor.this.startLabel.getPreferredSize().getHeight());
            TitledPeriodEditor.this.connector.setLocation(TitledPeriodEditor.this.startDate.getX() + TitledPeriodEditor.this.startDate.getWidth() + 5, (int)((double)parent.getHeight() - (TitledPeriodEditor.this.connector.getPreferredSize().getHeight() + 2.0 + 7.0)));
            TitledPeriodEditor.this.connector.setSize(TitledPeriodEditor.this.connector.getPreferredSize());
            int ew = w;
            if (((RDDateChooser)TitledPeriodEditor.this.endDate.getElement()).isCheckBoxEnabled()) {
                ew = we;
            }
            if (TitledPeriodEditor.this.isEndDateOffsetSet) {
                TitledPeriodEditor.this.endDate.setLocation(TitledPeriodEditor.this.endDateOffset, 2);
                TitledPeriodEditor.this.endDate.setSize(ew, (int)TitledPeriodEditor.this.endDate.getPreferredSize().getHeight());
                TitledPeriodEditor.this.endLabel.setLocation(TitledPeriodEditor.this.endDateOffset, 2);
                TitledPeriodEditor.this.endLabel.setSize(ew, (int)TitledPeriodEditor.this.endLabel.getPreferredSize().getHeight());
            } else {
                TitledPeriodEditor.this.endDate.setLocation(TitledPeriodEditor.this.connector.getX() + TitledPeriodEditor.this.connector.getWidth() + 5, 2);
                TitledPeriodEditor.this.endDate.setSize(ew, (int)TitledPeriodEditor.this.endDate.getPreferredSize().getHeight());
                TitledPeriodEditor.this.endLabel.setLocation(TitledPeriodEditor.this.connector.getX() + TitledPeriodEditor.this.connector.getWidth() + 5, 2);
                TitledPeriodEditor.this.endLabel.setSize(ew, (int)TitledPeriodEditor.this.endLabel.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)TitledPeriodEditor.this.startDate.getPreferredSize().getHeight() + 4;
            int w = TitledPeriodEditor.getPreferredWidth(parent, ((RDDateChooser)TitledPeriodEditor.this.startDate.getElement()).isCheckBoxEnabled(), ((RDDateChooser)TitledPeriodEditor.this.endDate.getElement()).isCheckBoxEnabled());
            if (TitledPeriodEditor.this.checkBox != null) {
                w = (int)((double)w + (TitledPeriodEditor.this.checkBox.getPreferredSize().getWidth() + 3.0));
            }
            if (TitledPeriodEditor.this.comboBox != null) {
                w = TitledPeriodEditor.this.comboBoxWidth == 0 ? (int)((double)w + (TitledPeriodEditor.this.comboBox.getPreferredSize().getWidth() + 3.0)) : (w += TitledPeriodEditor.this.comboBoxWidth + 3);
            }
            return new Dimension(w, h);
        }
    }
}

