/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.util.List;

public class BorderedInletPanel
extends JPanelKillable
implements LafListener,
AttributeListener,
Focusable {
    private static final long serialVersionUID = 1L;
    protected boolean hasBackground = false;
    protected boolean hasSkin = true;
    protected Skin9Field skin;
    protected boolean hasTitle;
    protected TextLabel titleText;
    protected int titleX;
    protected int titleY;
    protected int arcH;
    protected int arcW;
    protected Color innerBackground;
    protected boolean useCliping = true;

    public BorderedInletPanel() {
        this(true);
    }

    public BorderedInletPanel(boolean hasTitle, boolean hasSkin) {
        this.hasTitle = hasTitle;
        this.hasSkin = hasSkin;
        this.install();
    }

    public BorderedInletPanel(boolean hasTitle) {
        this(hasTitle, true);
    }

    public void isEnabled(boolean isEnabled) {
        if (this.hasTitle) {
            this.titleText.setEnabled(isEnabled);
        }
    }

    public void setUseClipping(boolean useClipping) {
        this.useCliping = useClipping;
    }

    public String getTitleText() {
        return this.titleText.getText();
    }

    public boolean isHasBackground() {
        return this.hasBackground;
    }

    public void setHasBackground(boolean hasBackground) {
        this.hasBackground = hasBackground;
    }

    private void install() {
        if (this.hasTitle) {
            this.titleText = new TextLabel();
            this.skin = (Skin9Field)DefaultSkins.PanelBorder.createDynamicSkin();
        } else {
            this.skin = (Skin9Field)DefaultSkins.ContainerBorder.createDynamicSkin();
        }
        this.arcW = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("details_panel_arcWidth"));
        this.arcH = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("details_panel_arcHeight"));
        this.setLayout(new Layout());
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        if (this.titleText != null) {
            this.add(this.titleText);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        if (this.titleText != null) {
            this.titleText.kill();
        }
        this.titleText = null;
        this.skin = null;
    }

    public void layoutTitle(Container parent) {
        if (this.hasTitle) {
            this.titleText.setLocation(this.titleX, this.titleY);
            this.titleText.setSize(parent.getWidth() - 2 * this.titleX, (int)this.titleText.getPreferredSize().getHeight());
        }
    }

    public int getTitleHeight() {
        if (this.hasTitle) {
            return this.skin.getImage11(Button.ButtonState.UP).getHeight();
        }
        return 0;
    }

    public void setTitleText(String t) {
        if (this.hasTitle) {
            this.titleText.setText(t);
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        if (this.hasTitle) {
            this.titleText.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("innerPanelFrame_font_size"), LafLoader.getLafLoader().getAttribute("innerPanelFrame_font_type")));
            this.titleText.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerPanelFrame_foreground_color")));
        }
        this.innerBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color"));
    }

    @Override
    public void attributeChanged(String attributeName) {
        this.titleX = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("gc_titlebar_text_x"));
        this.titleY = -1;
    }

    public Shape getClipingArea() {
        RoundRectangle2D.Double r = new RoundRectangle2D.Double(1.0, 1.0, this.getWidth() - 2, this.getHeight() - 2, this.arcW, this.arcH);
        return r;
    }

    public void paintOverBackgroundUnderComponents(Graphics2D g2) {
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            g2.clip(this.getClipingArea());
        }
        this.paintOverBackgroundUnderComponents(g2);
        this.paintChildren(g2);
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            BorderedInletPanel.this.layoutTitle(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, BorderedInletPanel.this.getTitleHeight());
        }
    }
}

