/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels.documentscan;

import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.DocumentScanPanel;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.DocumentScanToolkit;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanTypeE;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReceivingGroupComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PurchaseOrderAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class PurchsaeDocumentScanPanel
extends DocumentScanPanel<PurchaseOrderLight> {
    public PurchsaeDocumentScanPanel(SystemSettingsComplete settings, DocumentScanTypeE type) {
        super(settings, type);
    }

    public PurchsaeDocumentScanPanel(SystemSettingsComplete settings, DocumentScanTypeE type, Node<PurchaseOrderLight> orderNode) {
        super(settings, type, orderNode);
    }

    @Override
    public void initDataNode(DocumentScanTypeE type, Node<PurchaseOrderLight> orderNode) {
        this.showAnimation("Load Scans");
        this.loadScans();
        UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        ModuleAccessRightComplete poAccess = HUDToolkit.getCurrentAccessRight(PurchaseOrderAccess.MODULE_PURCHASE, currentUser);
        for (DataFieldAccessRightComplete a : poAccess.getFieldAccessRights()) {
            if (!a.getField().getName().equals(PurchaseOrderAccess.CHANGE_SCAN_DOCUMENT.getName())) continue;
            this.chooseFile = new TextButton(Words.CHOOSE);
            this.chooseFile.addButtonListener((source, x, y) -> {
                File manuallySelectedFile = FileChooserUtil.loadFile();
                if (manuallySelectedFile != null) {
                    File newFile = new File(manuallySelectedFile.getParentFile().getAbsolutePath() + File.separator + "from Purchase " + ((PurchaseOrderLight)orderNode.getValue(PurchaseOrderLight.class)).getNumber() + ".pdf");
                    try {
                        FileUtils.copyFile((File)manuallySelectedFile, (File)newFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        newFile = manuallySelectedFile;
                    }
                    DocumentScanComplete scan = new DocumentScanComplete();
                    scan.setClientOId(Long.valueOf(ADTO.getNextId()));
                    PegasusFileComplete pdf = new PegasusFileComplete();
                    pdf.setLocalFile(newFile);
                    pdf.setCategory(FileCategoryE.DOCUMENT);
                    pdf.setFileName(newFile.getName());
                    scan.setCreationDate(new Timestamp(System.currentTimeMillis()));
                    scan.setFileData(pdf);
                    scan.setType(type);
                    Node docNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)scan, true, false);
                    if (this.documentTable != null && this.documentTable.getModel() != null && this.documentTable.getModel().getNode() != null) {
                        this.documentTable.getModel().getNode().addChild(docNode, 0L);
                        Table2RowPanel panel = this.documentTable.getRowPanel4Node(docNode);
                        this.documentTable.getModel().selectRow(panel, false, true, 3);
                    }
                }
            });
            this.add(this.chooseFile);
        }
    }

    @Override
    public void loadScans() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                List<DocumentScanComplete> documentScan = DocumentScanToolkit.findDocumentScan(PurchsaeDocumentScanPanel.this.getDefaultDocumentScanPath(), PurchsaeDocumentScanPanel.this.type);
                if (PurchsaeDocumentScanPanel.this.orderNode != null) {
                    Iterator it = PurchsaeDocumentScanPanel.this.orderNode.getChildNamed(PurchaseOrderComplete_.checkinGroups).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node group = (Node)it.next();
                        DocumentScanComplete doc = (DocumentScanComplete)group.getChildNamed(PurchaseOrderReceivingGroupComplete_.documentScan).getValue();
                        if (doc == null || doc.getFileData() == null) continue;
                        File file = FileTransferUtil.download((PegasusFileComplete)doc.getFileData(), (FileTransferListener[])new FileTransferListener[0]);
                        PurchaseOrderLight value = (PurchaseOrderLight)PurchsaeDocumentScanPanel.this.orderNode.getValue(PurchaseOrderLight.class);
                        File newFile = new File(file.getParentFile().getAbsolutePath() + File.separator + "from Purchase " + value.getNumber() + ".pdf");
                        FileUtils.copyFile((File)file, (File)newFile);
                        DocumentScanComplete scan = new DocumentScanComplete();
                        scan.setClientOId(Long.valueOf(ADTO.getNextId()));
                        PegasusFileComplete pdf = new PegasusFileComplete();
                        pdf.setLocalFile(newFile);
                        pdf.setCategory(FileCategoryE.DOCUMENT);
                        pdf.setFileName(newFile.getName());
                        scan.setCreationDate(new Timestamp(System.currentTimeMillis()));
                        scan.setFileData(pdf);
                        scan.setType(PurchsaeDocumentScanPanel.this.type);
                        documentScan.add(scan);
                    }
                }
                Node nodes = INodeCreator.getDefaultImpl().createNodes(documentScan, false);
                return nodes;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        PurchsaeDocumentScanPanel.this.hideAnimation();
                        PurchsaeDocumentScanPanel.this.documentTable.fadeIn();
                        PurchsaeDocumentScanPanel.this.preview.fadeIn();
                        PurchsaeDocumentScanPanel.this.documentTable.getModel().setNode(node);
                    }

                    public void errorOccurred(ClientException exception) {
                        PurchsaeDocumentScanPanel.this.hideAnimation();
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)PurchsaeDocumentScanPanel.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }
}

