/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.ContactPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ScrollablePrintPopupInsert;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class UserDataEditPopupInsert
extends ScrollablePrintPopupInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private ContactPanel contactPanel;
    private TitledItem<CheckBox> useNowToResolveVariant;
    private TextButton changePassword;
    private Node<UserComplete> currentUser;

    public UserDataEditPopupInsert(Node<UserComplete> userNode) {
        this.installPanel(userNode);
    }

    private void installPanel(Node<UserComplete> userNode) {
        this.currentUser = userNode;
        this.contactPanel = new ContactPanel();
        this.contactPanel.setNode(this.currentUser.getChildNamed(UserLight_.contact));
        this.useNowToResolveVariant = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_NEWEST_VARIANT, TitledItem.TitledItemOrientation.EAST);
        this.useNowToResolveVariant.getElement().setNode(this.currentUser.getChildNamed(UserLight_.showNewestVariant));
        this.changePassword = new TextButton(Words.CHANGE_PASSWORD);
        this.changePassword.addButtonListener(this);
        this.getViewContainer().setLayout(new Layout());
        this.contactPanel.setProgress(1.0f);
        this.getViewContainer().add(this.contactPanel);
        this.getViewContainer().add(this.useNowToResolveVariant);
        this.getViewContainer().add(this.changePassword);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.contactPanel.setEnabled(isEnabled);
        this.useNowToResolveVariant.setEnabled(isEnabled);
        this.changePassword.setEnabled(isEnabled);
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                UserDataEditPopupInsert.this.currentUser.commit(UserComplete.class);
                UserComplete user = (UserComplete)UserDataEditPopupInsert.this.currentUser.getValue(UserComplete.class);
                try {
                    user = (UserComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).update((UserReference)user).getValue();
                    ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).setCurrentUser(user);
                }
                catch (ClientServerCallException e) {
                    ViewNode ret = new ViewNode("Errors");
                    ret.setValue((Object)e, 0L);
                    return ret;
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return UserDataEditPopupInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.contactPanel.kill();
        this.contactPanel = null;
        this.useNowToResolveVariant.kill();
        this.useNowToResolveVariant = null;
        this.changePassword.kill();
        this.changePassword = null;
    }

    @Override
    protected String getProgressText() {
        return Words.SAVE;
    }

    @Override
    protected String getFinishedText() {
        return Words.DATA_SAVED;
    }

    @Override
    public void removeInheritedComponents() {
        this.contactPanel.setVisible(false);
        this.useNowToResolveVariant.setVisible(false);
        this.changePassword.setVisible(false);
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.contactPanel.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.changePassword) {
            InnerPopupFactory.showPasswordChangePopup(source, null, (UserComplete)this.currentUser.getValue(UserComplete.class), false);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            UserDataEditPopupInsert.this.layoutInheritedComponents(parent);
            int h = UserDataEditPopupInsert.this.border;
            h = (int)((double)h + UserDataEditPopupInsert.this.contactPanel.getPreferredSize().getHeight());
            h += UserDataEditPopupInsert.this.border;
            h = (int)((double)h + UserDataEditPopupInsert.this.changePassword.getPreferredSize().getHeight());
            h += UserDataEditPopupInsert.this.border;
            int w = (int)(UserDataEditPopupInsert.this.contactPanel.getPreferredSize().getWidth() + (double)(2 * UserDataEditPopupInsert.this.border));
            int w2 = (int)(UserDataEditPopupInsert.this.useNowToResolveVariant.getPreferredSize().getWidth() + (double)(2 * UserDataEditPopupInsert.this.border));
            if (w2 > w) {
                w = w2;
            }
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            UserDataEditPopupInsert.this.contactPanel.setLocation(UserDataEditPopupInsert.this.border, UserDataEditPopupInsert.this.border);
            UserDataEditPopupInsert.this.contactPanel.setSize(parent.getWidth() - 2 * UserDataEditPopupInsert.this.border, (int)((double)parent.getHeight() - ((double)(UserDataEditPopupInsert.this.border * 2) + UserDataEditPopupInsert.this.useNowToResolveVariant.getPreferredSize().getHeight())));
            UserDataEditPopupInsert.this.changePassword.setLocation(UserDataEditPopupInsert.this.border, UserDataEditPopupInsert.this.contactPanel.getY() + UserDataEditPopupInsert.this.contactPanel.getHeight() + UserDataEditPopupInsert.this.border);
            UserDataEditPopupInsert.this.changePassword.setSize(UserDataEditPopupInsert.this.changePassword.getPreferredSize());
            UserDataEditPopupInsert.this.useNowToResolveVariant.setLocation(UserDataEditPopupInsert.this.changePassword.getX() + UserDataEditPopupInsert.this.changePassword.getWidth() + UserDataEditPopupInsert.this.border, UserDataEditPopupInsert.this.contactPanel.getY() + UserDataEditPopupInsert.this.contactPanel.getHeight() + UserDataEditPopupInsert.this.border);
            UserDataEditPopupInsert.this.useNowToResolveVariant.setSize(UserDataEditPopupInsert.this.useNowToResolveVariant.getPreferredSize());
        }
    }
}

