/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.rightdependant;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDField;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Dimension;
import java.util.Date;

public class RDDateChooser
extends RDField<DateChooser, TextLabel> {
    private static final long serialVersionUID = 1L;
    private boolean isShared = false;
    private boolean isCheckBoxEnabled;

    public RDDateChooser(RDProvider provider) {
        super(provider);
    }

    public RDDateChooser(RDProvider provider, boolean b) {
        this(provider);
        this.isShared = b;
    }

    @Override
    public DateChooser createEditor(Node<?> node) {
        DateChooser d = new DateChooser(node, this.isShared);
        d.setEnabled(this.isEnabled);
        if (this.isCheckBoxEnabled) {
            d.setNeverExpires(true, "");
        }
        return d;
    }

    @Override
    public Dimension getNodeLessPreferredSize() {
        int h = ((Skin1Field)DefaultSkins.CalendarOpenIcon.createDynamicSkin()).getImage(Button.ButtonState.UP).getHeight();
        return new Dimension(h, h);
    }

    @Override
    public TextLabel createRenderer(Node<?> node) {
        TextLabel t = new TextLabel(node, ConverterRegistry.getConverter(DateConverter.class));
        t.setReadOnlyTextField(true);
        t.setEnabled(this.isEnabled);
        return t;
    }

    public void addDateChooserListener(DateChooserListener titledPeriodEditor) {
        if (this.wField != null) {
            ((DateChooser)this.wField).addDateChooserListener(titledPeriodEditor);
        }
    }

    public void setMinimumDate(Date selectedDate) {
        if (this.wField != null) {
            ((DateChooser)this.wField).setMinimumDate(selectedDate);
        }
    }

    public Date getSelectedDate() {
        if (this.wField != null) {
            return ((DateChooser)this.wField).getSelectedDate();
        }
        if (this.rField != null) {
            return (Date)((TextLabel)this.rField).getNode().getValue();
        }
        return null;
    }

    public void setCommitOnFocusLost(boolean b) {
        if (this.wField != null) {
            ((DateChooser)this.wField).setCommitOnFocusLost(b);
        }
    }

    public void setCheckBoxEnabled() {
        this.isCheckBoxEnabled = true;
        if (this.wField != null) {
            ((DateChooser)this.wField).setNeverExpires(true, "");
        }
    }

    public boolean isCheckBoxEnabled() {
        if (this.wField != null) {
            return ((DateChooser)this.wField).isNeverExpires();
        }
        return this.isCheckBoxEnabled;
    }
}

