/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.DiscountTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.DiscountTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerDiscountsComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerDiscountsComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerPriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CustomerDiscountTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public CustomerDiscountTable() {
        super(true, Words.ADD, true, false, Words.CUSTOMERS);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                CustomerDiscountTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                ProductCustomerDiscountsComplete newDiscount = new ProductCustomerDiscountsComplete();
                newDiscount.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node node4DTO = INodeCreator.getDefaultImpl().getNode4DTO((Object)newDiscount, false, false);
                if (node4DTO != null) {
                    CustomerDiscountTable.this.getModel().getNode().addChild(node4DTO, 0L);
                }
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", 80, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo(Words.DISCOUNT, null, null, null, "", 80, Integer.MAX_VALUE, 120));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public void setNode(Node customers) {
        this.getModel().setNode(customers);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<CustomerLight> customerSearch;
        private ComboBox discountCombo;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.customerSearch = SearchTextField2Factory.getCustomerSearchField(true, m.getNode().getChildNamed(ProductCustomerPriceComplete_.customer));
            this.discountCombo = new ComboBox(m.getNode().getChildNamed(ProductCustomerDiscountsComplete_.discount), NodeToolkit.getAffixList(DiscountTypeComplete.class), ConverterRegistry.getConverter(DiscountTypeConverter.class));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.customerSearch);
            this.add(this.discountCombo);
            this.add(this.delete);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            } else {
                this.setEnabled(this.isEnabled());
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.customerSearch.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
            this.discountCombo.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.customerSearch.kill();
            this.delete.kill();
            this.discountCombo.kill();
            this.discountCombo = null;
            this.customerSearch = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.customerSearch);
            CheckedListAdder.addToList(focusList, this.discountCombo);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.customerSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customerSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customerSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customerSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.discountCombo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.discountCombo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.discountCombo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.discountCombo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

