/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.textfield;

import ch.icit.pegasus.client.gui.utils.textfield.NumberDocument;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import java.text.DecimalFormatSymbols;
import java.util.List;

public class NumberTextField
extends TextField {
    private static final long serialVersionUID = 1L;
    private boolean minusAllowed;

    public static String getUnifiedDecimalString(String t) {
        String ft;
        String sep = "" + DecimalFormatSymbols.getInstance().getDecimalSeparator();
        if (sep.equals(".")) {
            sep = "\\.";
        }
        if ((ft = t) != null) {
            ft = ft.replaceAll(sep, ".");
        }
        return ft;
    }

    public NumberTextField(Node node, TextFieldType type) {
        super(node, type);
    }

    public NumberTextField(TextFieldType type) {
        super(type);
    }

    @Override
    protected void installLocal() {
        super.installLocal();
        this.minusAllowed = true;
        this.textField.setDocument(new NumberDocument(this.type, this.minusAllowed, this.textField, this.maxKommastellen));
    }

    @Override
    protected void afterFocusGained() {
        this.textField.setSelectionStart(0);
        this.textField.setSelectionEnd(this.textField.getText().length());
    }

    @Override
    protected List<TextFieldType> getValidTypes() {
        if (this.validTypes.isEmpty()) {
            this.validTypes.add(TextFieldType.INT);
            this.validTypes.add(TextFieldType.LONG);
            this.validTypes.add(TextFieldType.DOUBLE);
        }
        return this.validTypes;
    }

    public void setUseMaxDecimals(boolean b) {
        this.useMaxDecimals = b;
    }

    public void disableMinus() {
        this.minusAllowed = false;
        if (this.textField.getDocument() instanceof NumberDocument) {
            NumberDocument d = (NumberDocument)this.textField.getDocument();
            d.setMinusAllowed(this.minusAllowed);
        }
    }

    public void allowMinus() {
        this.minusAllowed = true;
        if (this.textField.getDocument() instanceof NumberDocument) {
            NumberDocument d = (NumberDocument)this.textField.getDocument();
            d.setMinusAllowed(this.minusAllowed);
        }
    }

    public void setMaxKommaStellen(int m) {
        this.maxKommastellen = m;
        if (this.format != null) {
            this.format.setMinimumFractionDigits(0);
            this.format.setMaximumFractionDigits(m);
        }
        if (this.textField != null && this.textField.getDocument() instanceof NumberDocument) {
            NumberDocument d = (NumberDocument)this.textField.getDocument();
            d.setMaxKommastellen(this.maxKommastellen);
        }
    }

    public int getMaxKommaStelle() {
        return this.maxKommastellen;
    }
}

