/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.hud.HUDPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.GraphicsUtils;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class ScreenSaver {
    public static void saveScreenShot2Disc(Component currentScreeen) {
        ScreenSaver.tryToSave(currentScreeen);
        Component innerRow = ScreenSaver.scan((JPanel)currentScreeen);
        if (innerRow != null) {
            ScreenSaver.tryToSave(innerRow);
        }
    }

    public static void tryToSave(Component currentScreeen) {
        BufferedImage img = GraphicsUtils.createCompatibleImage(currentScreeen.getWidth(), currentScreeen.getHeight());
        Graphics g = img.getGraphics();
        currentScreeen.paint(g);
        if (MainFrame.isTempRelease) {
            return;
        }
        MainFrame.isTempRelease = true;
        File fileName = FileChooserUtil.saveFile(".png");
        if (fileName != null) {
            ScreenSaver.doSave(fileName, img, currentScreeen);
        } else {
            MainFrame.isTempRelease = false;
        }
    }

    private static Component scan(JPanel comp) {
        for (Component c : comp.getComponents()) {
            Component dt = ScreenSaver.searchForModule(c);
            if (dt != null) {
                return dt;
            }
            Component nc = null;
            if (c instanceof JPanel) {
                nc = c;
            } else if (c instanceof ScrollPane) {
                nc = ((ScrollPane)c).getViewport().getView();
            }
            if (nc != null && nc instanceof JPanel) {
                dt = ScreenSaver.scan((JPanel)nc);
            }
            if (dt == null) continue;
            return dt;
        }
        return null;
    }

    private static Component searchForModule(Component c) {
        ScreenTableView stv;
        RowModel row;
        if (c instanceof ScreenTableView && (row = (stv = (ScreenTableView)c).getTable().getExpandedRow()) != null) {
            return row.getView();
        }
        return null;
    }

    private static void doSave(File file, final BufferedImage img, Component currentScreen) {
        final File selectedFile = file;
        if (selectedFile != null && selectedFile.exists()) {
            String errorMSG = "File already exists. Do you want to override it?";
            InnerPopupFactory.showDesicionPopup("Override", "File already exists, do you want to override current?", currentScreen, new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    if (xargs == null) {
                        MainFrame.isTempRelease = false;
                        return;
                    }
                    ScreenSaver.saveImage(selectedFile, img);
                }
            }, 250, 100, PopupType.WARNING);
        } else if (selectedFile != null) {
            ScreenSaver.saveImage(selectedFile, img);
        }
    }

    private static void saveImage(File f, BufferedImage img) {
        MainFrame.isTempRelease = false;
        if (img != null && f != null) {
            try {
                ImageIO.write((RenderedImage)img, "png", f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] saveScreen(Component currentScreeen) {
        try {
            BufferedImage img = GraphicsUtils.createCompatibleImage(currentScreeen.getWidth(), currentScreeen.getHeight());
            Graphics g = img.getGraphics();
            g.clearRect(0, 0, img.getWidth(), img.getHeight());
            g.setColor(Color.RED);
            g.fillRect(0, 0, img.getWidth(), img.getTileHeight());
            currentScreeen.paint(g);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", out);
            out.flush();
            byte[] screenshot = out.toByteArray();
            out.close();
            return screenshot;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void savePopupToDisk(ArrayList<InnerPopUp2> openPopUp) {
        ScreenSaver.saveScreenShot2Disc(openPopUp.get(openPopUp.size() - 1));
    }

    public static void saveHudToDisk(HUDPanel currentScreeen) {
        BufferedImage img = GraphicsUtils.createCompatibleImage(currentScreeen.getWidth(), currentScreeen.getHeight());
        Graphics g = img.getGraphics();
        currentScreeen.paint(g);
        if (MainFrame.isTempRelease) {
            return;
        }
        MainFrame.isTempRelease = true;
        File fileName = FileChooserUtil.saveFile(".png");
        if (fileName != null) {
            ScreenSaver.doSave(fileName, img, currentScreeen);
        } else {
            MainFrame.isTempRelease = false;
        }
    }
}

