/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.flightschedule.returnscount;

import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountDeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.flight.returnscount.ReturnsCountProduct")
public class ReturnsCountProductComplete
extends ADTO
implements Comparable<ReturnsCountProductComplete> {
    @DTOField(nullable=false, updatable=false)
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ProductComplete product;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private ReturnsCountDeliverySpaceComplete deliverySpace;
    @XmlAttribute
    private Boolean crewPrice;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @IgnoreField
    private BasicArticleLight article;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @IgnoreField
    private QuantityComplete articleQuantity;
    @IgnoreField
    @XmlAttribute
    private Integer conversionFactor;
    @DTOField(readonly=true)
    @XmlAttribute
    private Integer calculatedDeliveredAmount = 0;
    @DTOField(nullable=false, minValue=0.0)
    @XmlAttribute
    private Integer revisedDeliveredAmount = 0;
    @DTOField(nullable=false, minValue=0.0)
    @XmlAttribute
    private Integer countedAmount = 0;
    @DTOField(nullable=false, minValue=0.0)
    @XmlAttribute
    private Integer soldAmount = 0;
    @DTOField(nullable=false, minValue=0.0)
    @XmlAttribute
    private Integer wasteAmount = 0;
    @DTOField(nullable=false, minValue=0.0)
    @XmlAttribute
    private Integer missingAmount = 0;
    @XmlAttribute
    private Boolean useRevisedDeliveredAmount = false;
    @DTOField(nullable=false)
    @XmlAttribute
    private Integer machineSoldAmount = 0;
    @DTOField(nullable=false, minValue=0.0)
    @XmlAttribute
    private Integer complementarySalesAmount = 0;
    @DTOField(nullable=false, minValue=0.0)
    @XmlAttribute
    private Integer crewSalesAmount = 0;
    @DTOField(nullable=false, minValue=0.0)
    @XmlAttribute
    private Integer discountAmount = 0;
    @DTOField(nullable=false, minValue=0.0)
    @XmlAttribute
    private Integer machineSalesAmount = 0;

    @Override
    public int compareTo(ReturnsCountProductComplete o) {
        if (this.product.getCurrentVariant().getCustomerProductNumber() == null) {
            return o.getProduct().getCurrentVariant().getCustomerProductNumber() == null ? 0 : -1;
        }
        if (o.getProduct().getCurrentVariant().getCustomerProductNumber() == null) {
            return 1;
        }
        try {
            Integer c1 = Integer.valueOf(this.product.getCurrentVariant().getCustomerProductNumber());
            Integer c2 = Integer.valueOf(o.getProduct().getCurrentVariant().getCustomerProductNumber());
            return c1 - c2;
        }
        catch (NumberFormatException numberFormatException) {
            return this.product.getCurrentVariant().getCustomerProductNumber().compareTo(o.getProduct().getCurrentVariant().getCustomerProductNumber());
        }
    }

    public Integer getMachineSoldAmount() {
        return this.machineSoldAmount;
    }

    public void setMachineSoldAmount(Integer machineSoldAmount) {
        this.machineSoldAmount = machineSoldAmount;
    }

    public BasicArticleLight getArticle() {
        return this.article;
    }

    public void setArticle(BasicArticleLight article) {
        this.article = article;
    }

    public QuantityComplete getArticleQuantity() {
        return this.articleQuantity;
    }

    public void setArticleQuantity(QuantityComplete articleQuantity) {
        this.articleQuantity = articleQuantity;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("ReturnsCountProductComplete: ");
        b.append("SobSold: " + this.machineSoldAmount);
        b.append("SobSales: " + this.machineSalesAmount);
        b.append("SobCrew: " + this.crewSalesAmount);
        b.append("SobComp: " + this.complementarySalesAmount);
        b.append("SobDisc: " + this.discountAmount);
        b.append("RCRevise: " + this.revisedDeliveredAmount);
        b.append("RCSold: " + this.soldAmount);
        b.append("RCWaste: " + this.wasteAmount);
        b.append("RCMissing: " + this.missingAmount);
        b.append("RCCount: " + this.countedAmount);
        return super.toString();
    }

    @Override
    public int hashCode() {
        if (this.getId() != null) {
            return super.hashCode();
        }
        Integer prime = 31;
        int result = super.hashCode();
        result = prime * result + (this.product == null ? 0 : this.product.hashCode());
        result = prime * result + (this.deliverySpace == null ? 0 : this.deliverySpace.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getId() != null) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReturnsCountProductComplete other = (ReturnsCountProductComplete)obj;
        if (this.product == null ? other.product != null : !this.product.equals(other.product)) {
            return false;
        }
        return !(this.deliverySpace == null ? other.deliverySpace != null : !this.deliverySpace.equals(other.deliverySpace));
    }

    public ReturnsCountDeliverySpaceComplete getDeliverySpace() {
        return this.deliverySpace;
    }

    public void setDeliverySpace(ReturnsCountDeliverySpaceComplete deliverySpace) {
        this.deliverySpace = deliverySpace;
    }

    public Integer getSoldAmount() {
        return this.soldAmount;
    }

    public void setSoldAmount(Integer soldAmount) {
        this.soldAmount = soldAmount;
    }

    public Integer getWasteAmount() {
        return this.wasteAmount;
    }

    public void setWasteAmount(Integer wasteAmount) {
        this.wasteAmount = wasteAmount;
    }

    public ProductComplete getProduct() {
        return this.product;
    }

    public void setProduct(ProductComplete product) {
        this.product = product;
    }

    public Integer getCountedAmount() {
        return this.countedAmount;
    }

    public void setCountedAmount(Integer countedAmount) {
        this.countedAmount = countedAmount;
    }

    public Integer getCalculatedDeliveredAmount() {
        return this.calculatedDeliveredAmount;
    }

    public void setCalculatedDeliveredAmount(Integer calculatedDeliveredAmount) {
        this.calculatedDeliveredAmount = calculatedDeliveredAmount;
    }

    public Integer getRevisedDeliveredAmount() {
        return this.revisedDeliveredAmount;
    }

    public void setRevisedDeliveredAmount(Integer revisedDeliveredAmount) {
        this.revisedDeliveredAmount = revisedDeliveredAmount;
    }

    public Boolean getUseRevisedDeliveredAmount() {
        return this.useRevisedDeliveredAmount;
    }

    public void setUseRevisedDeliveredAmount(Boolean useRevisedDeliveredAmount) {
        this.useRevisedDeliveredAmount = useRevisedDeliveredAmount;
    }

    public Integer getMissingAmount() {
        return this.missingAmount;
    }

    public void setMissingAmount(Integer missingAmount) {
        this.missingAmount = missingAmount;
    }

    public Integer getComplementarySalesAmount() {
        return this.complementarySalesAmount;
    }

    public void setComplementarySalesAmount(Integer complementarySalesAmount) {
        this.complementarySalesAmount = complementarySalesAmount;
    }

    public Integer getCrewSalesAmount() {
        return this.crewSalesAmount;
    }

    public void setCrewSalesAmount(Integer crewSalesAmount) {
        this.crewSalesAmount = crewSalesAmount;
    }

    public Integer getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(Integer discountSalesAmount) {
        this.discountAmount = discountSalesAmount;
    }

    public Integer getMachineSalesAmount() {
        return this.machineSalesAmount;
    }

    public void setMachineSalesAmount(Integer machineSalesAmount) {
        this.machineSalesAmount = machineSalesAmount;
    }

    public Integer getConversionFactor() {
        return this.conversionFactor;
    }

    public void setConversionFactor(Integer conversionFactor) {
        this.conversionFactor = conversionFactor;
    }

    public Boolean getCrewPrice() {
        return this.crewPrice;
    }

    public void setCrewPrice(Boolean crewPrice) {
        this.crewPrice = crewPrice;
    }

    public void afterUnmarshal(Unmarshaller m, Object o) {
        if (o instanceof ReturnsCountDeliverySpaceComplete) {
            this.deliverySpace = (ReturnsCountDeliverySpaceComplete)o;
        }
    }
}

