/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.ordering.transaction;

import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionLight;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.OrderPositionTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderPositionCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderPositionMutationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderRecipientTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderRejectionComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.SqlDateAdapter;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTOImplementations;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.sql.Date;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@DTOImplementations(value={PurchaseOrderRecipientTransactionComplete.class})
@XmlSeeAlso(value={PurchaseOrderPositionCorrectionComplete.class, PurchaseOrderRecipientTransactionComplete.class, PurchaseOrderPositionMutationComplete.class, PurchaseOrderAcceptationComplete.class, PurchaseOrderRejectionComplete.class})
public abstract class PurchaseOrderTransactionComplete
extends OrderPositionTransactionComplete {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private PurchaseOrderPositionLight orderPosition;
    @IgnoreField
    @XmlAttribute
    private Long orderPositionID;
    @IgnoreField
    @XmlAttribute
    private String orderNumber;
    @IgnoreField
    @XmlAttribute
    private String orderSupplier;
    @IgnoreField
    @XmlAttribute
    private OrderStateE orderState;
    @IgnoreField
    @XmlJavaTypeAdapter(value=SqlDateAdapter.class)
    private Date orderDate;
    @IgnoreField
    @XmlJavaTypeAdapter(value=SqlDateAdapter.class)
    private Date orderDeliveryDate;
    @IgnoreField
    private CostCenterComplete department;
    @IgnoreField
    private PriceComplete estimatedOrderPrice;
    @IgnoreField
    private PriceComplete realOrderCosts;
    @IgnoreField
    private OrderReviewStateE reviewState;

    public PurchaseOrderPositionLight getOrderPosition() {
        return this.orderPosition;
    }

    public void setOrderPosition(PurchaseOrderPositionLight orderPosition) {
        this.orderPosition = orderPosition;
    }

    public Long getOrderPositionID() {
        return this.orderPositionID;
    }

    public void setOrderPositionID(Long orderPositionID) {
        this.orderPositionID = orderPositionID;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getOrderSupplier() {
        return this.orderSupplier;
    }

    public void setOrderSupplier(String orderSupplier) {
        this.orderSupplier = orderSupplier;
    }

    public OrderStateE getOrderState() {
        return this.orderState;
    }

    public void setOrderState(OrderStateE orderState) {
        this.orderState = orderState;
    }

    public Date getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public Date getOrderDeliveryDate() {
        return this.orderDeliveryDate;
    }

    public void setOrderDeliveryDate(Date orderDeliveryDate) {
        this.orderDeliveryDate = orderDeliveryDate;
    }

    public CostCenterComplete getDepartment() {
        return this.department;
    }

    public void setDepartment(CostCenterComplete department) {
        this.department = department;
    }

    public PriceComplete getEstimatedOrderPrice() {
        return this.estimatedOrderPrice;
    }

    public void setEstimatedOrderPrice(PriceComplete estimatedOrderPrice) {
        this.estimatedOrderPrice = estimatedOrderPrice;
    }

    public PriceComplete getRealOrderCosts() {
        return this.realOrderCosts;
    }

    public void setRealOrderCosts(PriceComplete realOrderCosts) {
        this.realOrderCosts = realOrderCosts;
    }

    public OrderReviewStateE getReviewState() {
        return this.reviewState;
    }

    public void setReviewState(OrderReviewStateE reviewState) {
        this.reviewState = reviewState;
    }

    void beforeMarshal(Marshaller m) {
        if (this.orderPosition != null) {
            this.setOrderPositionID(this.orderPosition.getCacheId());
            if (this.orderPosition.getOrder() != null) {
                this.orderNumber = this.orderPosition.getOrder().getNumber() + "";
                if (this.orderPosition.getOrder().getSupplier() != null) {
                    this.orderSupplier = this.orderPosition.getOrder().getSupplier().getNumber() + " - " + this.orderPosition.getOrder().getSupplier().getName();
                }
                this.orderState = this.orderPosition.getOrder().getState();
                this.orderDate = this.orderPosition.getOrder().getOrderDate();
                this.orderDeliveryDate = this.orderPosition.getOrder().getDeliveryDate();
                this.department = this.orderPosition.getOrder().getCostCenter();
                this.estimatedOrderPrice = this.orderPosition.getOrder().getEstimatedCost();
                this.realOrderCosts = this.orderPosition.getOrder().getRealCost();
                this.reviewState = this.orderPosition.getOrder().getReviewState();
            }
        }
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (parent instanceof PurchaseOrderPositionComplete) {
            this.orderPosition = (PurchaseOrderPositionComplete)parent;
        }
    }
}

