/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.services.flight;

import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightParameterConfig;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.StowagePositionIdentifier;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.importer.FlightImportComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.importer.FlightImportReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountFlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountParameterConfig;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.FlightWagonComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.ReturnWagonComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.WagonStockComplete;
import ch.icit.pegasus.server.core.dtos.invoice.FlightInvoiceData;
import ch.icit.pegasus.server.core.dtos.masterdata.AlaCarteMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceLight;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.report.FlightDataReportConfig;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionTransactionDataComplete;
import ch.icit.pegasus.server.core.dtos.search.GalleyEquipmentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.tracking.FlightSealsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TrackableItemWrapper;
import ch.icit.pegasus.server.core.services.ServiceImplementation;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.util.ServiceReturnWithMessage;
import java.util.Map;
import javax.ejb.Remote;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;

@Remote
@WebService(targetNamespace="https://icit.ch/pegasus/flightservice")
@SOAPBinding(style=SOAPBinding.Style.RPC)
@ServiceImplementation(implementation="FlightServiceImpl")
@ApplicationPath(value="/resources")
@Path(value="flights")
public interface FlightService {
    @WebMethod
    public OptionalWrapper<FlightScheduleComplete> createScheduleFromTemplate(FlightScheduleReference var1) throws ServiceException;

    @WebMethod
    public ListWrapper<FlightScheduleLight> findDuplicateFlightSchedule(FlightScheduleComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightScheduleComplete> createFlightSchedule(FlightScheduleComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightScheduleComplete> updateFlightSchedule(FlightScheduleComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightScheduleComplete> getFlightSchedule(FlightScheduleReference var1) throws ServiceException;

    @WebMethod
    public ListWrapper<FlightLegComplete> getForeCastPax(FlightReference var1) throws ServiceException;

    @WebMethod
    public Boolean canCreateFlight(String var1, TimestampWrapper var2, String var3, TimestampWrapper var4, FlightReference var5) throws ServiceException;

    @WebMethod
    public Boolean canCreate(String var1, TimestampWrapper var2, String var3, TimestampWrapper var4) throws ServiceException;

    @WebMethod
    public ListWrapper<FlightWagonComplete> getFlightWagons(FlightReference var1) throws ServiceException;

    @WebMethod
    public void updateFlightWagons(FlightReference var1, ListWrapper<FlightWagonComplete> var2) throws ServiceException;

    @WebMethod
    public void addReturnWagon(ListWrapper<ReturnWagonComplete> var1) throws ServiceException;

    @WebMethod
    public ListWrapper<WagonStockComplete> getWagonStock() throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightLight> approveFlightSubstitutions(FlightReference var1) throws ServiceException;

    @WebMethod
    public ListWrapper<RetailInMotionTransactionDataComplete> getRiMTransactionsForFlight(FlightReference var1) throws ServiceException;

    @WebMethod
    public void updateRiMTransactionsForFlight(ListWrapper<RetailInMotionTransactionDataComplete> var1) throws ServiceException;

    @WebMethod
    public void resetRevisedAmount(ListWrapper<FlightReference> var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightComplete> create(FlightComplete var1, ListWrapper<String> var2, String var3) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightComplete> createWithAircraft(FlightComplete var1, StowingListTemplateReference var2, AircraftReference var3, MapWrapper<StowagePositionIdentifier, StowagePositionIdentifier> var4, MapWrapper<StowingListTemplateLegComplete, FlightLegComplete> var5, ListWrapper<String> var6) throws ServiceException;

    @WebMethod
    public ServiceReturnWithMessage<FlightComplete> update(FlightComplete var1, ListWrapper<String> var2, boolean var3, boolean var4, boolean var5, boolean var6) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightComplete> getFlight(FlightReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightComplete> getPlannedFlightComplete(FlightLight var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightComplete> updateInvoicedFlight(FlightComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<StowingListLight> switchStowingListFromPersistedFlight(FlightParameterConfig var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightComplete> switchStowingList(FlightParameterConfig var1) throws ServiceException;

    @WebMethod
    public ListWrapper<DeliverySpaceComplete> getAdditionalOrderSpaces(FlightReference var1) throws ServiceException;

    @WebMethod
    public ListWrapper<DeliverySpaceComplete> getAdditionalSPMLOrderSpaces(FlightReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightSealsComplete> getFlightSeals(GalleyEquipmentSearchConfiguration var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightSealsComplete> updateSeals(FlightSealsComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<ReturnsCountFlightComplete> getCountItems(FlightReference var1, ReturnsCountParameterConfig var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<ReturnsCountFlightComplete> getManualSalesItems(FlightReference var1, ReturnsCountParameterConfig var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<ReturnsCountFlightComplete> getCountAndManualSalesItems(FlightReference var1, ReturnsCountParameterConfig var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<ReturnsCountFlightComplete> updateCountItems(ReturnsCountFlightComplete var1, boolean var2, boolean var3) throws ServiceException;

    @WebMethod
    public OptionalWrapper<ReturnsCountFlightComplete> updateManualSalesItem(ReturnsCountFlightComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<ReturnsCountFlightComplete> updateCountAndManualSalesItem(ReturnsCountFlightComplete var1, boolean var2) throws ServiceException;

    @WebMethod
    public FlightInvoiceData getCostData(FlightDataReportConfig var1) throws ServiceException;

    @WebMethod
    public FlightInvoiceData getReturnsCountData(FlightDataReportConfig var1) throws ServiceException;

    @WebMethod
    public FlightInvoiceData getProductCostData(FlightDataReportConfig var1, TimestampWrapper var2) throws ServiceException;

    @WebMethod
    public FlightInvoiceData getHandlingCostData(FlightDataReportConfig var1, TimestampWrapper var2) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightImportComplete> createFlightImport(FlightImportComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightImportComplete> updateFlightImport(FlightImportComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightImportComplete> getFlightImport(FlightImportReference var1) throws ServiceException;

    @WebMethod
    public MapWrapper<ALegComplete, Map<CabinClassComplete, Map<ProductComplete, Integer>>> getDeliveredProducts(FlightReference var1) throws ServiceException;

    @WebMethod
    public MapWrapper<CabinClassComplete, ListWrapper<SpecialMenuTypeComplete>> getChoosableSpecialMenuTypes(FlightLight var1) throws ServiceException;

    @WebMethod
    public MapWrapper<CabinClassComplete, ListWrapper<AlaCarteMenuTypeComplete>> getChoosableALaCarteMenuTypes(FlightLight var1) throws ServiceException;

    @WebMethod
    public ListWrapper<String> performStockCheckouts(FlightReference var1, boolean var2) throws ServiceException;

    @WebMethod
    public void recalculateIrregularities(FlightReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightComplete> recalculateFlight(FlightReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightLight> reloadFlightData(FlightReference var1) throws ServiceException;

    @WebMethod
    public FlightInvoiceData getFlightOverviewCost(FlightDataReportConfig var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightScheduleLight> getFlightScheduleLight(FlightScheduleReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightLight> setFlightBackOpen(FlightReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<ReportFileComplete> getFlightDeliverySlipReportFile(FlightReference var1) throws ServiceException;

    @WebMethod
    public ListWrapper<CateringServiceLight> getMappedServices(FlightComplete var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightLight> getFlightLight(FlightReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightLight> getAssociatedFlight(SealComplete var1) throws ServiceException;

    @WebMethod
    public TrackableItemWrapper getAssociatedEquipment(SealComplete var1) throws ServiceException;

    @WebMethod
    public ListWrapper<ALoadingGroupComplete> getFlightLoadingGroups(FlightReference var1) throws ServiceException;

    @WebMethod
    public OptionalWrapper<FlightLight> revertAndRecalculateTransaction(FlightReference var1) throws ServiceException;

    @WebMethod
    public void uploadCounts(PegasusFileComplete var1, FlightReference var2) throws ServiceException;

    @WebMethod
    public void performTransactionReturnsCountData(FlightReference var1) throws ServiceException;

    @WebMethod
    public void addScanDocument(FlightReference var1, DocumentScanComplete var2) throws ServiceException;

    @WebMethod
    public void fixInOutBound(ListWrapper<FlightReference> var1) throws ServiceException;

    @WebMethod
    public void unFixInOutBound(ListWrapper<FlightReference> var1) throws ServiceException;

    @WebMethod
    public ListWrapper<String> getGalleys(FlightReference var1) throws ServiceException;

    @WebMethod
    public ListWrapper<FlightScheduleComplete> getFlightSchedules(ListWrapper<FlightScheduleReference> var1, boolean var2) throws ServiceException;
}

