/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.debug;

import ch.icit.pegasus.server.core.util.StringUtil;

public class StopWatch {
    private long startTime;
    private long endTime;
    private final String id;
    private String message;

    public StopWatch(String id) {
        this(id, null);
    }

    public StopWatch(String id, String message) {
        this.id = id;
        this.message = message;
        this.start();
    }

    public StopWatch start() {
        return this.start(this.message);
    }

    public StopWatch start(String message) {
        this.message = message;
        this.startTime = System.currentTimeMillis();
        return this;
    }

    public StopWatch stop() {
        this.endTime = System.currentTimeMillis();
        long duration = this.endTime - this.startTime;
        int millis = 0;
        String outputString = "";
        if (duration == 0L) {
            outputString = "0 sec";
        } else {
            millis = (int)(duration % 1000L);
            int sec = (int)((duration /= 1000L) % 60L);
            int min = (int)((duration /= 60L) % 60L);
            int hour = (int)((duration /= 60L) % 60L);
            if (hour > 0) {
                outputString = hour + "h ";
            }
            if (min > 0) {
                outputString = outputString + min + " min ";
            }
            if (sec > 0) {
                outputString = outputString + sec + " sec ";
            }
            if (millis > 0) {
                outputString = outputString + millis + " millis";
            }
        }
        if (StringUtil.isBlank(this.message)) {
            System.out.println("[Stop Watch " + this.id + "] Duration:  " + outputString);
        } else {
            System.out.println("[Stop Watch " + this.id + "] " + this.message + ". Duration: " + outputString);
        }
        return this;
    }
}

